/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.count;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import org.apache.commons.lang3.StringUtils;

public class CrvCondition {
    private String mappingNumber;
    private String tagField;
    private String billType;
    private String formulaDesc;
    private CRValByConditions crValByConditions;
    private List<CRValByCondition> items;
    private Set<String> fieldList = new HashSet<String>(16);
    private Map<String, String> fieldMap = new HashMap<String, String>(16);
    private Set<String> fields = new HashSet<String>(16);

    private CrvCondition(String tagField, String billType, String number, String formulaDesc) {
        this.tagField = tagField;
        this.billType = billType;
        this.formulaDesc = formulaDesc;
        this.mappingNumber = number;
    }

    public static CrvCondition build(String tagField, String billType, String number, String formulaDesc) {
        CrvCondition crvCondition = new CrvCondition(tagField, billType, number, formulaDesc);
        crvCondition.init();
        return crvCondition;
    }

    public void addField(String field) {
        this.fields.add(field);
    }

    public void init() {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.billType);
        this.crValByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)this.formulaDesc, CRValByConditions.class);
        this.items = this.crValByConditions.getItems();
        for (CRValByCondition condition : this.items) {
            CRCondition crCondition = condition.getCondition();
            String conditionExpression = crCondition.getExpression();
            if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u901a\u7528\u6620\u5c04\u914d\u7f6e%1$s,\u5b57\u6bb5%2$s,\u4e0d\u652f\u6301\u914d\u7f6e\u9ad8\u7ea7\u6761\u4ef6\u3002", (String)"CrvCondition_0", (String)"scmc-im-formplugin", (Object[])new Object[0]), this.mappingNumber, this.tagField));
            }
            HashSet<String> fields = new HashSet<String>(16);
            FilterBuilder fb = new FilterBuilder(dataEntityType, crCondition.getFilterCondition());
            String[] filterStrings = fb.buildFilterScript();
            String exprStr = filterStrings[0];
            if (StringUtils.isNotEmpty((CharSequence)exprStr)) {
                BOSExpression bosExpression = new BOSExpression(exprStr);
                Set vars = bosExpression.getVars();
                fields.addAll(vars);
            }
            CRFormula formula = condition.getFormula();
            String expression = formula.getExpression();
            String[] extractVariables = FormulaEngine.extractVariables((String)expression);
            fields.addAll(Arrays.asList(extractVariables));
            for (String field : fields) {
                String[] spit = field.split("\\.");
                String billField = spit[0];
                IDataEntityProperty property = dataEntityType.findProperty(billField);
                StringBuilder builder = new StringBuilder();
                this.getParentPath(property.getParent(), builder, dataEntityType.getName());
                builder.append(field);
                this.fieldList.add(builder.toString());
                this.fieldMap.put(builder.toString(), field);
            }
        }
    }

    private void getParentPath(IDataEntityType property, StringBuilder build, String billType) {
        if (property == null || billType.equals(property.getName())) {
            return;
        }
        String result = property.getName() + ".";
        build.insert(0, result);
        this.getParentPath(property.getParent(), build, billType);
    }

    public Object addExp(Map<String, Object> params) {
        List<CRValByCondition> items = this.items;
        for (CRValByCondition item : items) {
            BOSExpression bosExpression;
            Boolean aBoolean;
            CRCondition condition = item.getCondition();
            FilterBuilder buildFilter = this.buildFilter(this.getBillType(), condition);
            String[] filterStrings = buildFilter.buildFilterScript();
            String exprStr = filterStrings[0];
            if (!StringUtils.isNotEmpty((CharSequence)exprStr) || !(aBoolean = (Boolean)FormulaEngine.execExcelFormula((Expr)(bosExpression = new BOSExpression(exprStr)).getExpr(), params)).booleanValue()) continue;
            if (item.getIfconstant() == 1) {
                return item.getFormula().getExpression();
            }
            return FormulaEngine.execExcelFormula((String)item.getFormula().getExpression(), params);
        }
        return null;
    }

    public FilterBuilder buildFilter(String billType, CRCondition filterCondition) {
        FilterCondition condition = filterCondition.getFilterCondition();
        if (condition == null) {
            return null;
        }
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billType), condition);
        UserService userService = new UserService();
        filterBuilder.setUserService((IUserService)userService);
        filterBuilder.buildFilter(false);
        return filterBuilder;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public Set<String> getFieldList() {
        return this.fieldList;
    }

    public Map<String, String> getFieldMap() {
        return this.fieldMap;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public void setFields(Set<String> fields) {
        this.fields = fields;
    }
}

