/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.count;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.enums.InvCountInfoSourceEnum;
import kd.scmc.im.formplugin.count.InvCountBillBeforeF7Select;
import kd.scmc.im.formplugin.count.InvCountBillPropChanged;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public class InvCountBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
ItemClickListener,
ClickListener,
RowClickEventListener,
EntryGridBindDataListener {
    private static final Log log = LogFactory.getLog(InvCountBillEditPlugin.class);
    private DynamicObject bill;
    private Set<String> allEntryField = null;
    private static final String BARITEM_GENERATE_LOT = "generatelot";
    private static final List<String> listEnableFields = Arrays.asList("qty", "checkqty", "entrycomment");
    protected static final List<String> removeList = Arrays.asList("ownertype", "keepertype", "material", "auxpty", "lotnumber", "producedate", "expirydate", "unit", "baseunit", "unit2nd", "warehouse", "location", "invtype", "invstatus", "owner", "keeper", "project", "qtyacc", "adjustqty", "baseqtyacc", "adjustbaseqty", "qty2ndacc", "adjustqtyunit2nd");
    private static final String TOP_PANEL = "advcontoolbarap2";
    private static final String ADJUST = "adjust";
    private static final String CLEARADJUSTQTY = "clearadjustqty";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"material", "unit", "operatorgroup", "operator", "dept", "owner", "warehouse", "location", "checker", "checker2nd", "lot", "configuredcode", "tracknumber"});
        this.addItemClickListeners(new String[]{TOP_PANEL, BARITEM_GENERATE_LOT});
        this.addClickListeners(new String[]{"lotnumber"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        InvCountBillBeforeF7Select f7Select = new InvCountBillBeforeF7Select(this.getView());
        f7Select.beforeF7Select(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        InvCountBillPropChanged propChanged = new InvCountBillPropChanged(this.getView(), (IFormPlugin)this);
        propChanged.propertyChanged(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"operatorgroup"});
        this.setChecker2ndVisible();
        IDataModel bill = this.getModel();
        String billcretype = (String)bill.getValue("billcretype");
        if (!billcretype.equals("1")) {
            return;
        }
        this.setFieldEnable();
    }

    private void setFieldEnable() {
        int rowCount = this.getModel().getEntryRowCount("billentry");
        IFormView view = this.getView();
        for (int i = 0; i < rowCount; ++i) {
            view.setEnable(Boolean.valueOf(false), i, new String[]{"ownertype", "keepertype", "material", "auxpty", "lotnumber", "producedate", "expirydate", "unit", "baseunit", "unit2nd", "warehouse", "location", "invtype", "invstatus", "owner", "keeper", "project", "lot"});
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel bill = this.getModel();
        BillModel billModel = (BillModel)bill;
        boolean isFromWebApi = billModel.isFromWebApi();
        if (!isFromWebApi) {
            return;
        }
        this.resetImportData(billModel);
    }

    private void resetImportData(BillModel billModel) {
        Object id = billModel.getPKValue();
        DynamicObject invcountBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"im_invcountbill");
        DynamicObjectCollection loadEntrys = invcountBill.getDynamicObjectCollection("billentry");
        DynamicObjectCollection modelEntrys = billModel.getEntryEntity("billentry");
        int resetEntrySize = loadEntrys.size() > modelEntrys.size() ? modelEntrys.size() : loadEntrys.size();
        for (int i = 0; i < resetEntrySize; ++i) {
            DynamicObject loadEntryEntity = (DynamicObject)loadEntrys.get(i);
            DynamicObject modelEntry = (DynamicObject)modelEntrys.get(i);
            this.resetEntryData(modelEntry, loadEntryEntity);
        }
        if (modelEntrys.size() > loadEntrys.size()) {
            InvCountBillPropChanged propChanged = new InvCountBillPropChanged(this.getView(), (IFormPlugin)this);
            for (int i = resetEntrySize; i < modelEntrys.size(); ++i) {
                propChanged.handleNewImportEntry(i);
            }
        }
    }

    private void resetEntryData(DynamicObject modelEntry, DynamicObject loadEntry) {
        for (String removeField : removeList) {
            modelEntry.set(removeField, loadEntry.get(removeField));
        }
    }

    public void itemClick(ItemClickEvent e) {
        String itemKey;
        super.itemClick(e);
        switch (itemKey = e.getItemKey()) {
            case "queryinvcountscheme": {
                this.queryInvCountScheme();
                break;
            }
            case "adjust": {
                this.handleInvCountAdjustLogic();
                break;
            }
            case "generatelot": {
                this.handleLotMainFileNumber(this, itemKey);
                break;
            }
            case "clearadjustqty": {
                this.clearAdjustQty();
            }
        }
    }

    private void clearAdjustQty() {
        EntryGrid billentry = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = billentry.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u5206\u5f55\u5904\u7406\u3002", (String)"InvCountBillEditPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int index : selectRows) {
            DynamicObject entryRowData = (DynamicObject)this.getModel().getEntryEntity("billentry").get(index);
            entryRowData.set("adjustqty", (Object)BigDecimal.ZERO);
            entryRowData.set("adjustbaseqty", (Object)BigDecimal.ZERO);
            entryRowData.set("adjustqtyunit2nd", (Object)BigDecimal.ZERO);
            this.updateGainAndLoseQty(entryRowData);
        }
        this.getView().updateView("billentry");
    }

    public void handleLotMainFileNumber(AbstractBillPlugIn plugin, String itemKey) {
        IDataModel model = plugin.getView().getModel();
        DynamicObject bill = model.getDataEntity();
        String lotID = "lot";
        String lotnumber = "lotnumber";
        String lotidField = "billentry." + lotID;
        IFormView view = plugin.getView();
        DynamicObjectCollection entryEntity = model.getEntryEntity("billentry");
        LotMainFileHelper.handleLotMainFileNumber((IFormView)view, (DynamicObject)bill, (DynamicObjectCollection)entryEntity, (String)itemKey, (String)lotidField, (String)lotnumber);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "im_count_adjust": {
                this.handleCountAdjustClosedCallBack(e);
                break;
            }
            case "msmod_selectlot": {
                this.closedSelectedLot(e);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"auxpty"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"qty2ndacc"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"qtyacc"});
                this.getView().getModel().setValue("producedate", null, rowIndex);
                this.getView().getModel().setValue("expirydate", null, rowIndex);
            }
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        int rowCount = this.getModel().getEntryRowCount("billentry");
        int curIndex = rowCount - 1;
        this.dealOwnerAfterCreateOrAddRow(org, false, curIndex);
        this.getModel().setValue("billcretype", (Object)"0");
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.getModel().setValue("billcretype", (Object)"0");
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        if (this.allEntryField == null) {
            this.allEntryField = this.getAllEntryField();
        }
        boolean enablecheck = (Boolean)this.getModel().getValue("enablecheck");
        IFormView view = this.getView();
        for (RowDataEntity rowDataEntity : e.getRows()) {
            int rowIndex = rowDataEntity.getRowIndex();
            DynamicObject rowDy = rowDataEntity.getDataEntity();
            String sourceFlag = rowDy.get("sourceflag").toString();
            if (InvCountInfoSourceEnum.CREATE.getValue().equals(sourceFlag)) {
                this.allEntryField.removeAll(listEnableFields);
                this.getView().setEnable(Boolean.FALSE, rowIndex, this.allEntryField.toArray(new String[this.allEntryField.size()]));
            } else {
                boolean isUseAuxpty = rowDy.getBoolean("material.masterid.isuseauxpty");
                view.setEnable(Boolean.valueOf(isUseAuxpty), rowIndex, new String[]{"auxpty"});
                boolean enablelot = rowDy.getBoolean("material.enablelot");
                view.setEnable(Boolean.valueOf(enablelot), rowIndex, new String[]{"lotnumber"});
                view.setEnable(Boolean.valueOf(enablelot), rowIndex, new String[]{"lot"});
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"qty2ndacc"});
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"qtyacc"});
            }
            DynamicObject isUseAuxptyUnit = rowDy.getDynamicObject("material.masterid.auxptyunit");
            view.setEnable(Boolean.valueOf(isUseAuxptyUnit != null), rowIndex, new String[]{"qtyunit2nd"});
            view.setEnable(Boolean.valueOf(isUseAuxptyUnit != null && enablecheck), rowIndex, new String[]{"checkqtyunit2nd"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if ("MaterialLifeDate".equals(callBackId)) {
            String customVaule = e.getCustomVaule();
            List alertMsgList = (List)SerializationUtils.fromJsonString((String)customVaule, List.class);
            for (int i = 0; i < alertMsgList.size(); ++i) {
                Map params = (Map)alertMsgList.get(i);
                Date newExpirydate = this.parseDate((String)params.get("newExpiryDate"));
                Date newProducedate = this.parseDate((String)params.get("newProduceDate"));
                int rowIndex = (Integer)params.get("index");
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.setValue("expirydate", newExpirydate, rowIndex, false);
                    this.setValue("producedate", newProducedate, rowIndex, false);
                    continue;
                }
                this.setValue("producedate", null, rowIndex, false);
                this.setValue("expirydate", null, rowIndex, false);
            }
        }
    }

    private void setChecker2ndVisible() {
        boolean enablecheck = (Boolean)this.getBill().get("enablecheck");
        this.getView().setVisible(Boolean.valueOf(enablecheck), new String[]{"checker2nd"});
        FieldEdit control = (FieldEdit)this.getView().getControl("checker2nd");
        control.setMustInput(enablecheck);
    }

    private void setValue(String key, Object value, int i, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (int)i, (boolean)isTriggerChangeEvent);
    }

    private Date parseDate(String dateStr) {
        Date date;
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sd.parse(dateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImBillEditPlugin_10", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        return date;
    }

    private void setJsonObjectParams(JSONObject jsonObject, int rowIndex) {
        DynamicObject tracknumber;
        DynamicObject configuredcode;
        DynamicObject project;
        DynamicObject keeper;
        String keepertype;
        DynamicObject owner;
        String ownertype;
        DynamicObject invstatus;
        DynamicObject invtype;
        DynamicObject location;
        DynamicObject WAREHOUSE;
        Date expirydate;
        Date producedate;
        String lotnumber;
        DynamicObject unit2nd;
        DynamicObject unit;
        DynamicObject material;
        DynamicObject entryRowData = (DynamicObject)this.getModel().getEntryEntity("billentry").get(rowIndex);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            jsonObject.put("org", org.getPkValue());
        }
        if ((material = entryRowData.getDynamicObject("material")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5206\u5f55\u7269\u6599\u5fc5\u987b\u586b\u5199\u3002", (String)"InvCountBillEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        jsonObject.put("material", (Object)material.getLong("masterid.id"));
        DynamicObject auxpty = entryRowData.getDynamicObject("auxpty");
        if (auxpty != null) {
            jsonObject.put("auxpty", auxpty.getPkValue());
        }
        if ((unit = entryRowData.getDynamicObject("unit")) != null) {
            jsonObject.put("unit", unit.getPkValue());
        }
        if ((unit2nd = entryRowData.getDynamicObject("unit2nd")) != null) {
            jsonObject.put("unit2nd", unit2nd.getPkValue());
        }
        if (!(lotnumber = entryRowData.getString("lotnumber")).isEmpty()) {
            jsonObject.put("lotnumber", (Object)lotnumber);
        }
        if ((producedate = entryRowData.getDate("producedate")) != null) {
            jsonObject.put("producedate", (Object)producedate);
        }
        if ((expirydate = entryRowData.getDate("expirydate")) != null) {
            jsonObject.put("expirydate", (Object)expirydate);
        }
        if ((WAREHOUSE = entryRowData.getDynamicObject("warehouse")) != null) {
            jsonObject.put("warehouse", WAREHOUSE.getPkValue());
        }
        if ((location = entryRowData.getDynamicObject("location")) != null) {
            jsonObject.put("location", location.getPkValue());
        }
        if ((invtype = entryRowData.getDynamicObject("invtype")) != null) {
            jsonObject.put("invtype", invtype.getPkValue());
        }
        if ((invstatus = entryRowData.getDynamicObject("invstatus")) != null) {
            jsonObject.put("invstatus", invstatus.getPkValue());
        }
        if ((ownertype = entryRowData.getString("ownertype")) != null && !ownertype.isEmpty()) {
            jsonObject.put("ownertype", (Object)ownertype);
        }
        if ((owner = entryRowData.getDynamicObject("owner")) != null) {
            jsonObject.put("owner", owner.getPkValue());
        }
        if ((keepertype = entryRowData.getString("keepertype")) != null && !keepertype.isEmpty()) {
            jsonObject.put("keepertype", (Object)keepertype);
        }
        if ((keeper = entryRowData.getDynamicObject("keeper")) != null) {
            jsonObject.put("keeper", keeper.getPkValue());
        }
        if ((project = entryRowData.getDynamicObject("project")) != null) {
            jsonObject.put("project", project.getPkValue());
        }
        if ((configuredcode = entryRowData.getDynamicObject("configuredcode")) != null) {
            jsonObject.put("configuredcode", configuredcode.getPkValue());
        }
        if ((tracknumber = entryRowData.getDynamicObject("tracknumber")) != null) {
            jsonObject.put("tracknumber", tracknumber.getPkValue());
        }
        jsonObject.put("filterdate", this.getModel().getValue("invaccdate"));
        jsonObject.put("accessnode", this.getModel().getValue("accessnode"));
        jsonObject.put("excludeenddate", this.getModel().getValue("excludeenddate"));
        jsonObject.put("backupcondition", this.getModel().getValue("backupcondition"));
    }

    private void handleInvCountAdjustLogic() {
        EntryGrid billentry = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = billentry.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u5206\u5f55\u5904\u7406\u9009\u5355\u3002", (String)"InvCountBillEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject jsonObject = new JSONObject();
        this.setJsonObjectParams(jsonObject, selectRows[0]);
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("im_count_adjust");
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setCustomParam("param", (Object)jsonObject);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "im_count_adjust"));
        this.getView().showForm(baseShowParameter);
    }

    private void handleCountAdjustClosedCallBack(ClosedCallBackEvent e) {
        JSONObject jsonObject = (JSONObject)e.getReturnData();
        if (jsonObject == null) {
            return;
        }
        EntryGrid billentry = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = billentry.getSelectRows();
        DynamicObject entryRowData = (DynamicObject)this.getModel().getEntryEntity("billentry").get(selectRows[0]);
        entryRowData.set("adjustqty", jsonObject.get((Object)"adjustqty"));
        entryRowData.set("adjustbaseqty", jsonObject.get((Object)"adjustbaseqty"));
        entryRowData.set("adjustqtyunit2nd", jsonObject.get((Object)"adjustqtyunit2nd"));
        this.updateGainAndLoseQty(entryRowData);
        this.getView().updateView("billentry", selectRows[0]);
    }

    private void updateGainAndLoseQty(DynamicObject entryRowData) {
        boolean enablecheck = (Boolean)this.getModel().getValue("enablecheck");
        BigDecimal participateCalQty = null;
        BigDecimal participateCalBaseQty = null;
        BigDecimal participateCalQty2nd = null;
        if (enablecheck) {
            participateCalQty = entryRowData.getBigDecimal("checkqty");
            participateCalBaseQty = entryRowData.getBigDecimal("checkbaseqty");
            participateCalQty2nd = entryRowData.getBigDecimal("checkqtyunit2nd");
        } else {
            participateCalQty = entryRowData.getBigDecimal("qty");
            participateCalBaseQty = entryRowData.getBigDecimal("baseqty");
            participateCalQty2nd = entryRowData.getBigDecimal("qtyunit2nd");
        }
        BigDecimal qtyAcc = entryRowData.getBigDecimal("qtyacc");
        BigDecimal baseqtyAcc = entryRowData.getBigDecimal("baseqtyacc");
        BigDecimal qty2ndacc = entryRowData.getBigDecimal("qty2ndacc");
        BigDecimal gainQtyOrLossqty = participateCalQty.subtract(qtyAcc).subtract(entryRowData.getBigDecimal("adjustqty"));
        BigDecimal gainQtyOrLossBaseqty = participateCalBaseQty.subtract(baseqtyAcc).subtract(entryRowData.getBigDecimal("adjustbaseqty"));
        BigDecimal gainQtyOrLossQty2nd = participateCalQty2nd.subtract(qty2ndacc).subtract(entryRowData.getBigDecimal("adjustqtyunit2nd"));
        if (gainQtyOrLossqty.compareTo(BigDecimal.ZERO) > 0) {
            entryRowData.set("gainqty", (Object)gainQtyOrLossqty);
            entryRowData.set("lossqty", (Object)0);
        } else {
            entryRowData.set("gainqty", (Object)0);
            entryRowData.set("lossqty", (Object)gainQtyOrLossqty.abs());
        }
        if (gainQtyOrLossBaseqty.compareTo(BigDecimal.ZERO) > 0) {
            entryRowData.set("basegainqty", (Object)gainQtyOrLossBaseqty);
            entryRowData.set("baselossqty", (Object)0);
        } else {
            entryRowData.set("basegainqty", (Object)0);
            entryRowData.set("baselossqty", (Object)gainQtyOrLossBaseqty.abs());
        }
        if (gainQtyOrLossQty2nd.compareTo(BigDecimal.ZERO) > 0) {
            entryRowData.set("gainqty2nd", (Object)gainQtyOrLossQty2nd);
            entryRowData.set("lossqty2nd", (Object)0);
        } else {
            entryRowData.set("gainqty2nd", (Object)0);
            entryRowData.set("lossqty2nd", (Object)gainQtyOrLossQty2nd.abs());
        }
    }

    private void queryInvCountScheme() {
        IDataModel model = this.getModel();
        String sechemeid = model.getValue("schemeid").toString();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("im_invcountscheme");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setPkId((Object)sechemeid);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private Set<String> getAllEntryField() {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"im_invcountbill");
        Map allEntities = dataEntityType.getAllEntities();
        EntityType entityType = (EntityType)allEntities.get("billentry");
        Map fields = entityType.getFields();
        Set<String> keySet = fields.keySet();
        return keySet;
    }

    private void dealOwnerAfterCreateOrAddRow(DynamicObject org, boolean isCreateNew, int rowIndex) {
        Long ownerID = 0L;
        if (org != null) {
            ownerID = OwnerHelper.getDefaultOwner((Long)((Long)org.getPkValue()));
        }
        if (isCreateNew) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                Object OwnerType = this.getModel().getValue("ownertype", i);
                if (!"bos_org".equals(OwnerType)) continue;
                this.getModel().setValue("owner", (Object)ownerID, rowIndex);
            }
        } else {
            Object OwnerType = this.getModel().getValue("ownertype", rowIndex);
            if ("bos_org".equals(OwnerType)) {
                this.getModel().setValue("owner", (Object)ownerID, rowIndex);
            }
        }
    }

    protected DynamicObject getBill() {
        return this.getBill(false);
    }

    protected DynamicObject getBill(boolean hasEntry) {
        if (this.bill == null) {
            this.bill = this.getModel().getDataEntity(hasEntry);
        }
        return this.bill;
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "lotnumber": {
                this.openPageSelectLotMainfile(key);
                break;
            }
        }
    }

    private void openPageSelectLotMainfile(String fieldKey) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        int rowIndex = model.getEntryCurrentRowIndex("billentry");
        DynamicObject selectEntry = model.getEntryRowEntity("billentry", rowIndex);
        String lotnumField = "billentry." + fieldKey;
        LotMainFileHelper.showPageLotMainfileList((IFormPlugin)this, (IFormView)this.getView(), (DynamicObject)bill, (DynamicObject)selectEntry, (String)lotnumField);
    }

    private void closedSelectedLot(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData instanceof Map) {
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("billentry");
            Map lotAttr = (Map)returnData;
            String lotidfield = (String)lotAttr.get("lotidfield");
            model.setValue(lotidfield, lotAttr.get("lotid"), rowIndex);
        }
    }
}

