/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.count;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OperatorGroupHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class InvCountBillListPlugin
extends AbstractListPlugin {
    private static final String Cust_ORG = "org";

    public void filterContainerInit(FilterContainerInitArgs args) {
        Object org = this.getView().getFormShowParameter().getCustomParam(Cust_ORG);
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        BillList billList = (BillList)this.getControl("billlistap");
        String formId = billList.getEntityType().getName();
        List permissionOrgs = NewInvOrgHelper.getPermissionOrgsByAppId((String)formId, (String)this.getView().getFormShowParameter().getAppId());
        if (permissionOrgs == null || permissionOrgs.isEmpty()) {
            this.getView().showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_USE_INVORG()));
            return;
        }
        List orgItem = NewInvOrgHelper.getHasPermissionAndStartedInvOrgFilterColumns((List)permissionOrgs);
        if (orgItem == null || orgItem.size() == 0) {
            this.getView().showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ENABLED_INV()));
            return;
        }
        for (FilterColumn filterColumn : filterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (!"org.name".equals(commonFilterColumn.getFieldName())) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            commonFilterColumn.setComboItems(orgItem);
            if (org == null || this.getPageCache().get("isinitopen") != null) continue;
            List orgIdList = (List)org;
            commonFilterColumn.setDefaultValues(orgIdList.stream().map(Object::toString).toArray());
        }
    }

    public void setFilter(SetFilterEvent e) {
        Object org = this.getView().getFormShowParameter().getCustomParam(Cust_ORG);
        String isinitopen = this.getPageCache().get("isinitopen");
        if (org != null) {
            List listQFilters = e.getQFilters();
            Iterator iterator = listQFilters.iterator();
            if (isinitopen == null) {
                while (iterator.hasNext()) {
                    if (!"biztime".equals(((QFilter)iterator.next()).getProperty())) continue;
                    iterator.remove();
                }
                this.getPageCache().put("isinitopen", "1");
                return;
            }
            while (iterator.hasNext()) {
                if (!"schemeid".equals(((QFilter)iterator.next()).getProperty())) continue;
                iterator.remove();
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        String entityName = billList.getEntityType().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        OperatorGroupHelper.setOperatorGroupFilter((String)appId, (SetFilterEvent)e, (List)this.getSelectedMainOrgIds(), (String)entityName);
        WareHouseIsolateHelper.setWareHoseFilterByDataCtrl((String)appId, (SetFilterEvent)e, (List)this.getSelectedMainOrgIds(), (String)entityName);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Long mainOrgId;
        DynamicObject mainOrg;
        List selectedMainOrgIds;
        if ("tblnew".equals(evt.getItemKey()) && (selectedMainOrgIds = this.getSelectedMainOrgIds()) != null && selectedMainOrgIds.size() == 1 && !(mainOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(mainOrgId = (Long)selectedMainOrgIds.get(0)))})).getBoolean("enable")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff0c\u8bf7\u542f\u7528\u540e\u518d\u64cd\u4f5c\u3002", (String)"ImBillListPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        if ("queryinvcountscheme".equalsIgnoreCase(itemKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows == null || selectedRows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvCountBillListPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Object> billIds = new ArrayList<Object>(selectedRows.size());
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow listSelectedRow = selectedRows.get(i);
                Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                billIds.add(primaryKeyValue);
            }
            HashSet<Long> schemeIds = new HashSet<Long>(16);
            HashSet<Long> orgIds = new HashSet<Long>(16);
            DataSet invCountBills = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_invcountbill", (String)"schemeid", (QFilter[])new QFilter("id", "in", billIds).toArray(), null);
            for (Object row : invCountBills) {
                long schemeId = row.getLong("schemeid");
                schemeIds.add(schemeId);
            }
            DataSet invCountSchemes = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_invcountscheme", (String)Cust_ORG, (QFilter[])new QFilter("id", "in", schemeIds).toArray(), null);
            for (Row row : invCountSchemes) {
                Long orgId = row.getLong(Cust_ORG);
                orgIds.add(orgId);
            }
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("im_invcountscheme");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setCustomParam(Cust_ORG, orgIds);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter qFilter = new QFilter("id", "in", schemeIds);
            listFilterParameter.setFilter(qFilter);
            listShowParameter.setListFilterParameter(listFilterParameter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }
}

