/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.count;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OrgHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.consts.InvCountSchemeConst;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class InvCountSchemePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
ItemClickListener,
ClickListener,
BeforeFilterF7SelectListener {
    private static final String algoKey = InvCountSchemePlugin.class.getName();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"org", "warehouse", "location", "material", "mulorg"});
        this.addItemClickListeners(new String[]{"querycountbill"});
        this.addItemClickListeners(new String[]{"dimension"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.setCustomFilter();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.fillDimensionField();
        this.setDefaultCustomFilter();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        this.resetFilterColumns(filterGrid);
        this.setFilter();
        this.handleLocationView();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initOrg();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject invCountScheme = model.getDataEntity();
        DynamicObject org = invCountScheme.getDynamicObject("org");
        DynamicObjectCollection mulorgs = invCountScheme.getDynamicObjectCollection("mulorg");
        switch (fieldKey) {
            case "org": 
            case "mulorg": {
                this.handleOrgF7Select(showParameter);
                break;
            }
            case "warehouse": {
                this.handleWarehouseF7Select(org, mulorgs, showParameter);
                break;
            }
            case "location": {
                this.handleLocationF7Select(model, showParameter);
                break;
            }
            case "material": {
                this.handleMaterialF7Select(org, mulorgs, showParameter);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent e) {
        String fieldName = e.getRefEntityId();
        IDataModel model = this.getModel();
        DynamicObject invCountScheme = model.getDataEntity();
        DynamicObject org = invCountScheme.getDynamicObject("org");
        DynamicObjectCollection mulorgs = invCountScheme.getDynamicObjectCollection("mulorg");
        switch (fieldName) {
            case "bd_material": {
                this.handleCustomMaterialF7Select(org, mulorgs, e);
                break;
            }
            case "bd_warehouse": {
                this.handleCustomWarehouseF7Select(org, mulorgs, e);
                break;
            }
            case "bd_location": {
                this.handleCustomLocationF7Select(e);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "dimension": {
                this.handleDimensionChangeEvent(oldValue, rowIndex);
                break;
            }
            case "backupcondition": {
                this.handleBackupconditionChangeEvent(newValue, oldValue);
                break;
            }
            case "warehouse": {
                this.handleWarehouseChangeEvent(newValue);
                break;
            }
            case "mulorg": {
                this.handleMulOrgChangeEvent(newValue, oldValue);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getItemKey()) {
            case "querycountbill": {
                this.handleQueryCountBillClickEvent();
                break;
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        this.checkBaseData(sourceData);
    }

    private void initOrg() {
        String formId = this.getModel().getDataEntityType().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Object[] orgList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formId, (String)this.getView().getFormShowParameter().getAppId());
        if (orgList == null || orgList.length == 0) {
            this.getModel().setValue("org", null);
            return;
        }
        String orgId = org.getPkValue().toString();
        boolean hasOrg = false;
        for (int i = 0; i < orgList.length; ++i) {
            if (!orgId.equals(orgList[i].toString())) continue;
            hasOrg = true;
            break;
        }
        if (!hasOrg) {
            this.getModel().setValue("org", null);
        }
        this.getModel().setValue("mulorg", (Object)new Object[]{Long.valueOf(orgId)});
    }

    private void resetFilterColumns(FilterGrid filterGrid) {
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> resetFilterColumns = new ArrayList<Map>(filterColumns.size());
        for (Map filterColumn : filterColumns) {
            String fieldName = (String)filterColumn.get("fieldName");
            if (fieldName.contains("qty") || fieldName.contains("unit") || fieldName.equals("lot.number") || fieldName.equals("materialname") || fieldName.equals("warehouse.isopenlocation") || fieldName.equals("updatetime") || fieldName.equals("keycol") || fieldName.contains("org") || fieldName.equals("configuredcode.name")) continue;
            resetFilterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(resetFilterColumns);
        this.getView().updateView("filtergridap");
    }

    private void handleCustomWarehouseF7Select(DynamicObject org, DynamicObjectCollection mulOrgs, BeforeFilterF7SelectEvent e) {
        List<Long> orgIds;
        if (mulOrgs.isEmpty() && org == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_BIZORG()));
            return;
        }
        String formId = this.getModel().getDataEntityType().getName();
        QFilter filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)formId, orgIds = this.getOrgIds());
        if (filter != null) {
            e.getQfilters().add(filter);
        }
    }

    private void handleCustomLocationF7Select(BeforeFilterF7SelectEvent e) {
        DynamicObjectCollection whs = (DynamicObjectCollection)this.getModel().getValue("warehouse");
        ArrayList<Long> whsIds = new ArrayList<Long>();
        if (whs != null && whs.size() > 0) {
            for (int i = 0; i < whs.size(); ++i) {
                DynamicObject wh = (DynamicObject)whs.get(i);
                Object whid = wh.get("fbasedataid_id");
                whsIds.add(Long.parseLong(whid.toString()));
            }
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_warehouse", (String)"location", (QFilter[])new QFilter[]{new QFilter("id", "in", whsIds)});
            ArrayList<Long> locationids = new ArrayList<Long>();
            for (int i = 0; i < load.length; ++i) {
                DynamicObject warehouse = load[i];
                DynamicObjectCollection locations = (DynamicObjectCollection)warehouse.get("entryentity");
                if (locations == null || locations.size() <= 0) continue;
                for (int j = 0; j < locations.size(); ++j) {
                    DynamicObject location = (DynamicObject)((DynamicObject)locations.get(j)).get("location");
                    long locationid = Long.parseLong(location.getPkValue().toString());
                    locationids.add(locationid);
                }
            }
            e.setQfilters(Collections.singletonList(new QFilter("id", "in", locationids)));
        } else {
            e.setQfilters(Collections.singletonList(new QFilter("status", "=", (Object)"C")));
        }
    }

    private void handleCustomMaterialF7Select(DynamicObject org, DynamicObjectCollection mulOrgs, BeforeFilterF7SelectEvent e) {
        if (mulOrgs.isEmpty() && org == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_BIZORG()));
            return;
        }
        List<Long> orgIds = this.getOrgIds();
        QFilter materialSelectFilter = this.getMaterialSelectFilter(orgIds);
        e.setQfilters(Collections.singletonList(materialSelectFilter));
    }

    private QFilter getMaterialSelectFilter(List<Long> orgIds) {
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", orgIds, (boolean)true);
    }

    private void handleMulOrgChangeEvent(Object newValue, Object oldValue) {
        DynamicObjectCollection newMulOrgs = (DynamicObjectCollection)newValue;
        DynamicObjectCollection oldMulOrgs = (DynamicObjectCollection)oldValue;
        if (!oldMulOrgs.isEmpty()) {
            HashSet oldOrgIds = new HashSet(16);
            HashSet newOrgIds = new HashSet(16);
            newMulOrgs.forEach(newMulorg -> newOrgIds.add(newMulorg.getLong("fbasedataid_id")));
            oldMulOrgs.forEach(oldMulorg -> oldOrgIds.add(oldMulorg.getLong("fbasedataid_id")));
            Set collectSet = newOrgIds.stream().filter(oldOrgIds::contains).collect(Collectors.toSet());
            oldOrgIds.removeAll(collectSet);
            if (!oldOrgIds.isEmpty()) {
                this.getModel().setValue("warehouse", null);
                this.getModel().setValue("material", null);
            }
        } else {
            this.getModel().setValue("warehouse", null);
            this.getModel().setValue("material", null);
        }
    }

    private void handleWarehouseChangeEvent(Object newValue) {
        this.getModel().setValue("location", null);
        if (newValue != null) {
            for (DynamicObject dys : (DynamicObjectCollection)newValue) {
                if (dys.getDynamicObject("fbasedataid").getBoolean("isopenlocation")) continue;
                this.getView().setEnable(Boolean.FALSE, new String[]{"location"});
                return;
            }
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"location"});
    }

    private void handleLocationView() {
        DynamicObjectCollection warehouse = (DynamicObjectCollection)this.getModel().getValue("warehouse");
        if (warehouse != null) {
            for (DynamicObject dys : warehouse) {
                if (dys.getDynamicObject("fbasedataid").getBoolean("isopenlocation")) continue;
                this.getView().setEnable(Boolean.FALSE, new String[]{"location"});
                return;
            }
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"location"});
    }

    private void handleOrgF7Select(ListShowParameter showParameter) {
        List hasPermissionOrgs = OrgHelper.getHasPermissionOrg((String)this.getModel().getDataEntityType().getName());
        QFilter orgFilter = new QFilter("id", "in", (Object)hasPermissionOrgs);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(orgFilter));
    }

    private void handleWarehouseF7Select(DynamicObject org, DynamicObjectCollection mulOrgs, ListShowParameter showParameter) {
        if (mulOrgs.isEmpty() && org == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_BIZORG()));
            return;
        }
        String formId = this.getModel().getDataEntityType().getName();
        List<Long> orgIds = this.getOrgIds();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        QFilter customWarehouseF7Filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)formId, orgIds);
        QFilter warehouseUFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", orgIds, (boolean)true);
        qFilters.add(customWarehouseF7Filter);
        qFilters.add(warehouseUFilter);
        showParameter.getListFilterParameter().setQFilters(qFilters);
    }

    private void handleMaterialF7Select(DynamicObject org, DynamicObjectCollection mulOrgs, ListShowParameter showParameter) {
        if (mulOrgs.isEmpty() && org == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_BIZORG()));
            return;
        }
        List<Long> orgIds = this.getOrgIds();
        QFilter materialSelectFilter = this.getMaterialSelectFilter(orgIds);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(materialSelectFilter));
    }

    private void handleLocationF7Select(IDataModel model, ListShowParameter showParameter) {
        DynamicObjectCollection whs = (DynamicObjectCollection)model.getValue("warehouse");
        ArrayList<Long> whsIds = new ArrayList<Long>();
        if (whs != null && whs.size() > 0) {
            for (int i = 0; i < whs.size(); ++i) {
                DynamicObject wh = (DynamicObject)whs.get(i);
                Object whid = wh.get("fbasedataid_id");
                whsIds.add(Long.parseLong(whid.toString()));
            }
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_warehouse", (String)"location", (QFilter[])new QFilter[]{new QFilter("id", "in", whsIds)});
            ArrayList<Long> locationids = new ArrayList<Long>();
            for (int i = 0; i < load.length; ++i) {
                DynamicObject warehouse = load[i];
                DynamicObjectCollection locations = (DynamicObjectCollection)warehouse.get("entryentity");
                if (locations == null || locations.size() <= 0) continue;
                for (int j = 0; j < locations.size(); ++j) {
                    DynamicObject location = (DynamicObject)((DynamicObject)locations.get(j)).get("location");
                    long locationid = Long.parseLong(location.getPkValue().toString());
                    locationids.add(locationid);
                }
            }
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", locationids));
        } else {
            showParameter.getListFilterParameter().setFilter(new QFilter("status", "=", (Object)"C"));
        }
    }

    private void handleQueryCountBillClickEvent() {
        Object schemeId = this.getModel().getValue("id");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_invcountbill", (String)"id", (QFilter[])new QFilter("schemeid", "=", schemeId).toArray(), null, (int)1);
        if (dataSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u6570\u636e\u3002", (String)"InvCountSchemePlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId("im_invcountbill");
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter filter = new QFilter("schemeid", "=", this.getModel().getValue("id"));
        ListFilterParameter lfp = new ListFilterParameter();
        List<Long> orgIds = this.getOrgIds();
        lsp.setUseOrgIds(orgIds);
        lfp.setFilter(filter);
        String formId = this.getModel().getDataEntityType().getName();
        QFilter wareHoseFilter = WareHouseIsolateHelper.getWareHoseFilter((String)this.getView().getFormShowParameter().getAppId(), orgIds, (String)formId);
        if (wareHoseFilter != null) {
            lfp.setFilter(wareHoseFilter);
        }
        lsp.setListFilterParameter(lfp);
        lsp.setCustomParam("org", orgIds);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<Long> getOrgIds() {
        DynamicObject invCountSchemeObj = this.getModel().getDataEntity();
        DynamicObjectCollection mulorgs = invCountSchemeObj.getDynamicObjectCollection("mulorg");
        DynamicObject org = invCountSchemeObj.getDynamicObject("org");
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        if (!mulorgs.isEmpty()) {
            for (DynamicObject mulorg : mulorgs) {
                orgIds.add(mulorg.getLong("fbasedataid_id"));
            }
        } else if (org != null) {
            orgIds.add(org.getLong("id"));
        }
        return orgIds;
    }

    private void handleBackupconditionChangeEvent(Object newValue, Object oldValue) {
        if (newValue == null || "".equals(newValue)) {
            this.getModel().setValue("backupcondition", oldValue);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5907\u4efd\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvCountSchemePlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
    }

    private void handleDimensionChangeEvent(Object oldValue, int rowIndex) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("dimensionentity");
        HashSet<String> rowValueSet = new HashSet<String>();
        for (DynamicObject entry : entrys) {
            String dimesionRowValue = entry.getString("dimension");
            if (StringUtils.isEmpty((CharSequence)dimesionRowValue)) continue;
            if (rowValueSet.contains(dimesionRowValue)) {
                this.getModel().setValue("dimension", oldValue, rowIndex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u5355\u4f9d\u636e\u4e0d\u80fd\u6709\u91cd\u590d\u503c\u3002", (String)"InvCountSchemePlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            rowValueSet.add(dimesionRowValue);
        }
    }

    private void setCustomFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        if (filterCondition.getFilterRow().isEmpty()) {
            this.getModel().getDataEntity().set("filterstring_tag", null);
        } else {
            String filterString = SerializationUtils.toJsonString((Object)filterCondition);
            this.getModel().getDataEntity().set("filterstring_tag", (Object)filterString);
        }
    }

    private void setFilter() {
        String billfilterstr = (String)this.getModel().getDataEntity().get("filterstring_tag");
        if (!"".equals(billfilterstr)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billfilterstr, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }

    private void setDefaultCustomFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        if (null != filterGrid) {
            filterGrid.setEntityNumber(InvAccConst.getBalTb());
        }
    }

    private void fillDimensionField() {
        Map dymaccModelDimensionMapExcludeqty = InvCountSchemeConst.getDymaccModelDimensionMapExcludeQty();
        ComboEdit control = (ComboEdit)this.getControl("dimension");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(dymaccModelDimensionMapExcludeqty.size());
        for (Map.Entry entry : dymaccModelDimensionMapExcludeqty.entrySet()) {
            if ("biztime".equals(entry.getKey())) continue;
            comboItems.add(new ComboItem((LocaleString)entry.getValue(), (String)entry.getKey()));
        }
        control.setComboItems(comboItems);
    }

    private void checkBaseData(Map<String, Object> sourceData) {
        QFilter warehouseUFilter;
        ArrayList<String> orgNumList = new ArrayList<String>(16);
        ArrayList<String> wareHouseNumList = new ArrayList<String>(16);
        ArrayList<String> materialNumList = new ArrayList<String>(16);
        orgNumList.addAll(this.getDataNumList(sourceData, "mulorg"));
        wareHouseNumList.addAll(this.getDataNumList(sourceData, "warehouse"));
        materialNumList.addAll(this.getDataNumList(sourceData, "material"));
        if (orgNumList.isEmpty()) {
            return;
        }
        List hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)"im_invcountscheme");
        DataSet orgSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id,number", (QFilter[])new QFilter("number", "in", orgNumList).toArray(), null, (int)-1);
        HashMap<Long, String> orgIdMap = new HashMap<Long, String>(16);
        for (Row row : orgSet) {
            Long orgId2 = row.getLong("id");
            String orgNum = row.getString("number");
            orgIdMap.put(orgId2, orgNum);
        }
        HashSet newOrgIdSet = new HashSet(orgIdMap.keySet());
        newOrgIdSet.removeAll(hasPermissionOrg);
        if (!newOrgIdSet.isEmpty()) {
            StringBuilder orgNumStr = new StringBuilder();
            newOrgIdSet.forEach(orgId -> orgNumStr.append((String)orgIdMap.get(orgId)).append(","));
            String orgNumSubStr = orgNumStr.substring(0, orgNumStr.lastIndexOf(","));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u6ca1\u6709\u6743\u9650\u3002", (String)"InvCountSchemePlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]), orgNumSubStr));
        }
        StringBuilder errMsg = new StringBuilder();
        ArrayList orgIdList = new ArrayList(orgIdMap.keySet());
        QFilter warehouseFilter = new QFilter("number", "in", wareHouseNumList);
        QFilter customWarehouseF7Filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)"im_invcountscheme", new ArrayList(orgIdList));
        if (customWarehouseF7Filter != null) {
            warehouseFilter.and(customWarehouseF7Filter);
        }
        if ((warehouseUFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", orgIdList, (boolean)true)) != null) {
            warehouseFilter.and(warehouseUFilter);
        }
        DataSet wareHouseSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_warehouse", (String)"id,number", (QFilter[])warehouseFilter.toArray(), null, (int)-1);
        HashMap<String, Long> warehouseMap = new HashMap<String, Long>(16);
        for (Row row : wareHouseSet) {
            Long warehouseId = row.getLong("id");
            String warehouseNum = row.getString("number");
            warehouseMap.put(warehouseNum, warehouseId);
        }
        ArrayList noPermissionWareList = new ArrayList(wareHouseNumList);
        noPermissionWareList.removeAll(warehouseMap.keySet());
        if (!noPermissionWareList.isEmpty()) {
            errMsg.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u4ed3\u5e93\u201c%1$s\u201d\uff0c\u5728\u5e93\u5b58\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u6ca1\u6709\u5206\u914d\uff0c\u6216\u8005\u6ca1\u6709\u6570\u636e\u6743\u9650\u3002", (String)"InvCountSchemePlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]), noPermissionWareList, orgNumList));
        }
        QFilter materialFilter = new QFilter("number", "in", materialNumList);
        QFilter materialUFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", orgIdList, (boolean)true);
        if (materialUFilter != null) {
            materialFilter.and(materialUFilter);
        }
        DataSet materialSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,number", (QFilter[])materialFilter.toArray(), null, (int)-1);
        HashMap<String, Long> materialMap = new HashMap<String, Long>(16);
        for (Row row : materialSet) {
            Long materialId = row.getLong("id");
            String materialNum = row.getString("number");
            materialMap.put(materialNum, materialId);
        }
        ArrayList noPermissionMatList = new ArrayList(materialNumList);
        noPermissionMatList.removeAll(materialMap.keySet());
        if (!noPermissionMatList.isEmpty()) {
            errMsg.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u7269\u6599\u201c%1$s\u201d\uff0c\u5728\u5e93\u5b58\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u6ca1\u6709\u5206\u914d\uff0c\u6216\u8005\u6ca1\u6709\u6570\u636e\u6743\u9650\u3002", (String)"InvCountSchemePlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]), noPermissionMatList, orgNumList));
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            throw new KDBizException(errMsg.toString());
        }
        this.updateBaseData(sourceData, warehouseMap, materialMap);
    }

    private void updateBaseData(Map<String, Object> sourceData, Map<String, Long> warehouseMap, Map<String, Long> materialMap) {
        Map imptMaterialMap;
        Map imptWarehouseMap = (Map)sourceData.get("warehouse");
        if (imptWarehouseMap != null && imptWarehouseMap.getOrDefault("importprop", "number") != null) {
            String imptWarehouse = (String)imptWarehouseMap.get("number");
            String[] splitWarehouseNums = imptWarehouse.split(",");
            ArrayList<Long> warehouseIds = new ArrayList<Long>(16);
            for (String splitWarehouseNum : splitWarehouseNums) {
                Long warehouseId = warehouseMap.get(splitWarehouseNum);
                warehouseIds.add(warehouseId);
            }
            String wareHouseIdStr = ((Object)warehouseIds).toString().replace("[", "").replace("]", "");
            imptWarehouseMap.put("id", wareHouseIdStr);
        }
        if ((imptMaterialMap = (Map)sourceData.get("material")) != null && imptMaterialMap.getOrDefault("importprop", "number") != null) {
            String imptMaterial = (String)imptMaterialMap.get("number");
            String[] splitMaterialNums = imptMaterial.split(",");
            ArrayList<Long> materialIds = new ArrayList<Long>(16);
            for (String splitMaterialNum : splitMaterialNums) {
                Long materialId = materialMap.get(splitMaterialNum);
                materialIds.add(materialId);
            }
            String materialIdStr = ((Object)materialIds).toString().replace("[", "").replace("]", "");
            imptMaterialMap.put("id", materialIdStr);
        }
    }

    private List<String> getDataNumList(Map<String, Object> sourceData, String fieldKey) {
        ArrayList<String> dataNumList = new ArrayList<String>(16);
        Map dataMap = (Map)sourceData.get(fieldKey);
        if (dataMap != null && dataMap.getOrDefault("importprop", "number") != null) {
            String mulOrgNum = (String)dataMap.get("number");
            String[] splitOrgNums = mulOrgNum.split(",");
            dataNumList.addAll(Arrays.asList(splitOrgNums));
        }
        return dataNumList;
    }
}

