/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.entryrowop;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.operation.entryrowop.model.EntryRowOpArgs;
import kd.bos.ext.scmc.plugin.operation.IEntryRowOpFormPlugin;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;

public class ImBillEntryRowOpFormPlugin
implements IEntryRowOpFormPlugin {
    private Integer unitPrecision = 10;
    private List<String> amountFields = new ArrayList<String>(8);

    public void calQtyTypeFields(EntryRowOpArgs args) {
        IFormView billView = args.getView();
        IDataModel model = billView.getModel();
        String entityName = model.getDataEntityType().getName();
        this.initAmountFields();
        String entryKey = args.getEntryKey();
        Integer srcRowIndex = args.getSrcRowIndex();
        List newRowIndex = args.getNewRowIndex();
        Map<Integer, BigDecimal> rowQtyMap = this.getRowIndexQtyMapping(model, entryKey, "qty", "unit", srcRowIndex, newRowIndex);
        Map<Integer, BigDecimal> rowAuxQtyMap = this.getRowIndexQtyMapping(model, entryKey, "qtyunit2nd", "unit2nd", srcRowIndex, newRowIndex);
        if (rowQtyMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u884c\u672a\u586b\u5199\u6570\u91cf, \u62c6\u5206\u884c\u6570\u91cf\u91d1\u989d\u7b49\u5b57\u6bb5\u65e0\u6cd5\u8ba1\u7b97\u3002", (String)"ImBillEntryRowOpFormPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        DynamicObject oldEntryInfo = (DynamicObject)OrmUtils.clone((IDataEntityBase)model.getEntryRowEntity(entryKey, srcRowIndex.intValue()), (boolean)false, (boolean)false);
        if ("im_initbill".equals(entityName)) {
            this.calInitBillQty(billView, entryKey, srcRowIndex, newRowIndex, rowQtyMap);
        } else {
            BigDecimal srcBaseQty = (BigDecimal)model.getValue("baseqty", srcRowIndex.intValue());
            this.setQtyTriggerChange(model, entityName, entryKey, srcRowIndex, newRowIndex, rowQtyMap);
            model.beginInit();
            this.setQtyValue(model, srcRowIndex, newRowIndex, rowAuxQtyMap, "qtyunit2nd");
            this.dealLastLineField(model, srcBaseQty, srcRowIndex, newRowIndex, "baseqty");
            if ("im_purreceivebill".equals(entityName)) {
                Integer lastIndex = (Integer)newRowIndex.get(newRowIndex.size() - 1);
                Object lastBaseQty = model.getValue("baseqty", lastIndex.intValue());
                Object lastQty = model.getValue("qty", lastIndex.intValue());
                model.setValue("qualifiedbaseqty", lastBaseQty, lastIndex.intValue());
                model.setValue("qualifiedqty", lastQty, lastIndex.intValue());
            }
            model.endInit();
        }
        model.beginInit();
        this.reCalLastRowAmount(model, srcRowIndex, newRowIndex, oldEntryInfo);
        model.endInit();
        billView.updateView(entryKey);
        if ("im_materialreqbill".equals(entityName)) {
            ArrayList<Integer> rowIndexs = new ArrayList<Integer>(newRowIndex);
            rowIndexs.add(srcRowIndex);
            for (Integer rowIndex : rowIndexs) {
                boolean unControlLedQty = (Boolean)model.getValue("uncontrolledqty", rowIndex.intValue());
                billView.setEnable(Boolean.valueOf(!unControlLedQty), rowIndex.intValue(), new String[]{"excessratio"});
                billView.setEnable(Boolean.valueOf(!unControlLedQty), rowIndex.intValue(), new String[]{"shortageratio"});
            }
        }
        IPageCache pageCache = billView.getPageCache();
        pageCache.put("CheckDataChange", "true");
    }

    private void initAmountFields() {
        this.amountFields.add("amount");
        this.amountFields.add("curamount");
        this.amountFields.add("taxamount");
        this.amountFields.add("curtaxamount");
        this.amountFields.add("amountandtax");
        this.amountFields.add("curamountandtax");
        this.amountFields.add("discountamount");
        this.amountFields.add("intercostamt");
        this.amountFields.add("materialcost");
        this.amountFields.add("curdeductibleamt");
    }

    private void setQtyTriggerChange(IDataModel model, String entityName, String entryKey, Integer srcRowIndex, List<Integer> newRowIndex, Map<Integer, BigDecimal> rowQtyMap) {
        if ("im_materialreqbill".equals(entityName) || "im_transapply".equals(entityName)) {
            Map<Integer, BigDecimal> rowAuditQtyMap = this.getRowIndexQtyMapping(model, entryKey, "auditqty", "unit", srcRowIndex, newRowIndex);
            model.beginInit();
            this.setQtyValue(model, srcRowIndex, newRowIndex, rowQtyMap, "qty");
            model.endInit();
            this.setQtyValue(model, srcRowIndex, newRowIndex, rowAuditQtyMap, "auditqty");
        } else {
            this.setQtyValue(model, srcRowIndex, newRowIndex, rowQtyMap, "qty");
        }
    }

    private void reCalLastRowAmount(IDataModel model, Integer srcRowIndex, List<Integer> newRowIndex, DynamicObject oldEntryInfo) {
        BigDecimal taxRate;
        Integer lastRow = newRowIndex.get(newRowIndex.size() - 1);
        for (String amountField : this.amountFields) {
            if (!oldEntryInfo.containsProperty(amountField)) continue;
            BigDecimal srcAmountValue = oldEntryInfo.getBigDecimal(amountField);
            BigDecimal newValue = (BigDecimal)model.getValue(amountField, srcRowIndex.intValue());
            if (srcAmountValue == null || BigDecimal.ZERO.compareTo(srcAmountValue) == 0 || newValue == null || BigDecimal.ZERO.compareTo(newValue) == 0) continue;
            this.dealLastLineField(model, srcAmountValue, srcRowIndex, newRowIndex, amountField);
            BigDecimal adjustedValue = (BigDecimal)model.getValue(amountField, lastRow.intValue());
            if (adjustedValue.compareTo(BigDecimal.ZERO) >= 0) continue;
            srcAmountValue = srcAmountValue.subtract(newValue);
            for (Integer rowIndex : newRowIndex) {
                if (srcAmountValue.compareTo(BigDecimal.ZERO) <= 0) {
                    model.setValue(amountField, (Object)BigDecimal.ZERO, rowIndex.intValue());
                }
                srcAmountValue = srcAmountValue.subtract((BigDecimal)model.getValue(amountField, rowIndex.intValue()));
            }
        }
        boolean taxRateZero = false;
        if (oldEntryInfo.containsProperty("taxrate") && ((taxRate = (BigDecimal)model.getValue("taxrate", lastRow.intValue())) == null || BigDecimal.ZERO.compareTo(taxRate) == 0)) {
            taxRateZero = true;
        }
        boolean isTax = false;
        if (model.getDataEntity().containsProperty("istax")) {
            isTax = (Boolean)model.getValue("istax");
        }
        if (taxRateZero && isTax && oldEntryInfo.containsProperty("amount") && oldEntryInfo.containsProperty("amountandtax")) {
            BigDecimal amountAndTax = (BigDecimal)model.getValue("amountandtax", lastRow.intValue());
            model.setValue("amount", (Object)amountAndTax, lastRow.intValue());
        }
    }

    private void dealLastLineField(IDataModel model, BigDecimal srcValue, Integer srcRowIndex, List<Integer> newRowIndex, String fieldKey) {
        BigDecimal baseQty = (BigDecimal)model.getValue(fieldKey, srcRowIndex.intValue());
        BigDecimal lastBaseQty = srcValue.subtract(baseQty.multiply(new BigDecimal(newRowIndex.size())));
        model.setValue(fieldKey, (Object)lastBaseQty, newRowIndex.get(newRowIndex.size() - 1).intValue());
    }

    private void calInitBillQty(IFormView billView, String entryKey, Integer srcRowIndex, List<Integer> newRowIndex, Map<Integer, BigDecimal> rowQtyMap) {
        IDataModel model = billView.getModel();
        Map<Integer, BigDecimal> yReceiveQtyMap = this.getRowIndexQtyMapping(model, entryKey, "yreceiveqty", "unit", srcRowIndex, newRowIndex);
        Map<Integer, BigDecimal> ySendQtyMap = this.getRowIndexQtyMapping(model, entryKey, "ysendqty", "unit", srcRowIndex, newRowIndex);
        Map<Integer, BigDecimal> rowQtyUnit2ndMap = this.getRowIndexQtyMapping(model, entryKey, "qtyunit2nd", "unit2nd", srcRowIndex, newRowIndex);
        Map<Integer, BigDecimal> rowYStartQtyMap = this.getRowIndexQtyMapping(model, entryKey, "ystartqtyunit2nd", "unit2nd", srcRowIndex, newRowIndex);
        Map<Integer, BigDecimal> rowYReceiveQtyMap = this.getRowIndexQtyMapping(model, entryKey, "yreceiveqtyunit2nd", "unit2nd", srcRowIndex, newRowIndex);
        Map<Integer, BigDecimal> rowYSendQtyMap = this.getRowIndexQtyMapping(model, entryKey, "ysendqtyunit2nd", "unit2nd", srcRowIndex, newRowIndex);
        BigDecimal srcBaseQty = (BigDecimal)model.getValue("baseqty", srcRowIndex.intValue());
        BigDecimal yStartBaseQty = (BigDecimal)model.getValue("ystartbaseqty", srcRowIndex.intValue());
        BigDecimal yReceiveBaseQty = (BigDecimal)model.getValue("yreceivebaseqty", srcRowIndex.intValue());
        BigDecimal ySendBaseQty = (BigDecimal)model.getValue("ysendbaseqty", srcRowIndex.intValue());
        this.setQtyValue(model, srcRowIndex, newRowIndex, rowQtyMap, "qty");
        this.setQtyValue(model, srcRowIndex, newRowIndex, yReceiveQtyMap, "yreceiveqty");
        this.setQtyValue(model, srcRowIndex, newRowIndex, ySendQtyMap, "ysendqty");
        model.beginInit();
        this.dealLastLineField(model, srcBaseQty, srcRowIndex, newRowIndex, "baseqty");
        this.dealLastLineField(model, yStartBaseQty, srcRowIndex, newRowIndex, "ystartbaseqty");
        this.dealLastLineField(model, yReceiveBaseQty, srcRowIndex, newRowIndex, "yreceivebaseqty");
        this.dealLastLineField(model, ySendBaseQty, srcRowIndex, newRowIndex, "ysendbaseqty");
        this.setQtyValue(model, srcRowIndex, newRowIndex, rowQtyUnit2ndMap, "qtyunit2nd");
        this.setQtyValue(model, srcRowIndex, newRowIndex, rowYStartQtyMap, "ystartqtyunit2nd");
        this.setQtyValue(model, srcRowIndex, newRowIndex, rowYReceiveQtyMap, "yreceiveqtyunit2nd");
        this.setQtyValue(model, srcRowIndex, newRowIndex, rowYSendQtyMap, "ysendqtyunit2nd");
        model.endInit();
    }

    private void setQtyValue(IDataModel model, Integer srcRowIndex, List<Integer> newRowIndex, Map<Integer, BigDecimal> rowQtyMap, String qtyFieldKey) {
        if (rowQtyMap.isEmpty()) {
            return;
        }
        model.setValue(qtyFieldKey, (Object)rowQtyMap.get(srcRowIndex), srcRowIndex.intValue());
        for (Integer rowIndex : newRowIndex) {
            model.setValue(qtyFieldKey, (Object)rowQtyMap.get(rowIndex), rowIndex.intValue());
        }
    }

    private Map<Integer, BigDecimal> getRowIndexQtyMapping(IDataModel model, String entryKey, String qtyFieldKey, String unitKey, Integer srcRowIndex, List<Integer> newRowIndex) {
        int rowCount = newRowIndex.size() + 1;
        HashMap<Integer, BigDecimal> rowQtyMap = new HashMap<Integer, BigDecimal>(rowCount);
        DynamicObjectCollection billEntry = model.getDataEntity().getDynamicObjectCollection(entryKey);
        if (billEntry.isEmpty() || newRowIndex.isEmpty()) {
            return rowQtyMap;
        }
        DynamicObject entry = (DynamicObject)billEntry.get(srcRowIndex.intValue());
        BigDecimal srcQty = entry.getBigDecimal(qtyFieldKey);
        if (srcQty == null || BigDecimal.ZERO.compareTo(srcQty) == 0) {
            return rowQtyMap;
        }
        DynamicObject unit = entry.getDynamicObject(unitKey);
        if (unit != null) {
            this.unitPrecision = unit.getInt("precision");
        }
        BigDecimal average = srcQty.divide(new BigDecimal(rowCount), (int)this.unitPrecision, RoundingMode.DOWN);
        BigDecimal multiply = average.multiply(new BigDecimal(newRowIndex.size()));
        BigDecimal lastRowQty = srcQty.subtract(multiply);
        rowQtyMap.put(srcRowIndex, average);
        for (int i = 0; i < newRowIndex.size() - 1; ++i) {
            rowQtyMap.put(newRowIndex.get(i), average);
        }
        rowQtyMap.put(newRowIndex.get(newRowIndex.size() - 1), lastRowQty);
        return rowQtyMap;
    }
}

