/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.home;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.scmc.im.enums.ReadStatusEnum;
import kd.scmc.im.errorcode.InvHomePageErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class DelMsgListPlugin
extends AbstractListPlugin
implements ProgresssListener {
    private static final String KEY_READ = ReadStatusEnum.READ.getKey();
    private static final String KEY_NOREAD = ReadStatusEnum.NOREAD.getKey();
    private static final String KEY_ALL = ReadStatusEnum.ALL.getKey();
    private static final String CACHE_KEY = "ckeys";
    private static final List<String> arrays = Arrays.asList(KEY_READ, KEY_NOREAD);

    public void initialize() {
        super.initialize();
        this.addListener();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(KEY_NOREAD, (Object)Boolean.TRUE);
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        HashSet<String> ckeys = new HashSet<String>();
        ckeys.add(KEY_NOREAD);
        this.getPageCache().put(CACHE_KEY, SerializationUtils.toJsonString(ckeys));
        this.initEntryData();
        this.refrushCheckBox();
        this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.start();
    }

    public void onProgress(ProgressEvent evt) {
        this.refrush();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Set ckeys = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_KEY), Set.class);
        switch (ReadStatusEnum.getEnumByVal((String)key)) {
            case ALL: 
            case READ: 
            case NOREAD: {
                boolean ischeck = Boolean.parseBoolean(e.getChangeSet()[0].getNewValue().toString());
                if (ReadStatusEnum.ALL.getKey().equals(key)) {
                    this.allCheck(ischeck);
                    if (ischeck) {
                        ckeys.addAll(arrays);
                    } else {
                        ckeys.clear();
                    }
                } else {
                    if (ischeck) {
                        ckeys.add(key);
                    } else {
                        ckeys.remove(key);
                    }
                    this.allCBcheck(ckeys.size() == arrays.size());
                }
                this.getPageCache().put(CACHE_KEY, SerializationUtils.toJsonString((Object)ckeys));
                this.refrush();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_quick": {
                this.checkHasSelect();
                this.showQuickDelForm();
                break;
            }
            case "bar_del": {
                this.checkHasSelect();
                this.deleteSelectMsg();
                break;
            }
            case "bar_refrush": {
                this.refrush();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "confirm_delete": {
                if (!evt.getResult().equals((Object)MessageBoxResult.Yes)) break;
                int[] rows = this.getSelectRows();
                List<Object> keys = this.getSelectRowPks(rows);
                this.deleteDataByEntityKeys(keys);
                this.refrush();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String callBackId;
        super.closedCallBack(evt);
        switch (callBackId = evt.getActionId()) {
            case "close_quickdel": {
                this.refrush();
                break;
            }
        }
    }

    private void setMsgReadStatus(List<Object> pks) {
        MessageCenterServiceHelper.setMsgReadState(pks);
    }

    private void addListener() {
    }

    private List<Object> getSelectRowPks(int[] rows) {
        ArrayList<Object> pks = new ArrayList<Object>(rows.length);
        for (int row : rows) {
            pks.add(this.getModel().getEntryRowEntity("entryentity", row).get("eid"));
        }
        return pks;
    }

    private void deleteSelectMsg() {
        int[] rows = this.getSelectRows();
        List<Object> keys = this.getSelectRowPks(rows);
        boolean exist = this.checkExistNoReadMsg(rows);
        if (exist) {
            this.getView().showConfirm(CommonUtils.getCodeErrorMessage((ErrorCode)new InvHomePageErrorCode().getDATA_DELETE_SURE()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirm_delete", (IFormPlugin)this));
            return;
        }
        this.deleteDataByEntityKeys(keys);
        this.refrush();
    }

    private int[] getSelectRows() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        return entry.getSelectRows();
    }

    private void deleteDataByEntityKeys(List<Object> keys) {
        MessageCenterServiceHelper.deleteMessage(keys);
        this.getView().showSuccessNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvHomePageErrorCode().getDELETE_SUCCESS()));
    }

    private boolean checkExistNoReadMsg(int[] rows) {
        for (int index : rows) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", index);
            if (!ReadStatusEnum.NOREAD.getValue().equals(row.getString("readstate"))) continue;
            return true;
        }
        return false;
    }

    private void showQuickDelForm() {
        Map<String, Object[]> map = this.getSelectDataMap();
        HashSet<Object> pks = new HashSet<Object>(map.size());
        for (Map.Entry<String, Object[]> value : map.entrySet()) {
            if (!pks.add(value.getValue()[1])) continue;
            this.showBillForm(value);
        }
        ArrayList<Object> msgPks = new ArrayList<Object>();
        msgPks.addAll(map.keySet());
        this.setMsgReadStatus(msgPks);
    }

    private void showBillForm(Map.Entry<String, Object[]> value) {
        Object[] objects = value.getValue();
        boolean exist = QueryServiceHelper.exists((String)((String)objects[0]), (Object)objects[1]);
        if (!exist) {
            MessageCenterServiceHelper.deleteMessage(Collections.singletonList(value.getKey()));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u5f53\u524d\u8fd9\u6761\u6d88\u606f\u65e0\u6cd5\u5904\u7406\u5355\u636e\u3002", (String)"DelMsgListPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter param = new BillShowParameter();
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_quickdel"));
        param.setFormId((String)objects[0]);
        param.setPkId(objects[1]);
        this.getView().showForm((FormShowParameter)param);
    }

    private Map<String, Object[]> getSelectDataMap() {
        int[] rowIndexs = this.getSelectRows();
        HashMap<String, Object[]> dataMap = new HashMap<String, Object[]>(rowIndexs.length);
        for (int index : rowIndexs) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", index);
            Object[] obj = new Object[]{row.getString("eititytype"), row.get("billid")};
            dataMap.put(row.getString("eid"), obj);
        }
        return dataMap;
    }

    private int checkHasSelect() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        if (entry.getSelectRows().length < 1) {
            throw new KDBizException(new InvHomePageErrorCode().getDATA_SELECT(), new Object[0]);
        }
        return entry.getSelectRows().length;
    }

    private void refrush() {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        this.initEntryData();
        this.refrushCheckBox();
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void refrushCheckBox() {
        int size = this.setReadStateSize(ReadStatusEnum.NOREAD.getValue(), ReadStatusEnum.NOREAD.getNumKey());
        int size2 = this.setReadStateSize(ReadStatusEnum.READ.getValue(), ReadStatusEnum.READ.getNumKey());
        this.setLabelText(ReadStatusEnum.ALL.getNumKey(), size + size2);
    }

    private int setReadStateSize(String value, String key) {
        List<Map<String, Object>> entry = this.getMsgListFromCache();
        int size = 0;
        for (Map<String, Object> row : entry) {
            if (!value.equals(row.get("readstate"))) continue;
            ++size;
        }
        this.setLabelText(key, size);
        return size;
    }

    private void setLabelText(String key, int size) {
        Label label = (Label)this.getControl(key);
        label.setText(String.valueOf(size));
    }

    private void initEntryData() {
        List<Map<String, Object>> doc = this.getMsgList();
        if (doc.size() > 0) {
            int[] count = this.getModel().batchCreateNewEntryRow("entryentity", doc.size());
            for (int i = 0; i < count.length; ++i) {
                this.getModel().setValue("eid", doc.get(i).get("id"), count[i]);
                this.getModel().setValue("mtitle", doc.get(i).get("title"), count[i]);
                this.getModel().setValue("sendtime", doc.get(i).get("createdate"), count[i]);
                this.getModel().setValue("receiveusers", doc.get(i).get("receiveusers"), count[i]);
                this.getModel().setValue("readstate", doc.get(i).get("readstate"), count[i]);
                this.getModel().setValue("eititytype", doc.get(i).get("entitynumber"), count[i]);
                this.getModel().setValue("billid", doc.get(i).get("bizdataid"), count[i]);
            }
        }
    }

    private List<Map<String, Object>> getMsgList() {
        Set ckeys = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_KEY), Set.class);
        ArrayList status = new ArrayList();
        ckeys.forEach(p -> status.add(ReadStatusEnum.getEnumByVal((String)p).getValue()));
        List msg = MessageCenterServiceHelper.getMessageByFilter((String)RequestContext.get().getUserId(), null, (String)"scmc_im", (String)"message", (boolean)false, (int)0);
        this.getPageCache().put("data", SerializationUtils.toJsonString((Object)msg));
        Iterator iter = msg.iterator();
        if (status.size() == 1) {
            if (((String)status.get(0)).equals(ReadStatusEnum.READ.getValue())) {
                while (iter.hasNext()) {
                    if (!((Map)iter.next()).get("readstate").equals(ReadStatusEnum.NOREAD.getValue())) continue;
                    iter.remove();
                }
            } else {
                while (iter.hasNext()) {
                    if (!((Map)iter.next()).get("readstate").equals(ReadStatusEnum.READ.getValue())) continue;
                    iter.remove();
                }
            }
        } else if (status.size() == 0) {
            msg.clear();
        }
        return msg;
    }

    private List<Map<String, Object>> getMsgListFromCache() {
        String data = this.getPageCache().get("data");
        if (StringUtils.isEmpty((CharSequence)data)) {
            return new ArrayList<Map<String, Object>>();
        }
        List msg = (List)SerializationUtils.fromJsonString((String)data, List.class);
        return msg;
    }

    private void allCBcheck(boolean flag) {
        this.getModel().beginInit();
        this.getModel().setValue(KEY_ALL, (Object)flag);
        this.getModel().endInit();
        this.getView().updateView(KEY_ALL);
    }

    private void allCheck(boolean ischeck) {
        this.getModel().beginInit();
        arrays.forEach(p -> this.getModel().setValue(p, (Object)ischeck));
        this.getModel().endInit();
        this.getView().updateView(KEY_NOREAD);
        this.getView().updateView(KEY_READ);
    }
}

