/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.inbill;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.algorithm.TaxAlgorithmForForm;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.DefaultTaxRateHelper;
import kd.scmc.im.business.helper.ExchangeRateHelper;
import kd.scmc.im.business.helper.FarmProductsHelper;
import kd.scmc.im.business.helper.ImBillEditHelper;
import kd.scmc.im.business.helper.InvoiceBizHelper;
import kd.scmc.im.business.helper.SetValueForBotpWBHelper;
import kd.scmc.im.business.helper.SupplierHelper;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public class PurInBillEditPlugin
extends ImBillEditPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final Long DEFAULT_INVOICE_BIZ = 1533341968170710016L;
    private static final Long PROFORMA_INVOICE_BIZ = 1571047306646894592L;
    private TaxAlgorithmForForm algo = null;

    protected TaxAlgorithmForForm getAlgorithm() {
        if (this.algo == null) {
            this.algo = new TaxAlgorithmForForm(this.getView());
        }
        return this.algo;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"providersupplier", "receivesupplier", "invoicesupplier", "providerlinkman", "bizoperatorgroup", "bizoperator", "bizdept", "entrysettleorg", "owner", "outowner", "keeper", "outkeeper", "supplier", "taxrateid", "invoicebiztype", "outwarehouse", "outlocation"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ImBillEditHelper helper = new ImBillEditHelper(this.getView());
        IDataModel bill = this.getModel();
        DynamicObject bizOrg = (DynamicObject)bill.getValue("bizorg");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        switch (key) {
            case "material": {
                FarmProductsHelper.materialSelect((IDataModel)this.getModel(), (ListShowParameter)showParameter);
                break;
            }
            case "supplier": {
                this.supplierSelect(e);
                break;
            }
            case "providersupplier": 
            case "invoicesupplier": 
            case "receivesupplier": {
                this.supplierInfoSelect(e, key);
                break;
            }
            case "providerlinkman": {
                this.providerLinkmanSelect(e, rowIndex, showParameter);
                break;
            }
            case "bizoperatorgroup": {
                this.bizOperatorGroupSelect(e, bizOrg, showParameter);
                break;
            }
            case "bizoperator": {
                this.bizOperatorSelect(e, bizOrg, showParameter);
                break;
            }
            case "bizdept": {
                this.bizDeptSelect(e, bizOrg, showParameter);
                break;
            }
            case "owner": {
                this.ownerSelect(e);
                break;
            }
            case "taxrateid": {
                this.taxrateSelect(e, showParameter);
                break;
            }
            case "invoicebiztype": {
                InvoiceBizHelper.invoiceBizSelect((IFormView)this.getView(), (ListShowParameter)showParameter);
                break;
            }
            case "outwarehouse": {
                helper.warehouseSelect(e, showParameter, this.getModel());
                break;
            }
            case "outlocation": {
                helper.locationSelect(e, showParameter, this.getModel(), rowIndex, "outwarehouse");
                break;
            }
        }
    }

    private void supplierSelect(BeforeF7SelectEvent e) {
        this.addVMISelect(e);
        this.addBizFunctionFilter(e, "supplier");
    }

    private void initOutWarehouse() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        ImBillEditHelper helper = new ImBillEditHelper(this.getView());
        for (int i = 0; i < entryRowCount; ++i) {
            helper.updateEnableLocation("outlocation", (DynamicObject)this.getModel().getValue("outwarehouse", i), i);
        }
    }

    private void addVMISelect(BeforeF7SelectEvent e) {
        String domain;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && "6".equals(domain = bizType.getString("domain"))) {
            QFilter q = new QFilter("enablevmi", "=", (Object)"1");
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)q);
        }
    }

    private void supplierInfoSelect(BeforeF7SelectEvent e, String propName) {
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
        if (supplier == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_NEWSUPPLIER(), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.addBizFunctionFilter(e, propName);
    }

    private void providerLinkmanSelect(BeforeF7SelectEvent e, int rowIndex, ListShowParameter showParameter) {
        DynamicObject providerSupplier = (DynamicObject)this.getModel().getValue("supplier", rowIndex);
        if (providerSupplier == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_PROVIDERSUPPLIER(), (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("supplierid", "=", providerSupplier.getPkValue()).and("invalid", "=", (Object)false)));
        }
    }

    private void bizOperatorGroupSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\u3002", (String)"PurInBillEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        DynamicObject bizoperator = (DynamicObject)this.getModel().getValue("bizoperator");
        if (bizoperator == null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0));
        } else {
            bizoperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizoperator.getPkValue(), (String)"bd_operator");
            QFilter qFilter01 = new QFilter("operatorid", "=", bizoperator.getDynamicObject("operatorid").getPkValue());
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter01});
            if (map.size() != 0) {
                ArrayList list = new ArrayList(map.values());
                ArrayList<Long> groupList = new ArrayList<Long>();
                for (int i = 0; i < list.size(); ++i) {
                    groupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", groupList));
            }
        }
    }

    private void bizOperatorSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
        QFilter enableFilter;
        long bizOrgId;
        QFilter operatorGroupIdFilter;
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\u3002", (String)"PurInBillEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        BasedataEdit control = (BasedataEdit)this.getControl("bizoperatorgroup");
        BasedataProp property = (BasedataProp)control.getProperty();
        FilterBuilder buildCoreFilter = property.buildCoreFilter(this.getModel());
        QFilter filterGridFilter = buildCoreFilter.getQFilter();
        Map currentBizOrgBizOperatorGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{filterGridFilter, operatorGroupIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)(bizOrgId = Long.parseLong(bizOrg.getPkValue().toString()))), enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (currentBizOrgBizOperatorGroup != null && !currentBizOrgBizOperatorGroup.isEmpty()) {
            HashSet keySet = new HashSet(currentBizOrgBizOperatorGroup.keySet());
            QFilter qFilter = new QFilter("operatorgrpid", "in", new ArrayList(keySet));
            QFilter qFilter1 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter, qFilter1));
        } else if (currentBizOrgBizOperatorGroup == null || currentBizOrgBizOperatorGroup.isEmpty()) {
            showParameter.getListFilterParameter().setFilter(new QFilter("operatorgrpid", "in", null));
        }
    }

    private void bizDeptSelect(BeforeF7SelectEvent e, DynamicObject bizOrg, ListShowParameter showParameter) {
    }

    private void ownerSelect(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        String type = (String)this.getModel().getValue("ownertype", rowIndex);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        switch (type) {
            case "bos_org": 
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                this.addVMISelect(e);
                break;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    protected void taxrateSelect(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        IDataModel dataModel = this.getModel();
        Object bizTime = dataModel.getValue("biztime");
        if (bizTime == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_BIZTIME()));
            e.setCancel(true);
            return;
        }
        QFilter f = new QFilter("activedate", "<=", bizTime);
        QFilter fExpdate = new QFilter("expdate", ">=", bizTime);
        fExpdate.or(new QFilter("expdate", "is null", null));
        f.and(fExpdate);
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("billno")) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            if ("supplier".equals(propName)) {
                this.changeSupplier(newValue);
            } else if ("providersupplier".equals(propName)) {
                this.changeProviderSupplier((DynamicObject)newValue, rowIndex);
            } else if ("istax".equals(propName)) {
                this.changeIsTax(newValue);
            } else if ("inputamount".equals(propName)) {
                this.changeInputAmount((Boolean)newValue);
            } else if ("ispresent".equals(propName)) {
                this.changeIsPresent(newValue, rowIndex);
            } else if ("priceandtax".equals(propName)) {
                this.changePriceAndTax(rowIndex, newValue, oldValue);
                this.setByIspresent(newValue, (Boolean)this.getModel().getValue("ispresent", rowIndex), rowIndex);
            } else if ("price".equals(propName)) {
                this.setByIspresent(newValue, (Boolean)this.getModel().getValue("ispresent", rowIndex), rowIndex);
            } else if ("actualprice".equals(propName)) {
                this.changeActualPrice(rowIndex, newValue, oldValue);
            } else if ("actualtaxprice".equals(propName)) {
                this.changeActualTaxPrice(oldValue, newValue, rowIndex);
            } else if ("discounttype".equals(propName)) {
                this.changeDiscountType(newValue, rowIndex);
            } else if ("discountrate".equals(propName)) {
                this.changeDisCountRate(propName, oldValue, rowIndex);
            } else if ("discountamount".equals(propName)) {
                this.changeDiscountAmount(propName, oldValue, (BigDecimal)newValue, rowIndex);
            } else if ("taxamount".equals(propName)) {
                this.changeTaxMount(propName, oldValue, newValue, rowIndex);
            } else if ("taxrateid".equals(propName)) {
                this.changeTaxRateID((DynamicObject)newValue, rowIndex);
            } else if ("bizoperator".equals(propName)) {
                this.changeBizOperator((DynamicObject)newValue);
            } else if ("bizoperatorgroup".equals(propName)) {
                this.changeBizOperatorGroup((DynamicObject)newValue);
            } else if ("bizorg".equals(propName)) {
                this.changeBizOrg(newValue);
                this.change4BizOrg((DynamicObject)newValue);
            } else if ("entryreqorg".equals(propName)) {
                this.changeEntryReqOrg((DynamicObject)newValue, rowIndex);
            } else if ("biztime".equals(propName)) {
                this.changeBizTime(this.getModel());
            } else if ("qty".equals(propName) || "unit".equals(propName)) {
                IDataModel model = this.getModel();
                SetValueForBotpWBHelper.purInSetValueByQtyChange((IDataModel)model, (int)rowIndex);
            } else if ("material".equals(propName)) {
                DefaultTaxRateHelper.changeMaterial((IDataModel)this.getModel(), (String)"supplier", (DynamicObject)((DynamicObject)newValue), (int)rowIndex);
                FarmProductsHelper.changeMaterial((IDataModel)this.getModel(), (DynamicObject)((DynamicObject)newValue), (int)rowIndex);
            } else if ("currency".equals(propName) || "settlecurrency".equals(propName) || "exratetable".equals(propName) || "exratedate".equals(propName)) {
                this.checkExchangeRate(false, null);
            } else if ("invoicebiztype".equals(propName)) {
                InvoiceBizHelper.invoiceBizChange((IDataModel)this.getModel(), (DynamicObject)((DynamicObject)newValue));
            } else if ("invtype".equals(propName)) {
                this.changeInvType(rowIndex);
            } else if ("owner".equals(propName)) {
                this.changeOwner((DynamicObject)newValue, rowIndex);
            } else if ("invscheme".equals(propName)) {
                this.handleOutWarehouseVisible();
                this.clearWarehouse("outwarehouse", "outlocation");
                this.changeInvScheme();
            } else if ("taxpayertype".equals(propName)) {
                InvoiceBizHelper.taxPayerChange((IDataModel)this.getModel(), (int)rowIndex);
            } else if ("outwarehouse".equals(propName)) {
                this.changeOutWarehouse(valueSet, "outlocation");
            } else if ("location".equals(propName)) {
                this.changeOutLocation(rowIndex);
            } else if ("warehouse".equals(propName)) {
                this.changeWarehouse(rowIndex);
            }
            if ("settlecurrency".equals(propName)) {
                this.changeSettleCurrency(oldValue, newValue);
            }
            this.getAlgorithm().calByChange(e);
            if (!"taxamount".equals(propName) && !"taxrate".equals(propName)) continue;
            this.changeTaxMountOrTax(rowIndex);
        }
    }

    private void changeTaxMountOrTax(int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal deductibleRate = (BigDecimal)model.getValue("deductiblerate", rowIndex);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
        if (deductibleRate != null && taxRate != null && deductibleRate.compareTo(taxRate) == 0) {
            model.setValue("curdeductibleamt", model.getValue("curtaxamount", rowIndex), rowIndex);
            model.setValue("intercostamt", model.getValue("curamount", rowIndex), rowIndex);
            this.getView().updateView("curdeductibleamt", rowIndex);
            this.getView().updateView("intercostamt", rowIndex);
        }
    }

    private void changeInputAmount(boolean inputAmount) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.initPriceField(isTax, inputAmount, i);
        }
    }

    private void changeOutLocation(int rowIndex) {
        DynamicObject wareHouse = (DynamicObject)this.getModel().getValue("warehouse");
        DynamicObject outWareHouse = (DynamicObject)this.getModel().getValue("outwarehouse");
        DynamicObject outLocation = (DynamicObject)this.getModel().getValue("outlocation");
        if (wareHouse == null || outWareHouse == null) {
            return;
        }
        if (wareHouse.getPkValue().equals(outWareHouse.getPkValue()) && outLocation == null && this.isOutUpdate()) {
            Object value = this.getModel().getValue("location", rowIndex);
            this.getModel().setValue("outlocation", value, rowIndex);
        }
    }

    private void changeWarehouse(int rowIndex) {
        DynamicObject wareHouse = (DynamicObject)this.getModel().getValue("warehouse");
        Object outWareHouse = this.getModel().getValue("outwarehouse");
        if (outWareHouse == null && this.isOutUpdate()) {
            this.getModel().setValue("outwarehouse", (Object)wareHouse, rowIndex);
        }
    }

    private void handleOutWarehouseVisible() {
        this.getView().setVisible(Boolean.valueOf(this.isOutUpdate()), new String[]{"outwarehouse", "outlocation"});
    }

    private boolean isOutUpdate() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (scheme == null) {
            return false;
        }
        DynamicObject invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        if (invScheme == null) {
            return false;
        }
        return invScheme.getBoolean("isoutupdate");
    }

    private void changeBizTime(IDataModel model) {
        int rowCount = model.getEntryRowCount("billentry");
        Date bizTime = (Date)model.getValue("biztime");
        if (rowCount > 0) {
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("billentry");
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                boolean needClear;
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                DynamicObject taxrate = dynamicObject.getDynamicObject("taxrateid");
                if (taxrate == null) continue;
                Date activedate = taxrate.getDate("activedate");
                Date expdate = taxrate.getDate("expdate");
                boolean bl = needClear = bizTime == null || bizTime.before(activedate) || expdate != null && bizTime.after(expdate);
                if (!needClear) continue;
                this.setValue("taxrateid", null, i, false);
                this.changeTaxRateID(null, i);
            }
        }
    }

    private void changeSupplier(Object newValue) {
        DynamicObject supplier = (DynamicObject)newValue;
        Object supplierId = null;
        DynamicObject invoiceSupplier = null;
        DynamicObject receivingSupplier = null;
        DynamicObject settlementCy = null;
        DynamicObject settlementType = null;
        DynamicObject payCond = null;
        IDataModel bill = this.getModel();
        int size = bill.getEntryEntity("billentry").size();
        if (supplier == null) {
            bill.setValue("paycondition", null);
            bill.setValue("settletype", null);
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                bill.setValue("invoicesupplier", null, rowIndex);
                bill.setValue("receivesupplier", null, rowIndex);
                bill.setValue("providersupplier", null, rowIndex);
                bill.setValue("provideraddress", null, rowIndex);
                bill.setValue("providerlinkman", null, rowIndex);
            }
            return;
        }
        invoiceSupplier = supplier.getDynamicObject("invoicesupplierid");
        receivingSupplier = supplier.getDynamicObject("receivingsupplierid");
        settlementCy = supplier.getDynamicObject("settlementcyid");
        settlementType = supplier.getDynamicObject("settlementtypeid");
        payCond = supplier.getDynamicObject("paycond");
        supplierId = supplier.getPkValue();
        bill.setValue("paycondition", payCond == null ? null : payCond.getPkValue());
        bill.setValue("settletype", settlementType == null ? null : settlementType.getPkValue());
        if (settlementCy != null) {
            bill.setValue("settlecurrency", settlementCy.getPkValue());
        } else {
            DynamicObject currency = (DynamicObject)bill.getValue("currency");
            bill.setValue("settlecurrency", currency == null ? null : currency.getPkValue());
        }
        DynamicObject invoiceType = (DynamicObject)supplier.get("invoicecategory");
        String appId = this.getView().getFormShowParameter().getAppId();
        if (invoiceType != null && appId != null) {
            Long invoiceTypeId = invoiceType.getLong("id");
            DynamicObject invoiceBizType = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"CommonHelperService", (String)"getInvoiceBizType", (Object[])new Object[]{invoiceTypeId, appId});
            if (invoiceBizType != null) {
                bill.setValue("invoicebiztype", (Object)invoiceBizType);
            } else {
                bill.setValue("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
            }
        } else {
            bill.setValue("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
        }
        Object bizFunction = supplier.get("bizfunction");
        ILocaleString providerAddress = SupplierHelper.getValidDefaultMultilingualAddress((DynamicObject)supplier);
        DynamicObject linkman = SupplierHelper.getDefaultLinkMan((DynamicObject)supplier);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            String outKeeperType;
            String keeperType;
            String outOwnerType;
            String type;
            if (bizFunction != null && !bizFunction.toString().isEmpty()) {
                String bizFunctionStr = bizFunction.toString();
                bill.setValue("invoicesupplier", invoiceSupplier == null ? (bizFunctionStr.contains("2") ? supplier.getPkValue() : null) : invoiceSupplier.getPkValue(), rowIndex);
                bill.setValue("receivesupplier", receivingSupplier == null ? (bizFunctionStr.contains("3") ? supplier.getPkValue() : null) : receivingSupplier.getPkValue(), rowIndex);
                bill.setValue("providersupplier", bizFunctionStr.contains("1") ? supplier.getPkValue() : null, rowIndex);
            }
            if ("bd_supplier".equals(type = (String)bill.getValue("ownertype", rowIndex))) {
                bill.setValue("owner", supplierId, rowIndex);
            }
            if ("bd_supplier".equals(outOwnerType = (String)bill.getValue("outownertype", rowIndex))) {
                bill.setValue("outowner", supplierId, rowIndex);
            }
            if ("bd_supplier".equals(keeperType = (String)bill.getValue("keepertype", rowIndex))) {
                bill.setValue("keeper", supplierId, rowIndex);
            }
            if ("bd_supplier".equals(outKeeperType = (String)bill.getValue("outkeepertype", rowIndex))) {
                bill.setValue("outkeeper", supplierId, rowIndex);
            }
            bill.setValue("provideraddress", (Object)providerAddress, rowIndex);
            bill.setValue("providerlinkman", (Object)linkman, rowIndex);
        }
    }

    private void changeProviderSupplier(DynamicObject providerSupplier, int rowIndex) {
    }

    private void changeOwner(DynamicObject owner, int rowIndex) {
        Object ownerType = this.getModel().getValue("ownertype", rowIndex);
        if ("bos_org".equals(ownerType)) {
            if (owner != null) {
                Map cacheOwners = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"taxpayertype", (QFilter[])new QFilter("id", "=", owner.getPkValue()).toArray());
                this.setTaxPayerType(rowIndex, owner, cacheOwners);
            } else {
                this.getModel().setValue("taxpayertype", null, rowIndex);
            }
        } else {
            this.getModel().setValue("taxpayertype", null, rowIndex);
        }
    }

    private void changeInvType(int rowIndex) {
        DynamicObject owner = (DynamicObject)this.getModel().getValue("owner", rowIndex);
        this.changeOwner(owner, rowIndex);
    }

    private void changeInvScheme() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject owner = (DynamicObject)this.getModel().getValue("owner", i);
            this.changeOwner(owner, i);
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.initOutWarehouse();
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if ("billentry".equals(entryName)) {
            DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
            DynamicObject invoiceSupplier = null;
            DynamicObject receivingSupplier = null;
            DynamicObject deliverSupplier = null;
            if (supplier != null) {
                String bizFunction = supplier.get("bizfunction") == null ? "" : supplier.get("bizfunction").toString();
                invoiceSupplier = supplier.getDynamicObject("invoicesupplierid");
                invoiceSupplier = invoiceSupplier == null ? (bizFunction.contains("2") ? supplier : null) : invoiceSupplier;
                receivingSupplier = supplier.getDynamicObject("receivingsupplierid");
                receivingSupplier = receivingSupplier == null ? (bizFunction.contains("3") ? supplier : null) : receivingSupplier;
                deliverSupplier = bizFunction.contains("1") ? supplier : null;
            }
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            boolean inputAmount = (Boolean)this.getModel().getValue("inputamount");
            ILocaleString providerAddress = SupplierHelper.getValidDefaultMultilingualAddress((DynamicObject)supplier);
            DynamicObject linkman = SupplierHelper.getDefaultLinkMan((DynamicObject)supplier);
            boolean isFarmBillType = FarmProductsHelper.isFarmBillType((DynamicObject)this.getModel().getDataEntity());
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.initPriceField(isTax, inputAmount, rowIndex);
                this.initNewEntry(rowIndex, invoiceSupplier, receivingSupplier, deliverSupplier);
                this.getModel().setValue("provideraddress", (Object)providerAddress, rowIndex);
                this.getModel().setValue("providerlinkman", (Object)linkman, rowIndex);
                this.getView().setEnable(Boolean.valueOf(isFarmBillType), rowIndex, new String[]{"deductiblerate", "intercostamt"});
            }
        }
    }

    private void changeTaxRateID(DynamicObject taxRateID, int rowIndex) {
        DynamicObject bill = this.getBill();
        boolean purInBillType = InvoiceBizHelper.isPurInBillType((DynamicObject)bill);
        if (taxRateID == null) {
            this.getModel().setValue("taxrate", (Object)0, rowIndex);
            if (purInBillType) {
                this.getModel().setValue("deductiblerate", (Object)BigDecimal.ZERO, rowIndex);
            }
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
        if (purInBillType) {
            DynamicObject invoiceBiz = bill.getDynamicObject("invoicebiztype");
            if (invoiceBiz != null) {
                Long invoiceBizId = invoiceBiz.getLong("id");
                Object taxPayerType = model.getValue("taxpayertype", rowIndex);
                if ("1".equals(taxPayerType) && (DEFAULT_INVOICE_BIZ.equals(invoiceBizId) || PROFORMA_INVOICE_BIZ.equals(invoiceBizId))) {
                    model.setValue("deductiblerate", taxRateID.get("taxrate"), rowIndex);
                } else {
                    model.setValue("deductiblerate", (Object)BigDecimal.ZERO, rowIndex);
                }
            } else {
                model.setValue("deductiblerate", (Object)BigDecimal.ZERO, rowIndex);
            }
        }
    }

    private void changeDiscountType(Object newValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        model.setValue("discountrate", null, rowIndex);
        model.setValue("discountamount", null, rowIndex);
        if (DiscountTypeEnum.NULL.getValue().equals(newValue)) {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountamount"});
        } else {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountamount"});
        }
    }

    private void changeDisCountRate(String fieldName, Object oldValue, int rowIndex) {
        DynamicObject settleCurrency;
        IDataModel model = this.getModel();
        int discountRateScale = 4;
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate == null) {
            discountRate = BigDecimal.ZERO;
        }
        if ((settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency")) != null) {
            discountRateScale = settleCurrency.getInt("priceprecision");
        }
        if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            discountRate = discountRate.setScale(discountRateScale, 4);
            model.setValue("discountrate", (Object)discountRate, rowIndex);
            if (discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) > 0) {
                model.setValue(fieldName, oldValue, rowIndex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e100%\u3002", (String)"PurInBillEditPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else if (discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) == 0) {
                model.setValue("ispresent", (Object)true, rowIndex);
            }
        } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            boolean isTax = (Boolean)model.getValue("istax");
            BigDecimal amount = discountRate;
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                if (amount.compareTo(priceAndTax) > 0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurInBillEditPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                if (amount.compareTo(price) > 0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurInBillEditPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            model.setValue("discountrate", (Object)discountRate.doubleValue(), rowIndex);
        }
    }

    private void changeIsTax(Object newValue) {
        if (newValue instanceof Boolean) {
            boolean isTax = (Boolean)newValue;
            IDataModel model = this.getModel();
            boolean inputAmount = (Boolean)model.getValue("inputamount");
            int discountRateScale = this.getDiscountRateScale();
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.initPriceField(isTax, inputAmount, i);
                this.checkAndSetDiscountRate(isTax, model, discountRateScale, i);
            }
        }
    }

    protected void initPriceField(boolean isTax, boolean inputAmount, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)model.getValue("ispresent", rowIndex);
        view.setEnable(Boolean.valueOf(!isPresent), rowIndex, new String[]{"taxrateid"});
        view.setEnable(Boolean.valueOf(!isPresent && !this.isDrawByBOTP()), rowIndex, new String[]{"discounttype"});
        boolean isDiscount = DiscountTypeEnum.NULL.getValue().equals(model.getValue("discounttype", rowIndex));
        view.setEnable(Boolean.valueOf(!isDiscount && !isPresent), rowIndex, new String[]{"discountrate"});
        view.setEnable(Boolean.valueOf(!isDiscount && !isPresent), rowIndex, new String[]{"discountamount"});
        boolean isEnable = !isPresent && !isTax;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"actualprice"});
        view.setEnable(Boolean.valueOf(isEnable && inputAmount), rowIndex, new String[]{"amount"});
        isEnable = !isPresent && isTax;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"actualtaxprice"});
        view.setEnable(Boolean.valueOf(isEnable && inputAmount), rowIndex, new String[]{"amountandtax"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"taxamount"});
        if (inputAmount && !isPresent) {
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"price"});
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"priceandtax"});
        } else {
            this.setPriceEnable(isPresent, isTax, rowIndex);
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)newValue;
        boolean isTax = (Boolean)model.getValue("istax");
        boolean inputAmount = (Boolean)model.getValue("inputamount");
        this.initPriceField(isTax, inputAmount, rowIndex);
        Object price = model.getValue("price", rowIndex);
        this.presentChange(price, isPresent, rowIndex);
    }

    private String getBizOrgDisplayName() {
        BasedataEdit bizOrgEdit = (BasedataEdit)this.getControl("bizorg");
        IDataEntityProperty orgProp = bizOrgEdit.getProperty();
        LocaleString displayName = orgProp.getDisplayName();
        return displayName.toString();
    }

    private void changeBizOrg(Object newValue) {
        DynamicObject bizOrg = (DynamicObject)newValue;
        if (bizOrg != null) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            this.changeBizDept(bizOrgId);
            this.getModel().setValue("bizoperator", null);
            this.getModel().setValue("bizoperatorgroup", null);
        }
    }

    private void changeBizDept(Long orgId) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && deptIds.size() > 0) {
            this.getModel().setValue("bizdept", deptIds.get(0));
            return;
        }
        deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptIds != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
            this.getModel().setValue("bizdept", (Object)orgId);
        } else {
            this.getModel().setValue("bizdept", null);
        }
    }

    private void changeBizOperatorGroup(DynamicObject bizGrp) {
        if (bizGrp == null) {
            this.getModel().setValue("bizoperator", null);
        }
    }

    private void changeBizOperator(DynamicObject bizOperator) {
        if (bizOperator != null) {
            bizOperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizOperator.getPkValue(), (String)"bd_operator");
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", bizOperator.get("operatorgrpid"));
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
            if (bizOrg == null) {
                return;
            }
            List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)((Long)bizOrg.getPkValue()), (boolean)true);
            if (deptids != null && deptids.size() > 0) {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    for (Long deptId : userdeptIds) {
                        if (!deptids.contains(deptId)) continue;
                        this.getModel().beginInit();
                        this.getModel().setValue("bizdept", (Object)deptId);
                        this.getModel().endInit();
                        this.getView().updateView("bizdept");
                        break;
                    }
                }
            } else {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    this.getModel().beginInit();
                    this.getModel().setValue("bizdept", userdeptIds.get(0));
                    this.getModel().endInit();
                    this.getView().updateView("bizdept");
                }
            }
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", null);
            this.getModel().setValue("bizdept", null);
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            this.getView().updateView("bizdept");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.initCurrencyAndExrateTable((Long)org.getPkValue());
        }
        Date bizDate = (Date)this.getModel().getValue("biztime");
        this.getModel().setValue("exratedate", (Object)bizDate);
        this.initSettleType();
        this.initDeductibleRate();
        this.initTaxPayerType();
        boolean fromWebApi = ((BillModel)this.getModel()).isFromWebApi();
        if (!fromWebApi) {
            this.getModel().setValue("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
        }
        this.initOutWarehouse();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleOutWarehouseVisible();
        this.initOutWarehouse();
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        IDataModel dataModel = this.getView().getModel();
        Object srcBillEntity = dataModel.getValue("srcbillentity", 0);
        if ("mal_returnreq".equals(srcBillEntity)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"addrow"});
        }
        List rows = e.getRows();
        boolean isFarmBillType = FarmProductsHelper.isFarmBillType((DynamicObject)this.getModel().getDataEntity());
        for (RowDataEntity row : rows) {
            int rowIndex = row.getRowIndex();
            this.getView().setEnable(Boolean.valueOf(isFarmBillType), rowIndex, new String[]{"deductiblerate", "intercostamt"});
        }
        this.setClientViewScale();
    }

    private void initDeductibleRate() {
        FarmProductsHelper.setDeductibleRate((DynamicObject)this.getModel().getDataEntity(true));
    }

    private void initTaxPayerType() {
        DynamicObject bill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        HashSet<Object> ownerIds = new HashSet<Object>(16);
        for (DynamicObject entry : entrys) {
            Object ownerId;
            String ownerType = entry.getString("ownertype");
            if (!"bos_org".equals(ownerType)) continue;
            DynamicObject owner = entry.getDynamicObject("owner");
            if (owner == null && (ownerId = entry.get("owner_id")) != null) {
                owner = BusinessDataServiceHelper.newDynamicObject((String)ownerType);
                owner.set("id", ownerId);
                entry.set("owner", (Object)owner);
            }
            if (owner == null) continue;
            ownerIds.add(owner.getPkValue());
        }
        Map cacheOwners = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"taxpayertype", (QFilter[])new QFilter("id", "in", ownerIds).toArray());
        int rowCount = entrys.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object ownerType = this.getModel().getValue("ownertype", i);
            if (!"bos_org".equals(ownerType)) continue;
            DynamicObject owner = (DynamicObject)this.getModel().getValue("owner", i);
            this.setTaxPayerType(i, owner, cacheOwners);
        }
    }

    private void setTaxPayerType(int rowIndex, DynamicObject owner, Map<Object, DynamicObject> cacheOwners) {
        DynamicObject cacheOwner;
        if (owner != null && (cacheOwner = cacheOwners.get(owner.getPkValue())) != null) {
            this.getModel().setValue("taxpayertype", cacheOwner.get("taxpayertype"), rowIndex);
        }
    }

    private void initSettleType() {
        this.getModel().setValue("settletype", null);
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            this.initCurrencyAndExrateTable((Long)org.getPkValue());
        }
        Date bizDate = (Date)this.getModel().getValue("biztime");
        model.setValue("exratedate", (Object)bizDate);
        SetValueForBotpWBHelper.purInAfterCopyData((IDataModel)model);
        Map exchangeRateMap = ExchangeRateHelper.getExRateMap((Object)this.getModel().getValue("currency"), (Object)this.getModel().getValue("settlecurrency"), (Object)this.getModel().getValue("exratetable"), (Date)bizDate);
        if (exchangeRateMap != null) {
            Object quoteType = exchangeRateMap.get("quoteType");
            Object exchangeRate = exchangeRateMap.get("exchangeRate");
            if (quoteType != null) {
                this.getModel().setValue("quotation", (Object)((Boolean)quoteType != false ? "1" : "0"));
            }
            this.getModel().setValue("exchangerate", exchangeRate);
        }
        this.checkExchangeRate(true, exchangeRateMap == null ? null : exchangeRateMap.get("exchangeRate"));
        this.getAlgorithm().calByChange("exchangerate");
        String appId = this.getView().getFormShowParameter().getAppId();
        DynamicObject bill = model.getDataEntity();
        InvoiceBizHelper.handleInvoiceBizNull((DynamicObject)bill, (String)appId);
        this.initTaxPayerType();
    }

    private void change4BizOrg(DynamicObject bizOrg) {
    }

    private void changeEntryReqOrg(DynamicObject newValue, int rowIndex) {
        IDataModel model = this.getModel();
        String type = (String)model.getValue("ownertype", rowIndex);
        if ("bos_org".equals(type)) {
            Object defalutOwner = this.getInvSchemeService().getDefalutOwner(type, rowIndex);
            model.setValue("owner", defalutOwner, rowIndex);
        }
    }

    private void changeDiscountAmount(String fieldName, Object oldValue, BigDecimal discountAmount, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal amoutAndTax = BigDecimal.ZERO;
        BigDecimal qty = model.getValue("qty") == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("qty");
        int amountPrecision = 2;
        DynamicObject currency = (DynamicObject)model.getValue("settlecurrency");
        if (currency != null) {
            amountPrecision = currency.getInt("amtprecision");
        }
        if (isTax) {
            BigDecimal taxPrice = model.getValue("priceandtax") == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("priceandtax");
            amoutAndTax = qty.multiply(taxPrice).setScale(amountPrecision, RoundingMode.HALF_UP);
        } else {
            BigDecimal taxRate = model.getValue("taxrate") == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("taxrate");
            BigDecimal price = model.getValue("price") == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("price");
            amoutAndTax = qty.multiply(price).multiply(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100")))).setScale(amountPrecision, RoundingMode.HALF_UP);
        }
        if (discountAmount.compareTo(amoutAndTax) > 0 || discountAmount.compareTo(BigDecimal.ZERO) < 0) {
            model.setValue("discountamount", oldValue, rowIndex);
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_UNITDISAMOUNT()));
        }
    }

    private void changeTaxMount(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        boolean taxAmountCheck;
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal amountAndTax = (BigDecimal)model.getValue("amountandtax", rowIndex);
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
        boolean bl = taxAmountCheck = isTax && (taxAmount.compareTo(amountAndTax) > 0 || taxAmount.compareTo(BigDecimal.ZERO) < 0);
        if (taxAmountCheck) {
            model.setValue("taxamount", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u4e14\u4e0d\u80fd\u5927\u4e8e\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"PurInBillEditPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void initCurrencyAndExrateTable(Long orgId) {
        IDataModel model = this.getModel();
        if (orgId == null) {
            model.setValue("currency", null);
            model.setValue("exratetable", null);
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (map == null) {
            model.setValue("currency", null);
            model.setValue("exratetable", null);
            return;
        }
        model.setValue("currency", map.get("baseCurrencyID"));
        Object exRateTableId = map.get("exchangeRateTableID");
        model.setValue("exratetable", exRateTableId);
    }

    private void initNewEntry(int rowIndex, DynamicObject invoiceSupplier, DynamicObject receivingSupplier, DynamicObject deliverSupplier) {
        this.setDefaultSupplierInfo(invoiceSupplier, receivingSupplier, deliverSupplier, rowIndex);
        this.setDefaultQty(rowIndex);
        this.setDefaultTaxPayerType(rowIndex);
    }

    private void setDefaultTaxPayerType(int rowIndex) {
        DynamicObject owner;
        Object ownerType = this.getModel().getValue("ownertype", rowIndex);
        if ("bos_org".equals(ownerType) && (owner = (DynamicObject)this.getModel().getValue("owner", rowIndex)) != null) {
            Map cacheOwners = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"taxpayertype", (QFilter[])new QFilter("id", "=", owner.getPkValue()).toArray());
            this.setTaxPayerType(rowIndex, owner, cacheOwners);
        }
    }

    private void setDefaultQty(int rowIndex) {
        IDataModel bill = this.getModel();
        bill.setValue("returnbaseqty", null, rowIndex);
        bill.setValue("returnqty", null, rowIndex);
        bill.setValue("remainreturnqty", null, rowIndex);
        bill.setValue("remainreturnbaseqty", null, rowIndex);
        bill.setValue("joinpriceqty", null, rowIndex);
        bill.setValue("remainjoinpriceqty", null, rowIndex);
    }

    private void setDefaultSupplierInfo(DynamicObject invoiceSupplier, DynamicObject receivingSupplier, DynamicObject deliverSupplier, int rowIndex) {
        this.getModel().setValue("providersupplier", deliverSupplier == null ? null : deliverSupplier.getPkValue(), rowIndex);
        this.getModel().setValue("invoicesupplier", invoiceSupplier == null ? null : invoiceSupplier.getPkValue(), rowIndex);
        this.getModel().setValue("receivesupplier", receivingSupplier == null ? null : receivingSupplier.getPkValue(), rowIndex);
    }

    protected void changePriceAndTax(int rowIndex, Object newValue, Object oldValue) {
        BigDecimal priceAndTax;
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate != null && DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && (priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex)) != null && discountRate != null && priceAndTax.compareTo(discountRate) < 0) {
            model.setValue("priceandtax", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u5355\u4f4d\u6298\u6263\u989d\u3002", (String)"PurInBillEditPlugin_8", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    protected void changeActualPrice(int rowIndex, Object newValue, Object oldValue) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal actualPrice = (BigDecimal)newValue;
        if (price != null && actualPrice != null && price.compareTo(actualPrice) < 0) {
            model.setValue("actualprice", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5355\u4ef7\u4e0d\u5f97\u9ad8\u4e8e\u5355\u4ef7\u3002", (String)"PurInBillEditPlugin_9", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setDefaultDiscountType(rowIndex);
    }

    protected void changeActualTaxPrice(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal actualPrice = (BigDecimal)newValue;
        if (price != null && actualPrice != null && price.compareTo(actualPrice) < 0) {
            this.setValue("actualtaxprice", oldValue, rowIndex, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurInBillEditPlugin_10", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setDefaultDiscountType(rowIndex);
    }

    private void setDefaultDiscountType(int i) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String discountType = (String)model.getValue("discounttype", i);
        if (StringUtils.isEmpty((CharSequence)discountType) || DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            model.beginInit();
            model.setValue("discounttype", (Object)DiscountTypeEnum.UNITDIS.getValue(), i);
            model.endInit();
            BillViewHelper.updateViewField((IFormView)this.getView(), (int)i, (String)"discounttype", (String[])new String[0]);
            view.setEnable(Boolean.TRUE, i, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, i, new String[]{"discountamount"});
        }
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        Object entryObj;
        super.afterImportData(e);
        IDataModel bill = this.getModel();
        BillModel billModel = (BillModel)bill;
        boolean isFromWebApi = billModel.isFromWebApi();
        if (!isFromWebApi) {
            return;
        }
        DynamicObject bizOrg = (DynamicObject)bill.getValue("bizorg");
        if (bizOrg == null) {
            return;
        }
        Map sourceData = e.getSourceData();
        Map bizDept = (Map)sourceData.get("bizdept");
        if (bizDept == null || StringUtils.isBlank((CharSequence)((String)bizDept.get("number")))) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            this.changeBizDept(bizOrgId);
        }
        if (!((entryObj = sourceData.get("billentry")) instanceof JSONArray)) {
            SetValueForBotpWBHelper.purInSetValueByWabApi((IDataModel)bill);
        }
        this.initTaxPayerType();
    }

    @Override
    protected void setHeadEnable() {
        super.setHeadEnable();
        IFormView view = this.getView();
        DynamicObject bill = this.getBill();
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        boolean isEnable = currency == null || settleCurrency == null || !currency.getPkValue().equals(settleCurrency.getPkValue());
        view.setEnable(Boolean.valueOf(isEnable), new String[]{"exchangerate"});
    }

    @Override
    protected void setEnable4IsDraw(boolean isDraw) {
        super.setEnable4IsDraw(isDraw);
        IFormView view = this.getView();
        if (isDraw) {
            view.setEnable(Boolean.FALSE, new String[]{"billtype", "settlecurrency", "bizorg", "supplier", "exchangerate", "exratetable", "transactepath"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"supplier"});
        }
    }

    @Override
    protected void setBillEntryEnable(RowDataEntity entry) {
        DynamicObject warehouse;
        String outKeeperType;
        String keeperType;
        super.setBillEntryEnable(entry);
        DynamicObject bill = this.getBill();
        IFormView view = this.getView();
        int index = entry.getRowIndex();
        boolean isTax = bill.getBoolean("istax");
        boolean inputAmount = bill.getBoolean("inputamount");
        this.initPriceField(isTax, inputAmount, index);
        String discountType = (String)this.getModel().getValue("discounttype", index);
        if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            view.setEnable(Boolean.FALSE, index, new String[]{"discountrate"});
            view.setEnable(Boolean.FALSE, index, new String[]{"discountamount"});
        }
        if ((keeperType = entry.getDataEntity().getString("keepertype")) != null) {
            boolean isAccountOrg = "bd_supplier".equalsIgnoreCase(keeperType) || "bd_customer".equalsIgnoreCase(keeperType);
            view.setEnable(Boolean.valueOf(isAccountOrg), new String[]{"keeper"});
        }
        if ((outKeeperType = entry.getDataEntity().getString("outkeepertype")) != null) {
            boolean isAccountOrg = "bd_supplier".equalsIgnoreCase(outKeeperType) || "bd_customer".equalsIgnoreCase(outKeeperType);
            view.setEnable(Boolean.valueOf(isAccountOrg), new String[]{"outkeeper"});
        }
        if ((warehouse = entry.getDataEntity().getDynamicObject("outwarehouse")) != null) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            view.setEnable(Boolean.valueOf(isopenlocation), index, new String[]{"outlocation"});
        } else {
            view.setEnable(Boolean.FALSE, index, new String[]{"outlocation"});
        }
    }

    @Override
    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        if (isDraw) {
            IFormView view = this.getView();
            int index = row.getRowIndex();
            view.setEnable(Boolean.FALSE, index, new String[]{"model", "unit", "ownertype", "owner", "entrysettleorg", "taxrate", "discounttype", "discountamount", "discountrate", "providersupplier"});
            IDataModel dataModel = view.getModel();
            Object srcbillentity = dataModel.getValue("srcbillentity");
            if ("im_purinbill".equals(srcbillentity)) {
                view.setEnable(Boolean.FALSE, index, new String[]{"lotnumber", "producedate", "expirydate"});
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        super.beforeFieldPostBack(e);
        switch (key = e.getKey()) {
            case "price": 
            case "priceandtax": 
            case "actualprice": 
            case "actualtaxprice": 
            case "amount": 
            case "taxamount": 
            case "discountrate": 
            case "amountandtax": {
                this.checkSettleCurrencyNotNull(e);
                break;
            }
        }
    }
}

