/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.inspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.ImBillEditHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.consts.InvInspectBillConst;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.FormUtils;

public class InvInspectBillEditPlugin
extends ImBillEditPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"outwarehouse", "outlocation", "qualifiedwarehouse", "unqualifiedwarehouse", "qualifiedlocation", "unqualifiedlocation"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ImBillEditHelper helper = new ImBillEditHelper(this.getView());
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        switch (key) {
            case "outwarehouse": 
            case "qualifiedwarehouse": 
            case "unqualifiedwarehouse": {
                helper.warehouseSelect(e, showParameter, this.getModel());
                break;
            }
            case "outlocation": {
                helper.locationSelect(e, showParameter, this.getModel(), rowIndex, "outwarehouse");
                break;
            }
            case "qualifiedlocation": {
                helper.locationSelect(e, showParameter, this.getModel(), rowIndex, "qualifiedwarehouse");
                break;
            }
            case "unqualifiedlocation": {
                helper.locationSelect(e, showParameter, this.getModel(), rowIndex, "unqualifiedwarehouse");
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "outwarehouse": {
                this.changeOutWarehouse(valueSet, "outlocation");
                this.setWareHouseToQualWareHouse(this.getModel().getEntryRowEntity("billentry", rowIndex), rowIndex, "outwarehouse", "outlocation");
                break;
            }
            case "outlocation": {
                this.changeOutLocation(rowIndex);
                break;
            }
            case "warehouse": {
                this.changeWarehouse(rowIndex);
                break;
            }
            case "location": {
                this.changeLocation(rowIndex);
                break;
            }
            case "invscheme": {
                this.handleOutWarehouseVisible();
                break;
            }
            case "entryreqorg": {
                this.changeEntryReqOrg((DynamicObject)valueSet[0].getNewValue(), rowIndex);
                break;
            }
            case "qualifiedwarehouse": {
                this.changeOutWarehouse(valueSet, "qualifiedlocation");
                break;
            }
            case "unqualifiedwarehouse": {
                this.changeOutWarehouse(valueSet, "unqualifiedlocation");
                break;
            }
            case "unit": 
            case "qty": 
            case "qualifiedqty": {
                this.calculateQty(valueSet[0], rowIndex, propName);
                break;
            }
        }
    }

    private void calculateQty(ChangeData changeData, int rowIndex, String propName) {
        Object bizType = this.getModel().getValue("biztype");
        String number = ((DynamicObject)bizType).getString("number");
        boolean salOrInspect = "210".equals(number) || "430".equals(number);
        boolean enableImQmc = SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0003");
        if ("qty".equals(propName) && BigDecimal.ZERO.compareTo((BigDecimal)changeData.getNewValue()) > 0) {
            DataChangeHelper.setValue((IDataModel)this.getView().getModel(), (String)propName, (Object)BigDecimal.ZERO, (int)rowIndex, (boolean)true);
            return;
        }
        if (enableImQmc || !salOrInspect) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject billEntry = model.getEntryRowEntity("billentry", rowIndex);
        BigDecimal qty = billEntry.getBigDecimal("qty");
        BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
        BigDecimal qualifiedQty = billEntry.getBigDecimal("qualifiedqty");
        DynamicObject baseUnit = billEntry.getDynamicObject("baseunit");
        DynamicObject unit = billEntry.getDynamicObject("unit");
        DynamicObject material = billEntry.getDynamicObject("material");
        BigDecimal qualifiedBaseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qualifiedQty, (DynamicObject)baseUnit);
        IFormView view = this.getView();
        if (qualifiedBaseQty.compareTo(baseQty) > 0) {
            String msg = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\uff1a\u5408\u683c\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u57fa\u672c\u6570\u91cf\u3002", (String)"InvInspectBillEditPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[]{rowIndex + 1});
            this.getView().showErrorNotification(msg);
            model.beginInit();
            if ("qualifiedqty".equals(propName)) {
                BigDecimal qualifiedQtyOld = (BigDecimal)changeData.getOldValue();
                model.setValue("qualifiedqty", (Object)qualifiedQtyOld, rowIndex);
                view.updateView("qualifiedqty", rowIndex);
            } else if ("qty".equals(propName)) {
                BigDecimal qtyOld = (BigDecimal)changeData.getOldValue();
                model.setValue("qty", (Object)qtyOld, rowIndex);
                view.updateView("qty", rowIndex);
            }
            model.endInit();
            return;
        }
        model.beginInit();
        BigDecimal subNum = qty.subtract(qualifiedQty);
        BigDecimal unqualifiedBaseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)subNum, (DynamicObject)baseUnit);
        model.setValue("unqualifiedqty", (Object)subNum, rowIndex);
        view.updateView("unqualifiedqty", rowIndex);
        model.setValue("unqualifiedbaseqty", (Object)unqualifiedBaseQty, rowIndex);
        view.updateView("unqualifiedbaseqty", rowIndex);
        model.setValue("qualifiedbaseqty", (Object)qualifiedBaseQty, rowIndex);
        view.updateView("qualifiedbaseqty", rowIndex);
        model.setValue("checkagainqty", (Object)subNum, rowIndex);
        view.updateView("checkagainqty", rowIndex);
        model.setValue("checkagainbaseqty", (Object)unqualifiedBaseQty, rowIndex);
        view.updateView("checkagainbaseqty", rowIndex);
        model.setValue("qualremaininvqty", (Object)qualifiedQty, rowIndex);
        view.updateView("qualremaininvqty", rowIndex);
        model.setValue("qualremaininvbaseqty", (Object)qualifiedBaseQty, rowIndex);
        view.updateView("qualremaininvbaseqty", rowIndex);
        model.setValue("unqualremaininvqty", (Object)subNum, rowIndex);
        view.updateView("unqualremaininvqty", rowIndex);
        model.setValue("unqualremaininvbaseqty", (Object)unqualifiedBaseQty, rowIndex);
        view.updateView("unqualremaininvbaseqty", rowIndex);
        model.setValue("qualifiedinvqty", (Object)BigDecimal.ZERO, rowIndex);
        view.updateView("qualifiedinvqty", rowIndex);
        model.setValue("qualifiedinvbaseqty", (Object)BigDecimal.ZERO, rowIndex);
        view.updateView("qualifiedinvbaseqty", rowIndex);
        model.setValue("unqualifiedinvqty", (Object)BigDecimal.ZERO, rowIndex);
        view.updateView("unqualifiedinvqty", rowIndex);
        model.setValue("unqualifiedinvbaseqty", (Object)BigDecimal.ZERO, rowIndex);
        view.updateView("unqualifiedinvbaseqty", rowIndex);
        model.endInit();
    }

    private void changeEntryReqOrg(DynamicObject newValue, int rowIndex) {
        String outOwnerType;
        IDataModel model = this.getModel();
        String inOwnerType = (String)model.getValue("ownertype", rowIndex);
        if ("bos_org".equals(inOwnerType)) {
            Object defalutOwner = this.getInvSchemeService().getDefalutOwner(inOwnerType, rowIndex);
            model.setValue("owner", defalutOwner, rowIndex);
        }
        if ("bos_org".equals(outOwnerType = (String)model.getValue("outownertype", rowIndex))) {
            Object defaultOutOwner = this.getInvSchemeService().getDefalutOutOwner(outOwnerType, rowIndex);
            model.setValue("outowner", defaultOutOwner, rowIndex);
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        this.setInspectOrg(org, rowIndex);
    }

    private void handleOutWarehouseVisible() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (scheme == null) {
            return;
        }
        boolean isOutUpdate = scheme.getBoolean("isoutupdate");
        this.getView().setVisible(Boolean.valueOf(isOutUpdate), new String[]{"outwarehouse", "outlocation"});
        this.getView().setVisible(Boolean.valueOf(!isOutUpdate), new String[]{"generatelot"});
        if (!isOutUpdate) {
            DynamicObjectCollection entryEntityList = this.getModel().getEntryEntity("billentry");
            for (int i = 0; i < entryEntityList.size(); ++i) {
                this.getModel().setValue("outwarehouse", null, i);
                this.getModel().setValue("outlocation", null, i);
            }
        }
    }

    private void changeOutLocation(int rowIndex) {
        HashSet<String> bizTypes = new HashSet<String>(8);
        bizTypes.add("430");
        bizTypes.addAll(InvInspectBillConst.BIZ_TYPE_MAT_PUR_SET);
        bizTypes.addAll(InvInspectBillConst.BIZ_TYPE_MAT_SALE_SET);
        boolean isSet = this.isSetLocation(bizTypes);
        this.setQualifiedLocation("outwarehouse", "outlocation", rowIndex, isSet);
    }

    private void changeWarehouse(int rowIndex) {
        DynamicObject bizType = this.getBill().getDynamicObject("biztype");
        if (bizType == null) {
            return;
        }
        String number = bizType.getString("number");
        if (InvInspectBillConst.BIZ_TYPE_MAT_SALE_RETURN_SET.contains(number)) {
            this.setWareHouseToQualWareHouse(this.getModel().getEntryRowEntity("billentry", rowIndex), rowIndex, "warehouse", "location");
        }
    }

    private void changeLocation(int rowIndex) {
        HashSet<String> bizTypes = new HashSet<String>(4);
        bizTypes.addAll(InvInspectBillConst.BIZ_TYPE_MAT_SALE_RETURN_SET);
        boolean isSet = this.isSetLocation(bizTypes);
        this.setQualifiedLocation("warehouse", "location", rowIndex, isSet);
    }

    private boolean isSetLocation(HashSet<String> numSet) {
        DynamicObject bizType = this.getModel().getDataEntity().getDynamicObject("biztype");
        if (bizType == null) {
            return false;
        }
        String number = bizType.getString("number");
        return numSet.contains(number);
    }

    private void setQualifiedLocation(String wh, String l, int rowIndex, boolean isSet) {
        if (!isSet) {
            return;
        }
        DynamicObject entry = this.getModel().getEntryRowEntity("billentry", rowIndex);
        DynamicObject wareHouse = entry.getDynamicObject(wh);
        if (wareHouse == null) {
            return;
        }
        DynamicObject qualifiedWareHouse = entry.getDynamicObject("qualifiedwarehouse");
        DynamicObject qualifiedLocation = entry.getDynamicObject("qualifiedlocation");
        if (qualifiedWareHouse != null && qualifiedLocation == null && wareHouse.getPkValue().equals(qualifiedWareHouse.getPkValue())) {
            DynamicObject location = entry.getDynamicObject(l);
            this.getModel().setValue("qualifiedlocation", (Object)location, rowIndex);
        }
    }

    @Override
    protected void handleVisible() {
        super.handleVisible();
        DynamicObject invScheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (invScheme == null) {
            return;
        }
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        this.getView().setVisible(Boolean.valueOf(!isOutUpdate), new String[]{"generatelot"});
        this.getView().setVisible(Boolean.valueOf(isOutUpdate), new String[]{"outwarehouse", "outlocation"});
        this.handleQtyVisibleByBizType();
    }

    private void setMustInput(IFormView view, boolean isMustInput, String ... keys) {
        for (String key : keys) {
            FieldEdit control = (FieldEdit)view.getControl(key);
            if (control == null) continue;
            control.setMustInput(isMustInput);
        }
    }

    private void handleQtyVisibleByBizType() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        String number = bizType.getString("number");
        boolean visibleQty = false;
        boolean isMatSale = InvInspectBillConst.BIZ_TYPE_MAT_SALE_SET.contains(number);
        if ("430".equals(number) || isMatSale) {
            visibleQty = true;
        }
        this.getView().setVisible(Boolean.valueOf(isMatSale), new String[]{"checkagainbaseqty", "checkagainqty", "checkagainbaseqty", "checkagainqty"});
        this.getView().setVisible(Boolean.valueOf(visibleQty), new String[]{"qualifiedinvbaseqty", "qualifiedinvqty", "unqualifiedinvbaseqty", "unqualifiedinvqty", "qualremaininvbaseqty", "qualremaininvqty", "unqualremaininvbaseqty", "unqualremaininvqty"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject invInspect = this.getModel().getDataEntity();
        DynamicObject bizType = invInspect.getDynamicObject("biztype");
        if (bizType == null) {
            return;
        }
        String number = bizType.getString("number");
        DynamicObjectCollection billEntry = invInspect.getDynamicObjectCollection("billentry");
        for (int i = 0; i < billEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)billEntry.get(i);
            if (InvInspectBillConst.BIZ_TYPE_MAT_PUR_SET.contains(number) || InvInspectBillConst.BIZ_TYPE_MAT_SALE_SET.contains(number)) {
                this.setWareHouseToQualWareHouse(entry, i, "outwarehouse", "outlocation");
                continue;
            }
            if (!InvInspectBillConst.BIZ_TYPE_MAT_SALE_RETURN_SET.contains(number)) continue;
            this.setWareHouseToQualWareHouse(entry, i, "warehouse", "location");
        }
    }

    private void setWareHouseToQualWareHouse(DynamicObject entry, Integer i, String wareHouse, String location) {
        DynamicObject wareHouseObj = entry.getDynamicObject(wareHouse);
        DynamicObject qualifiedWareHouse = entry.getDynamicObject("qualifiedwarehouse");
        if (wareHouseObj != null && qualifiedWareHouse == null) {
            this.getModel().setValue("qualifiedwarehouse", (Object)wareHouseObj, i.intValue());
            DynamicObject locationObj = entry.getDynamicObject(location);
            DynamicObject qualLocation = entry.getDynamicObject("qualifiedlocation");
            if (locationObj != null && qualLocation == null) {
                this.getModel().setValue("qualifiedlocation", (Object)locationObj, i.intValue());
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.initEntryReqOrg();
        super.afterCreateNewData(e);
        this.initInspectOrg();
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        boolean enableImQmc = SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0003");
        for (RowDataEntity row : rowDataEntities) {
            int insertRow = row.getRowIndex();
            ImBillEditHelper helper = new ImBillEditHelper(this.getView());
            helper.updateEnableLocation("outlocation", (DynamicObject)this.getModel().getValue("outwarehouse", insertRow), insertRow);
            helper.updateEnableLocation("qualifiedlocation", (DynamicObject)this.getModel().getValue("qualifiedwarehouse", insertRow), insertRow);
            helper.updateEnableLocation("unqualifiedlocation", (DynamicObject)this.getModel().getValue("unqualifiedwarehouse", insertRow), insertRow);
            if (!enableImQmc) continue;
            this.getView().setEnable(Boolean.FALSE, insertRow, new String[]{"qualifiedqty"});
        }
        this.initEntryReqOrg();
        this.initInspectOrg();
    }

    private void initEntryReqOrg() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType == null) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String number = bizType.getString("number");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject entryReqOrg = entry.getDynamicObject("entryreqorg");
            if (!"430".equals(number) || entryReqOrg != null) continue;
            this.getModel().setValue("entryreqorg", (Object)org, i);
            this.changeEntryReqOrg(org, i);
        }
    }

    @Override
    protected void setEnable4IsDraw(boolean isDraw) {
        super.setEnable4IsDraw(isDraw);
        Object invscheme = this.getModel().getValue("invscheme");
        if (invscheme == null) {
            return;
        }
        String number = ((DynamicObject)invscheme).getString("number");
        if ("410".equals(number)) {
            this.getView().setEnable(Boolean.valueOf(!isDraw), new String[]{"invscheme"});
        }
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        Object bizType = this.getModel().getValue("biztype");
        String number = ((DynamicObject)bizType).getString("number");
        IFormView view = this.getView();
        List entities = e.getRows();
        ImBillEditHelper helper = new ImBillEditHelper(view);
        boolean enableImQmc = SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0003");
        boolean salOrInspect = "210".equals(number) || "430".equals(number);
        for (int i = 0; i < entities.size(); ++i) {
            RowDataEntity row = (RowDataEntity)entities.get(i);
            DynamicObject entry = row.getDataEntity();
            helper.updateEnableLocation("outlocation", entry.getDynamicObject("outwarehouse"), i);
            helper.updateEnableLocation("qualifiedlocation", entry.getDynamicObject("qualifiedwarehouse"), i);
            helper.updateEnableLocation("unqualifiedlocation", entry.getDynamicObject("unqualifiedwarehouse"), i);
            if (InvInspectBillConst.BIZ_TYPE_MAT_PUR_SET.contains(number)) {
                view.setEnable(Boolean.FALSE, i, new String[]{"owner", "outowner"});
            }
            view.setEnable(Boolean.FALSE, i, new String[]{"qualifiedqty"});
            if (enableImQmc || !salOrInspect) continue;
            view.setEnable(Boolean.TRUE, i, new String[]{"qualifiedqty"});
        }
        if (!enableImQmc) {
            view.setVisible(Boolean.FALSE, new String[]{"leftinspqty", "leftinspbaseqty", "totalinspqty", "totalinspbaseqty"});
            if (salOrInspect) {
                view.setVisible(Boolean.TRUE, new String[]{"qualifiedqty", "qualifiedbaseqty", "unqualifiedqty", "unqualifiedbaseqty", "checkagainqty", "checkagainbaseqty", "qualifiedinvqty", "qualifiedinvbaseqty", "unqualifiedinvqty", "unqualifiedinvbaseqty", "qualremaininvqty", "qualremaininvbaseqty", "unqualremaininvqty", "unqualremaininvbaseqty"});
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        String message = e.getCustomVaule();
        if ("bar_inspectionrelease".equals(callBackId)) {
            this.judgeToSuccessPage(message);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "inspectionrelease": 
            case "waitauditadjustbill": 
            case "customer_return": {
                if (!e.getOperationResult().isSuccess()) {
                    return;
                }
                this.handleUnionPush(operateKey);
                break;
            }
        }
    }

    private void handleUnionPush(String operateKey) {
        if ("inspectionrelease".equals(operateKey) || "waitauditadjustbill".equals(operateKey) || "customer_return".equals(operateKey)) {
            String entityId = this.getView().getEntityId();
            ArrayList<Long> ids = new ArrayList<Long>();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            ids.add(dataEntity.getLong("id"));
            String message = (String)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msisv", (String)"IsvIntegrationService", (String)"process", (Object[])new Object[]{ids, entityId, operateKey});
            JSONObject param = JSON.parseObject((String)message);
            JSONArray failArray = param.getJSONArray("fail");
            JSONArray successArray = param.getJSONArray("success");
            if (CollectionUtils.isNotEmpty((Collection)failArray)) {
                StringBuilder failSb = new StringBuilder();
                for (int i = 0; i < failArray.size(); ++i) {
                    String failStr = failArray.getString(i);
                    if (!StringUtils.isNotEmpty((String)failStr)) continue;
                    failSb.append(failStr).append("\n");
                }
                String btnMsg = "1";
                if (CollectionUtils.isNotEmpty((Collection)successArray)) {
                    btnMsg = "2";
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("im_union_push_msg");
                formShowParameter.getCustomParams().put("messageDetail", failSb.toString());
                formShowParameter.getCustomParams().put("btnMsg", btnMsg);
                formShowParameter.getCustomParams().put("message", message);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_inspectionrelease"));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(formShowParameter);
            } else {
                if (CollectionUtils.isEmpty((Collection)successArray)) {
                    String msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"InvInspectBillEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(msg);
                    return;
                }
                this.judgeToSuccessPage(message);
            }
        }
    }

    private void judgeToSuccessPage(String message) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("im_union_push_target");
        showParameter.setCustomParam("message", (Object)message);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    @Override
    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("billentry");
        if (entryList.isEmpty()) {
            return;
        }
        String srcBillEntity = ((DynamicObject)entryList.get(0)).getString("srcbillentity");
        HashSet<Long> oldIdSet = new HashSet<Long>();
        if ("im_purreceivebill".equals(srcBillEntity) || "sm_delivernotice".equals(srcBillEntity) || "sm_returnapply".equals(srcBillEntity)) {
            for (DynamicObject dynamicObject : entryList) {
                long srcEntryId = dynamicObject.getLong("inspectdemandbillentryid");
                if (srcEntryId == 0L) continue;
                oldIdSet.add(srcEntryId);
            }
            HashSet<Integer> indexSet = new HashSet<Integer>(rowIndexs.length);
            for (int index : rowIndexs) {
                indexSet.add(index + 1);
            }
            HashSet<Long> hashSet = new HashSet<Long>();
            for (DynamicObject entry : entryList) {
                long srcEntryId;
                int seq = entry.getInt("seq");
                if (indexSet.contains(seq) || (srcEntryId = entry.getLong("inspectdemandbillentryid")) == 0L) continue;
                hashSet.add(srcEntryId);
            }
            if (oldIdSet.size() != hashSet.size()) {
                StringBuilder msg = new StringBuilder();
                for (int index : rowIndexs) {
                    long srcEntryId = (Long)this.getModel().getValue("inspectdemandbillentryid", index);
                    if (hashSet.contains(srcEntryId)) continue;
                    long srcEntrySeq = (Long)this.getModel().getValue("srcbillentryseq", index);
                    msg.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\u4e0e\u4e0a\u6e38\u7b2c{1}\u884c\u5206\u5f55\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u5220\u884c\u3002", (String)"InvInspectBillEditPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[]{index + 1, srcEntrySeq})).append("\n");
                }
                this.getView().showErrorNotification(msg.toString());
                e.setCancel(true);
            }
        }
    }

    private void initInspectOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.setInspectOrg(org, i);
        }
    }

    private void setInspectOrg(DynamicObject org, int i) {
        Long defaultToOrgId;
        this.getModel().setValue("insporg", null, i);
        DynamicObject entry = this.getModel().getEntryRowEntity("billentry", i);
        DynamicObject entryReqOrg = entry.getDynamicObject("entryreqorg");
        if (entryReqOrg == null && org == null) {
            return;
        }
        Long l = defaultToOrgId = entryReqOrg != null ? this.getDefaultToOrg((Long)entryReqOrg.getPkValue()) : null;
        if (defaultToOrgId != null) {
            this.getModel().setValue("insporg", (Object)defaultToOrgId, i);
        } else if (org != null && OrgUnitServiceHelper.checkOrgFunction((Long)((Long)org.getPkValue()), (String)"06")) {
            this.getModel().setValue("insporg", org.getPkValue(), i);
        }
    }

    private Long getDefaultToOrg(Long entryReqOrg) {
        Map<String, Object> delegation = this.getDelegationOrgList(entryReqOrg);
        List detailList = (List)delegation.get("data");
        for (Map detailMap : detailList) {
            Boolean isDefault = (Boolean)detailMap.get("isDefault");
            Object orgId = detailMap.get("orgId");
            if (!isDefault.booleanValue() || orgId == null) continue;
            return orgId instanceof Long ? (Long)orgId : Long.valueOf(orgId.toString());
        }
        return null;
    }

    private Map<String, Object> getDelegationOrgList(Long orgId) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setToViewType("06");
        param.setDirectViewType("toorg");
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
    }
}

