/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.inspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabCloseEvent;
import kd.bos.form.control.events.TabCloseListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;

public class InvInspectBillUnionPushPlugin
extends AbstractBillPlugIn
implements TabCloseListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabCloseListener((TabCloseListener)this);
        tab.addItemClickListener((ItemClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String message = (String)formShowParameter.getCustomParam("message");
        this.judgeToSuccessPage(message);
    }

    private void judgeToSuccessPage(String message) {
        JSONObject param = JSON.parseObject((String)message);
        JSONArray successArray = param.getJSONArray("success");
        for (int i = 0; i < successArray.size(); ++i) {
            String tabApNum;
            JSONObject successObj = successArray.getJSONObject(i);
            String entityType = successObj.getString("entityType");
            JSONArray billIdsArray = successObj.getJSONArray("billIds");
            ArrayList<Long> pks = new ArrayList<Long>(billIdsArray.size());
            for (int j = 0; j < billIdsArray.size(); ++j) {
                Long billId = billIdsArray.getLong(j);
                pks.add(billId);
            }
            if (pks.size() == 1) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId(entityType);
                showParameter.setPkId(pks.get(0));
                showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                showParameter.getOpenStyle().setTargetKey("tabap");
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeChildPage"));
                tabApNum = this.getPageCache().get("tabApNum");
                this.getPageCache().put("tabApNum", String.valueOf(tabApNum == null ? 1 : Integer.parseInt(tabApNum) + 1));
                this.getView().showForm((FormShowParameter)showParameter);
                continue;
            }
            if (pks.size() > 1) {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setShowFilter(false);
                listShowParameter.setShowQuickFilter(false);
                listShowParameter.setBillFormId(entityType);
                for (int j = 0; j < pks.size(); ++j) {
                    listShowParameter.addLinkQueryPkId(pks.get(j));
                }
                listShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                listShowParameter.getOpenStyle().setTargetKey("tabap");
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeChildPage"));
                tabApNum = this.getPageCache().get("tabApNum");
                this.getPageCache().put("tabApNum", String.valueOf(tabApNum == null ? 1 : Integer.parseInt(tabApNum) + 1));
                this.getView().showForm((FormShowParameter)listShowParameter);
                continue;
            }
            return;
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("closeChildPage".equals(actionId)) {
            String tabApNum = this.getPageCache().get("tabApNum");
            int i = tabApNum == null ? 0 : Integer.parseInt(tabApNum) - 1;
            this.getPageCache().put("tabApNum", String.valueOf(i));
            if (i == 0) {
                this.getView().close();
            }
        }
    }

    public void tabClose(TabCloseEvent evt) {
        List tabKeys = evt.getTabKeys();
        Iterator iterator = tabKeys.iterator();
        ArrayList tabCloseList = new ArrayList(10);
        while (iterator.hasNext()) {
            String tabKey = (String)iterator.next();
            IFormView iFormView = SessionManager.getCurrent().getViewNoPlugin(tabKey);
            iFormView.close();
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("pageId", tabKey);
            tabCloseList.add(map);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("closeWindow", tabCloseList);
        String tabApNum = this.getPageCache().get("tabApNum");
        int i = tabApNum == null ? 0 : Integer.parseInt(tabApNum);
        this.getPageCache().put("tabApNum", String.valueOf(i));
        if (i == 0) {
            this.getView().close();
        }
    }
}

