/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.invplan;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.im.business.helper.invplan.DynamicObjDataHelper;
import kd.scmc.im.business.helper.invplan.InvPlanHelper;
import kd.scmc.im.business.helper.invplan.OrgBasedCalendarModel;
import kd.scmc.im.business.helper.invplan.PlanViewOrgHelper;

public class InvPlanPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String IM_INVENTORY_PLAN = "im_inventoryplan";
    private static final String ORG = "org";
    private static final String PLANPROGRAM = "plangram";
    private static final String ID = "id";
    private static final String START_CAL = "startcaculate";
    private static final String MRP_CACULATE_LOG = "mrp_caculate_log";
    private static final String FLEX_CACULATE_LOG = "flex_caculate_log";
    private static final String NUMBER = "number";
    private static final String ISLLC = "isllc";
    private static final String BOMCHECK = "isbomcheck";
    private static final String ALLOWDATE = "isallowdateinpast";
    private static final String PLANDATE = "plandate";
    private static final String PLANTYPE = "plantype";
    private static final String CONFIRM_EXEC = "confirm_exec";
    private static final String CACULATELOG_CACHE = "caculateLog_cache";
    private static final String ISCOMMON = "iscommon";
    private static final String ISCUSTOMIZE = "iscustomize";
    private static final String ISSELECTION = "isselection";
    private static final String ISNOTSETUP = "isnotsetup";
    private static final String CREATE_ORG = "createorg";
    private static final String USE_ORG = "useorg";
    private static final String RUN_TYPE = "runtype";
    private static final String RUN_TYPE_SCM = "F";
    private static final String PROGRAM_NUMBER = "programnumber";
    private static final String PROGRAM_NAME = "programname";
    private static final String NAME = "name";
    private static final String CREATOR = "creator";
    private static final String OPERATE_MODE = "operatmode";
    private static final String OPERATE_MODE_KEY = "operatmodekey";
    private static final String CALCULATE_STATUS = "calculatestatus";
    private static final String START_DATE = "startdate";
    private static final String CTRL_STRATEGY = "ctrlstrategy";
    private static final String PLAN_TAGS = "plantags";
    private static final String FBASEDATA_ID = "fbasedataid";
    private static final String DATA_VERSION = "dataversion";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"im"), (String)IM_INVENTORY_PLAN, (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        Set planViewOrgIds = PlanViewOrgHelper.getOrgIdsByPlanView();
        long orgId = RequestContext.get().getOrgId();
        if (!orgIds.isEmpty()) {
            this.setOrgByPermission(orgId, orgIds, planViewOrgIds);
        } else if (result.hasAllOrgPerm() && planViewOrgIds.contains(orgId)) {
            this.getModel().setValue(ORG, (Object)RequestContext.get().getOrgId());
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit org;
        super.registerListener(e);
        BasedataEdit planProgram = (BasedataEdit)this.getView().getControl(PLANPROGRAM);
        if (planProgram != null) {
            planProgram.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            planProgram.setLayoutId("msplan_invplanprogram");
        }
        if ((org = (BasedataEdit)this.getView().getControl(ORG)) != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String key = con.getKey();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter listFilterParameter = param.getListFilterParameter();
        if (PLANPROGRAM.equals(key)) {
            Long orgId = this.checkOrgIsNull();
            if (orgId != -1L) {
                QFilter planFilter = new QFilter("createorg.id", "=", (Object)orgId);
                planFilter.and(new QFilter("status", "=", (Object)"C"));
                planFilter.and(new QFilter("enable", "=", (Object)"1"));
                planFilter.and(new QFilter("type", "=", (Object)"B"));
                listFilterParameter.setFilter(planFilter);
            } else {
                e.setCancel(true);
            }
        } else if (ORG.equals(key)) {
            param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            QFilter idFilter = new QFilter(ID, "in", (Object)PlanViewOrgHelper.getOrgIdsByPlanView());
            listFilterParameter.getQFilters().add(idFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String string = key = op != null ? op.getOperateKey() : "";
        if (START_CAL.equals(key)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u51c6\u5907\u4e2d\uff0c\u8bf7\u7a0d\u7b49", (String)"InvPlanPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0])));
            try {
                this.beforeCalculate(e);
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    private void beforeCalculate(BeforeDoOperationEventArgs e) {
        DynamicObject org = DynamicObjDataHelper.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)ORG);
        DynamicObject planGram = DynamicObjDataHelper.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)PLANPROGRAM);
        if (planGram == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u5212\u65b9\u6848\u3002", (String)"InvPlanPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long planId = DynamicObjDataHelper.getDynamicObjectPK((DynamicObject)planGram);
        if (InvPlanHelper.isExistInvRunning((Long)planId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"InvPlanPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else if (org != null) {
            DynamicObject caculateLog = this.createNewLog(null);
            String number = CodeRuleServiceHelper.getNumber((String)MRP_CACULATE_LOG, (DynamicObject)caculateLog, (String)org.getPkValue().toString());
            this.getPageCache().put(CACULATELOG_CACHE, number);
            if (StringUtils.isBlank((CharSequence)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"InvPlanPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                this.execGlobalPlan(number, planGram);
            }
        } else {
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && CONFIRM_EXEC.equals(e.getCallBackId())) {
            String number = this.getPageCache().get(CACULATELOG_CACHE);
            this.runMRP4Global(number);
        }
    }

    private void execGlobalPlan(String number, DynamicObject plangram) {
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)plangram.getLong(ID), (String)"mrp_planprogram");
        int planOutLook = plan.getInt("planoutlook");
        DynamicObjectCollection orgColl = plan.getDynamicObjectCollection("orgentryentity");
        StringBuilder calOrgName = new StringBuilder();
        for (DynamicObject dyn : orgColl) {
            if (dyn.getDynamicObject("entrydemandorg") == null) continue;
            DynamicObject org = dyn.getDynamicObject("entrydemandorg");
            String orgid = org.getString(ID);
            String name = org.getString(NAME);
            OrgBasedCalendarModel cUtil = new OrgBasedCalendarModel(orgid);
            if (cUtil.isEmpty()) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)this.getModel().getValue(PLANDATE));
            calendar.add(5, planOutLook);
            if (!calendar.getTime().after(cUtil.getMaxDate().getDate().getTime())) continue;
            if (calOrgName.length() > 0) {
                calOrgName.append('\uff0c');
            }
            calOrgName.append(name);
        }
        if (calOrgName.length() > 0) {
            this.confirmCaculateLog(calOrgName);
        } else {
            this.runMRP4Global(number);
        }
    }

    public void confirmCaculateLog(StringBuilder calOrgName) {
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONFIRM_EXEC, (IFormPlugin)this);
        StringBuilder str = new StringBuilder();
        if (calOrgName.length() > 0) {
            str.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5b58\u5728\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f\u5927\u4e8e\u8ba1\u5212\u65e5\u5386\u6700\u5927\u65e5\u671f\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u8fd0\u7b97\uff1f\u5982\u9009\u62e9\u662f\uff0c\u5219\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f\u53d6\u8ba1\u5212\u65e5\u5386\u7684\u6700\u5927\u65e5\u671f\u3002", (String)"InvPlanPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]), calOrgName.toString()));
        }
        confirmCallBack.setView(this.getView());
        this.getView().showConfirm(str.toString(), MessageBoxOptions.YesNo, confirmCallBack);
    }

    private void runMRP4Global(String number) {
        DynamicObject caculateLog = this.createNewLog(number);
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IMRPRunnerApi", (String)"mrpstarter", (Object[])new Object[]{caculateLog});
        this.showLogForm(caculateLog.getLong(ID));
    }

    private DynamicObject createNewLog(String number) {
        DynamicObject plangram = (DynamicObject)this.getModel().getValue(PLANPROGRAM);
        DynamicObject caculateLog = ORM.create().newDynamicObject(MRP_CACULATE_LOG);
        if (plangram == null) {
            return caculateLog;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        String planType = InvPlanHelper.getPlanType((DynamicObject)plangram);
        Long id = ORM.create().genLongId(MRP_CACULATE_LOG);
        caculateLog.set(ID, (Object)id);
        caculateLog.set(NUMBER, (Object)number);
        caculateLog.set(CREATE_ORG, (Object)org);
        caculateLog.set(USE_ORG, (Object)org);
        caculateLog.set(RUN_TYPE, (Object)RUN_TYPE_SCM);
        caculateLog.set(PLANTYPE, (Object)planType);
        caculateLog.set(PLANPROGRAM, (Object)plangram.getLong(ID));
        caculateLog.set(PROGRAM_NUMBER, (Object)plangram.getString(NUMBER));
        caculateLog.set(PROGRAM_NAME, (Object)plangram.getString(NAME));
        caculateLog.set(PLANDATE, this.getModel().getValue(PLANDATE));
        caculateLog.set(ISCOMMON, plangram.get(ISCOMMON));
        caculateLog.set(ISCUSTOMIZE, plangram.get(ISCUSTOMIZE));
        caculateLog.set(ISSELECTION, plangram.get(ISSELECTION));
        caculateLog.set(ISNOTSETUP, plangram.get(ISNOTSETUP));
        caculateLog.set(CREATOR, (Object)RequestContext.get().getCurrUserId());
        caculateLog.set(OPERATE_MODE, (Object)this.getView().getFormShowParameter().getFormName());
        caculateLog.set(OPERATE_MODE_KEY, (Object)this.getView().getFormShowParameter().getFormId());
        caculateLog.set(CALCULATE_STATUS, (Object)"D");
        caculateLog.set(START_DATE, (Object)new Date());
        caculateLog.set(CTRL_STRATEGY, (Object)"7");
        caculateLog.set(ISLLC, this.getModel().getValue(ISLLC));
        caculateLog.set(BOMCHECK, this.getModel().getValue(BOMCHECK));
        caculateLog.set(ALLOWDATE, this.getModel().getValue(ALLOWDATE));
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)plangram.getLong(ID), (String)"mrp_planprogram", (String)PLAN_TAGS);
        DynamicObjectCollection plantags = plan.getDynamicObjectCollection(PLAN_TAGS);
        DynamicObjectCollection calctags = caculateLog.getDynamicObjectCollection(PLAN_TAGS);
        calctags.clear();
        for (DynamicObject tag : plantags) {
            DynamicObject cal = calctags.addNew();
            cal.set(FBASEDATA_ID, tag.get(FBASEDATA_ID));
        }
        if (this.getModel().getValue(DATA_VERSION) != null) {
            DynamicObject dataVersion = (DynamicObject)this.getModel().getValue(DATA_VERSION);
            caculateLog.set(DATA_VERSION, (Object)dataVersion.getLong(ID));
        }
        if (number != null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{caculateLog});
            BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        }
        return caculateLog;
    }

    private void showLogForm(long id) {
        this.getView().close();
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(MRP_CACULATE_LOG);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam(ID, (Object)id);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.equalsIgnoreCase((CharSequence)e.getActionId(), (CharSequence)FLEX_CACULATE_LOG)) {
            this.getView().close();
        }
    }

    private Long checkOrgIsNull() {
        if (this.getModel().getValue(ORG) != null) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            return org.getLong(ID);
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8ba1\u5212\u7ec4\u7ec7\u3002", (String)"InvPlanPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        return -1L;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (ORG.equals(key)) {
            this.getModel().setValue(PLANPROGRAM, null);
        }
    }

    private void setOrgByPermission(long orgId, List<Long> orgIds, Set<Long> planViewOrgIds) {
        if (orgIds.contains(orgId) && planViewOrgIds.contains(orgId)) {
            this.getModel().setValue(ORG, (Object)RequestContext.get().getOrgId());
        } else {
            this.getModel().setValue(ORG, (Object)orgIds.get(0));
        }
    }
}

