/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.locationtransfer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.FillBatchHelper;
import kd.scmc.im.business.helper.ImBillEditHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImBillBeforeF7Select;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.formplugin.transbill.TransBillCommonBeforeF7SelectListener;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class LocationTransferEditPlugin
extends ImBillEditPlugin {
    private static final String SCMCAVBINVQUERY = "scmcavbinvquery";

    @Override
    public void registerListener(EventObject e) {
        FlexEdit auxpty;
        TextEdit te;
        Button btnDown;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"warehouse", "location", "outlocation", "owner", "keeper", "org", "biztype", "invstatus", "invtype", "unit", "lot", "operatorgroup", "operator", "dept", "owner", "keeper", "mversion"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addItemClickListeners(new String[]{"seradvcontoolbarap"});
        Button btnOk = (Button)this.getControl("btn_import");
        if (null != btnOk) {
            btnOk.addClickListener((ClickListener)this);
        }
        if (null != (btnDown = (Button)this.getControl("btn_download"))) {
            btnDown.addClickListener((ClickListener)this);
        }
        if (null != (te = (TextEdit)this.getControl("serialnumber"))) {
            te.addClickListener((ClickListener)this);
        }
        if (null != (auxpty = (FlexEdit)this.getView().getControl("auxpty"))) {
            // empty if block
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.setSettleCurrency(org);
        this.initEntry(org);
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("ischargeoff", (Object)Boolean.FALSE);
        this.getModel().setValue("ischargeoffed", (Object)Boolean.FALSE);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        int index = changeSet.getRowIndex();
        String key = e.getProperty().getName();
        super.propertyChanged(e);
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "price": 
            case "qty": 
            case "qtyunit2nd": {
                this.setAmount(index);
                break;
            }
            case "amount": {
                this.setPrice(index, oldValue);
                break;
            }
            case "keepertype": {
                this.dealKeeper(index);
                break;
            }
            case "ownertype": {
                this.dealOwner(index);
                break;
            }
            case "isfreegift": {
                this.changeIsPresent(newValue, index);
                break;
            }
            case "warehouse": {
                this.setLocationIsEnableByWarehouse((DynamicObject)newValue, index);
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        boolean isMainOrg = ImBillEditHelper.isMainOrgByF7((IFormView)this.getView(), (IDataModel)this.getModel(), (String)fieldKey);
        if (!isMainOrg) {
            e.setCancel(true);
            return;
        }
        switch (fieldKey) {
            case "owner": 
            case "keeper": 
            case "inkeepertype": 
            case "warehouse": 
            case "org": {
                TransBillCommonBeforeF7SelectListener listener = new TransBillCommonBeforeF7SelectListener(this.getView());
                listener.beforeF7Select(e);
                break;
            }
            case "location": 
            case "outlocation": {
                this.beforeSelectLocation(e);
                break;
            }
            default: {
                ImBillBeforeF7Select selecter = new ImBillBeforeF7Select(this.getView());
                selecter.beforeF7Select(e);
            }
        }
        if ("warehouse".equals(fieldKey)) {
            ListShowParameter cardF7Param = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter listFilterParameter = cardF7Param.getListFilterParameter();
            listFilterParameter.getQFilters().add(new QFilter("isopenlocation", "=", (Object)Boolean.TRUE));
            String formId = this.getModel().getDataEntityType().getName();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)formId, (DynamicObject)org, (ListShowParameter)cardF7Param);
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if ("billentry".equals(e.getEntryProp().getName())) {
            RowDataEntity[] rows;
            Object matchingrule = this.getView().getFormShowParameter().getCustomParam("matchingrule");
            if (null != matchingrule) {
                return;
            }
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode"});
                this.initEntryLineType(rowIndex);
                this.initEntryRow(rowIndex);
            }
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean aBoolean;
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("bar_copy".equals(key) && (aBoolean = this.getModel().getDataEntity().getBoolean("ischargeoff"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5355\u636e\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"ImBillEditPlugin_33", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    protected void initEntry(DynamicObject org) {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.initEntryRow(i);
        }
    }

    private void initEntryRow(int i) {
        this.dealKeeper(i);
        this.dealOwner(i);
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", i);
        if (null != warehouse) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), i, new String[]{"location"});
            this.getView().setEnable(Boolean.valueOf(isopenlocation), i, new String[]{"outlocation"});
        } else {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"outlocation"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"location"});
        }
    }

    private void dealKeeper(int i) {
        Object keeperTypeObj = this.getModel().getValue("keepertype", i);
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (keeperTypeObj != null) {
            switch (keeperTypeObj.toString()) {
                case "bos_org": {
                    model.setValue("keeper", org == null ? null : org.getPkValue(), i);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"keeper"});
                    break;
                }
                case "bd_supplier": 
                case "bd_customer": {
                    model.setValue("keeper", null, i);
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"keeper"});
                    break;
                }
            }
        } else {
            model.setValue("keeper", null, i);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"keeper"});
        }
    }

    protected void setSettleCurrency(DynamicObject org) {
        Map currencyinfo;
        IDataModel model = this.getModel();
        if (org != null && (currencyinfo = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getLong("id"))) != null) {
            model.setValue("settlescurrency", currencyinfo.get("baseCurrencyID"));
            return;
        }
        model.setValue("settlescurrency", (Object)1L);
    }

    @Override
    public String getCurrencyKey() {
        return "settlescurrency";
    }

    @Override
    protected void initNewDataEntry(IFormView view, int rowIndex) {
        view.setEnable(Boolean.FALSE, rowIndex, new String[]{"location"});
        view.setEnable(Boolean.FALSE, rowIndex, new String[]{"outlocation"});
        view.setEnable(Boolean.FALSE, rowIndex, new String[]{"auxpty"});
        view.setEnable(Boolean.FALSE, rowIndex, new String[]{"qtyunit2nd"});
        view.setEnable(Boolean.FALSE, rowIndex, new String[]{"lotnumber"});
        this.dealKeeper(rowIndex);
        this.dealOwner(rowIndex);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel bill = this.getModel();
        this.setShowbindData(view, bill);
    }

    public void beforeSelectLocation(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        int rowindex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject warehouse = (DynamicObject)model.getValue("warehouse", rowindex);
        this.addSelectLocaltionFilter(e);
        this.commonLocationFilter(warehouse, e);
    }

    private void addSelectLocaltionFilter(BeforeF7SelectEvent e) {
        int row = e.getRow();
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        DynamicObject localtion = null;
        if ("location".equals(key)) {
            localtion = (DynamicObject)model.getValue("outlocation", row);
        } else if ("outlocation".equals(key)) {
            localtion = (DynamicObject)model.getValue("location", row);
        }
        if (localtion == null) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = new QFilter("id", "!=", localtion.getPkValue());
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void commonLocationFilter(DynamicObject warehouse, BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (warehouse == null) {
            e.setCancel(true);
        } else {
            QFilter qFilter = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol, String locationkey) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject(locationkey);
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    protected void dealOwner(int rowIndex) {
        String field = "ownertype";
        Object ownerType = this.getModel().getValue(field, rowIndex);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        String ownerkey = "owner";
        if (!"bos_org".equals(ownerType)) {
            return;
        }
        if (org == null) {
            this.getModel().setValue(ownerkey, (Object)null, rowIndex);
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Object ownerID = OwnerHelper.getOwnerDefValue((Long)orgId);
        this.getModel().setValue(ownerkey, ownerID, rowIndex);
    }

    protected Object getAccountOrgId(DynamicObject org) {
        Long orgId = (Long)org.getPkValue();
        Long accountingId = null;
        Boolean isaccounting = org.getBoolean("fisaccounting");
        if (isaccounting.booleanValue()) {
            accountingId = orgId;
        } else {
            Map companys = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            accountingId = companys.get("id");
        }
        return accountingId;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "fillbatch": {
                FillBatchHelper.batchFill((IFormView)this.getView());
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        switch (operateKey = e.getOperateKey()) {
            case "unaudit": 
            case "scmcavbinvquery": 
            case "batchfillentry": {
                super.afterDoOperation(e);
                break;
            }
        }
    }

    @Override
    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        FillBatchHelper.batchSetPredicate((IFormView)this.getView(), (BeforeBatchFillEntryArgs)e);
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    protected void setAmount(int index) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", index);
        if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0) {
            this.getModel().beginInit();
            this.getModel().setValue("amount", (Object)BigDecimal.ZERO, index);
            this.getModel().setValue("price", (Object)BigDecimal.ZERO, index);
            this.getModel().endInit();
            return;
        }
        BigDecimal price = (BigDecimal)this.getModel().getValue("price", index);
        int precision = this.getPrecision("settlescurrency", "amtprecision");
        BigDecimal amount_all = qty.multiply(price);
        if (amount_all.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_AMOUNT()));
        }
        BigDecimal amount = amount_all.setScale(precision, 4);
        this.setValue("amount", amount, index, false);
    }

    protected void setPrice(int index, Object oldValue) {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", index);
        if (amount != null && amount.compareTo(BigDecimal.ZERO) < 0) {
            this.getModel().beginInit();
            this.getModel().setValue("amount", oldValue, index);
            this.getModel().endInit();
            return;
        }
        this.calPriceByAmountChange(index, "price", "qty", "amount", "settlescurrency");
    }

    protected void setLocationIsEnableByWarehouse(DynamicObject warehouse, int rowindex) {
        this.getModel().setValue("location", null, rowindex);
        this.getModel().setValue("outlocation", null, rowindex);
        if (warehouse != null) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowindex, new String[]{"location"});
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowindex, new String[]{"outlocation"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"location"});
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"outlocation"});
        }
    }

    private void initPriceField(boolean isPresent, int rowIndex) {
        IFormView view = this.getView();
        boolean isEnable = !isPresent;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"price"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amount"});
    }

    @Override
    protected void setBillEntryEnable(RowDataEntity row) {
        super.setBillEntryEnable(row);
        DynamicObject dynamicObject = row.getDataEntity();
        Boolean isPresent = dynamicObject.getBoolean("isfreegift");
        this.initPriceField(isPresent, row.getRowIndex());
        int rowIndex = row.getRowIndex();
        Object keeperTypeObj = this.getModel().getValue("keepertype", rowIndex);
        if (keeperTypeObj != null) {
            switch (keeperTypeObj.toString()) {
                case "bos_org": {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keeper"});
                    break;
                }
                case "bd_supplier": 
                case "bd_customer": {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"keeper"});
                    break;
                }
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keeper"});
        }
    }

    @Override
    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        IFormView view = this.getView();
        int index = row.getRowIndex();
        if (isDraw) {
            view.setEnable(Boolean.valueOf(!isDraw), index, new String[]{"isfreegift"});
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)newValue;
        this.initPriceField(isPresent, rowIndex);
        if (isPresent) {
            model.setValue("price", (Object)Constants.ZERO, rowIndex);
            model.setValue("amount", (Object)Constants.ZERO, rowIndex);
        }
    }

    private void setShowbindData(IFormView view, IDataModel bill) {
        bill.getDataEntity(true);
        this.setHeadEnable();
    }

    private void initEntryLineType(int rowIndex) {
        ArrayList<Long> bizTypes = new ArrayList<Long>();
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType == null) {
            return;
        }
        Long bizTypeId = (Long)bizType.getPkValue();
        Long lineType = null;
        bizTypes.add(bizTypeId);
        Map lineTypeByBillType = BillTypeMaterialHelper.getLineTypeByBillType(bizTypes);
        if (lineTypeByBillType.size() != 0) {
            LineTypeParam lineTypeParam = (LineTypeParam)lineTypeByBillType.get(bizTypeId);
            lineType = lineTypeParam.getDeafaultLineType();
        }
        this.getModel().beginInit();
        this.getModel().setValue("linetype", (Object)lineType, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("linetype", rowIndex);
    }
}

