/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.outbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.InvSchemeHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;
import kd.scmc.im.utils.IMStringUtils;
import org.apache.commons.lang3.StringUtils;

public class MaterialReqOutBillPlugin
extends ImBillEditPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"requser", "bizdept", "owner", "supplyowner", "settleorg"});
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        IFormView view = this.getView();
        String entityId = view.getEntityId();
        if ("im_mdc_mftreturnorder".equals(entityId) || "im_mdc_mftfeedorder".equals(entityId)) {
            List entities = e.getRows();
            entities.forEach(entry -> this.setEntryEnable((RowDataEntity)entry));
        }
    }

    private void setEntryEnable(RowDataEntity row) {
        IFormView view = this.getView();
        if (row.getDataEntity().getBoolean("isadd")) {
            view.setEnable(Boolean.TRUE, row.getRowIndex(), new String[]{"material", "materialname"});
        } else {
            view.setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"material", "materialname"});
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
        if (!CommonUtils.isNull((Object)org)) {
            this.initCurrency((Long)org.getPkValue());
        }
        if (!CommonUtils.isNull((Object)bizOrg)) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)bizOrgId, (Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE);
            Object settleOrgId = null;
            if (map != null) {
                settleOrgId = map.get("id");
            }
            this.getModel().setValue("settleorg", settleOrgId);
        }
        this.resetTopDefaltOwner();
        this.changeSupplyOwner();
    }

    private void resetTopDefaltOwner() {
        IDataModel bill = this.getView().getModel();
        bill.setValue("supplyowner", null);
        DynamicObject scheme = (DynamicObject)bill.getValue("invscheme");
        if (scheme == null) {
            Long ownerId = null;
            ArrayList<Object> ownerList = this.getOwnerList();
            if (ownerList != null && ownerList.size() > 0) {
                ownerId = (Long)ownerList.get(0);
            }
            bill.setValue("supplyownertype", (Object)"bos_org");
            bill.setValue("supplyowner", (Object)ownerId);
            return;
        }
        DynamicObject invScheme = null;
        if (scheme != null && scheme.getPkValue() != null) {
            invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        }
        if (invScheme == null) {
            return;
        }
        boolean isoutupdate = invScheme.getBoolean("isoutupdate");
        if (!isoutupdate) {
            Long ownerId = null;
            ArrayList<Object> ownerList = this.getOwnerList();
            if (ownerList != null && ownerList.size() > 0) {
                ownerId = (Long)ownerList.get(0);
            }
            bill.setValue("supplyownertype", (Object)"bos_org");
            bill.setValue("supplyowner", (Object)ownerId);
            return;
        }
        String outOwnerType = InvSchemeHelper.getDefaultOutOwnerType((DynamicObject)invScheme);
        bill.setValue("supplyownertype", (Object)outOwnerType);
        Long ownerId = null;
        if (StringUtils.isEmpty((CharSequence)outOwnerType)) {
            bill.setValue("supplyowner", null);
            bill.setValue("supplyownertype", null);
            return;
        }
        switch (outOwnerType) {
            case "bos_org": {
                ArrayList<Object> ownerList = this.getOwnerList();
                if (ownerList == null || ownerList.size() <= 0) break;
                ownerId = (Long)ownerList.get(0);
                break;
            }
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        bill.setValue("supplyowner", ownerId);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        block26: for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue != null && newValue != null && oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue != null && newValue != null && oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldName) {
                case "settlecurrency": {
                    this.changeSettleCurrency();
                    continue block26;
                }
                case "ispresent": {
                    this.changeIsPresent(newValue, rowIndex);
                    continue block26;
                }
                case "bizorg": {
                    this.changeBizOrg(newValue);
                    continue block26;
                }
                case "org": {
                    this.changeOrg(newValue);
                    continue block26;
                }
                case "bizdept": {
                    this.changeBizDept();
                    continue block26;
                }
                case "requser": {
                    this.changeReqUser((DynamicObject)newValue);
                    continue block26;
                }
                case "invscheme": {
                    this.changeInvScheme();
                    continue block26;
                }
                case "qty": {
                    this.changeQty(newValue, oldValue, rowIndex);
                    continue block26;
                }
                case "price": {
                    this.changePrice(newValue, oldValue, rowIndex);
                    continue block26;
                }
                case "amount": {
                    this.changeAmout(newValue, oldValue, rowIndex);
                    continue block26;
                }
                case "supplyowner": {
                    this.changeSupplyOwner();
                    continue block26;
                }
            }
        }
    }

    private void changeQty(Object newValue, Object oldValue, int i) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", i);
        BigDecimal price = (BigDecimal)this.getModel().getValue("price", i);
        if (qty == null || price == null || price.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0) {
            this.setValue("amount", BigDecimal.ZERO, i, false);
            return;
        }
        this.calAmonutByQtyChange(i, "price", "qty", "amount", "settlecurrency");
    }

    private void changePrice(Object newValue, Object oldValue, int i) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("price", i);
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", i);
        if (qty == null || price == null || price.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0) {
            this.setValue("amount", BigDecimal.ZERO, i, false);
            return;
        }
        this.calAmonutByPriceChange(i, "price", "qty", "amount", "settlecurrency");
    }

    private void changeAmout(Object newValue, Object oldValue, int i) {
        BigDecimal amout = (BigDecimal)this.getModel().getValue("amount", i);
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", i);
        if (qty == null || amout == null || amout.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0) {
            this.setValue("price", BigDecimal.ZERO, i, false);
            return;
        }
        this.calPriceByAmountChange(i, "price", "qty", "amount", "settlecurrency");
    }

    private void changeSettleCurrency() {
        int amountPrecision = 2;
        int pricePrecision = 10;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("settlecurrency");
        if (currency != null) {
            amountPrecision = this.getPrecision("settlecurrency", "amtprecision");
            pricePrecision = this.getPrecision("settlecurrency", "priceprecision");
        }
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", i);
            BigDecimal price = (BigDecimal)this.getModel().getValue("price", i);
            if (price != null) {
                price = price.setScale(pricePrecision, 4);
                this.setValue("price", price, i, false);
            }
            if (qty == null || price == null || price.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0) {
                this.setValue("amount", BigDecimal.ZERO, i, false);
                continue;
            }
            BigDecimal amout = qty.multiply(price).setScale(amountPrecision, 4);
            this.setValue("amount", amout, i, false);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject bizOrg = (DynamicObject)bill.getValue("bizorg");
        switch (key) {
            case "bizdept": {
                this.bizDeptSelect(e, showParameter, bizOrg);
                break;
            }
            case "requser": {
                this.reqUsertSelect(e, showParameter, bizOrg);
                break;
            }
            case "supplyowner": {
                this.supplyOwnerSelect(e, showParameter);
                break;
            }
        }
    }

    private void bizDeptSelect(BeforeF7SelectEvent e, ListShowParameter showParameter, DynamicObject bizOrg) {
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
    }

    private void reqUsertSelect(BeforeF7SelectEvent e, ListShowParameter showParameter, DynamicObject bizOrg) {
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showTipNotification(IMStringUtils.append((String)String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"MaterialReqOutBillPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]), displayName), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        showParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        DynamicObject bizdept = (DynamicObject)this.getModel().getValue("bizdept");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        if (bizdept == null) {
            List subDeptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList((Long)bizOrg.getPkValue()), (boolean)true);
            if (!subDeptIds.isEmpty()) {
                orgIds.addAll(subDeptIds);
            }
        } else {
            orgIds.add((Long)bizdept.getPkValue());
        }
        if (orgIds.isEmpty()) {
            return;
        }
        List orgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), orgIds, (boolean)true);
        showParameter.getListFilterParameter().setFilter(new QFilter("entryentity.dpt", "in", (Object)orgs));
    }

    private void supplyOwnerSelect(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        IDataModel model = this.getModel();
        String type = (String)this.getModel().getValue("supplyownertype");
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)model.getValue("org");
        switch (type) {
            case "bos_org": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                f = new QFilter("id", "in", this.getOwnerList());
                showParameter.setCustomParam("orgFuncId", (Object)"10");
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                this.addVMISelect(e);
                break;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    private void addVMISelect(BeforeF7SelectEvent e) {
        String domain;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && "6".equals(domain = bizType.getString("domain"))) {
            QFilter q = new QFilter("enablevmi", "=", (Object)"1");
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)q);
        }
    }

    public ArrayList<Object> getOwnerList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Object> array = new ArrayList<Object>();
        if (!CommonUtils.isNull((Object)org)) {
            Long orgId = (Long)org.getPkValue();
            ArrayList ownerArray = OwnerHelper.getOwners((Long)orgId);
            array.addAll(ownerArray);
            Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (companyByOrg != null) {
                array.add(companyByOrg.get("id"));
            }
        }
        return array;
    }

    private void initPriceField(boolean isPresent, int rowIndex) {
        IFormView view = this.getView();
        boolean isEnable = !isPresent;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"price"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amount"});
    }

    @Override
    protected void setBillEntryEnable(RowDataEntity row) {
        super.setBillEntryEnable(row);
        DynamicObject dynamicObject = row.getDataEntity();
        Boolean isPresent = dynamicObject.getBoolean("ispresent");
        this.initPriceField(isPresent, row.getRowIndex());
    }

    @Override
    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        IFormView view = this.getView();
        int index = row.getRowIndex();
        if (isDraw) {
            view.setEnable(Boolean.valueOf(!isDraw), index, new String[]{"ispresent"});
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)newValue;
        this.initPriceField(isPresent, rowIndex);
        if (isPresent) {
            model.setValue("price", (Object)Constants.ZERO, rowIndex);
            model.setValue("amount", (Object)Constants.ZERO, rowIndex);
        }
    }

    private String getBizOrgDisplayName() {
        BasedataEdit bizOrgEdit = (BasedataEdit)this.getControl("bizorg");
        IDataEntityProperty orgProp = bizOrgEdit.getProperty();
        LocaleString displayName = orgProp.getDisplayName();
        return displayName.toString();
    }

    private void changeBizOrg(Object newValue) {
        boolean isinupdate;
        IDataModel model = this.getModel();
        Object settleOrgId = null;
        if (newValue == null) {
            model.setValue("bizdept", null);
            model.setValue("bizoperatorgroup", null);
            model.setValue("bizoperator", null);
            model.setValue("settleorg", settleOrgId);
        } else {
            DynamicObject bizOrg = (DynamicObject)newValue;
            model.setValue("bizdept", null);
            model.setValue("requser", null);
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)bizOrg.getPkValue()), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (map != null) {
                settleOrgId = map.get("id");
            }
            model.setValue("settleorg", settleOrgId);
        }
        DynamicObject invscheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (invscheme != null && (isinupdate = invscheme.getBoolean("isinupdate"))) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                Object ownerType = this.getModel().getValue("ownertype");
                if (!"bos_org".equals(ownerType)) continue;
                this.setValue("owner", settleOrgId, i, false);
            }
        }
    }

    private void changeSupplyOwner() {
        boolean isinupdate;
        IDataModel model = this.getModel();
        Object supplyOwnerId = null;
        DynamicObject supplyOwner = (DynamicObject)model.getValue("supplyowner");
        if (supplyOwner != null) {
            supplyOwnerId = supplyOwner.getPkValue();
        }
        Object supplyOwnerType = model.getValue("supplyownertype");
        DynamicObject invscheme = (DynamicObject)model.getValue("invscheme");
        if (invscheme != null && (isinupdate = invscheme.getBoolean("isoutupdate"))) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                Object outOwnerType = this.getModel().getValue("outownertype", i);
                if (supplyOwnerType == null || !supplyOwnerType.equals(outOwnerType)) continue;
                this.setValue("outowner", supplyOwnerId, i, true);
            }
        }
    }

    private void changeOrg(Object newValue) {
        this.initCurrency(newValue == null ? null : (Long)((DynamicObject)newValue).getPkValue());
    }

    private void changeReqUser(DynamicObject user) {
        IDataModel model = this.getModel();
        DynamicObject dept = (DynamicObject)model.getValue("bizdept");
        DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
        if (dept != null || user == null || bizOrg == null) {
            return;
        }
        DynamicObjectCollection entrys = user.getDynamicObjectCollection("entryentity");
        if (entrys == null) {
            return;
        }
        List orgIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList((Long)bizOrg.getPkValue()), (boolean)true);
        HashSet deptIds = new HashSet(16);
        if (!orgIds.isEmpty()) {
            List orgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (List)orgIds, (boolean)true);
            deptIds.addAll(orgs);
        }
        for (DynamicObject entry : entrys) {
            boolean isPartJob = entry.getBoolean("ispartjob");
            DynamicObject dptObj = entry.getDynamicObject("dpt");
            if (dptObj == null || dept != null && isPartJob || !deptIds.isEmpty() && !deptIds.contains(dptObj.getPkValue())) continue;
            dept = dptObj;
        }
        this.getModel().setValue("bizdept", (Object)dept);
    }

    private void changeBizDept() {
        Long deptId;
        Set userIds;
        DynamicObject bizDept = (DynamicObject)this.getModel().getValue("bizdept");
        DynamicObject reqUser = (DynamicObject)this.getModel().getValue("requser");
        if (bizDept != null && reqUser != null && !(userIds = UserServiceHelper.getAllUsersOfOrg((int)6, Collections.singletonList(deptId = (Long)bizDept.getPkValue()), (boolean)false, (boolean)false)).contains((Long)reqUser.getPkValue())) {
            this.getModel().setValue("requser", null);
        }
    }

    private void initCurrency(Long orgId) {
        if (orgId == null) {
            this.getModel().setValue("settlecurrency", null);
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (map == null) {
            this.getModel().setValue("settlecurrency", null);
            return;
        }
        this.getModel().setValue("settlecurrency", map.get("baseCurrencyID"));
    }

    private void changeInvScheme() {
        this.resetTopDefaltOwner();
        this.changeSupplyOwner();
    }
}

