/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.outbill.saloutbill;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.algorithm.TaxAlgorithmForForm;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.CustomerHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.DefaultTaxRateHelper;
import kd.scmc.im.business.helper.ExchangeRateHelper;
import kd.scmc.im.business.helper.ImBillEditHelper;
import kd.scmc.im.business.helper.ImLotHelper;
import kd.scmc.im.business.helper.InvSchemeHelper;
import kd.scmc.im.business.helper.KitManagementHelper;
import kd.scmc.im.business.helper.MaterialChangeHelper;
import kd.scmc.im.business.helper.SetValueForBotpWBHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.business.service.InvSchemeService;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.CustomerConst;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public class SaleOutBillPlugin
extends ImBillEditPlugin {
    private TaxAlgorithmForForm algo = null;

    protected TaxAlgorithmForForm getAlgorithm() {
        if (this.algo == null) {
            this.algo = new TaxAlgorithmForForm(this.getView());
        }
        return this.algo;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"reclinkman", "reccustomer", "settlecustomer", "payingcustomer", "linkman", "bizoperatorgroup", "bizoperator", "bizdept", "bizorg", "entrysettleorg", "owner", "warehouse", "taxrateid", "customer", "inwarehouse", "inlocation"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject bizOrg = (DynamicObject)model.getValue("bizorg");
        if (org != null) {
            this.initCurrencyAndExrateTable((Long)org.getPkValue());
        }
        Date bizDate = (Date)model.getValue("biztime");
        model.setValue("exratedate", (Object)bizDate);
        this.handleInWarehouseVisible();
        this.initInWarehouse();
        if (org != null && bizOrg != null) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            int entryRowCount = model.getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.setDefaltOwnerAndKeeper(i);
            }
        }
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            this.initCurrencyAndExrateTable((Long)org.getPkValue());
        }
        Date bizDate = (Date)this.getModel().getValue("biztime");
        model.setValue("exratedate", (Object)bizDate);
        SetValueForBotpWBHelper.salOutAfterCopyData((IDataModel)model);
        Map exchangeRateMap = ExchangeRateHelper.getExRateMap((Object)this.getModel().getValue("currency"), (Object)this.getModel().getValue("settlecurrency"), (Object)this.getModel().getValue("exratetable"), (Date)bizDate);
        if (exchangeRateMap != null) {
            Object quoteType = exchangeRateMap.get("quoteType");
            Object exchangeRate = exchangeRateMap.get("exchangeRate");
            if (quoteType != null) {
                this.getModel().setValue("quotation", (Object)((Boolean)quoteType != false ? "1" : "0"));
            }
            this.getModel().setValue("exchangerate", exchangeRate);
        }
        this.checkExchangeRate(true, exchangeRateMap == null ? null : exchangeRateMap.get("exchangeRate"));
        this.getAlgorithm().calByChange("exchangerate");
    }

    @Override
    protected void handleVisible() {
        super.handleVisible();
        boolean isInitBill = this.getBill().getBoolean("isinitbill");
        this.getView().setVisible(Boolean.valueOf(isInitBill), new String[]{"materialcost"});
        this.getView().setVisible(Boolean.valueOf(isInitBill), new String[]{"unitmaterialcost"});
    }

    private void change2InitBill(IDataModel model) {
        int rowCount;
        boolean isInitBill = (Boolean)model.getValue("isinitbill");
        this.getView().setVisible(Boolean.valueOf(isInitBill), new String[]{"materialcost"});
        this.getView().setVisible(Boolean.valueOf(isInitBill), new String[]{"unitmaterialcost"});
        if (!isInitBill && (rowCount = this.getModel().getEntryRowCount("billentry")) > 0) {
            for (int i = 0; i < rowCount; ++i) {
                this.getModel().setValue("materialcost", (Object)new BigDecimal(BigInteger.ZERO), i);
                this.getModel().setValue("unitmaterialcost", (Object)new BigDecimal(BigInteger.ZERO), i);
            }
        }
    }

    private void changeBizTime(IDataModel model) {
        int rowCount = model.getEntryRowCount("billentry");
        Date bizTime = (Date)model.getValue("biztime");
        if (rowCount > 0) {
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("billentry");
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                boolean needClear;
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                DynamicObject taxrate = dynamicObject.getDynamicObject("taxrateid");
                if (taxrate == null) continue;
                Date activedate = taxrate.getDate("activedate");
                Date expdate = taxrate.getDate("expdate");
                boolean bl = needClear = bizTime == null || bizTime.before(activedate) || expdate != null && bizTime.after(expdate);
                if (!needClear) continue;
                this.setValue("taxrateid", null, i, false);
                this.changeTaxRateID(null, i);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData[] valueSet = e.getChangeSet();
        for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            if (!this.isChange(newValue, oldValue)) {
                return;
            }
            switch (fieldName) {
                case "istax": {
                    this.changeIsTax(newValue);
                    break;
                }
                case "inputamount": {
                    this.changeInputAmount((Boolean)newValue);
                    break;
                }
                case "ispresent": {
                    this.changeIsPresent(newValue, rowIndex);
                    break;
                }
                case "taxrateid": {
                    if (null != newValue) {
                        DynamicObject taxRateID = (DynamicObject)newValue;
                        this.changeTaxRateID(taxRateID, rowIndex);
                        break;
                    }
                    model.setValue("taxrate", (Object)0, rowIndex);
                    break;
                }
                case "price": {
                    this.changePrice(oldValue, newValue, rowIndex);
                    break;
                }
                case "priceandtax": {
                    this.changePriceAndTax(oldValue, newValue, rowIndex);
                    break;
                }
                case "actualprice": {
                    this.changeActualPrice(oldValue, newValue, rowIndex);
                    break;
                }
                case "actualtaxprice": {
                    this.changeActualTaxPrice(oldValue, newValue, rowIndex);
                    break;
                }
                case "discounttype": {
                    this.changeDiscountType(newValue, rowIndex);
                    break;
                }
                case "discountrate": {
                    this.changeDisCountRate(fieldName, oldValue, rowIndex);
                    break;
                }
                case "discountamount": {
                    BigDecimal discountAmount = (BigDecimal)newValue;
                    this.changeDiscountAmount(fieldName, oldValue, discountAmount, rowIndex);
                    break;
                }
                case "taxamount": {
                    this.changeTaxMount(oldValue, rowIndex);
                    break;
                }
                case "customer": {
                    DynamicObject customer = (DynamicObject)newValue;
                    this.changeCustomer(customer);
                    break;
                }
                case "reccustomer": {
                    DynamicObject recCustomer = (DynamicObject)newValue;
                    this.changeRecCustomer(recCustomer, rowIndex);
                    break;
                }
                case "bizoperator": {
                    if (null != newValue) {
                        DynamicObject bizOperator = (DynamicObject)newValue;
                        this.changeBizOperator(bizOperator);
                        break;
                    }
                    model.setValue("bizoperatorgroup", null);
                    break;
                }
                case "bizoperatorgroup": {
                    DynamicObject bizGrp = (DynamicObject)newValue;
                    this.changeBizOperatorGroup(bizGrp);
                    break;
                }
                case "bizorg": {
                    if (null != newValue) {
                        DynamicObject bizOrg = (DynamicObject)newValue;
                        this.changeBizOrg(bizOrg);
                        break;
                    }
                    int entryRowCount = this.getModel().getEntryRowCount("billentry");
                    model.setValue("bizdept", null);
                    model.setValue("bizoperatorgroup", null);
                    model.setValue("bizoperator", null);
                    model.setValue("customer", null);
                    model.setValue("settlecurrency", null);
                    break;
                }
                case "org": {
                    this.changeOrg(newValue);
                    break;
                }
                case "entrysettleorg": {
                    this.changeEntrySettleOrg(newValue, rowIndex);
                    break;
                }
                case "invscheme": {
                    this.handleInWarehouseVisible();
                    this.clearWarehouse("inwarehouse", "inlocation");
                    break;
                }
                case "outowner": {
                    this.changeOutOwenr(rowIndex);
                    break;
                }
                case "qty": 
                case "unitmaterialcost": {
                    this.cal2MaterialCost(null, rowIndex);
                    SetValueForBotpWBHelper.salOutSetValueByPropChange((IDataModel)model, (int)rowIndex);
                    KitManagementHelper.reCalKitChildQty((IFormView)this.getView(), (int)rowIndex, (String)fieldName);
                    break;
                }
                case "materialcost": {
                    this.cal2MaterialCost("unitmaterialcost", rowIndex);
                    break;
                }
                case "isinitbill": {
                    this.change2InitBill(this.getModel());
                    break;
                }
                case "biztime": {
                    this.changeBizTime(this.getModel());
                    break;
                }
                case "outownertype": {
                    this.changeOutOwnerType(newValue, rowIndex);
                    break;
                }
                case "unit": {
                    SetValueForBotpWBHelper.salOutSetValueByPropChange((IDataModel)model, (int)rowIndex);
                    break;
                }
                case "material": {
                    DefaultTaxRateHelper.changeMaterial((IDataModel)this.getModel(), (String)"customer", (DynamicObject)((DynamicObject)newValue), (int)rowIndex);
                    MaterialChangeHelper.changeMaterial((IDataModel)this.getModel(), (DynamicObject)((DynamicObject)newValue), (int)rowIndex);
                    break;
                }
                case "currency": 
                case "settlecurrency": 
                case "exratetable": 
                case "exratedate": {
                    this.checkExchangeRate(false, null);
                    break;
                }
                case "inwarehouse": {
                    this.changeOutWarehouse(valueSet, "inlocation");
                    break;
                }
                case "warehouse": {
                    this.changeWarehouse(rowIndex);
                    break;
                }
                case "location": {
                    this.changeLocation(rowIndex);
                    break;
                }
            }
            if ("settlecurrency".equals(fieldName)) {
                this.changeSettleCurrency(oldValue, newValue);
            }
            this.getAlgorithm().calByChange(e);
        }
    }

    private void changeLocation(int rowIndex) {
        DynamicObject wareHouse = (DynamicObject)this.getModel().getValue("warehouse");
        DynamicObject outWareHouse = (DynamicObject)this.getModel().getValue("inwarehouse");
        if (wareHouse == null || outWareHouse == null) {
            return;
        }
        DynamicObject inWareHouse = (DynamicObject)this.getModel().getValue("inlocation");
        if (wareHouse.getPkValue().equals(outWareHouse.getPkValue()) && inWareHouse == null && this.isInUpdate()) {
            Object value = this.getModel().getValue("location", rowIndex);
            this.getModel().setValue("inlocation", value, rowIndex);
        }
    }

    private void changeWarehouse(int rowIndex) {
        DynamicObject wareHouse = (DynamicObject)this.getModel().getValue("warehouse");
        Object outWareHouse = this.getModel().getValue("inwarehouse");
        if (outWareHouse == null && this.isInUpdate()) {
            this.getModel().setValue("inwarehouse", (Object)wareHouse, rowIndex);
        }
    }

    private void cal2MaterialCost(String changeKey, int rowIndex) {
        this.getModel().beginInit();
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
        if (StringUtils.isBlank((CharSequence)changeKey)) {
            BigDecimal baseMCost = (BigDecimal)this.getModel().getValue("unitmaterialcost", rowIndex);
            baseMCost = baseMCost == null ? new BigDecimal(BigInteger.ZERO) : baseMCost;
            this.getModel().setValue("materialcost", (Object)baseMCost.multiply(qty), rowIndex);
        } else {
            BigDecimal materialCost = (BigDecimal)this.getModel().getValue("materialcost");
            int compareTo = qty.compareTo(new BigDecimal(BigInteger.ZERO));
            int pricePrecision = this.getPrecision("currency", "priceprecision");
            this.getModel().setValue("unitmaterialcost", (Object)(compareTo == 0 ? new BigDecimal(BigInteger.ZERO) : materialCost.divide(qty, pricePrecision, 4)), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("unitmaterialcost", rowIndex);
        this.getView().updateView("materialcost", rowIndex);
    }

    private boolean isChange(Object newValue, Object oldValue) {
        if (newValue != null && newValue.equals(oldValue)) {
            return false;
        }
        if (oldValue != null && newValue != null && oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
            return false;
        }
        return oldValue == null || newValue == null || !(oldValue instanceof BigDecimal) || !(newValue instanceof BigDecimal) || ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) != 0;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject bizOrg = (DynamicObject)bill.getValue("bizorg");
        ImBillEditHelper helper = new ImBillEditHelper(this.getView());
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        switch (key) {
            case "customer": {
                this.customerSelect(e, rowIndex);
                break;
            }
            case "settlecustomer": 
            case "payingcustomer": 
            case "reccustomer": {
                this.entryCustomerSelect(e, key);
                break;
            }
            case "reclinkman": {
                this.linkManSelect(e, showParameter, rowIndex);
                break;
            }
            case "bizoperatorgroup": {
                this.operatorGroupSelect(e, bill, showParameter, bizOrg);
                break;
            }
            case "bizorg": {
                this.bizOrgSelect(e, showParameter, bizOrg);
                break;
            }
            case "bizoperator": {
                this.operatorSelect(e, showParameter, bizOrg);
                break;
            }
            case "bizdept": {
                this.bizDeptSelect(e, showParameter, bizOrg);
                break;
            }
            case "taxrateid": {
                this.taxrateSelect(e, showParameter);
                break;
            }
            case "inwarehouse": {
                helper.warehouseSelect(e, showParameter, bill);
                break;
            }
            case "inlocation": {
                helper.locationSelect(e, showParameter, bill, rowIndex, "inwarehouse");
                break;
            }
        }
    }

    private void bizOrgSelect(BeforeF7SelectEvent e, ListShowParameter showParameter, DynamicObject bizOrg) {
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.initInWarehouse();
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        boolean isTax = (Boolean)this.getModel().getValue("istax");
        boolean inputAmount = (Boolean)this.getModel().getValue("inputamount");
        DynamicObject customer = this.getModel().getValue("customer") == null ? null : (DynamicObject)this.getModel().getValue("customer");
        Long receiveLinkman = customer == null ? null : CustomerHelper.getLinkman((DynamicObject)customer);
        ILocaleString receiveAddress = CustomerHelper.getValidDefaultMultilingualAddress((DynamicObject)customer);
        if ("billentry".equals(entryName)) {
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.initPriceField(isTax, inputAmount, rowIndex);
                this.setDefaultCustomerInfo(rowIndex);
                this.getModel().setValue("reclinkman", (Object)receiveLinkman, rowIndex);
                this.getModel().setValue("receiveaddress", (Object)receiveAddress, rowIndex);
            }
        }
    }

    private void setDefaultCustomerInfo(int rowIndex) {
        IDataModel bill = this.getModel();
        DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
        DynamicObject settleCustomer = null;
        DynamicObject payingCustomer = null;
        DynamicObject recCustomer = null;
        if (customer != null) {
            String bizFunction = customer.get("bizfunction") == null ? "" : customer.get("bizfunction").toString();
            recCustomer = bizFunction.contains("1") ? customer : null;
            settleCustomer = customer.getDynamicObject("invoicecustomerid");
            settleCustomer = settleCustomer == null ? (bizFunction.contains("2") ? customer : null) : settleCustomer;
            payingCustomer = customer.getDynamicObject("paymentcustomerid");
            payingCustomer = payingCustomer == null ? (bizFunction.contains("3") ? customer : null) : payingCustomer;
        }
        bill.setValue("reccustomer", recCustomer == null ? null : recCustomer.getPkValue(), rowIndex);
        bill.setValue("settlecustomer", settleCustomer == null ? null : settleCustomer.getPkValue(), rowIndex);
        bill.setValue("payingcustomer", payingCustomer == null ? null : payingCustomer.getPkValue(), rowIndex);
    }

    @Override
    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        boolean enableKitSale = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"KIT0001");
        if (!enableKitSale) {
            return;
        }
        String completeDeleteKitRows = this.getPageCache().get("completeDeleteKitRows");
        if ("false".equals(completeDeleteKitRows)) {
            return;
        }
        KitManagementHelper.deleteKitRow((IFormPlugin)this, (IFormView)this.getView(), (BeforeDeleteRowEventArgs)e);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        KitManagementHelper.confirmCallBack((MessageBoxClosedEvent)e, (IPageCache)this.getPageCache(), (IFormView)this.getView());
    }

    private void customerSelect(BeforeF7SelectEvent e, int rowIndex) {
        boolean isConsignment = this.isConsignment();
        if (isConsignment) {
            QFilter qf = new QFilter("consignment", "=", (Object)true);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qf);
        }
        this.addCustomerBizFuncFilter(e, "customer");
    }

    private void addCustomerBizFuncFilter(BeforeF7SelectEvent e, String propName) {
        QFilter bizFunctionFilter = null;
        switch (propName) {
            case "customer": {
                bizFunctionFilter = new QFilter("bizfunction", "match", (Object)"4");
                break;
            }
            case "settlecustomer": {
                bizFunctionFilter = new QFilter("bizfunction", "match", (Object)"2");
                break;
            }
            case "payingcustomer": {
                bizFunctionFilter = new QFilter("bizfunction", "match", (Object)"3");
                break;
            }
            case "reccustomer": {
                bizFunctionFilter = new QFilter("bizfunction", "match", (Object)"1");
                break;
            }
        }
        if (bizFunctionFilter != null) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, bizFunctionFilter);
        }
    }

    private boolean isConsignment() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        return bizType != null && ("230".equals(bizType.getString("number")) || "2301".equals(bizType.getString("number")));
    }

    private QFilter getCustomerFilter(Long orgId) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)orgId);
        return filter;
    }

    private void entryCustomerSelect(BeforeF7SelectEvent e, String propName) {
        if (this.getModel().getValue("customer") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u8d27\u5ba2\u6237\u3002", (String)"SaleOutBillPlugin_12", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.addCustomerBizFuncFilter(e, propName);
    }

    private void bizDeptSelect(BeforeF7SelectEvent e, ListShowParameter showParameter, DynamicObject bizOrg) {
    }

    private void operatorSelect(BeforeF7SelectEvent e, ListShowParameter showParameter, DynamicObject bizOrg) {
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\u3002", (String)"SaleOutBillPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        BasedataEdit control = (BasedataEdit)this.getControl("bizoperatorgroup");
        BasedataProp property = (BasedataProp)control.getProperty();
        FilterBuilder buildCoreFilter = property.buildCoreFilter(this.getModel());
        QFilter filterGridFilter = buildCoreFilter.getQFilter();
        long bizOrgId = (Long)bizOrg.getPkValue();
        List operatorGroupIds = this.getOperatorGroup(filterGridFilter, bizOrgId);
        QFilter qFilter1 = new QFilter("operatorgrpid", "in", (Object)operatorGroupIds);
        QFilter qFilter2 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2));
    }

    private List getOperatorGroup(QFilter filterGridFilter, long bizOrgId) {
        QFilter enableFilter;
        QFilter operatorGroupIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)bizOrgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{filterGridFilter, operatorGroupIdFilter, enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashSet keySet = new HashSet(map.keySet());
        return new ArrayList(keySet);
    }

    private void operatorGroupSelect(BeforeF7SelectEvent e, IDataModel bill, ListShowParameter showParameter, DynamicObject bizOrg) {
        if (bizOrg == null) {
            String displayName = this.getBizOrgDisplayName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%1$s\u3002", (String)"SaleOutBillPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]), displayName));
            e.setCancel(true);
            return;
        }
        DynamicObject bizoperator = (DynamicObject)bill.getValue("bizoperator");
        if (bizoperator == null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0));
        } else {
            bizoperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizoperator.getPkValue(), (String)"bd_operator");
            QFilter qFilter01 = new QFilter("operatorid", "=", bizoperator.getDynamicObject("operatorid").getPkValue());
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter01});
            if (map.size() != 0) {
                ArrayList list = new ArrayList(map.values());
                ArrayList<Long> groupList = new ArrayList<Long>();
                for (int i = 0; i < list.size(); ++i) {
                    groupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", groupList));
            }
        }
    }

    private void linkManSelect(BeforeF7SelectEvent e, ListShowParameter showParameter, int rowIndex) {
        Object recCustomer = this.getModel().getValue("customer", rowIndex);
        if (recCustomer == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u8d27\u5ba2\u6237\u3002", (String)"SaleOutBillPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            DynamicObject recCustomerDy = (DynamicObject)recCustomer;
            QFilter qFilter = new QFilter("customerid", "=", recCustomerDy.getPkValue());
            qFilter.and("invalid", "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
        }
    }

    private void changeTaxRateID(DynamicObject taxRateID, int rowIndex) {
        if (taxRateID == null) {
            this.getModel().setValue("taxrate", (Object)0, rowIndex);
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
    }

    private void changeDiscountType(Object newValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        model.setValue("discountrate", null, rowIndex);
        model.setValue("discountamount", null, rowIndex);
        if (DiscountTypeEnum.NULL.getValue().equals(newValue)) {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountamount"});
        } else {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountamount"});
        }
    }

    private void changeDisCountRate(String fieldName, Object oldValue, int rowIndex) {
        DynamicObject settleCurrency;
        IDataModel model = this.getModel();
        int discountRateScale = 4;
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate == null) {
            discountRate = BigDecimal.ZERO;
        }
        if ((settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency")) != null) {
            discountRateScale = settleCurrency.getInt("priceprecision");
        }
        if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            discountRate = discountRate.setScale(discountRateScale, 4);
            model.setValue("discountrate", (Object)discountRate, rowIndex);
            if (discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) > 0) {
                model.setValue(fieldName, oldValue, rowIndex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e100%\u3002", (String)"SaleOutBillPlugin_9", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else if (discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) == 0) {
                model.setValue("ispresent", (Object)true, rowIndex);
            }
        } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            boolean isTax = (Boolean)model.getValue("istax");
            BigDecimal amount = discountRate;
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                if (amount.compareTo(priceAndTax) > 0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"SaleOutBillPlugin_10", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                if (amount.compareTo(price) > 0) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"SaleOutBillPlugin_11", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            model.setValue("discountrate", (Object)discountRate.doubleValue(), rowIndex);
        }
    }

    private void changeDiscountAmount(String fieldName, Object oldValue, BigDecimal discountAmount, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        BigDecimal amoutAndTax = BigDecimal.ZERO;
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        int amountPrecision = 2;
        DynamicObject currency = (DynamicObject)model.getValue("settlecurrency");
        if (currency != null) {
            amountPrecision = currency.getInt("amtprecision");
        }
        if (isTax) {
            BigDecimal price = (BigDecimal)model.getValue("priceandtax", rowIndex);
            amoutAndTax = price.multiply(qty).setScale(amountPrecision, RoundingMode.HALF_UP);
        } else {
            BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
            BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
            amoutAndTax = price.multiply(qty).multiply(taxRate.add(BigDecimal.ONE)).setScale(amountPrecision, RoundingMode.HALF_UP);
        }
        if (discountAmount != null && discountAmount.compareTo(amoutAndTax) > 0) {
            this.getModel().setValue(fieldName, oldValue, rowIndex);
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_UNITDISAMOUNT()));
        }
    }

    private void changeTaxMount(Object oldValue, int rowIndex) {
        boolean taxAmountCheck;
        IDataModel model = this.getModel();
        BigDecimal amountAndTax = (BigDecimal)model.getValue("amountandtax", rowIndex);
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
        boolean bl = taxAmountCheck = taxAmount.compareTo(amountAndTax) > 0 || taxAmount.compareTo(BigDecimal.ZERO) < 0;
        if (taxAmountCheck) {
            model.setValue("taxamount", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u4e14\u4e0d\u80fd\u5927\u4e8e\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"PurInBillEditPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void changeIsTax(Object newValue) {
        boolean inputAmount = (Boolean)this.getModel().getValue("inputamount");
        if (newValue instanceof Boolean) {
            boolean isTax = (Boolean)newValue;
            IDataModel model = this.getModel();
            int entryRowCount = model.getEntryRowCount("billentry");
            int discountRateScale = this.getDiscountRateScale();
            for (int i = 0; i < entryRowCount; ++i) {
                this.initPriceField(isTax, inputAmount, i);
                this.checkAndSetDiscountRate(isTax, model, discountRateScale, i);
            }
        }
    }

    protected void initPriceField(boolean isTax, boolean inputAmount, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)model.getValue("ispresent", rowIndex);
        view.setEnable(Boolean.valueOf(!isPresent), rowIndex, new String[]{"taxrateid"});
        boolean isDraw = this.isDrawByBOTP();
        view.setEnable(Boolean.valueOf(!isPresent && !isDraw), rowIndex, new String[]{"discounttype"});
        boolean isDiscount = DiscountTypeEnum.NULL.getValue().equals(model.getValue("discounttype", rowIndex));
        view.setEnable(Boolean.valueOf(!isDiscount && !isPresent && !isDraw), rowIndex, new String[]{"discountrate"});
        view.setEnable(Boolean.valueOf(!isDiscount && !isPresent && !isDraw), rowIndex, new String[]{"discountamount"});
        String discountType = (String)model.getValue("discounttype", rowIndex);
        if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"discountamount"});
        }
        boolean isEnable = !isPresent && !isTax;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"actualprice"});
        view.setEnable(Boolean.valueOf(isEnable && inputAmount), rowIndex, new String[]{"amount"});
        isEnable = !isPresent && isTax;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"actualtaxprice"});
        view.setEnable(Boolean.valueOf(isEnable && inputAmount), rowIndex, new String[]{"amountandtax"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"taxamount"});
        if (inputAmount && !isPresent) {
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"price"});
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"priceandtax"});
        } else {
            this.setPriceEnable(isPresent, isTax, rowIndex);
        }
        KitManagementHelper.setPriceAmtEnable((IFormView)view, (int)rowIndex);
    }

    @Override
    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        IFormView view = this.getView();
        int index = row.getRowIndex();
        if (isDraw) {
            view.setEnable(Boolean.FALSE, index, new String[]{"ispresent", "discountamount", "discounttype", "discountrate", "reccustomer"});
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)newValue;
        boolean isTax = (Boolean)model.getValue("istax");
        boolean inputAmount = (Boolean)model.getValue("inputamount");
        this.initPriceField(isTax, inputAmount, rowIndex);
        Object price = this.getModel().getValue("price", rowIndex);
        this.presentChange(price, isPresent, rowIndex);
    }

    private void changeCustomer(DynamicObject customer) {
        IDataModel model = this.getModel();
        if (customer == null) {
            model.setValue("settletype", null);
            model.setValue("settlecurrency", null);
            model.setValue("settletype", null);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getModel().setValue("payingcustomer", null, i);
                this.getModel().setValue("settlecustomer", null, i);
                this.getModel().setValue("reclinkman", null, i);
                this.getModel().setValue("receiveaddress", null, i);
                this.getModel().setValue("reccustomer", null, i);
                this.setValue("reclinkman", null, i, false);
                this.setValue("receiveaddress", null, i, false);
                if ("bd_customer".equals(this.getModel().getValue("outownertype", i))) {
                    this.setValue("outowner", null, i, false);
                }
                if ("bd_customer".equals(this.getModel().getValue("outkeepertype", i))) {
                    this.setValue("outkeeper", null, i, false);
                }
                if ("bd_customer".equals(this.getModel().getValue("ownertype", i))) {
                    this.setValue("owner", null, i, false);
                }
                if (!"bd_customer".equals(this.getModel().getValue("keepertype", i))) continue;
                this.setValue("keeper", null, i, false);
            }
            return;
        }
        Long receiveLinkman = null;
        ILocaleString receiveAddress = null;
        DynamicObject payingCustomer = null;
        DynamicObject settleCustomer = null;
        receiveLinkman = CustomerHelper.getLinkman((DynamicObject)customer);
        receiveAddress = CustomerHelper.getValidDefaultMultilingualAddress((DynamicObject)customer);
        Object bizFunction = customer.get("bizfunction");
        String bizFunctionStr = bizFunction == null ? "" : bizFunction.toString();
        DynamicObject payCustomer = customer.getDynamicObject("paymentcustomerid");
        payingCustomer = payCustomer == null ? (bizFunctionStr.contains("3") ? customer.getPkValue() : null) : payCustomer;
        DynamicObject invoiceCustomer = customer.getDynamicObject("invoicecustomerid");
        settleCustomer = invoiceCustomer == null ? (bizFunctionStr.contains("2") ? customer.getPkValue() : null) : invoiceCustomer;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.setValue("payingcustomer", payingCustomer, i, false);
            this.setValue("settlecustomer", settleCustomer, i, false);
            this.setValue("reccustomer", bizFunctionStr.contains("1") ? customer : null, i, false);
            this.setValue("reclinkman", receiveLinkman, i, false);
            this.setValue("receiveaddress", receiveAddress, i, false);
            if ("bd_customer".equals(this.getModel().getValue("outownertype", i))) {
                this.setValue("outowner", this.getModel().getValue("customer"), i, false);
            }
            if ("bd_customer".equals(this.getModel().getValue("outkeepertype", i))) {
                this.setValue("outkeeper", this.getModel().getValue("customer"), i, false);
            }
            if ("bd_customer".equals(this.getModel().getValue("ownertype", i))) {
                this.setValue("owner", this.getModel().getValue("customer"), i, false);
            }
            if (!"bd_customer".equals(this.getModel().getValue("keepertype", i))) continue;
            this.setValue("keeper", this.getModel().getValue("customer"), i, false);
        }
        this.setValue("settletype", customer.getDynamicObject("settlementtypeid"), false);
        if (customer.getDynamicObject("settlementcyid") != null) {
            DynamicObject settleCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getDynamicObject("settlementcyid").getPkValue(), (String)"bd_currency", (String)"id, number, name, amtprecision,priceprecision,sign,isshowsign");
            this.setValue("settlecurrency", settleCurrency, true);
        } else {
            this.setValue("settlecurrency", model.getValue("currency"), true);
        }
        DynamicObject reccondition = customer.getDynamicObject("receivingcondid");
        if (reccondition != null) {
            this.setValue("reccondition", reccondition, false);
        } else {
            this.setValue("reccondition", null, false);
        }
    }

    private void changeRecCustomer(DynamicObject recCustomer, int row) {
    }

    private String getBizOrgDisplayName() {
        BasedataEdit bizOrgEdit = (BasedataEdit)this.getControl("bizorg");
        IDataEntityProperty orgProp = bizOrgEdit.getProperty();
        LocaleString displayName = orgProp.getDisplayName();
        return displayName.toString();
    }

    private void changeBizOrg(DynamicObject bizOrg) {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        this.getModel().setValue("bizoperator", null);
        this.getModel().setValue("bizoperatorgroup", null);
        for (int i = 0; i < entryRowCount; ++i) {
            this.setDefaltOwnerAndKeeper(i);
        }
    }

    private void changeOrg(Object newValue) {
        this.initCurrencyAndExrateTable(newValue == null ? null : (Long)((DynamicObject)newValue).getPkValue());
    }

    private void changeBizOperatorGroup(DynamicObject bizGrp) {
        if (bizGrp == null) {
            this.getModel().setValue("bizoperator", null);
            return;
        }
    }

    private void changeBizOperator(DynamicObject bizOperator) {
        if (bizOperator != null) {
            bizOperator = BusinessDataServiceHelper.loadSingleFromCache((Object)bizOperator.getPkValue(), (String)"bd_operator");
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", bizOperator.get("operatorgrpid"));
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            DynamicObject bizOrg = (DynamicObject)this.getModel().getValue("bizorg");
            if (bizOrg == null) {
                return;
            }
            List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)((Long)bizOrg.getPkValue()), (boolean)true);
            if (deptids != null && deptids.size() > 0) {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    for (Long deptId : userdeptIds) {
                        if (!deptids.contains(deptId)) continue;
                        this.getModel().beginInit();
                        this.getModel().setValue("bizdept", (Object)deptId);
                        this.getModel().endInit();
                        this.getView().updateView("bizdept");
                        break;
                    }
                }
            } else {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)bizOperator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    this.getModel().beginInit();
                    this.getModel().setValue("bizdept", userdeptIds.get(0));
                    this.getModel().endInit();
                    this.getView().updateView("bizdept");
                }
            }
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("bizoperatorgroup", null);
            this.getModel().setValue("bizdept", null);
            this.getModel().endInit();
            this.getView().updateView("bizoperatorgroup");
            this.getView().updateView("bizdept");
        }
    }

    private void initCurrencyAndExrateTable(Long orgId) {
        IDataModel model = this.getModel();
        if (orgId == null) {
            model.setValue("currency", null);
            model.setValue("exratetable", null);
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (map == null) {
            model.setValue("currency", null);
            model.setValue("exratetable", null);
            return;
        }
        model.setValue("currency", map.get("baseCurrencyID"));
        Object exratetableId = map.get("exchangeRateTableID");
        model.setValue("exratetable", exratetableId);
    }

    @Override
    protected void initNewDataEntry(IFormView view, int rowIndex) {
        super.initNewDataEntry(view, rowIndex);
        IDataModel bill = this.getModel();
        DynamicObject bizOrg = (DynamicObject)bill.getValue("bizorg");
        if (bizOrg != null) {
            this.setDefaltCustomerInfo(rowIndex);
        }
    }

    private void setDefaltCustomerInfo(int rowIndex) {
        DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
        if (customer == null) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        if (customer.getDynamicObject("delivercustomerid") == null || customer.getLong("id") == customer.getDynamicObject("delivercustomerid").getLong("id")) {
            this.getModel().setValue("reccustomer", (Object)customer, rowIndex);
            this.getModel().setValue("reclinkman", (Object)CustomerHelper.getLinkman((DynamicObject)customer), rowIndex);
            this.getModel().setValue("receiveaddress", (Object)CustomerHelper.getValidDefaultMultilingualAddress((DynamicObject)customer), rowIndex);
        } else {
            this.getModel().setValue("reccustomer", (Object)customer.getDynamicObject("delivercustomerid"), rowIndex);
            DynamicObject recCustomer = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getDynamicObject("delivercustomerid").getLong("id"), (String)"bd_customer", (String)String.join((CharSequence)",", CustomerConst.getSelectorList()));
            this.getModel().setValue("reclinkman", (Object)CustomerHelper.getLinkman((DynamicObject)recCustomer), rowIndex);
            this.getModel().setValue("receiveaddress", (Object)CustomerHelper.getValidDefaultMultilingualAddress((DynamicObject)recCustomer), rowIndex);
        }
        if (customer.getDynamicObject("paymentcustomerid") == null) {
            this.getModel().setValue("payingcustomer", (Object)customer, rowIndex);
        } else {
            this.getModel().setValue("payingcustomer", (Object)customer.getDynamicObject("paymentcustomerid"), rowIndex);
        }
        if (customer.getDynamicObject("invoicecustomerid") == null) {
            this.getModel().setValue("settlecustomer", (Object)customer, rowIndex);
        } else {
            this.getModel().setValue("settlecustomer", (Object)customer.getDynamicObject("invoicecustomerid"), rowIndex);
        }
        this.getModel().endInit();
        BillViewHelper.updateViewField((IFormView)this.getView(), (int)rowIndex, (String)"billentry", (String[])new String[]{"payingcustomer", "settlecustomer", "reclinkman", "receiveaddress", "reccustomer"});
    }

    private void handleInWarehouseVisible() {
        this.getView().setVisible(Boolean.valueOf(this.isInUpdate()), new String[]{"inwarehouse", "inlocation"});
    }

    private boolean isInUpdate() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (scheme == null) {
            return false;
        }
        DynamicObject invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        if (invScheme == null) {
            return false;
        }
        return invScheme.getBoolean("isinupdate");
    }

    private void setDefaltOwnerAndKeeper(int rowIndex) {
        InvSchemeHelper.setDefalutOwnerAndKeeeper((InvSchemeService)this.getInvSchemeService(), (IFormView)this.getView(), (int)rowIndex);
    }

    private void initInWarehouse() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        ImBillEditHelper helper = new ImBillEditHelper(this.getView());
        for (int i = 0; i < entryRowCount; ++i) {
            helper.updateEnableLocation("inlocation", (DynamicObject)this.getModel().getValue("inwarehouse", i), i);
        }
    }

    private void changeEntrySettleOrg(Object newValue, int rowIndex) {
        String outOwnerType = String.valueOf(this.getModel().getValue("outownertype", rowIndex));
        Object outOwner = this.getModel().getValue("outowner", rowIndex);
    }

    private void changeOutOwnerType(Object newValue, int rowIndex) {
        Object settleOrg = this.getModel().getValue("entrysettleorg", rowIndex);
        Object outOwner = this.getModel().getValue("outowner", rowIndex);
    }

    private void changeOutOwenr(int rowIndex) {
        String outOwnerType = (String)this.getModel().getValue("outownertype", rowIndex);
        String ownerType = (String)this.getModel().getValue("ownertype", rowIndex);
        DynamicObject outowner = (DynamicObject)this.getModel().getValue("outowner", rowIndex);
        if ("bos_org".equals(ownerType) && "bos_org".equals(outOwnerType)) {
            Object outownerId = null;
            if (outowner != null) {
                outownerId = outowner.getPkValue();
            }
            this.setValue("owner", outownerId, rowIndex, false);
        }
    }

    private void changePriceAndTax(Object oldValue, Object newValue, int rowIndex) {
        BigDecimal discountRate;
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("priceandtax", rowIndex);
        this.setByIspresent(newValue, (Boolean)model.getValue("ispresent", rowIndex), rowIndex);
        if (price != null && price.compareTo(BigDecimal.ZERO) < 0) {
            this.setValue("priceandtax", oldValue, rowIndex, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"SaleOutBillPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String discountType = (String)this.getModel().getValue("discounttype", rowIndex);
        if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && null != (discountRate = (BigDecimal)this.getModel().getValue("discountrate", rowIndex)) && discountRate != null && price != null && price.compareTo(discountRate) < 0) {
            this.setValue("priceandtax", oldValue, rowIndex, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u5355\u4f4d\u6298\u6263\u989d\u3002", (String)"SaleOutBillPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void changePrice(Object oldValue, Object newValue, int rowIndex) {
        BigDecimal discountRate;
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        this.setByIspresent(newValue, (Boolean)model.getValue("ispresent", rowIndex), rowIndex);
        if (price != null && price.compareTo(BigDecimal.ZERO) < 0) {
            this.setValue("price", oldValue, rowIndex, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"SaleOutBillPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String discountType = (String)this.getModel().getValue("discounttype", rowIndex);
        if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && null != (discountRate = (BigDecimal)this.getModel().getValue("discountrate", rowIndex)) && discountRate != null && price != null && price.compareTo(discountRate) < 0) {
            this.setValue("price", oldValue, rowIndex, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u5355\u4f4d\u6298\u6263\u989d\u3002", (String)"SaleOutBillPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    protected void changeActualPrice(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal actualPrice = (BigDecimal)newValue;
        if (price != null && actualPrice != null && actualPrice.compareTo(BigDecimal.ZERO) < 0) {
            model.setValue("actualprice", oldValue, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"SaleOutBillPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setDefaultDiscountType(rowIndex);
    }

    protected void changeActualTaxPrice(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal price = (BigDecimal)model.getValue("priceandtax", rowIndex);
        BigDecimal actualPrice = (BigDecimal)newValue;
        if (price != null && actualPrice != null && price.compareTo(actualPrice) < 0) {
            this.setValue("actualtaxprice", oldValue, rowIndex, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"SaleOutBillPlugin_13", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        if (price != null && actualPrice != null && actualPrice.compareTo(BigDecimal.ZERO) < 0) {
            this.setValue("actualprice", oldValue, rowIndex, false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"SaleOutBillPlugin_8", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setDefaultDiscountType(rowIndex);
    }

    private void setDefaultDiscountType(int i) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String discountType = (String)model.getValue("discounttype", i);
        if (StringUtils.isEmpty((CharSequence)discountType) || DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            model.beginInit();
            model.setValue("discounttype", (Object)DiscountTypeEnum.UNITDIS.getValue(), i);
            model.endInit();
            BillViewHelper.updateViewField((IFormView)this.getView(), (int)i, (String)"discounttype", (String[])new String[0]);
            view.setEnable(Boolean.TRUE, i, new String[]{"discountrate"});
            view.setEnable(Boolean.TRUE, i, new String[]{"discountamount"});
        }
    }

    @Override
    protected void setHeadEnable() {
        super.setHeadEnable();
        IFormView view = this.getView();
        DynamicObject bill = this.getBill();
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        view.setEnable(Boolean.valueOf(currency == null || settleCurrency == null || !currency.getPkValue().equals(settleCurrency.getPkValue())), new String[]{"exchangerate"});
    }

    @Override
    protected void setBillEntryEnable(RowDataEntity entry) {
        DynamicObject warehouse;
        super.setBillEntryEnable(entry);
        DynamicObject bill = this.getBill();
        IFormView view = this.getView();
        int index = entry.getRowIndex();
        boolean isTax = bill.getBoolean("istax");
        boolean inputAmount = bill.getBoolean("inputamount");
        this.initPriceField(isTax, inputAmount, index);
        String discountType = (String)this.getModel().getValue("discounttype", index);
        if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            view.setEnable(Boolean.FALSE, index, new String[]{"discountrate"});
            view.setEnable(Boolean.FALSE, index, new String[]{"discountamount"});
        }
        if ((warehouse = entry.getDataEntity().getDynamicObject("inwarehouse")) != null) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            view.setEnable(Boolean.valueOf(isopenlocation), index, new String[]{"inlocation"});
        } else {
            view.setEnable(Boolean.FALSE, index, new String[]{"inlocation"});
        }
    }

    protected void taxrateSelect(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        IDataModel dataModel = this.getModel();
        Object bizTime = dataModel.getValue("biztime");
        if (bizTime == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_BIZTIME()));
            e.setCancel(true);
            return;
        }
        QFilter f = new QFilter("activedate", "<=", bizTime);
        QFilter fExpdate = new QFilter("expdate", ">=", bizTime);
        fExpdate.or(new QFilter("expdate", "is null", null));
        f.and(fExpdate);
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleInWarehouseVisible();
        this.initInWarehouse();
        DynamicObject bill = this.getModel().getDataEntity(true);
        boolean fromDatabase = bill.getDataEntityState().getFromDatabase();
        if (!fromDatabase && this.isDrawByBOTP()) {
            this.setLifeDateByLotNumber();
        }
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        boolean enableKitSale = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"KIT0001");
        this.getView().setVisible(Boolean.valueOf(enableKitSale), new String[]{"kitproducttype", "kitproduct", "kittransfermodel", "pricemodel", "kitpid"});
        this.setClientViewScale();
    }

    private void setLifeDateByLotNumber() {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("billentry");
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        HashSet<Object> orgIds = new HashSet<Object>(1);
        HashSet<Object> materialIds = new HashSet<Object>(entryRowCount);
        HashSet<String> lotNumbers = new HashSet<String>(entryRowCount);
        orgIds.add(org.getPkValue());
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject material = (DynamicObject)model.getValue("material", i);
            String lotNumer = (String)model.getValue("lotnumber", i);
            if (StringUtils.isNotEmpty((CharSequence)lotNumer)) {
                lotNumbers.add(lotNumer);
            }
            if (material == null) continue;
            materialIds.add(material.getPkValue());
        }
        if (lotNumbers.isEmpty()) {
            return;
        }
        Map lotIntrackMap = ImLotHelper.getLotIntrackMap(orgIds, materialIds, lotNumbers);
        for (int i = 0; i < entryRowCount; ++i) {
            String key;
            DynamicObject lotinTrack;
            Date produceDate = (Date)model.getValue("producedate", i);
            Date expiryDate = (Date)model.getValue("expirydate", i);
            if (produceDate != null || expiryDate != null) continue;
            DynamicObject material = (DynamicObject)model.getValue("material", i);
            String lotNumer = (String)model.getValue("lotnumber", i);
            if (material == null || !material.getBoolean("enableshelflifemgr") || (lotinTrack = (DynamicObject)lotIntrackMap.get(key = org.getPkValue() + "_" + material.getPkValue() + "_" + lotNumer)) == null) continue;
            produceDate = lotinTrack.getDate("producedate");
            expiryDate = lotinTrack.getDate("expirydate");
            this.setValue("producedate", produceDate, i, false);
            this.setValue("expirydate", expiryDate, i, false);
        }
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel bill = this.getModel();
        BillModel billModel = (BillModel)bill;
        boolean isFromWebApi = billModel.isFromWebApi();
        if (!isFromWebApi) {
            return;
        }
        Map sourceData = e.getSourceData();
        Object entryObj = sourceData.get("billentry");
        if (entryObj instanceof JSONArray) {
            return;
        }
        bill.setValue("billcretype", (Object)"3");
        DynamicObjectCollection billEntry = (DynamicObjectCollection)bill.getValue("billentry");
        for (DynamicObject entry : billEntry) {
            DynamicObject taxRateID = entry.getDynamicObject("taxrateid");
            if (taxRateID == null) {
                entry.set("taxrate", (Object)0);
                continue;
            }
            entry.set("taxrate", taxRateID.get("taxrate"));
        }
    }

    private void changeInputAmount(boolean inputAmount) {
        IDataModel model = this.getModel();
        boolean isTax = (Boolean)model.getValue("istax");
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.initPriceField(isTax, inputAmount, i);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        super.beforeFieldPostBack(e);
        switch (key = e.getKey()) {
            case "price": 
            case "priceandtax": 
            case "actualprice": 
            case "actualtaxprice": 
            case "amount": 
            case "taxamount": 
            case "discountrate": 
            case "amountandtax": {
                this.checkSettleCurrencyNotNull(e);
                break;
            }
        }
    }
}

