/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.setup;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.ArrayUtils;

public class DefaultWarehouseEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"org", "materialnumber", "materialgrpnumber", "defaultwarehouse", "defaultlocation"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (fieldKey) {
            case "materialnumber": {
                this.beforeF7WithMateriel(evt, showParameter);
                break;
            }
            case "defaultwarehouse": {
                this.beforeF7WithWarehouse(evt, showParameter);
                break;
            }
            case "defaultlocation": {
                this.beforeF7WithLocation(evt, showParameter);
                break;
            }
        }
    }

    private void beforeF7WithWarehouse(BeforeF7SelectEvent evt, ListShowParameter showParameter) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG(), (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Set<Long> whIds = this.queryWarehouseIds(new Long[]{(Long)org.getPkValue()});
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", whIds));
    }

    private void beforeF7WithLocation(BeforeF7SelectEvent evt, ListShowParameter showParameter) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("defaultwarehouse");
        if (null == warehouse) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_WAREHOUSE(), (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            QFilter locationQFilter = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
            showParameter.getListFilterParameter().setFilter(locationQFilter);
        }
    }

    private List<Long> getLocationIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add((Long)location.getPkValue());
        }
        return ids;
    }

    private Set<Long> queryWarehouseIds(Long[] orgIds) {
        QFilter orgf = new QFilter("org", "in", (Object)orgIds);
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        DynamicObjectCollection warehouseCollection = QueryServiceHelper.query((String)"im_warehousesetup", (String)"warehouse.id as whid", (QFilter[])orgf.toArray());
        return warehouseCollection.stream().map(item -> item.getLong("whid")).collect(Collectors.toSet());
    }

    private void beforeF7WithMateriel(BeforeF7SelectEvent evt, ListShowParameter showParameter) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter qFilter = null;
        if (null != org) {
            qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)Long.valueOf(org.getPkValue().toString()));
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (propName = e.getProperty().getName()) {
            case "org": {
                this.propChangeClearer("materialnumber", "materialgrpnumber", "defaultwarehouse", "defaultlocation");
                break;
            }
            case "materialnumber": {
                this.propChangeClearer("materialgrpnumber", "defaultwarehouse", "defaultlocation");
                break;
            }
            case "materialgrpnumber": {
                this.propChangeClearer("materialnumber", "defaultwarehouse", "defaultlocation");
                break;
            }
            case "defaultwarehouse": {
                this.propChangeClearer("defaultlocation");
                break;
            }
        }
    }

    private void propChangeClearer(String ... props) {
        if (ArrayUtils.isEmpty((Object[])props)) {
            return;
        }
        for (String prop : props) {
            this.getModel().setValue(prop, null);
        }
    }
}

