/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.setup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.utils.FormUtils;

public class WarehouseSetupMaterialRelListPlugin
extends AbstractListPlugin {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String key = args.getFieldName();
        if ("warehousesetup.org.id".equalsIgnoreCase(key)) {
            this.initOrg(args);
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] dataList = e.getQueryValues();
        HashSet<Object> entryIdList = new HashSet<Object>(16);
        for (DynamicObject data : dataList) {
            Object pkValue = data.getPkValue();
            entryIdList.add(pkValue);
        }
        QFilter qFilter = new QFilter("materialentity.id", "in", entryIdList);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"im_warehousesetup", (String)"org, warehouse, materialentity.id", (QFilter[])qFilter.toArray());
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject bill : load) {
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("materialentity");
            for (DynamicObject entry : entryEntity) {
                long id = entry.getLong("id");
                entryMap.put(id, bill);
            }
        }
        if (entryMap.isEmpty()) {
            return;
        }
        for (DynamicObject data : dataList) {
            Object pkValue = data.getPkValue();
            DynamicObject row = (DynamicObject)entryMap.get(pkValue);
            DynamicObject org = row.getDynamicObject("org");
            DynamicObject warehouse = row.getDynamicObject("warehouse");
            data.set("org", (Object)org);
            data.set("warehouse", (Object)warehouse);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        switch (opKey = FormUtils.getOpKey((BeforeDoOperationEventArgs)args)) {
            case "new": {
                this.buildSelectOrgFilter();
                break;
            }
        }
    }

    private Object[] getPermissionOrgIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        Object[] ids = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)"im_warehousesetupmate_rel", (String)appId);
        return ids;
    }

    private Long getFirstOrgId() {
        Object[] ids = this.getPermissionOrgIds();
        if (ids != null && ids.length > 0) {
            return (Long)ids[0];
        }
        return null;
    }

    private void buildSelectOrgFilter() {
        IListView listView = (IListView)this.getView();
        List controlFilters = (List)listView.getControlFilters().getFiltersListMap().get("warehousesetup.org.id");
        ArrayList<Long> mainOrgList = new ArrayList<Long>(4);
        if (controlFilters != null && controlFilters.size() > 0) {
            ControlFilter controlFilter = (ControlFilter)controlFilters.get(0);
            List value = controlFilter.getValue();
            if (value != null) {
                if ((value.size() == 1 || value.size() > 1) && StringUtils.isNotEmpty((String)value.get(0).toString())) {
                    mainOrgList.add(Long.parseLong(value.get(0).toString()));
                } else if (value.size() == 1 && StringUtils.isEmpty((String)value.get(0).toString())) {
                    Long firstOrgId = this.getFirstOrgId();
                    mainOrgList.add(firstOrgId);
                }
            }
        } else {
            Long firstOrgId = this.getFirstOrgId();
            mainOrgList.add(firstOrgId);
        }
        listView.setSelectedMainOrgIds(mainOrgList);
    }

    private void initOrg(BeforeFilterF7SelectEvent args) {
        QFilter qFilter = this.getPermissionOrgFilter();
        args.addCustomQFilter(qFilter);
    }

    private QFilter getPermissionOrgFilter() {
        Object[] ids = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)"im_warehousesetupmate_rel", (String)this.getView().getFormShowParameter().getAppId());
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return qFilter;
    }
}

