/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.setup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class WarehouseSetupPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final String EVENT_CUSTOM_SHOWMATERIALINVINFO = "ShowMaterialInvInfo";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initMaterialNumber();
        this.initOperator();
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"warehouse", "operatoruser", "materialgrpnumber", "materialnumber"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("materialentity");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection mCol = this.getModel().getEntryEntity("materialentity");
        if (!CommonUtils.isNull((Object)mCol)) {
            this.setMaterialEnabel(mCol);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)"isallowpartialneginv") && StringUtils.equals((CharSequence)e.getEventName(), (CharSequence)EVENT_CUSTOM_SHOWMATERIALINVINFO)) {
            List appIds = AppMetadataCache.getAppMenusInfoByAppId((String)"basedata");
            for (AppMenuInfo appId : appIds) {
                String formId = appId.getFormId();
                if (!"bd_materialinventoryinfo".equals(formId)) continue;
                String id = appId.getId();
                OpenPageUtils.openMenu((IFormView)this.getView(), (String)id, (String)"0efa1992000000ac");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (!CommonUtils.isNull((Object)newValue) && newValue.equals(oldValue)) {
            return;
        }
        int entryIndex = changeSet[0].getRowIndex();
        String key = e.getProperty().getName();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("materialentity");
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "materialgrpnumber": {
                this.getView().setEnable(Boolean.FALSE, entryIndex, new String[]{"materialnumber"});
                this.setMaterialEnabel(entryEntity);
                break;
            }
            case "materialnumber": {
                this.getView().setEnable(Boolean.FALSE, entryIndex, new String[]{"materialgrpnumber"});
                this.setMaterialEnabel(entryEntity);
                break;
            }
            case "warehouse": {
                DynamicObjectCollection operaEntity = this.getModel().getEntryEntity("operatorentity");
                DynamicObjectCollection materEntity = this.getModel().getEntryEntity("materialentity");
                if ((CommonUtils.isNull((Object)operaEntity) || operaEntity.size() == 0) && (CommonUtils.isNull((Object)materEntity) || materEntity.size() == 0)) break;
                if (!CommonUtils.isNull((Object)oldValue)) {
                    String warehouseId = String.valueOf(((DynamicObject)oldValue).getPkValue());
                    this.getPageCache().put("warehouseId", warehouseId);
                    ConfirmCallBackListener cb = new ConfirmCallBackListener(key, (IFormPlugin)this);
                    this.getView().showConfirm(new InvBillErrorCode().getCONFIRM_HEADWAREHOUSE().getMessage(), MessageBoxOptions.OKCancel, cb);
                    break;
                }
                return;
            }
            case "isallowallneginv": {
                if (!((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("isallowpartialneginv", (Object)Boolean.FALSE);
                break;
            }
            case "isallowpartialneginv": {
                if (!((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("isallowallneginv", (Object)Boolean.FALSE);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = FormUtils.getOpKey((BeforeDoOperationEventArgs)args)) {
            case "materialdeleteentry": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("materialentity");
                this.setMaterialEnabel(entryEntity);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "warehouse": {
                if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.getModel().deleteEntryData("operatorentity");
                    this.getModel().deleteEntryData("materialentity");
                    this.getModel().createNewEntryRow("operatorentity");
                    this.getModel().createNewEntryRow("materialentity");
                    break;
                }
                String invWh = this.getPageCache().get("warehouseId");
                Long warehouseId = invWh == null ? null : Long.valueOf(invWh);
                this.getModel().beginInit();
                this.getModel().setValue("warehouse", (Object)warehouseId);
                this.getModel().endInit();
                this.getView().updateView("warehouse");
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        for (RowDataEntity entity : entities) {
            DynamicObject entry = entity.getDataEntity();
            int rowIndex = entity.getRowIndex();
            DynamicObject materialNum = entry.getDynamicObject("materialnumber");
            DynamicObject materialGrpNum = entry.getDynamicObject("materialgrpnumber");
            if (null == materialGrpNum && null != materialNum) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialgrpnumber"});
                continue;
            }
            if (null == materialGrpNum || null != materialNum) continue;
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialnumber"});
        }
    }

    private void initOperator() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("operatoruser");
        orgF7.addBeforeF7SelectListener(listener -> {
            ListShowParameter showParameter = (ListShowParameter)listener.getFormShowParameter();
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                showParameter.getListFilterParameter().setFilter(new QFilter("1", "=", (Object)2));
                return;
            }
            long userId = UserServiceHelper.getCurrentUserId();
            String formId = this.getModel().getDataEntityType().getName();
            Map customParas = this.getView().getFormShowParameter().getCustomParams();
            if (customParas != null && customParas.get("sourceformid") != null && customParas.get("orgViewType") != null) {
                formId = (String)customParas.get("sourceformid");
            }
            QFilter qFilter1 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            QFilter qFilter2 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg((Long)org.getPkValue()));
            QFilter qFilter3 = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2, qFilter3));
        });
    }

    private ArrayList<Long> getOperatorGroupByOrg(long orgId) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
        qFilter2.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (map == null || map.isEmpty()) {
            return operatorGroupList;
        }
        ArrayList list = new ArrayList(map.values());
        for (int i = 0; i < list.size(); ++i) {
            operatorGroupList.add((Long)((DynamicObject)list.get(i)).getPkValue());
        }
        return operatorGroupList;
    }

    private void initMaterialNumber() {
        BasedataEdit numberF7 = (BasedataEdit)this.getControl("materialnumber");
        numberF7.addBeforeF7SelectListener(listener -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            QFilter qFilter = null;
            if (!CommonUtils.isNull((Object)org)) {
                qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)Long.valueOf(org.getPkValue().toString()));
            }
            ListShowParameter showParameter = (ListShowParameter)listener.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void setMaterialEnabel(DynamicObjectCollection mCol) {
        DynamicObject materialNum = null;
        DynamicObject materialGrpNum = null;
        for (int i = 0; i < mCol.size(); ++i) {
            materialNum = ((DynamicObject)mCol.get(i)).getDynamicObject("materialnumber");
            materialGrpNum = ((DynamicObject)mCol.get(i)).getDynamicObject("materialgrpnumber");
            if (null == materialGrpNum && null != materialNum) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"materialgrpnumber"});
                continue;
            }
            if (null == materialGrpNum || null != materialNum) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"materialnumber"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InvOperatorMatPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }
}

