/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.MetadataServiceHelper;

public class InvMaterialMasteridUpdTask
extends AbstractTask {
    private static final String[] billEntryTableNames = new String[]{"t_im_purrecbillentry", "t_im_purinbillentry", "t_im_otherinbillentry", "t_im_productinbillentry", "t_im_ospurinbillentry", "t_im_saloutbillentry", "t_im_otheroutbillentry", "t_im_mreqbillentry", "t_im_mreqoutbillentry", "t_im_osmreqoutbillentry", "t_im_transapplyentry", "t_im_transdirbillentry", "t_im_transinbillentry", "t_im_transoutbillentry", "t_im_locationtransentry", "t_im_adjustbillentry", "t_im_adjustbillsubentry", "t_im_assembbillentry", "t_im_assembbillsubentry", "t_im_disassembleentry", "t_im_disassemblesubentry", "t_im_initbillentry", "t_im_invinspectbillentry"};
    private Map<Long, Long> matInfoIdByMatIdMap = new HashMap<Long, Long>(16);

    public void execute(RequestContext context, Map<String, Object> jobparam) throws KDException {
        String formId = (String)jobparam.get("formId");
        DBRoute scmRoute = new DBRoute("scm");
        DBRoute sysRoute = new DBRoute("sys");
        String algoKey = ((Object)((Object)this)).getClass().getName();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String[] formIdSpilt;
            for (String split : formIdSpilt = formId.replaceAll("\\n", " ").split(" ")) {
                SubEntryProp subProp;
                if (StringUtils.isBlank((CharSequence)split)) continue;
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)split);
                EntryProp eProp = (EntryProp)dataEntityType.findProperty("billentry");
                if (eProp != null) {
                    String alias = eProp.getDynamicCollectionItemPropertyType().getAlias();
                    this.updMaterialMasteridByBill(scmRoute, sysRoute, algoKey, alias);
                }
                if ((subProp = (SubEntryProp)dataEntityType.findProperty("afterentry")) == null) continue;
                String alias = subProp.getDynamicCollectionItemPropertyType().getAlias();
                this.updMaterialMasteridByBill(scmRoute, sysRoute, algoKey, alias);
            }
        } else {
            for (String billEntryTableName : billEntryTableNames) {
                this.updMaterialMasteridByBill(scmRoute, sysRoute, algoKey, billEntryTableName);
            }
        }
    }

    private void updMaterialMasteridByBill(DBRoute scmRoute, DBRoute sysRoute, String algoKey, String billEntryTableName) {
        StringBuilder billSelSqlSb = new StringBuilder("select fentryid,fmaterialid from ");
        billSelSqlSb.append(billEntryTableName).append(" where  fmaterialmasterid = 0 and fmaterialid > 0 ");
        StringBuilder billUpdSqlSb = new StringBuilder("update ");
        billUpdSqlSb.append(billEntryTableName).append(" set fmaterialmasterid = ? where fentryid = ?");
        String billUpdSql = billUpdSqlSb.toString();
        HashSet<Long> matInfoIds = new HashSet<Long>(16);
        HashMap<Long, List<Long>> matIdByEId = new HashMap<Long, List<Long>>();
        ArrayList<Object[]> matParams = new ArrayList<Object[]>(16);
        try (TXHandle tx = TX.requiresNew((String)((Object)((Object)this)).getClass().getName());){
            DataSet billEntryDatas = DB.queryDataSet((String)algoKey, (DBRoute)scmRoute, (String)billSelSqlSb.toString());
            for (Row row : billEntryDatas) {
                Long matInfoId = row.getLong("fmaterialid");
                Long entryId = row.getLong("fentryid");
                Long matId = this.matInfoIdByMatIdMap.get(matInfoId);
                if (matId != null) {
                    matParams.add(new Object[]{matId, entryId});
                    if (matParams.size() < 1000) continue;
                    DB.executeBatch((DBRoute)scmRoute, (String)billUpdSql, matParams);
                    tx.commit();
                    matParams.clear();
                    continue;
                }
                ArrayList<Long> entryIds = (ArrayList<Long>)matIdByEId.get(matInfoId);
                if (entryIds == null) {
                    entryIds = new ArrayList<Long>(16);
                    matIdByEId.put(matInfoId, entryIds);
                }
                entryIds.add(entryId);
                matInfoIds.add(matInfoId);
                if (matInfoIds.size() < 1000) continue;
                this.updBillEntryMatId(scmRoute, sysRoute, algoKey, billUpdSql, matInfoIds, matIdByEId);
                tx.commit();
                matInfoIds.clear();
                matIdByEId.clear();
            }
            if (!matParams.isEmpty()) {
                DB.executeBatch((DBRoute)scmRoute, (String)billUpdSql, matParams);
                tx.commit();
            }
            if (!matInfoIds.isEmpty()) {
                this.updBillEntryMatId(scmRoute, sysRoute, algoKey, billUpdSql, matInfoIds, matIdByEId);
                tx.commit();
            }
        }
    }

    private void updBillEntryMatId(DBRoute scmRoute, DBRoute sysRoute, String algoKey, String billUpdSql, Set<Long> matInfoIds, Map<Long, List<Long>> matIdByEId) {
        StringBuilder selectMatSqlSb = new StringBuilder("select fid,fmasterid from t_bd_materialinvinfo where fid in ");
        selectMatSqlSb.append("(");
        int i = 0;
        for (Long matInvInfoId : matInfoIds) {
            if (i > 0) {
                selectMatSqlSb.append(",");
            }
            selectMatSqlSb.append(matInvInfoId);
            ++i;
        }
        selectMatSqlSb.append(")");
        DataSet matInfoDatas = DB.queryDataSet((String)algoKey, (DBRoute)sysRoute, (String)selectMatSqlSb.toString());
        ArrayList<Object[]> nMatParams = new ArrayList<Object[]>(16);
        for (Row next : matInfoDatas) {
            Long masterid = next.getLong("fmasterid");
            Long pkId = next.getLong("fid");
            List<Long> entryIds = matIdByEId.get(pkId);
            this.matInfoIdByMatIdMap.put(pkId, masterid);
            if (entryIds == null || entryIds.isEmpty()) continue;
            for (Long entryId : entryIds) {
                nMatParams.add(new Object[]{masterid, entryId});
            }
        }
        if (!nMatParams.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)billUpdSql, nMatParams);
        }
    }
}

