/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.tpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.ErrorCode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OperatorGroupHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.MaterialNameProvider;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class BillTplListPlugin
extends AbstractListPlugin {
    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        String formId = billList.getEntityType().getName();
        if ("im_initbill".equals(formId) || billList.getEntryState().isSelectAllRows()) {
            return;
        }
        MaterialNameProvider.setMaterialName(e.getPageData());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Long mainOrgId;
        DynamicObject mainOrg;
        List selectedMainOrgIds;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        if ("tblcopy".equals(itemKey) && pks.length == 1) {
            String entityName = billList.getEntityType().getName();
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pks[0], (String)entityName, (String)"ischargeoff");
            boolean isCaBill = bill.getBoolean("ischargeoff");
            if (isCaBill) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5355\u636e\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"ImBillEditPlugin_33", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if ("tblnew".equals(itemKey) && (selectedMainOrgIds = this.getSelectedMainOrgIds()) != null && selectedMainOrgIds.size() == 1 && !(mainOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(mainOrgId = (Long)selectedMainOrgIds.get(0)))})).getBoolean("enable")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\uff0c\u8bf7\u542f\u7528\u540e\u518d\u64cd\u4f5c\u3002", (String)"ImBillListPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            protected boolean isOnlyPK4SelectedAllRows() {
                return true;
            }
        });
        super.beforeCreateListDataProvider(args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        BillList billList = (BillList)this.getControl("billlistap");
        String formId = billList.getEntityType().getName();
        List permissionOrgs = NewInvOrgHelper.getPermissionOrgsByAppId((String)formId, (String)this.getView().getFormShowParameter().getAppId());
        if (permissionOrgs == null || permissionOrgs.isEmpty()) {
            this.getView().showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_USE_INVORG()));
            return;
        }
        List orgItem = NewInvOrgHelper.getHasPermissionAndStartedInvOrgFilterColumns((List)permissionOrgs);
        if (orgItem == null || orgItem.isEmpty()) {
            this.getView().showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ENABLED_INV()));
        } else {
            for (FilterColumn filterColumn : filterColumns) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("org.name".equals(fieldName) || "outorg.name".equals(fieldName)) {
                    List listcomitem = commonFilterColumn.getComboItems();
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(orgItem);
                    if (!((ListShowParameter)this.getView().getFormShowParameter()).getLinkQueryPkIdCollection().isEmpty()) {
                        commonFilterColumn.setDefaultValue(null);
                    } else if (!CommonUtils.isNull((Object)orgItem)) {
                        commonFilterColumn.setDefaultValue(((ComboItem)orgItem.get(0)).getValue());
                    }
                } else if (this.isFilterCloseAcctBizTime(commonFilterColumn.getFieldName())) {
                    commonFilterColumn.setDefaultValue(null);
                }
                if ((!"im_transdirbill".equals(formId) || !"org.name".equals(fieldName)) && (!"im_transinbill".equals(formId) || !"outorg.name".equals(fieldName))) continue;
                commonFilterColumn.setDefaultValue(null);
            }
        }
    }

    protected boolean isFilterCloseAcctBizTime(String fieldName) {
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        return parentFormId != null && fieldName != null && parentFormId.equals("im_closeaccount") && fieldName.equals("biztime");
    }

    public void setFilter(SetFilterEvent e) {
        IFormView parentView;
        super.setFilter(e);
        BillList billList = (BillList)this.getControl("billlistap");
        String entityName = billList.getEntityType().getName();
        if ("im_transoutbill".equals(entityName) && (parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())) != null && (parentView = parentView.getViewNoPlugin(parentView.getFormShowParameter().getParentPageId())) != null && parentView.getPageCache() != null && "true".equals(parentView.getPageCache().get("drawfromstepin"))) {
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        OperatorGroupHelper.setOperatorGroupFilter((String)appId, (SetFilterEvent)e, (List)this.getSelectedMainOrgIds(), (String)entityName);
        WareHouseIsolateHelper.setWareHoseFilterByDataCtrl((String)appId, (SetFilterEvent)e, (List)this.getSelectedMainOrgIds(), (String)entityName);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        QFilter qFilter;
        Map tempInvAcc;
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().equals("org.id") && null != (tempInvAcc = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter = new QFilter("startstatus", "=", (Object)"B")})) && !tempInvAcc.isEmpty()) {
            ArrayList<Long> orgDOs = new ArrayList<Long>(tempInvAcc.size());
            for (DynamicObject orgObj : tempInvAcc.values()) {
                orgDOs.add(orgObj.getLong("org.id"));
            }
            QFilter orgIdFilter = new QFilter("id", "in", orgDOs);
            args.addCustomQFilter(orgIdFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = FormUtils.getOpKey((BeforeDoOperationEventArgs)args);
        if ("submit".equals(opKey)) {
            List<Long> list;
            BillList billList = (BillList)this.getControl("billlistap");
            String formId = billList.getEntityType().getName();
            FormOperate operate = (FormOperate)args.getSource();
            if ("im_otherinbill".equals(formId)) {
                list = Arrays.asList(688865344802319360L, 1037687972641726464L);
                operate.getOption().setVariableValue("notcheck_others_biztype", SerializationUtils.toJsonString(list));
                operate.getOption().setVariableValue("notcheck_others_biztypename", "biztype");
            }
            if ("im_otheroutbill".equals(formId)) {
                list = Arrays.asList(688865858117916672L, 1037688326724870144L);
                operate.getOption().setVariableValue("notcheck_others_biztype", SerializationUtils.toJsonString(list));
                operate.getOption().setVariableValue("notcheck_others_biztypename", "biztype");
            }
        }
    }
}

