/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.tpl;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Locale;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.utils.CommonUtils;

public class InvOwnerPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit entryOwner = (BasedataEdit)this.getView().getControl("owner");
        if (entryOwner != null) {
            entryOwner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        switch (fieldKey) {
            case "owner": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                ArrayList array = new ArrayList();
                array = OwnerHelper.getOwners((Long)((Long)org.getPkValue()), (Long)((Long)billType.getPkValue()));
                if (array.size() == 0) break;
                QFilter ownerFilter = new QFilter("id", "in", (Object)array);
                showParameter.getListFilterParameter().setFilter(ownerFilter);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.dealOwner(org, true, 0);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            int rowCount = this.getModel().getEntryRowCount("billentry");
            int curIndex = rowCount - 1;
            this.dealOwner(org, false, curIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        if (!CommonUtils.isNull((Object)newValue) && newValue.equals(oldValue)) {
            return;
        }
        String key = e.getProperty().getName();
        int index = changeSet.getRowIndex();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "ownertype": {
                if (!"bos_org".equals(newValue)) break;
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                this.dealOwner(org, false, index);
                break;
            }
        }
    }

    private void dealOwner(DynamicObject org, boolean isCreateNew, int rowIndex) {
        Long ownerID = 0L;
        if (!CommonUtils.isNull((Object)org)) {
            ownerID = OwnerHelper.getDefaultOwner((Long)((Long)org.getPkValue()));
        }
        if (isCreateNew) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                Object OwnerType = this.getModel().getValue("ownertype", i);
                if (!"bos_org".equals(OwnerType)) continue;
                this.getModel().setValue("owner", (Object)ownerID, rowIndex);
            }
        } else {
            Object OwnerType = this.getModel().getValue("ownertype", rowIndex);
            if ("bos_org".equals(OwnerType)) {
                this.getModel().setValue("owner", (Object)ownerID, rowIndex);
            }
        }
    }
}

