/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.transbill;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import kd.scmc.im.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class TransBillCommonBeforeF7SelectListener
implements BeforeF7SelectListener {
    private IFormView view = null;
    private static final String MASTERID_ENABLEVMI = "masterid.enablevmi";

    public TransBillCommonBeforeF7SelectListener(IFormView view) {
        this.view = view;
    }

    public IDataModel getModel() {
        return this.view.getModel();
    }

    public IFormView getView() {
        return this.view;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "owner": 
            case "transitowner": {
                this.beforeSelectOwner(e);
                break;
            }
            case "inowner": {
                this.beforeSelectInOwner(e);
                break;
            }
            case "outowner": {
                this.beforeSelectOutOwner(e);
                break;
            }
            case "keeper": {
                this.beforeSelectKeeper(e);
                break;
            }
            case "outkeeper": {
                this.beforeSelectOutKeeper(e);
                break;
            }
            case "org": {
                this.beforeSelectOrg(e);
                break;
            }
            case "outorg": {
                this.beforeSelectOutOrg(e);
                break;
            }
            case "inorg": {
                this.beforeSelectInOrg(e);
                break;
            }
            case "warehouse": {
                this.beforeSelectWarehouse(e);
                break;
            }
            case "inwarehouse": {
                this.beforeSelectInWarehouse(e);
                break;
            }
            case "outwarehouse": {
                this.beforeSelectOutWarehouse(e);
                break;
            }
            case "location": {
                this.beforeSelectLocation(e);
                break;
            }
            case "inlocation": {
                this.beforeSelectInLocation(e);
                break;
            }
            case "outlocation": {
                this.beforeSelectOutlocation(e);
                break;
            }
            case "unit": {
                this.beforeSelectUnit(e);
                break;
            }
            case "material": {
                this.beforeSelectMaterial(e);
                break;
            }
            case "lot": {
                this.beforeSelectLot(e, fieldKey);
                break;
            }
            case "biztype": {
                this.beforeSelectBiztype(e);
                break;
            }
            case "linetype": {
                this.beforeLineType(e, this.getModel().getDataEntityType().getName());
                break;
            }
            case "configuredcode": 
            case "tracknumber": {
                this.beforeTrackNumOrConfigCode(showParameter, e.getRow(), fieldKey);
                break;
            }
        }
    }

    private void beforeTrackNumOrConfigCode(ListShowParameter showParameter, int rowIndex, String field) {
        QFilter qFilter = null;
        if (field.equalsIgnoreCase("configuredcode")) {
            Object value = this.getModel().getValue("material", rowIndex);
            if (value != null) {
                DynamicObject material = (DynamicObject)value;
                qFilter = InvBillHelper.getConfigureCodeFilter((Object)material.get("masterid.id"));
            }
        } else {
            qFilter = InvBillHelper.getTrackNumberFilter();
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void beforeSelectOwner(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        String type = (String)this.getModel().getValue("ownertype", rowIndex);
        DynamicObject org = null;
        String entityId = ((ItemClassEdit)e.getSource()).getView().getEntityId();
        boolean isTransApplyBill = "im_transapply".equals(entityId);
        String billEntryOrg = isTransApplyBill ? "outorg" : "inorg";
        org = MetaDataHelper.isExistField((IDataModel)this.getModel(), (String)billEntryOrg) ? (DynamicObject)this.getModel().getValue(billEntryOrg) : (DynamicObject)this.getModel().getValue("org");
        this.commonOnwerFilter(e, org, type, "owner", billEntryOrg);
    }

    public void beforeSelectInOwner(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        String type = (String)this.getModel().getValue("inownertype", rowIndex);
        DynamicObject org = null;
        org = MetaDataHelper.isExistField((IDataModel)this.getModel(), (String)"inorg") ? (DynamicObject)this.getModel().getValue("inorg") : (DynamicObject)this.getModel().getValue("org");
        this.commonOnwerFilter(e, org, type, "inowner", "inorg");
    }

    public void beforeSelectOutOwner(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        String type = (String)this.getModel().getValue("outownertype", rowIndex);
        DynamicObject org = null;
        org = MetaDataHelper.isExistField((IDataModel)this.getModel(), (String)"outorg") ? (DynamicObject)this.getModel().getValue("outorg") : (DynamicObject)this.getModel().getValue("org");
        this.commonOnwerFilter(e, org, type, "outowner", "outorg");
    }

    public void beforeSelectKeeper(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        String type = (String)this.getModel().getValue("keepertype", rowIndex);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.commonKeeperFilter(e, org, type, "keeper");
    }

    public void beforeSelectInKeeper(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        String type = (String)this.getModel().getValue("inkeepertype", rowIndex);
        DynamicObject org = null;
        org = MetaDataHelper.isExistField((IDataModel)this.getModel(), (String)"inorg") ? (DynamicObject)this.getModel().getValue("inorg") : (DynamicObject)this.getModel().getValue("org");
        this.commonKeeperFilter(e, org, type, "keeper");
    }

    public void beforeSelectOutKeeper(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        String type = (String)this.getModel().getValue("outkeepertype", rowIndex);
        DynamicObject org = null;
        org = MetaDataHelper.isExistField((IDataModel)this.getModel(), (String)"outorg") ? (DynamicObject)this.getModel().getValue("outorg") : (DynamicObject)this.getModel().getValue("org");
        this.commonKeeperFilter(e, org, type, "outkeeper");
    }

    private void commonOnwerFilter(BeforeF7SelectEvent e, DynamicObject org, String type, String owner, String billEntryOrg) {
        if (org == null || StringUtils.isEmpty((CharSequence)type)) {
            IDataEntityProperty orgProp = this.getModel().getDataEntityType().findProperty(billEntryOrg);
            if (orgProp != null) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9{0}\u3002", (String)"IM-W-068466", (String)"scmc-im-business", (Object[])new Object[]{orgProp.getDisplayName()}));
            }
            e.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject bizType = this.getModel().getDataEntity().getDynamicObject("biztype");
        switch (type) {
            case "bos_org": {
                QFilter ownerFilter = null;
                ArrayList<Object> ownerList = this.getOwnerList(org);
                ownerFilter = new QFilter("id", "in", ownerList);
                showParameter.getListFilterParameter().setFilter(ownerFilter);
                break;
            }
            case "bd_supplier": {
                if (bizType == null || !"6".equals(bizType.get("domain"))) break;
                QFilter f = new QFilter("enablevmi", "=", (Object)Boolean.TRUE);
                showParameter.getListFilterParameter().setFilter(f);
                break;
            }
        }
    }

    private List<Object> getTransitOwnerList(String owner, String formId) {
        ArrayList<Object> ownerList = null;
        switch (formId) {
            case "im_transoutbill": {
                if (!"A".equals(this.getModel().getValue("transit")) || !"owner".equals(owner)) break;
                DynamicObject outOrg = (DynamicObject)this.getModel().getValue("org");
                DynamicObject inOrg = (DynamicObject)this.getModel().getValue("inorg");
                ArrayList<Object> outOrgIds = this.getOwnerList(outOrg);
                ownerList = this.getOwnerList(inOrg);
                ownerList.addAll(outOrgIds);
                break;
            }
            case "im_transinbill": {
                if (!"B".equals(this.getModel().getValue("transit")) || !"outowner".equals(owner)) break;
                DynamicObject outOrg = (DynamicObject)this.getModel().getValue("outorg");
                DynamicObject inOrg = (DynamicObject)this.getModel().getValue("org");
                ArrayList<Object> outOrgIds = this.getOwnerList(outOrg);
                ownerList = this.getOwnerList(inOrg);
                ownerList.addAll(outOrgIds);
                break;
            }
        }
        return ownerList;
    }

    private void commonKeeperFilter(BeforeF7SelectEvent e, DynamicObject org, String type, String keeper) {
        if (org == null || StringUtils.isEmpty((CharSequence)type)) {
            e.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String formId = this.getModel().getDataEntityType().getName();
        switch (type) {
            case "bos_org": {
                QFilter orgFilter = this.getFilterByFormId(formId);
                showParameter.getListFilterParameter().setFilter(orgFilter);
                break;
            }
        }
    }

    private QFilter getFilterByFormId(String formId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        if ("im_transoutbill".equals(formId)) {
            DynamicObject outOrg = (DynamicObject)this.getModel().getValue("org");
            DynamicObject inOrg = (DynamicObject)this.getModel().getValue("inorg");
            if (outOrg != null) {
                orgIds.add((Long)outOrg.getPkValue());
            }
            if (inOrg != null && !inOrg.equals(outOrg)) {
                orgIds.add((Long)inOrg.getPkValue());
            }
        } else if ("im_transinbill".equals(formId) || "im_transdirbill".equals(formId)) {
            DynamicObject outOrg = (DynamicObject)this.getModel().getValue("outorg");
            DynamicObject inOrg = (DynamicObject)this.getModel().getValue("org");
            if (outOrg != null) {
                orgIds.add((Long)outOrg.getPkValue());
            }
            if (inOrg != null && !inOrg.equals(outOrg)) {
                orgIds.add((Long)inOrg.getPkValue());
            }
        }
        return new QFilter("id", "in", orgIds);
    }

    public void beforeSelectOrg(BeforeF7SelectEvent e) {
        String formid = this.getModel().getDataEntityType().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formid, (String)this.getView().getFormShowParameter().getAppId());
        QFilter filter = new QFilter("id", "in", (Object)orgIdList);
        showParameter.getListFilterParameter().setFilter(filter);
        showParameter.setCustomParam("orgFuncId", (Object)"05");
    }

    public void beforeSelectOutOrg(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String orgKey = e.getProperty().getName();
        String formid = this.getModel().getDataEntityType().getName();
        String mainOrg = this.getModel().getDataEntityType().getMainOrg();
        QFilter filter = null;
        if (orgKey.equals(mainOrg)) {
            Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formid, (String)this.getView().getFormShowParameter().getAppId());
            filter = new QFilter("id", "in", (Object)orgIdList);
        } else {
            QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
            Map tempInvAccs = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
            ArrayList<Object> orgIds = new ArrayList<Object>(tempInvAccs.size());
            for (DynamicObject tempInvAcc : tempInvAccs.values()) {
                DynamicObject org = tempInvAcc.getDynamicObject("org");
                if (org == null) continue;
                orgIds.add(org.getPkValue());
            }
            if (!orgIds.isEmpty()) {
                filter = new QFilter("id", "in", orgIds);
            }
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            if (filter != null) {
                filter.and("id", "!=", org.getPkValue());
            } else {
                filter = new QFilter("id", "!=", org.getPkValue());
            }
        }
        showParameter.getListFilterParameter().setFilter(filter);
    }

    public void beforeSelectInOrg(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String orgKey = e.getProperty().getName();
        String formid = this.getModel().getDataEntityType().getName();
        String mainOrg = this.getModel().getDataEntityType().getMainOrg();
        QFilter filter = null;
        if (orgKey.equals(mainOrg)) {
            Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formid, (String)this.getView().getFormShowParameter().getAppId());
            filter = new QFilter("id", "in", (Object)orgIdList);
        } else {
            QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
            Map tempInvAccs = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
            ArrayList<Object> orgIds = new ArrayList<Object>(tempInvAccs.size());
            for (DynamicObject tempInvAcc : tempInvAccs.values()) {
                DynamicObject org = tempInvAcc.getDynamicObject("org");
                if (org == null) continue;
                orgIds.add(org.getPkValue());
            }
            if (!orgIds.isEmpty()) {
                filter = new QFilter("id", "in", orgIds);
            }
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            if (filter != null) {
                filter.and("id", "!=", org.getPkValue());
            } else {
                filter = new QFilter("id", "!=", org.getPkValue());
            }
        }
        if (filter != null) {
            showParameter.getListFilterParameter().setFilter(filter);
        }
        showParameter.setCustomParam("orgFuncId", (Object)"05");
    }

    public void beforeSelectWarehouse(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject inOrg = (DynamicObject)model.getValue("org");
        this.commonWareHouseFilter(inOrg, e);
    }

    public void beforeSelectInWarehouse(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject inOrg = (DynamicObject)model.getValue("inorg");
        this.commonWareHouseFilter(inOrg, e);
    }

    public void beforeSelectOutWarehouse(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject outOrg = (DynamicObject)model.getValue("outorg");
        this.commonWareHouseFilter(outOrg, e);
    }

    private void commonWareHouseFilter(DynamicObject org, BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (CommonUtils.isNull((Object)org)) {
            e.setCancel(true);
        } else {
            String formId = this.getModel().getDataEntityType().getName();
            IDataModel bill = this.getModel();
            int rowIdx = bill.getEntryCurrentRowIndex("billentry");
            DynamicObject row = bill.getEntryRowEntity("billentry", rowIdx);
            WareHouseIsolateHelper.setWarehouseQFilterByDataCtrl((Long)org.getLong("id"), (ListShowParameter)showParameter, (String)formId, (DynamicObject)row, (String)e.getProperty().getName());
        }
    }

    public void beforeSelectLocation(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        int rowindex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject warehouse = (DynamicObject)model.getValue("warehouse", rowindex);
        this.commonLocationFilter(warehouse, e);
    }

    public void beforeSelectInLocation(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        int rowindex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject warehouse = (DynamicObject)model.getValue("inwarehouse", rowindex);
        this.commonLocationFilter(warehouse, e);
    }

    public void beforeSelectOutlocation(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        int rowindex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject outWh = (DynamicObject)model.getValue("outwarehouse", rowindex);
        this.commonLocationFilter(outWh, e);
    }

    private void commonLocationFilter(DynamicObject warehouse, BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (CommonUtils.isNull((Object)warehouse)) {
            e.setCancel(true);
        } else {
            QFilter qFilter = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol, String locationkey) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (CommonUtils.isNull((Object)locationCol) || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject(locationkey);
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    public void beforeSelectUnit(BeforeF7SelectEvent e) {
        Object material;
        IDataModel bill = this.getModel();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Long masterMaterialId = 0L;
        Object masterMaterial = material = bill.getValue("material", rowIndex);
        if (MetaDataHelper.isExistField((IDataModel)bill, (String)"billentry", (String)"materialmasterid")) {
            masterMaterial = bill.getValue("materialmasterid", rowIndex);
        }
        masterMaterialId = masterMaterial instanceof DynamicObject ? (Long)((DynamicObject)masterMaterial).getPkValue() : (Long)masterMaterial;
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
        Long srcmuId = baseUnit == null ? Long.valueOf(0L) : Long.valueOf(baseUnit.getPkValue().toString());
        List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1", (Boolean)Boolean.TRUE);
        QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void beforeSelectMaterial(BeforeF7SelectEvent e) {
        IDataModel bill = this.getModel();
        DynamicObject org = (DynamicObject)bill.getValue("org");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject billType = (DynamicObject)bill.getValue("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"TransBillCommonBeforeF7SelectListener_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        if (!CommonUtils.isNull((Object)org)) {
            QFilter qFilter = new QFilter("masterid.status", "=", (Object)"C");
            qFilter.and("masterid.enable", "=", (Object)"1").and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
            if (MetaDataHelper.isExistField((IDataModel)bill, (String)"biztype")) {
                DynamicObject bizType = (DynamicObject)bill.getValue("biztype");
                if (bizType == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"TransBillCommonBeforeF7SelectListener_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                }
                if (!CommonUtils.isNull((Object)bizType)) {
                    Object value;
                    DynamicObject lineType = (DynamicObject)bill.getValue("linetype");
                    if (lineType == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u884c\u7c7b\u578b\u3002", (String)"TransBillCommonBeforeF7SelectListener_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    }
                    QFilter[] qFilterByLineType = BillTypeMaterialHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)((Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (boolean)true);
                    if (qFilterByLineType != null && (value = qFilterByLineType[0].getValue()) != null && !value.equals(1)) {
                        QFilter serviceAttrFilter = QFilter.sqlExpress((String)"masterid.id", (String)"in", (String)(" ( select fid from t_bd_mtsserviceattribute where fbasedataid = " + value + " ) "));
                        qFilter.and(serviceAttrFilter);
                    }
                    String bizCategory = bizType.getString("bizcategory");
                    String domain = bizType.getString("domain");
                    if ("6".equals(domain)) {
                        qFilter.and(MASTERID_ENABLEVMI, "=", (Object)Boolean.TRUE);
                    } else {
                        List materialTypes = BizTypeHelper.getMaterialQFilterByBizCategory((String)bizCategory);
                        if (materialTypes.size() != 0) {
                            qFilter.and("masterid.materialtype", "in", (Object)materialTypes);
                        }
                    }
                }
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeSelectLot(BeforeF7SelectEvent e, String fieldKey) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject selectEntry = model.getEntryRowEntity("billentry", rowIndex);
        String lotidField = "billentry." + fieldKey;
        LotMainFileHelper.setLotMainfFileF7Filter((BeforeF7SelectEvent)e, (DynamicObject)bill, (DynamicObject)selectEntry, (String)lotidField);
    }

    public void beforeSelectBiztype(BeforeF7SelectEvent e) {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"TransBillCommonBeforeF7SelectListener_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String formid = this.getModel().getDataEntityType().getName();
        List bizTypeIds = BizTypeHelper.getBizTypeIds((Object)billType.getPkValue(), (String)formid);
        if (bizTypeIds != null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)bizTypeIds));
        }
    }

    private void beforeLineType(BeforeF7SelectEvent e, String formId) {
        LineTypeParam lineTypeParam;
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        ArrayList<Long> bizTypes = new ArrayList<Long>(16);
        List lineTypes = new ArrayList(16);
        if (bizType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ApplyBillBeforeF7SelectListener_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        bizTypes.add(bizType.getLong("id"));
        Map lineTypeByBillType = BillTypeMaterialHelper.getLineTypeByBillType(bizTypes);
        if (lineTypeByBillType.size() != 0 && (lineTypes = (List)(lineTypeParam = (LineTypeParam)lineTypeByBillType.get(bizType.getLong("id"))).getLineTypeQf()[0].getValue()) != null) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_linetype", (QFilter[])new QFilter("id", "in", lineTypes).toArray());
            Iterator iterator = lineTypes.iterator();
            while (iterator.hasNext()) {
                Long next = (Long)iterator.next();
                DynamicObject lineType = (DynamicObject)dynamicObjectMap.get(next);
                if (lineType == null) {
                    iterator.remove();
                    continue;
                }
                DynamicObject entity = lineType.getDynamicObject("serviceattribute").getDynamicObject("entity");
                String entityNum = entity.getString("number");
                if ("bd_material".equals(entityNum)) continue;
                iterator.remove();
            }
        }
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", lineTypes));
    }

    public ArrayList<Object> getOwnerList(DynamicObject org) {
        ArrayList<Object> array = new ArrayList<Object>();
        if (!CommonUtils.isNull((Object)org)) {
            Long orgId = (Long)org.getPkValue();
            ArrayList ownerArray = OwnerHelper.getOwners((Long)orgId);
            array.addAll(ownerArray);
            Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            Object settleOrgId = null;
            if (companyByOrg != null) {
                settleOrgId = companyByOrg.get("id");
                array.add(settleOrgId);
            }
        }
        return array;
    }
}

