/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.transbill;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.ImBillEditHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.formplugin.transbill.AbstractTransBill;
import kd.scmc.im.formplugin.transbill.TransBillCommonBeforeF7SelectListener;
import kd.scmc.im.utils.FormUtils;

public class TransBillSetpOut
extends AbstractTransBill {
    private static final String TRANSIT_OUT = "A";
    private static final String TRANSIT_IN = "B";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"owner", "outowner", this.getTransOutOrgKey(), this.getTransInOrgKey(), "keeper", "outkeeper", "warehouse", "location", "inwarehouse", "inlocation"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateTransit((DynamicObject)this.getModel().getValue("invscheme"));
        DynamicObject org = (DynamicObject)this.getModel().getValue(this.getTransOutOrgKey());
        DynamicObject inorg = this.getModel().getDataEntity().getDynamicObject(this.getTransInOrgKey());
        String transType = this.getModel().getDataEntity().getString("transtype");
        this.setOrg(transType);
        this.setSettleCurrency(org);
        this.initEntry(inorg, org);
        this.updateTransitOwner();
        this.initInWarehouse();
    }

    private void initInWarehouse() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.updateEnableLocation("inlocation", (DynamicObject)this.getModel().getValue("inwarehouse", i), i);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel model = this.getView().getModel();
        switch (itemKey) {
            case "getprice": {
                this.getOrgPrice(model);
                break;
            }
        }
    }

    private void getOrgPrice(IDataModel model) {
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.isPropertyChange(e)) {
            return;
        }
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        int index = changeSet.getRowIndex();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        String key = e.getProperty().getName();
        this.updateLogisticBill(key);
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "transtype": {
                this.setOrg(newValue);
                this.setInOrgEnable();
                break;
            }
            case "inorg": {
                int entryRowCount = this.getModel().getEntryRowCount("billentry");
                Object trans = this.getModel().getValue("transit");
                boolean isTransIn = TRANSIT_IN.equals(trans);
                for (int i = 0; i < entryRowCount; ++i) {
                    this.dealOwner("ownertype", i);
                    this.dealKeeper("keepertype", i);
                    if (!isTransIn) continue;
                    this.getModel().setValue("inwarehouse", null, i);
                    this.getModel().setValue("inlocation", null, i);
                }
                break;
            }
            case "org": {
                int entryRowCount = this.getModel().getEntryRowCount("billentry");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.dealOwner("outowner", i);
                    this.dealKeeper("outkeepertype", i);
                }
                break;
            }
            case "invscheme": {
                this.changeInvScheme(e);
                this.update4InScheme();
                this.handleIsVisible();
                this.updateTransitOwner();
                break;
            }
            case "isfreegift": {
                this.changeIsPresent(newValue, index);
                break;
            }
            case "transit": {
                int entryRowCount = this.getModel().getEntryRowCount("billentry");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.dealKeeper("keepertype", i);
                    this.getModel().setValue("inwarehouse", null, i);
                    this.getModel().setValue("inlocation", null, i);
                }
                this.updateTransitOwner();
                break;
            }
            case "outownertype": 
            case "ownertype": 
            case "outowner": 
            case "owner": {
                super.propertyChanged(e);
                this.updateTransitOwnerByIndex(index);
                break;
            }
            case "inwarehouse": {
                this.changeWarehouse(e, "inlocation");
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    private void updateTransitOwnerByIndex(int index) {
        IDataModel model = this.getModel();
        String transit = (String)model.getValue("transit");
        if (StringUtils.isBlank((CharSequence)transit)) {
            return;
        }
        switch (transit) {
            case "A": {
                model.setValue("transitownertype", model.getValue("outownertype", index), index);
                model.setValue("transitowner", model.getValue("outowner", index), index);
                break;
            }
            case "B": {
                model.setValue("transitownertype", model.getValue("ownertype", index), index);
                model.setValue("transitowner", model.getValue("owner", index), index);
                break;
            }
        }
    }

    protected void changeInWarehouse(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        int index = changeSet.getRowIndex();
        this.setLocationIsEnableByInWarehouse((DynamicObject)newValue, index);
    }

    protected void setLocationIsEnableByInWarehouse(DynamicObject warehouse, int rowindex) {
        this.getModel().setValue("inlocation", null, rowindex);
        if (warehouse != null) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowindex, new String[]{"inlocation"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"inlocation"});
        }
    }

    private void updateTransitOwner() {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("billentry");
        String transit = (String)model.getValue("transit");
        if (StringUtils.isBlank((CharSequence)transit)) {
            return;
        }
        switch (transit) {
            case "A": {
                for (int i = 0; i < entryRowCount; ++i) {
                    model.setValue("transitownertype", model.getValue("outownertype", i), i);
                    model.setValue("transitowner", model.getValue("outowner", i), i);
                }
                break;
            }
            case "B": {
                for (int i = 0; i < entryRowCount; ++i) {
                    model.setValue("transitownertype", model.getValue("ownertype", i), i);
                    model.setValue("transitowner", model.getValue("owner", i), i);
                }
                break;
            }
        }
    }

    @Override
    protected void changeInvScheme(PropertyChangedArgs e) {
        DynamicObject invScheme;
        super.changeInvScheme(e);
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject newInvScheme = (DynamicObject)changeData.getNewValue();
        this.updateTransit(newInvScheme);
        DynamicObject inorg = (DynamicObject)this.getModel().getValue(this.getTransInOrgKey());
        DynamicObject outorg = this.getModel().getDataEntity().getDynamicObject(this.getTransOutOrgKey());
        if (this.isDrawByBOTP() && (invScheme = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            String bizDirection = invScheme.getString("bizdirection");
            String transtype = (String)this.getModel().getValue("transtype");
            if ("1".equals(bizDirection) && TRANSIT_IN.equals(transtype)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"inorg"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"inorg"});
            }
        }
        this.initEntry(inorg, outorg);
    }

    private void updateTransit(DynamicObject invScheme) {
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        if (isInUpdate && isOutUpdate) {
            this.getModel().setValue("transit", (Object)TRANSIT_OUT);
        } else {
            this.getModel().setValue("transit", null);
        }
    }

    private void setOrg(Object transType) {
        DynamicObject outOrg = this.getModel().getDataEntity().getDynamicObject(this.getTransOutOrgKey());
        if (outOrg != null && transType != null) {
            boolean isInv = outOrg.getBoolean("fisinventory");
            if (isInv && TRANSIT_OUT.equals(transType)) {
                this.getModel().setValue(this.getTransInOrgKey(), outOrg.getPkValue());
            } else {
                this.getModel().setValue(this.getTransInOrgKey(), null);
            }
        }
    }

    private void setInOrgEnable() {
        String transType = this.getModel().getDataEntity().getString("transtype");
        boolean transInOrg = TRANSIT_OUT.equals(transType);
        this.getView().setEnable(Boolean.valueOf(!transInOrg), new String[]{this.getTransInOrgKey()});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel bill = this.getModel();
        boolean isMainOrg = ImBillEditHelper.isMainOrgByF7((IFormView)this.getView(), (IDataModel)bill, (String)fieldKey);
        if (!isMainOrg) {
            e.setCancel(true);
            return;
        }
        switch (fieldKey) {
            case "org": {
                this.beforeSelectOrg(e);
                break;
            }
            case "inwarehouse": {
                DynamicObject inOrg = (DynamicObject)bill.getValue("inorg");
                DynamicObject outOrg = (DynamicObject)bill.getValue("org");
                break;
            }
            case "inlocation": {
                TransBillCommonBeforeF7SelectListener listener = new TransBillCommonBeforeF7SelectListener(this.getView());
                listener.beforeF7Select(e);
                break;
            }
            default: {
                super.beforeF7Select(e);
            }
        }
    }

    protected void beforeSelectOrg(BeforeF7SelectEvent e) {
        String formid = this.getModel().getDataEntityType().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formid, (String)this.getView().getFormShowParameter().getAppId());
        QFilter filter = new QFilter("id", "in", (Object)orgIdList);
        showParameter.getListFilterParameter().setFilter(filter);
    }

    @Override
    protected String getTransOutOrgKey() {
        return "org";
    }

    @Override
    protected String getTransInOrgKey() {
        return "inorg";
    }

    @Override
    protected void handleVisible() {
        super.handleVisible();
        this.update4InScheme();
    }

    private void initPriceField(boolean isPresent, int rowIndex) {
        IFormView view = this.getView();
        boolean isEnable = !isPresent;
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"price"});
        view.setEnable(Boolean.valueOf(isEnable), rowIndex, new String[]{"amount"});
    }

    @Override
    protected void setBillEntryEnable(RowDataEntity row) {
        super.setBillEntryEnable(row);
        DynamicObject dynamicObject = row.getDataEntity();
        Boolean isPresent = dynamicObject.getBoolean("isfreegift");
        this.initPriceField(isPresent, row.getRowIndex());
    }

    @Override
    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        super.setBillEntryEnable4IsDraw(row, isDraw);
        IFormView view = this.getView();
        int index = row.getRowIndex();
        if (isDraw) {
            view.setEnable(Boolean.valueOf(!isDraw), index, new String[]{"isfreegift"});
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        boolean isPresent = (Boolean)newValue;
        this.initPriceField(isPresent, rowIndex);
        if (isPresent) {
            model.setValue("price", (Object)Constants.ZERO, rowIndex);
            model.setValue("amount", (Object)Constants.ZERO, rowIndex);
        }
    }

    private void update4InScheme() {
        IDataModel bill = this.getModel();
        DynamicObject scheme = (DynamicObject)bill.getValue("invscheme");
        DynamicObject invScheme = null;
        if (scheme == null || scheme.getPkValue() == null) {
            return;
        }
        invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        if (!isInUpdate) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"owner", "ownertype"});
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObject invScheme;
        super.afterBindData(e);
        this.handleIsVisible();
        this.initInWarehouse();
        this.setInOrgEnable();
        if (this.isDrawByBOTP() && (invScheme = (DynamicObject)this.getModel().getValue("invscheme")) != null) {
            String bizDirection = invScheme.getString("bizdirection");
            String transtype = (String)this.getModel().getValue("transtype");
            if ("1".equals(bizDirection) && TRANSIT_IN.equals(transtype)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"inorg"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"inorg"});
            }
        }
    }

    private void handleIsVisible() {
        IDataModel model = this.getModel();
        DynamicObject invScheme = (DynamicObject)model.getValue("invscheme");
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        this.getView().setVisible(Boolean.valueOf(isInUpdate), new String[]{"inwarehouse", "inlocation"});
        this.getView().setVisible(Boolean.valueOf(isInUpdate && isOutUpdate), new String[]{"transitownertype", "transitowner"});
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.updateTransitOwner();
        this.initInWarehouse();
    }

    private void inWareHouseFilter(DynamicObject outOrg, DynamicObject inOrg, BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (outOrg == null || inOrg == null) {
            e.setCancel(true);
        } else {
            Long[] allWhs;
            String formId = this.getModel().getDataEntityType().getName();
            QFilter outWhsF7Filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)formId, (DynamicObject)outOrg);
            QFilter inWhsF7Filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)formId, (DynamicObject)inOrg);
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            if (outWhsF7Filter == null) {
                allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(outOrg.getPkValue().toString()));
                outWhsF7Filter = new QFilter("id", "in", (Object)allWhs);
            }
            if (inWhsF7Filter == null) {
                allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(inOrg.getPkValue().toString()));
                inWhsF7Filter = new QFilter("id", "in", (Object)allWhs);
            }
            filterParameter.getQFilters().clear();
            Object value = this.getModel().getValue("transit");
            if (TRANSIT_OUT.equals(value)) {
                showParameter.setUseOrgId(outOrg.getLong("id"));
                filterParameter.setFilter(outWhsF7Filter);
            } else {
                showParameter.setUseOrgId(inOrg.getLong("id"));
                filterParameter.setFilter(inWhsF7Filter);
            }
        }
    }
}

