/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.warn;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BigIntProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WarnHelper {
    public static final String CONDITION = "filterConditionString";

    public static FilterCondition parseFilterCondition(Map<String, Object> customerParam) {
        String conditionStr = (String)customerParam.get(CONDITION);
        if (conditionStr == null) {
            return null;
        }
        return (FilterCondition)SerializationUtils.fromJsonString((String)conditionStr, FilterCondition.class);
    }

    public static Map<String, Object> parseCustomerParam(FilterCondition condition) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (condition != null) {
            param.put(CONDITION, SerializationUtils.toJsonString((Object)condition));
        }
        return param;
    }

    public static QFilter buildQFilter(Map<String, Object> customerParam, MainEntityType type) {
        FilterCondition condition = WarnHelper.parseFilterCondition(customerParam);
        if (condition == null || type == null) {
            return null;
        }
        FilterBuilder filterBuilder = new FilterBuilder(type, condition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilter();
    }

    public static Map<Long, Map<Long, BigDecimal>> getOrgToMaterialsMapping(DataSet invAcc) {
        HashMap<Long, Map<Long, BigDecimal>> orgToMaterialsMapping = new HashMap<Long, Map<Long, BigDecimal>>(16);
        for (Row row : invAcc) {
            Long org = row.getLong("org");
            Long material = row.getLong("material");
            BigDecimal avbBaseQty = row.getBigDecimal("avbbaseqty");
            if (org == null || material == null) continue;
            Map materialToInvQty = orgToMaterialsMapping.computeIfAbsent(org, k -> new HashMap());
            materialToInvQty.put(material, avbBaseQty);
        }
        return orgToMaterialsMapping;
    }

    public static Map<Object, DynamicObject> getDynamicObjectMap(Set<Long> orgIds) {
        QFilter orgFilter = new QFilter("id", "in", orgIds);
        return BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"name,number,id", (QFilter[])orgFilter.toArray());
    }

    @Deprecated
    public static DynamicObject getShelfLifeWarnDynamicObject(DynamicObject invOrg, DynamicObject createOrg, DynamicObject materialId, BigDecimal avbbaseqty, BigDecimal rioqty) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"im_shelflifewarnparam");
        DynamicObject shelfLifeWarnParam = new DynamicObject((DynamicObjectType)mainEntityType);
        if (createOrg != null) {
            shelfLifeWarnParam.set("createorg", (Object)createOrg);
        }
        if (null != invOrg) {
            shelfLifeWarnParam.set("org", (Object)invOrg);
        }
        if (null != materialId) {
            shelfLifeWarnParam.set("material", (Object)materialId);
            shelfLifeWarnParam.set("id", (Object)materialId.getLong("id"));
        }
        shelfLifeWarnParam.set("avbbaseqty", (Object)avbbaseqty);
        shelfLifeWarnParam.set("warnqty", (Object)rioqty);
        return shelfLifeWarnParam;
    }

    public static DynamicObject getShelfLifeWarnDynamicObject(DynamicObject invOrg, DynamicObject createOrg, DynamicObject materialId, BigDecimal avbbaseqty, BigDecimal rioqty, long pkId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"im_shelflifewarnparam");
        DynamicObject shelfLifeWarnParam = new DynamicObject((DynamicObjectType)mainEntityType);
        DynamicProperty idProp = mainEntityType.getProperty("pk");
        ((BigIntProp)idProp).setPrimaryKey(true);
        shelfLifeWarnParam.set("pk", (Object)pkId);
        if (createOrg != null) {
            shelfLifeWarnParam.set("createorg", (Object)createOrg);
        }
        if (null != invOrg) {
            shelfLifeWarnParam.set("org", (Object)invOrg);
        }
        if (null != materialId) {
            shelfLifeWarnParam.set("material", (Object)materialId);
            shelfLifeWarnParam.set("id", (Object)materialId.getLong("id"));
        }
        shelfLifeWarnParam.set("avbbaseqty", (Object)avbbaseqty);
        shelfLifeWarnParam.set("warnqty", (Object)rioqty);
        return shelfLifeWarnParam;
    }
}

