/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.warn.datasource;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnDataSource;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.InvaccDataSetHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.formplugin.warn.WarnHelper;

public class SaftyInventoryWarnDataSource
implements IEarlyWarnDataSource {
    private static final Log log = LogFactory.getLog(SaftyInventoryWarnDataSource.class);

    public List<QFilter> buildFilter(String s, FilterCondition filterCondition, EarlyWarnContext earlyWarnContext) {
        return null;
    }

    public DynamicObjectCollection getData(String dataSource, List<QFilter> filterList, EarlyWarnContext context) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"im_shelflifewarnparam");
        DynamicObjectCollection collection = new DynamicObjectCollection((DynamicObjectType)mainEntityType, null, new ArrayList(16));
        try {
            QFilter customFilter = WarnHelper.buildQFilter(context.getCustomConditionDataMap(), MetadataServiceHelper.getDataEntityType((String)InvAccConst.getBalTb()));
            DataSet invAccs = InvaccDataSetHelper.queryInvAccs((QFilter)customFilter);
            Map<Long, Map<Long, BigDecimal>> orgToMaterialsMapping = WarnHelper.getOrgToMaterialsMapping(invAccs);
            if (orgToMaterialsMapping.isEmpty()) {
                return new DynamicObjectCollection();
            }
            Map<Object, DynamicObject> orgMap = WarnHelper.getDynamicObjectMap(orgToMaterialsMapping.keySet());
            Set<Map.Entry<Long, Map<Long, BigDecimal>>> entrySet = orgToMaterialsMapping.entrySet();
            for (Map.Entry<Long, Map<Long, BigDecimal>> entry : entrySet) {
                Map<Object, DynamicObject> invInfo = this.getInvInfo(entry);
                this.buildWarnParam(collection, invInfo, entry, orgMap);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return collection;
    }

    private void buildWarnParam(DynamicObjectCollection collection, Map<Object, DynamicObject> invInfo, Map.Entry<Long, Map<Long, BigDecimal>> entry, Map<Object, DynamicObject> orgMap) {
        Long invOrgId = entry.getKey();
        Map<Long, BigDecimal> materialToInvQty = entry.getValue();
        DynamicObject invOrg = orgMap.get(invOrgId);
        Set<Map.Entry<Object, DynamicObject>> entrySet = invInfo.entrySet();
        long[] pkIds = DB.genGlobalLongIds((int)entrySet.size());
        int index = 0;
        for (Map.Entry<Object, DynamicObject> invInfoEntry : entrySet) {
            DynamicObject invInfoDy = invInfoEntry.getValue();
            BigDecimal safeInvQty = invInfoDy.getBigDecimal("saftyinvqty");
            DynamicObject masterId = invInfoDy.getDynamicObject("masterid");
            DynamicObject createOrg = invInfoDy.getDynamicObject("createorg");
            BigDecimal avbBaseQty = materialToInvQty.get((Long)masterId.getPkValue());
            Boolean isWarning = this.getIsWarning(safeInvQty, avbBaseQty);
            if (!isWarning.booleanValue()) continue;
            DynamicObject shelfLifeWarnDynamicObject = WarnHelper.getShelfLifeWarnDynamicObject(invOrg, createOrg, masterId, avbBaseQty, safeInvQty, pkIds[index]);
            collection.add((Object)shelfLifeWarnDynamicObject);
            ++index;
        }
    }

    private Map<Object, DynamicObject> getInvInfo(Map.Entry<Long, Map<Long, BigDecimal>> entry) {
        Long orgId = entry.getKey();
        Map<Long, BigDecimal> subMap = entry.getValue();
        Set<Long> materialMasterIds = subMap.keySet();
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("issaftyinvalert");
        selectorSet.add("saftyinvqty");
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        QFilter warnFilter = new QFilter("issaftyinvalert", "=", (Object)"1");
        QFilter masterIdFilter = new QFilter("masterid", "in", materialMasterIds);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
        qFilter.and(warnFilter).and(masterIdFilter).and(baseDataFilter);
        selectorSet.add("id");
        selectorSet.add("masterid.id");
        selectorSet.add("createorg");
        Map materialInvInfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)String.join((CharSequence)",", selectorSet), (QFilter[])qFilter.toArray());
        return materialInvInfo;
    }

    public List<Map<String, Object>> getCommonFilterColumns(String s) {
        return null;
    }

    public TreeNode getSingleMessageFieldTree(String s) {
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setOnlyPhysicsField(false);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"im_shelflifewarnparam");
        TreeNode root = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)option);
        root.setIsOpened(true);
        return root;
    }

    public TreeNode getMergeMessageFieldTree(String s) {
        return this.getSingleMessageFieldTree(s);
    }

    private Boolean getIsWarning(BigDecimal warnqty, BigDecimal avbbaseqty) {
        Boolean warn = Boolean.FALSE;
        if (avbbaseqty.compareTo(warnqty) < 0) {
            warn = Boolean.TRUE;
        }
        return warn;
    }
}

