/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OccDeliveryRecord2OutWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String SOURCEENTITY = "ocbsoc_delivery_record";
    private static final String SOURCESALEENTITY = "ocbsoc_saleorder";

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if (SOURCEENTITY.equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add("sumpurinbaseqty");
            e.getFieldKeys().add("closestatus");
            e.getFieldKeys().add("signstatus");
            e.getFieldKeys().add("billstatus");
        }
        if (SOURCESALEENTITY.equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add("approvebaseqty");
            e.getFieldKeys().add("totalinstockbaseqty");
            e.getFieldKeys().add("signstatus");
            e.getFieldKeys().add("billstatus");
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        DynamicObject[] srcDataEntities;
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        ArrayList<DynamicObject> saveValue = new ArrayList(16);
        if (SOURCEENTITY.equals(srcSubMainType.getName()) && (opType.equalsIgnoreCase("audit") || opType.equalsIgnoreCase("unaudit") || "cancel".equalsIgnoreCase(opType))) {
            srcDataEntities = e.getSrcDataEntities();
            Map<Object, DynamicObject> deliveryRecordMap = this.querySrcData(srcDataEntities, SOURCEENTITY);
            saveValue = this.getDeliveryRecSaveValues(deliveryRecordMap, srcDataEntities);
            Set<Long> deliveryIdSet = Arrays.asList(srcDataEntities).stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
            boolean isAudit = opType.equalsIgnoreCase("audit");
            this.setDeliverySubEntrySignValue(saveValue, deliveryIdSet, isAudit);
        }
        if (SOURCESALEENTITY.equals(srcSubMainType.getName()) && (opType.equalsIgnoreCase("audit") || opType.equalsIgnoreCase("unaudit"))) {
            srcDataEntities = e.getSrcDataEntities();
            Map<Object, DynamicObject> saleOrderMap = this.querySrcData(srcDataEntities, SOURCESALEENTITY);
            saveValue = this.getSaleOrderSaveValues(saleOrderMap, srcDataEntities, opType);
        }
        if (saveValue != null && saveValue.size() > 0) {
            DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
            SaveServiceHelper.save((DynamicObject[])saveValues);
        }
    }

    private Map<Object, DynamicObject> querySrcData(DynamicObject[] srcDataEntities, String sourceEntity) {
        if (srcDataEntities == null) {
            return new HashMap<Object, DynamicObject>(0);
        }
        HashSet<Object> srcPkValues = new HashSet<Object>(srcDataEntities.length);
        for (DynamicObject srcDataEntity : srcDataEntities) {
            srcPkValues.add(srcDataEntity.getPkValue());
        }
        Map saleOrderMap = BusinessDataServiceHelper.loadFromCache((Object[])srcPkValues.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntity));
        return saleOrderMap;
    }

    private List<DynamicObject> getDeliveryRecSaveValues(Map<Object, DynamicObject> deliveryRecordMap, DynamicObject[] srcDataEntities) {
        if (deliveryRecordMap != null && deliveryRecordMap.size() > 0) {
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>(deliveryRecordMap.size());
            for (DynamicObject srcEntity : srcDataEntities) {
                DynamicObject record = deliveryRecordMap.get(srcEntity.getPkValue());
                DynamicObjectCollection deliverydetails = record.getDynamicObjectCollection("deliverydetail");
                BigDecimal allstockSum = deliverydetails.stream().map(m -> m.getBigDecimal("sumpurinbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (allstockSum.compareTo(BigDecimal.ZERO) > 0) {
                    if ("A".equals(srcEntity.getString("closestatus"))) {
                        record.set("billstatus", (Object)"D");
                    } else {
                        record.set("billstatus", (Object)"C");
                    }
                    record.set("signer", (Object)RequestContext.get().getUserId());
                    record.set("signtime", (Object)TimeServiceHelper.now());
                } else {
                    record.set("billstatus", (Object)"B");
                    record.set("signer", null);
                    record.set("signtime", null);
                }
                saveValue.add(record);
            }
            return saveValue;
        }
        return new ArrayList<DynamicObject>(0);
    }

    private List<DynamicObject> getSaleOrderSaveValues(Map<Object, DynamicObject> saleOrderMap, DynamicObject[] srcDataEntities, String opType) {
        if (saleOrderMap != null && saleOrderMap.size() > 0) {
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>(saleOrderMap.size());
            for (DynamicObject srcEntity : srcDataEntities) {
                DynamicObject saleOrder = saleOrderMap.get(srcEntity.getPkValue());
                DynamicObjectCollection itementry = saleOrder.getDynamicObjectCollection("itementry");
                if (itementry == null || itementry.size() == 0) continue;
                List itemEntryDynObjList = itementry.stream().filter(m -> (m.getLong("combinationid_id") == 0L || m.getLong("combineparentid") > 0L) && m.getString("entryclosestatus").equals("A")).collect(Collectors.toList());
                BigDecimal totalInstockBaseQty = itemEntryDynObjList.stream().map(m -> m.getBigDecimal("totalinstockbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalApproveBaseQty = itemEntryDynObjList.stream().map(m -> m.getBigDecimal("approvebaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalOutstockBaseQty = itemEntryDynObjList.stream().map(m -> m.getBigDecimal("totaloutstockbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                List itemEntryDynObjList_Close = itementry.stream().filter(m -> (m.getLong("combinationid_id") == 0L || m.getLong("combineparentid") > 0L) && m.getString("entryclosestatus").equals("B")).collect(Collectors.toList());
                BigDecimal totalInStockBaseQty_Close = itemEntryDynObjList_Close.stream().map(m -> m.getBigDecimal("totalinstockbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalOutStockBaseQty_Close = itemEntryDynObjList_Close.stream().map(m -> m.getBigDecimal("totaloutstockbaseqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.setStatus(totalInstockBaseQty, totalOutstockBaseQty, totalApproveBaseQty, totalInStockBaseQty_Close, totalOutStockBaseQty_Close, saleOrder, opType);
                saveValue.add(saleOrder);
            }
            return saveValue;
        }
        return new ArrayList<DynamicObject>(0);
    }

    private void setStatus(BigDecimal totalInstockBaseQty, BigDecimal totalOutstockBaseQty, BigDecimal totalApproveBaseQty, BigDecimal totalInStockBaseQty_Close, BigDecimal totalOutStockBaseQty_Close, DynamicObject saleOrder, String opType) {
        boolean inQty_LE_OutQty_Close;
        boolean inQty_LE_OutQty = totalInstockBaseQty.compareTo(totalOutstockBaseQty) >= 0;
        boolean bl = inQty_LE_OutQty_Close = totalInStockBaseQty_Close.compareTo(totalOutStockBaseQty_Close) >= 0;
        if (opType.equalsIgnoreCase("unaudit")) {
            saleOrder.set("signstatus", (Object)"B");
        } else if (inQty_LE_OutQty && inQty_LE_OutQty_Close) {
            saleOrder.set("signstatus", (Object)"D");
        } else {
            saleOrder.set("signstatus", (Object)"C");
        }
        if (inQty_LE_OutQty && inQty_LE_OutQty_Close) {
            saleOrder.set("billstatus", (Object)"F");
        } else if (totalOutstockBaseQty.compareTo(totalApproveBaseQty) == 0) {
            saleOrder.set("billstatus", (Object)"E");
        } else if (totalOutstockBaseQty.compareTo(BigDecimal.ZERO) > 0 && totalOutstockBaseQty.compareTo(totalApproveBaseQty) < 0) {
            saleOrder.set("billstatus", (Object)"D");
        }
    }

    private void setDeliverySubEntrySignValue(List<DynamicObject> deliveryDynObjList, Set<Long> deliveryIdSet, boolean isAudit) {
        HashSet snNumberSet = new HashSet(20);
        for (DynamicObject deliveryDynObj : deliveryDynObjList) {
            DynamicObjectCollection deliveryEntryColl = deliveryDynObj.getDynamicObjectCollection("deliverydetail");
            for (DynamicObject deliveryEntryDynObj : deliveryEntryColl) {
                DynamicObjectCollection deliverySubEntryColl = deliveryEntryDynObj.getDynamicObjectCollection("subentryentity");
                snNumberSet.addAll(deliverySubEntryColl.stream().map(obj -> obj.getString("serialnumber")).collect(Collectors.toSet()));
            }
        }
        if (snNumberSet.size() > 0) {
            QFilter qFilter = new QFilter("entryentity.snnumber", "in", snNumberSet);
            qFilter.and("billtype", "=", (Object)"im_purinbill");
            DynamicObjectCollection channelSerialDynObjColl = QueryServiceHelper.query((String)"sbs_billsnrelation", (String)String.join((CharSequence)",", "entryentity.snnumber"), (QFilter[])qFilter.toArray());
            if (channelSerialDynObjColl != null && channelSerialDynObjColl.size() > 0) {
                Set serialNumberSet = channelSerialDynObjColl.stream().map(obj -> obj.getString("entryentity.snnumber")).collect(Collectors.toSet());
                for (DynamicObject deliveryDynObj : deliveryDynObjList) {
                    DynamicObjectCollection deliveryEntryColl = deliveryDynObj.getDynamicObjectCollection("deliverydetail");
                    for (DynamicObject deliveryEntryDynObj : deliveryEntryColl) {
                        DynamicObjectCollection deliverySubEntryColl = deliveryEntryDynObj.getDynamicObjectCollection("subentryentity");
                        for (DynamicObject subEntryDynObj : deliverySubEntryColl) {
                            if (!serialNumberSet.contains(subEntryDynObj.getString("serialnumber"))) continue;
                            subEntryDynObj.set("issign", (Object)(isAudit ? 1 : 0));
                        }
                    }
                }
            }
        }
    }
}

