/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class OccReturnOrder2OutWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String OcBsocReturnorder_P_name = "ocbsoc_returnorder";
    private static final String OcBsocReturnorder_EF_baseqty = "baseqty";
    private static final String OcBsocReturnorder_F_salereturnstatus = "salereturnstatus";
    private static final String OcBsocReturnorder_EF_sumsalereturnbaseqty = "sumsalereturnbaseqty";
    private static final String OcBsocReturnorder_EF_sumsalereturnassistqty = "sumsalereturnassistqty";
    private static final String OcBsocReturnorder_EF_joinsalereturnbaseqty = "joinsalereturnbaseqty";
    private static final String OcBsocReturnorder_EF_joinsalereturnassistqty = "joinsalereturnassistqty";
    private static final String OcBsocReturnorder_EF_joinpurreturnbaseqty = "joinpurreturnbaseqty";
    private static final String OcBsocReturnorder_F_pushstatus = "pushstatus";
    private static final String OcBsocReturnorder_E_itementry = "itementry";
    private static final String OcBsocReturnorder_EF_srcbillentity = "srcbillentity";
    private static final String OcBsocReturnorder_EF_srcbillid = "srcbillid";
    private static final String OcBsocReturnorder_EF_srcbillentryid = "srcbillentryid";
    private static final String OP_draft = "draft";
    private static final String OP_save = "save";
    private static final String OP_delete = "delete";
    private static final String OP_audit = "audit";
    private static final String OP_unaudit = "unaudit";
    private static final String OP_cancel = "cancel";
    private static final String OCBSOCRETURNORDER_RETURNSTATUS_NORETURN = "A";
    private static final String OcBsocReturnorder_returnstatus_RETURNING = "D";
    private static final String OcBsocReturnorder_returnstatus_RETURNED = "E";
    private static final String OcBsocReturnorder_status_NULL = "";
    private static final String OcBsocReturnorder_pushstatus_PURINIMOUT = "B";

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        DynamicObject[] srcDataEntities;
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        if (OcBsocReturnorder_P_name.equals(srcSubMainType.getName()) && (srcDataEntities = e.getSrcDataEntities()) != null && srcDataEntities.length > 0) {
            ArrayList<Object> pkArray = new ArrayList<Object>(srcDataEntities.length);
            for (DynamicObject srcDataEntity : srcDataEntities) {
                pkArray.add(srcDataEntity.getPkValue());
            }
            srcDataEntities = BusinessDataServiceHelper.load((Object[])pkArray.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)OcBsocReturnorder_P_name));
            if (opType.equalsIgnoreCase(OP_audit) || OP_cancel.equalsIgnoreCase(opType)) {
                this.onImOutBillAuditWriteBack(srcDataEntities);
            } else if (OP_unaudit.equalsIgnoreCase(opType) || OP_cancel.equalsIgnoreCase(opType)) {
                this.onImOutBillUnauditWriteBack(srcDataEntities);
            } else if (OP_draft.equalsIgnoreCase(opType) || OP_save.equalsIgnoreCase(opType)) {
                this.onImOutBillSaveWriteBack(srcDataEntities);
            } else if (OP_delete.equalsIgnoreCase(opType) || OP_cancel.equalsIgnoreCase(opType)) {
                this.onImOutBillDeleteWriteBack(srcDataEntities);
            }
            List<Object> saveValue = new ArrayList(16);
            if (OP_audit.equalsIgnoreCase(opType) || OP_unaudit.equalsIgnoreCase(opType) || OP_cancel.equalsIgnoreCase(opType)) {
                saveValue = this.getReturnOrderSaveValues(srcDataEntities, true);
            } else if (OP_save.equalsIgnoreCase(opType) || OP_delete.equalsIgnoreCase(opType) || OP_cancel.equalsIgnoreCase(opType)) {
                saveValue = this.getReturnOrderSaveValues(srcDataEntities, false);
            }
            if (!CollectionUtils.isEmpty(saveValue)) {
                DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
                SaveServiceHelper.save((DynamicObject[])saveValues);
            }
        }
    }

    private List<DynamicObject> getReturnOrderSaveValues(DynamicObject[] srcDataEntities, boolean isAudit) {
        ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>(srcDataEntities.length);
        for (DynamicObject returnOrderDynObj : srcDataEntities) {
            DynamicObjectCollection itementry = returnOrderDynObj.getDynamicObjectCollection(OcBsocReturnorder_E_itementry);
            if (CollectionUtils.isEmpty((Collection)itementry)) continue;
            if (isAudit) {
                saveValue.addAll(this.setTotalSaleReturnBaseQty(returnOrderDynObj));
                continue;
            }
            saveValue.addAll(this.setJoinSaleReturnBaseQty(returnOrderDynObj));
        }
        return saveValue;
    }

    private void onImOutBillSaveWriteBack(DynamicObject[] returnOrders) {
        ArrayList<DynamicObject> updateOrders = new ArrayList<DynamicObject>(returnOrders.length);
        for (DynamicObject returnOrder : returnOrders) {
            if (!StringUtils.isEmpty((String)returnOrder.getString(OcBsocReturnorder_F_pushstatus))) continue;
            returnOrder.set(OcBsocReturnorder_F_pushstatus, (Object)OcBsocReturnorder_pushstatus_PURINIMOUT);
            updateOrders.add(returnOrder);
        }
        if (!CollectionUtils.isEmpty(updateOrders)) {
            SaveServiceHelper.save((DynamicObject[])updateOrders.toArray(new DynamicObject[updateOrders.size()]));
        }
    }

    private void onImOutBillDeleteWriteBack(DynamicObject[] returnOrders) {
        ArrayList<DynamicObject> updateOrders = new ArrayList<DynamicObject>(returnOrders.length);
        for (DynamicObject returnOrder : returnOrders) {
            DynamicObjectCollection itemEntrys = returnOrder.getDynamicObjectCollection(OcBsocReturnorder_E_itementry);
            boolean isNoReturn = true;
            for (DynamicObject itemEntry : itemEntrys) {
                if (BigDecimal.ZERO.compareTo(itemEntry.getBigDecimal(OcBsocReturnorder_EF_joinsalereturnbaseqty)) == 0 && BigDecimal.ZERO.compareTo(itemEntry.getBigDecimal(OcBsocReturnorder_EF_joinpurreturnbaseqty)) == 0) continue;
                isNoReturn = false;
                break;
            }
            if (!isNoReturn || !OcBsocReturnorder_pushstatus_PURINIMOUT.equals(returnOrder.getString(OcBsocReturnorder_F_pushstatus))) continue;
            returnOrder.set(OcBsocReturnorder_F_pushstatus, (Object)OcBsocReturnorder_status_NULL);
            updateOrders.add(returnOrder);
        }
        if (!CollectionUtils.isEmpty(updateOrders)) {
            SaveServiceHelper.update((DynamicObject[])updateOrders.toArray(new DynamicObject[updateOrders.size()]));
        }
    }

    private void onImOutBillAuditWriteBack(DynamicObject[] returnOrders) {
        ArrayList<DynamicObject> updateOrders = new ArrayList<DynamicObject>(returnOrders.length);
        for (DynamicObject returnOrder : returnOrders) {
            DynamicObjectCollection itemEntrys = returnOrder.getDynamicObjectCollection(OcBsocReturnorder_E_itementry);
            boolean isReturned = true;
            boolean isReturning = false;
            for (DynamicObject itemEntry : itemEntrys) {
                if (itemEntry.getBigDecimal(OcBsocReturnorder_EF_sumsalereturnbaseqty).compareTo(itemEntry.getBigDecimal(OcBsocReturnorder_EF_baseqty)) < 0) {
                    isReturned = false;
                }
                if (itemEntry.getBigDecimal(OcBsocReturnorder_EF_sumsalereturnbaseqty).compareTo(BigDecimal.ZERO) <= 0) continue;
                isReturning = true;
            }
            if (isReturned) {
                if (OcBsocReturnorder_returnstatus_RETURNED.equals(returnOrder.getString(OcBsocReturnorder_F_salereturnstatus))) continue;
                returnOrder.set(OcBsocReturnorder_F_salereturnstatus, (Object)OcBsocReturnorder_returnstatus_RETURNED);
                updateOrders.add(returnOrder);
                continue;
            }
            if (!isReturning || OcBsocReturnorder_returnstatus_RETURNING.equals(returnOrder.getString(OcBsocReturnorder_F_salereturnstatus))) continue;
            returnOrder.set(OcBsocReturnorder_F_salereturnstatus, (Object)OcBsocReturnorder_returnstatus_RETURNING);
            updateOrders.add(returnOrder);
        }
        if (!CollectionUtils.isEmpty(updateOrders)) {
            SaveServiceHelper.update((DynamicObject[])updateOrders.toArray(new DynamicObject[0]));
        }
    }

    private void onImOutBillUnauditWriteBack(DynamicObject[] returnOrders) {
        ArrayList<DynamicObject> updateOrders = new ArrayList<DynamicObject>(returnOrders.length);
        for (DynamicObject returnOrder : returnOrders) {
            DynamicObjectCollection itemEntrys = returnOrder.getDynamicObjectCollection(OcBsocReturnorder_E_itementry);
            boolean isNoReturn = true;
            boolean isReturning = false;
            for (DynamicObject itemEntry : itemEntrys) {
                if (itemEntry.getBigDecimal(OcBsocReturnorder_EF_sumsalereturnbaseqty).compareTo(BigDecimal.ZERO) > 0) {
                    isNoReturn = false;
                }
                if (itemEntry.getBigDecimal(OcBsocReturnorder_EF_sumsalereturnbaseqty).compareTo(itemEntry.getBigDecimal(OcBsocReturnorder_EF_baseqty)) > 0) continue;
                isReturning = true;
            }
            if (isNoReturn) {
                if (!StringUtils.isNotEmpty((String)returnOrder.getString(OcBsocReturnorder_F_salereturnstatus))) continue;
                returnOrder.set(OcBsocReturnorder_F_salereturnstatus, (Object)OCBSOCRETURNORDER_RETURNSTATUS_NORETURN);
                updateOrders.add(returnOrder);
                continue;
            }
            if (!isReturning || OcBsocReturnorder_returnstatus_RETURNING.equals(returnOrder.getString(OcBsocReturnorder_F_salereturnstatus))) continue;
            returnOrder.set(OcBsocReturnorder_F_salereturnstatus, (Object)OcBsocReturnorder_returnstatus_RETURNING);
            updateOrders.add(returnOrder);
        }
        if (!CollectionUtils.isEmpty(updateOrders)) {
            SaveServiceHelper.update((DynamicObject[])updateOrders.toArray(new DynamicObject[0]));
        }
    }

    private List<DynamicObject> setTotalSaleReturnBaseQty(DynamicObject srcDataEntity) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection itemEntrys = srcDataEntity.getDynamicObjectCollection(OcBsocReturnorder_E_itementry);
        if (CollectionUtils.isEmpty((Collection)itemEntrys)) {
            return itemEntrys;
        }
        String srcBillEntity = ((DynamicObject)itemEntrys.get(0)).getString(OcBsocReturnorder_EF_srcbillentity);
        if (OcBsocReturnorder_P_name.equals(srcBillEntity)) {
            DynamicObject[] returnOrderDynObjs;
            Map<Long, List<DynamicObject>> itemEntryMap = itemEntrys.stream().collect(Collectors.groupingBy(obj -> obj.getLong(OcBsocReturnorder_EF_srcbillentryid)));
            Set srcBillIdSet = itemEntrys.stream().map(obj -> obj.getLong(OcBsocReturnorder_EF_srcbillid)).collect(Collectors.toSet());
            for (DynamicObject returnOrderDynObj : returnOrderDynObjs = BusinessDataServiceHelper.load((Object[])srcBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)OcBsocReturnorder_P_name))) {
                DynamicObjectCollection entryColl = returnOrderDynObj.getDynamicObjectCollection(OcBsocReturnorder_E_itementry);
                boolean isSave = false;
                for (DynamicObject entryDynObj : entryColl) {
                    long entryId = entryDynObj.getLong("id");
                    List<DynamicObject> list = itemEntryMap.get(entryId);
                    if (CollectionUtils.isEmpty(list)) continue;
                    BigDecimal sumsalereturnbaseqty = list.stream().map(m -> m.getBigDecimal(OcBsocReturnorder_EF_sumsalereturnbaseqty)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set(OcBsocReturnorder_EF_sumsalereturnbaseqty, (Object)sumsalereturnbaseqty);
                    BigDecimal sumsalereturnassistqty = list.stream().map(m -> m.getBigDecimal(OcBsocReturnorder_EF_sumsalereturnassistqty)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set(OcBsocReturnorder_EF_sumsalereturnassistqty, (Object)sumsalereturnassistqty);
                    isSave = true;
                }
                if (!isSave) continue;
                BigDecimal totalReturnInstockBaseQty = entryColl.stream().map(m -> m.getBigDecimal(OcBsocReturnorder_EF_sumsalereturnbaseqty)).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalBaseQty = entryColl.stream().map(m -> m.getBigDecimal(OcBsocReturnorder_EF_baseqty)).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.setPurReturnStatus(totalReturnInstockBaseQty, totalBaseQty, returnOrderDynObj);
                updateList.add(returnOrderDynObj);
            }
        }
        return updateList;
    }

    private void setPurReturnStatus(BigDecimal totalReturnInstockBaseQty, BigDecimal totalBaseQty, DynamicObject returnOrderDynObj) {
        if (totalReturnInstockBaseQty.compareTo(BigDecimal.ZERO) > 0) {
            if (totalReturnInstockBaseQty.compareTo(totalBaseQty) == 0) {
                returnOrderDynObj.set(OcBsocReturnorder_F_salereturnstatus, (Object)OcBsocReturnorder_returnstatus_RETURNED);
            } else {
                returnOrderDynObj.set(OcBsocReturnorder_F_salereturnstatus, (Object)OcBsocReturnorder_returnstatus_RETURNING);
            }
        } else {
            returnOrderDynObj.set(OcBsocReturnorder_F_salereturnstatus, (Object)OCBSOCRETURNORDER_RETURNSTATUS_NORETURN);
        }
    }

    private List<DynamicObject> setJoinSaleReturnBaseQty(DynamicObject srcDataEntity) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection itemEntrys = srcDataEntity.getDynamicObjectCollection(OcBsocReturnorder_E_itementry);
        if (CollectionUtils.isEmpty((Collection)itemEntrys)) {
            return itemEntrys;
        }
        String srcBillEntity = ((DynamicObject)itemEntrys.get(0)).getString(OcBsocReturnorder_EF_srcbillentity);
        if (OcBsocReturnorder_P_name.equals(srcBillEntity)) {
            DynamicObject[] returnOrderDynObjs;
            Map<Long, List<DynamicObject>> itemEntryMap = itemEntrys.stream().collect(Collectors.groupingBy(obj -> obj.getLong(OcBsocReturnorder_EF_srcbillentryid)));
            Set srcBillIdSet = itemEntrys.stream().map(obj -> obj.getLong(OcBsocReturnorder_EF_srcbillid)).collect(Collectors.toSet());
            for (DynamicObject returnOrderDynObj : returnOrderDynObjs = BusinessDataServiceHelper.load((Object[])srcBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)OcBsocReturnorder_P_name))) {
                DynamicObjectCollection orderEntryColl = returnOrderDynObj.getDynamicObjectCollection(OcBsocReturnorder_E_itementry);
                boolean isSave = false;
                for (DynamicObject entryDynObj : orderEntryColl) {
                    long entryId = entryDynObj.getLong("id");
                    List<DynamicObject> list = itemEntryMap.get(entryId);
                    if (CollectionUtils.isEmpty(list)) continue;
                    BigDecimal joinsalereturnbaseqty = list.stream().map(m -> m.getBigDecimal(OcBsocReturnorder_EF_joinsalereturnbaseqty)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set(OcBsocReturnorder_EF_joinsalereturnbaseqty, (Object)joinsalereturnbaseqty);
                    BigDecimal joinsalereturnassistqty = list.stream().map(m -> m.getBigDecimal(OcBsocReturnorder_EF_joinsalereturnassistqty)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entryDynObj.set(OcBsocReturnorder_EF_joinsalereturnassistqty, (Object)joinsalereturnassistqty);
                    isSave = true;
                }
                if (!isSave) continue;
                updateList.add(returnOrderDynObj);
            }
        }
        return updateList;
    }
}

