/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.wb;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.AfterReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.FinishWriteBackEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.enums.StatusEnum;

public class SalesOrder2OutWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final Long ADMINISTRATORID = 1L;
    private static final String CLOSESTATUS = "closestatus";
    private static final String CLOSER = "closer";
    private static final String CLOSEDATE = "closedate";
    private static final String ROWCLOSESTATUS = "billentry.rowclosestatus";
    private final Long BIZTYPE_REFUND = 688855385217756160L;
    private final Long BIZTYPE_BACKFILL = 688858434904479744L;
    private static Log log = LogFactory.getLog(SalesOrder2OutWriteBackPlugin.class);
    private static ThreadLocal delivEntryids = new ThreadLocal();

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        e.getFieldKeys().add("orderdeliverentry.d_planqty");
        e.getFieldKeys().add("orderdeliverentry.d_actqty");
        e.getFieldKeys().add("orderdeliverentry.d_actdeliverydate");
        e.getFieldKeys().add("biztime");
        e.getFieldKeys().add(CLOSER);
        e.getFieldKeys().add(CLOSEDATE);
        e.getFieldKeys().add(CLOSESTATUS);
        e.getFieldKeys().add(ROWCLOSESTATUS);
        e.getFieldKeys().add("billentry.iscontrolday");
        e.getFieldKeys().add("billentry.deliveradvdays");
        e.getFieldKeys().add("billentry.deliverdelaydays");
        e.getFieldKeys().add("billentry.deliverydate");
    }

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        e.getFieldKeys().add("biztime");
    }

    public void afterReadSourceBill(AfterReadSourceBillEventArgs e) {
        super.afterReadSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        if ("sm_delivernotice".equals(srcSubMainType.getName()) && "UnAudit".equals(opType)) {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            this.setDelivEntryids(srcDataEntities);
        }
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
        String op = e.getRule().getOp();
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        if ("sm_salorder".equals(srcSubMainType.getName()) && "Audit".equals(op) && "invbaseqty".equals(e.getSrcFieldKey())) {
            DynamicObject srcActiveRow = e.getSrcActiveRow();
            DynamicObject targetActiveRow = e.getTargetActiveRow();
            if (srcActiveRow != null && targetActiveRow != null) {
                DynamicObject srcBill = (DynamicObject)srcActiveRow.getParent();
                DynamicObject tarBill = (DynamicObject)targetActiveRow.getParent();
                String targeStatus = tarBill.getString("billstatus");
                Date outStockDate = tarBill.getDate("biztime");
                BigDecimal backwriteBaseQty = targetActiveRow.getBigDecimal("baseqty");
                BigDecimal exchangeRate = srcActiveRow.getBigDecimal("baseqty").divide(srcActiveRow.getBigDecimal("qty"), 10, 4);
                BigDecimal backwriteQty = backwriteBaseQty.divide(exchangeRate, 10, 4);
                DynamicObjectCollection srcEntrys = srcBill.getDynamicObjectCollection("billentry");
                for (int i = 0; i < srcEntrys.size(); ++i) {
                    if (!srcActiveRow.getPkValue().equals(((DynamicObject)srcEntrys.get(i)).getPkValue())) continue;
                    DynamicObjectCollection deliverEntrys = ((DynamicObject)srcEntrys.get(i)).getDynamicObjectCollection("orderdeliverentry");
                    if (targeStatus.equals(StatusEnum.AUDIT.getValue())) {
                        this.auditWriteBack(deliverEntrys, backwriteQty, outStockDate);
                        continue;
                    }
                    if (!targeStatus.equals(StatusEnum.SAVE.getValue())) continue;
                    this.unAuditWriteBack(deliverEntrys, backwriteQty, outStockDate);
                }
            }
        }
    }

    private void auditWriteBack(DynamicObjectCollection deliverEntrys, BigDecimal backwriteQty, Date outStockDate) {
        if (backwriteQty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        String direction = backwriteQty.compareTo(BigDecimal.ZERO) > 0 ? "F" : "R";
        for (int j = 0; j < deliverEntrys.size(); ++j) {
            if (backwriteQty.compareTo(BigDecimal.ZERO) == 0) continue;
            if ("F".equals(direction)) {
                BigDecimal planQty = ((DynamicObject)deliverEntrys.get(j)).getBigDecimal("d_planqty");
                BigDecimal actualQty = ((DynamicObject)deliverEntrys.get(j)).getBigDecimal("d_actqty");
                if (j == deliverEntrys.size() - 1) {
                    ((DynamicObject)deliverEntrys.get(j)).set("d_actqty", (Object)backwriteQty.add(actualQty));
                    ((DynamicObject)deliverEntrys.get(j)).set("d_actdeliverydate", (Object)outStockDate);
                    break;
                }
                if (backwriteQty.add(actualQty).compareTo(planQty) > 0) {
                    backwriteQty = backwriteQty.add(actualQty).subtract(planQty);
                    ((DynamicObject)deliverEntrys.get(j)).set("d_actqty", (Object)planQty);
                } else {
                    ((DynamicObject)deliverEntrys.get(j)).set("d_actqty", (Object)backwriteQty.add(actualQty));
                    backwriteQty = BigDecimal.ZERO;
                }
                ((DynamicObject)deliverEntrys.get(j)).set("d_actdeliverydate", (Object)outStockDate);
            }
            if (!"R".equals(direction)) continue;
            int i = deliverEntrys.size() - 1 - j;
            BigDecimal planQty = ((DynamicObject)deliverEntrys.get(i)).getBigDecimal("d_planqty");
            BigDecimal actualQty = ((DynamicObject)deliverEntrys.get(i)).getBigDecimal("d_actqty");
            if (i == 0) {
                ((DynamicObject)deliverEntrys.get(i)).set("d_actqty", (Object)backwriteQty.add(actualQty));
                if (backwriteQty.add(actualQty).compareTo(BigDecimal.ZERO) == 0) {
                    ((DynamicObject)deliverEntrys.get(i)).set("d_actdeliverydate", null);
                    break;
                }
                ((DynamicObject)deliverEntrys.get(i)).set("d_actdeliverydate", (Object)outStockDate);
                break;
            }
            if (backwriteQty.add(actualQty).compareTo(BigDecimal.ZERO) <= 0) {
                backwriteQty = backwriteQty.add(actualQty);
                ((DynamicObject)deliverEntrys.get(i)).set("d_actqty", (Object)BigDecimal.ZERO);
                ((DynamicObject)deliverEntrys.get(i)).set("d_actdeliverydate", null);
                continue;
            }
            ((DynamicObject)deliverEntrys.get(i)).set("d_actqty", (Object)backwriteQty.add(actualQty));
            backwriteQty = BigDecimal.ZERO;
            ((DynamicObject)deliverEntrys.get(i)).set("d_actdeliverydate", (Object)outStockDate);
        }
    }

    private void unAuditWriteBack(DynamicObjectCollection deliverEntrys, BigDecimal backwriteQty, Date outStockDate) {
        if (backwriteQty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        String direction = backwriteQty.compareTo(BigDecimal.ZERO) > 0 ? "F" : "R";
        for (int j = deliverEntrys.size() - 1; j >= 0; --j) {
            if (backwriteQty.compareTo(BigDecimal.ZERO) == 0) continue;
            if ("F".equals(direction)) {
                BigDecimal actualQty = ((DynamicObject)deliverEntrys.get(j)).getBigDecimal("d_actqty");
                BigDecimal planQty = ((DynamicObject)deliverEntrys.get(j)).getBigDecimal("d_planqty");
                if (backwriteQty.subtract(actualQty).compareTo(BigDecimal.ZERO) >= 0) {
                    ((DynamicObject)deliverEntrys.get(j)).set("d_actqty", (Object)BigDecimal.ZERO);
                    ((DynamicObject)deliverEntrys.get(j)).set("d_actdeliverydate", null);
                    backwriteQty = backwriteQty.subtract(actualQty);
                } else {
                    ((DynamicObject)deliverEntrys.get(j)).set("d_actqty", (Object)actualQty.subtract(backwriteQty));
                    backwriteQty = BigDecimal.ZERO;
                }
            }
            if (!"R".equals(direction)) continue;
            int i = deliverEntrys.size() - 1 - j;
            BigDecimal actualQty = ((DynamicObject)deliverEntrys.get(i)).getBigDecimal("d_actqty");
            BigDecimal planQty = ((DynamicObject)deliverEntrys.get(i)).getBigDecimal("d_planqty");
            if (actualQty.subtract(backwriteQty).compareTo(planQty) > 0) {
                if (i == deliverEntrys.size() - 1) {
                    ((DynamicObject)deliverEntrys.get(i)).set("d_actqty", (Object)actualQty.subtract(backwriteQty));
                    backwriteQty = BigDecimal.ZERO;
                } else {
                    ((DynamicObject)deliverEntrys.get(i)).set("d_actqty", (Object)planQty);
                    backwriteQty = backwriteQty.add(planQty.subtract(actualQty));
                }
            } else {
                ((DynamicObject)deliverEntrys.get(i)).set("d_actqty", (Object)actualQty.subtract(backwriteQty));
                backwriteQty = BigDecimal.ZERO;
            }
            ((DynamicObject)deliverEntrys.get(i)).set("d_actdeliverydate", (Object)outStockDate);
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        DynamicObject[] srcDataEntities = e.getSrcDataEntities();
        if ("sm_salorder".equals(srcSubMainType.getName()) || "sm_returnapply".equals(srcSubMainType.getName()) || "sm_delivernotice".equals(srcSubMainType.getName())) {
            this.autoSetCloseInfo(srcDataEntities);
        }
        if ("sm_delivernotice".equals(srcSubMainType.getName()) && "Audit".equals(opType)) {
            this.setDelivEntryids(srcDataEntities);
        }
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        super.afterExcessCheck(e);
        String opType = this.getOpType();
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        if ("sm_salorder".equals(srcSubMainType.getName()) && opType.equalsIgnoreCase("audit")) {
            boolean isControlDay;
            DynamicObject srcActiveRow = e.getSrcActiveRow();
            DynamicObject targetActiveRow = e.getTargetActiveRow();
            DynamicObject salOutBill = (DynamicObject)targetActiveRow.getParent();
            boolean isVirtualBill = salOutBill.getBoolean("isvirtualbill");
            if (isVirtualBill) {
                return;
            }
            DynamicObject bizType = salOutBill.getDynamicObject("biztype");
            if (bizType != null) {
                Long pkValue = (Long)bizType.getPkValue();
                ArrayList<Long> fundBizTypeIds = new ArrayList<Long>();
                fundBizTypeIds.add(this.BIZTYPE_REFUND);
                fundBizTypeIds.add(this.BIZTYPE_BACKFILL);
                if (fundBizTypeIds.contains(pkValue)) {
                    return;
                }
            }
            if (isControlDay = srcActiveRow.getBoolean("iscontrolday")) {
                Date deliverDate = (Date)srcActiveRow.get("deliverydate");
                if (deliverDate == null) {
                    return;
                }
                Date salOutDate = salOutBill.getDate("biztime");
                int ahead = srcActiveRow.getInt("deliveradvdays");
                int delay = srcActiveRow.getInt("deliverdelaydays");
                int rowSeq = targetActiveRow.getInt("seq");
                Date aheadDate = this.getTargetDate(deliverDate, -ahead);
                Date delayDate = this.getTargetDate(deliverDate, delay);
                if (salOutDate.before(aheadDate) || salOutDate.after(delayDate)) {
                    e.setExcess(true);
                    String message = e.getMessage();
                    StringBuilder sb = new StringBuilder();
                    if (message != null) {
                        sb.append(message);
                    }
                    String dataMessage = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\uff0c\u51fa\u5e93\u65e5\u671f\u8d85\u51fa\u4e86\u7269\u6599\u5141\u8bb8\u53d1\u8d27\u7684\u63a7\u5236\u5929\u6570\u3002", (String)"SalesOrder2OutWriteBackPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                    dataMessage = String.format(dataMessage, rowSeq);
                    e.setMessage(sb.append(dataMessage).toString());
                }
            }
        }
    }

    private Date getTargetDate(Date deliverDate, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(deliverDate);
        calendar.add(5, days);
        return calendar.getTime();
    }

    private void autoSetCloseInfo(DynamicObject[] srcDataEntities) {
        ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>();
        for (int i = 0; i < srcDataEntities.length; ++i) {
            if (srcDataEntities[i].get(CLOSESTATUS).equals("B")) {
                if (srcDataEntities[i].get(CLOSER) != null || srcDataEntities[i].get(CLOSEDATE) != null) continue;
                srcDataEntities[i].set(CLOSER, (Object)ADMINISTRATORID);
                srcDataEntities[i].set(CLOSEDATE, (Object)TimeServiceHelper.now());
                saveValue.add(srcDataEntities[i]);
                continue;
            }
            if (srcDataEntities[i].get(CLOSER) == null && srcDataEntities[i].get(CLOSEDATE) == null) continue;
            srcDataEntities[i].set(CLOSER, null);
            srcDataEntities[i].set(CLOSEDATE, null);
            saveValue.add(srcDataEntities[i]);
        }
        if (saveValue.size() > 0) {
            DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
            SaveServiceHelper.save((DynamicObject[])saveValues);
        }
    }

    private void setDelivEntryids(DynamicObject[] srcDataEntities) {
        ArrayList<Long> ids = new ArrayList<Long>(srcDataEntities.length);
        for (DynamicObject delbill : srcDataEntities) {
            ids.add((Long)delbill.getPkValue());
        }
        DynamicObjectCollection entrys = QueryServiceHelper.query((String)"sm_delivernotice", (String)"billentry.id entryid,billentry.rowclosestatus rowclosestatus,billentry.baseqty baseqty,billentry.invbaseqty invbaseqty,billentry.deliverbaseqtydown deliverbaseqtydown", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        ArrayList<Long> entryIds = new ArrayList<Long>(8);
        for (DynamicObject entry : entrys) {
            String rowCloseStatus = entry.getString("rowclosestatus");
            BigDecimal baseqty = entry.getBigDecimal("baseqty");
            BigDecimal invbaseqty = entry.getBigDecimal("invbaseqty");
            BigDecimal downBaseQty = entry.getBigDecimal("deliverbaseqtydown");
            if (invbaseqty == null || downBaseQty == null || baseqty == null || invbaseqty.compareTo(downBaseQty) < 0 || invbaseqty.compareTo(baseqty) >= 0 || !"B".equals(rowCloseStatus)) continue;
            entryIds.add(entry.getLong("entryid"));
        }
        if (entryIds.size() > 0) {
            delivEntryids.set(entryIds);
        }
    }

    public void finishWriteBack(FinishWriteBackEventArgs e) {
        String opType = this.getOpType();
        List entryIds = (List)delivEntryids.get();
        if (entryIds != null && entryIds.size() > 0) {
            try (TXHandle h = TX.requiresNew((String)"doReleaseReserveByEntryIds");){
                try {
                    if ("Audit".equals(opType)) {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"ReserveService", (String)"doReleaseReserveByEntryIds", (Object[])new Object[]{"sm_delivernotice", "rowclose", JSON.toJSONString((Object)entryIds.toArray(new Long[0]))});
                    }
                    if ("UnAudit".equals(opType)) {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"ReserveService", (String)"unDoReleaseReserveByEntryIds", (Object[])new Object[]{"sm_delivernotice", "rowclose", JSON.toJSONString((Object)entryIds.toArray(new Long[0]))});
                    }
                }
                catch (KDBizException ex) {
                    h.markRollback();
                }
            }
            delivEntryids.remove();
        }
    }
}

