/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SctmSub2ImMaterialWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String SUBDELGROUPQTY = "subdelgroupqty";
    private static final String SUBDELBASEQTY = "subdelbaseqty";
    private static final String BASEUNIT = "baseunit";
    private static final String BASEQTY = "baseqty";
    private static final String SUBBASEQTY = "subbaseqty";

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        String opType = this.getOpType();
        if ("sctm_scposublist".equals(e.getSrcMainType().getName()) && "audit".equalsIgnoreCase(opType)) {
            e.getFieldKeys().add(SUBDELGROUPQTY);
            e.getFieldKeys().add("billentry.subdelbaseqty");
        } else if ("sctm_scposublist".equals(e.getSrcMainType().getName()) && "unaudit".equalsIgnoreCase(opType)) {
            e.getFieldKeys().add(SUBDELGROUPQTY);
            e.getFieldKeys().add("billentry.subdelbaseqty");
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        if ("sctm_scposublist".equals(srcSubMainType.getName())) {
            QFilter srcBillIDFilter;
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(16);
            ArrayList<Object> billID = new ArrayList<Object>(16);
            for (DynamicObject srcDataEntity : srcDataEntities) {
                billID.add(srcDataEntity.getPkValue());
            }
            if (billID.size() == 0) {
                return;
            }
            if ("audit".equalsIgnoreCase(opType)) {
                srcBillIDFilter = new QFilter("id", "in", billID);
                DynamicObject[] srcBillDynamics = BusinessDataServiceHelper.load((String)"sctm_scposublist", (String)"id,baseqty,subdelgroupqty,billentry.subdelbaseqty,billentry.qtyratio,billentry.subbaseqty,baseunit", (QFilter[])new QFilter[]{srcBillIDFilter});
                if (srcBillDynamics == null || srcBillDynamics.length == 0) {
                    return;
                }
                SctmSub2ImMaterialWriteBackPlugin.getSaveBills(srcBillDynamics, bills);
            } else if ("unaudit".equalsIgnoreCase(opType)) {
                srcBillIDFilter = new QFilter("id", "in", billID);
                DynamicObject[] srcBillDynamics = BusinessDataServiceHelper.load((String)"sctm_scposublist", (String)"id,baseqty,subdelgroupqty,billentry.subdelbaseqty,billentry.qtyratio,billentry.subbaseqty,baseunit", (QFilter[])new QFilter[]{srcBillIDFilter});
                if (srcBillDynamics == null || srcBillDynamics.length == 0) {
                    return;
                }
                SctmSub2ImMaterialWriteBackPlugin.getSaveBills(srcBillDynamics, bills);
            }
            if (bills.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[bills.size()]));
            }
        }
    }

    private static void getSaveBills(DynamicObject[] srcBillDynamics, List<DynamicObject> bills) {
        if (srcBillDynamics == null || srcBillDynamics.length == 0 || bills == null) {
            return;
        }
        for (DynamicObject srcDataEntity : srcBillDynamics) {
            BigDecimal minQty = null;
            BigDecimal zero = new BigDecimal(0);
            DynamicObject baseUnit = srcDataEntity.getDynamicObject(BASEUNIT);
            BigDecimal baseQty = srcDataEntity.getBigDecimal(BASEQTY);
            if (baseUnit == null || baseQty == null) {
                return;
            }
            DynamicObjectCollection srcDyObjCollection = srcDataEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject srcDynamicObject : srcDyObjCollection) {
                BigDecimal subDelBaseQty = srcDynamicObject.getBigDecimal(SUBDELBASEQTY);
                BigDecimal qtyRatio = srcDynamicObject.getBigDecimal("qtyratio");
                BigDecimal subBaseQty = srcDynamicObject.getBigDecimal(SUBBASEQTY);
                if (subDelBaseQty == null || subDelBaseQty.compareTo(zero) == 0 || subBaseQty == null || subBaseQty.compareTo(zero) == 0) {
                    minQty = new BigDecimal(0);
                    break;
                }
                BigDecimal rowSubDelGroupQty = baseQty.multiply(subDelBaseQty).divide(subBaseQty, SctmSub2ImMaterialWriteBackPlugin.getPrecision(baseUnit), SctmSub2ImMaterialWriteBackPlugin.getPrecisionType(baseUnit));
                if (minQty == null) {
                    minQty = rowSubDelGroupQty;
                }
                if (rowSubDelGroupQty.compareTo(minQty) >= 0) continue;
                minQty = rowSubDelGroupQty;
            }
            BigDecimal subDelGroupQty = srcDataEntity.getBigDecimal(SUBDELGROUPQTY);
            if (minQty == null || subDelGroupQty == null || subDelGroupQty.compareTo(minQty) == 0) continue;
            srcDataEntity.set(SUBDELGROUPQTY, minQty);
            bills.add(srcDataEntity);
        }
    }

    private static int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt("precision");
        }
        return precision;
    }

    private static int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get("precisionaccount"))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString("precisionaccount")) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }
}

