/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TransDirToSaleOrderWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String SOURCESALEENTITY = "ocbsoc_saleorder";
    private static final String OP_AUDIT = "audit";
    private static final String OP_UNAUDIT = "unaudit";
    private static final String SIGNSTATUS = "signstatus";
    private static final String BILLSTATUS = "billstatus";
    private static final String APPROVEBASEQTY = "approvebaseqty";
    private static final String TOTALINSTOCKBASEQTY = "totalinstockbaseqty";
    private static final String TOTALOUTSTOCKBASEQTY = "totaloutstockbaseqty";

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if (SOURCESALEENTITY.equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add(APPROVEBASEQTY);
            e.getFieldKeys().add(TOTALINSTOCKBASEQTY);
            e.getFieldKeys().add(TOTALOUTSTOCKBASEQTY);
            e.getFieldKeys().add(SIGNSTATUS);
            e.getFieldKeys().add(BILLSTATUS);
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        List<Object> saveValue = new ArrayList(16);
        if (SOURCESALEENTITY.equals(srcSubMainType.getName()) && (opType.equalsIgnoreCase(OP_AUDIT) || opType.equalsIgnoreCase(OP_UNAUDIT))) {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            Map<Object, DynamicObject> saleOrderMap = this.querySrcData(srcDataEntities, SOURCESALEENTITY);
            saveValue = this.getSaleOrderSaveValues(saleOrderMap, srcDataEntities);
        }
        if (!CollectionUtils.isEmpty(saveValue)) {
            DynamicObject[] saveValues = saveValue.toArray(new DynamicObject[saveValue.size()]);
            SaveServiceHelper.save((DynamicObject[])saveValues);
        }
    }

    private Map<Object, DynamicObject> querySrcData(DynamicObject[] srcDataEntities, String sourceEntity) {
        if (srcDataEntities == null) {
            return new HashMap<Object, DynamicObject>(0);
        }
        HashSet<Object> srcPkValues = new HashSet<Object>(srcDataEntities.length);
        for (DynamicObject srcDataEntity : srcDataEntities) {
            srcPkValues.add(srcDataEntity.getPkValue());
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])srcPkValues.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntity));
    }

    private List<DynamicObject> getSaleOrderSaveValues(Map<Object, DynamicObject> saleOrderMap, DynamicObject[] srcDataEntities) {
        if (saleOrderMap != null && saleOrderMap.size() > 0) {
            ArrayList<DynamicObject> saveValue = new ArrayList<DynamicObject>(saleOrderMap.size());
            for (DynamicObject srcEntity : srcDataEntities) {
                DynamicObject saleOrder = saleOrderMap.get(srcEntity.getPkValue());
                DynamicObjectCollection itementry = saleOrder.getDynamicObjectCollection("itementry");
                if (CollectionUtils.isEmpty((Collection)itementry)) continue;
                List itemEntryDynObjList = itementry.stream().filter(m -> m.getLong("combinationid_id") == 0L || m.getLong("combineparentid") > 0L).collect(Collectors.toList());
                BigDecimal totalInstockBaseQty = itemEntryDynObjList.stream().map(m -> m.getBigDecimal(TOTALINSTOCKBASEQTY)).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalApproveBaseQty = itemEntryDynObjList.stream().map(m -> m.getBigDecimal(APPROVEBASEQTY)).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalOutstockBaseQty = itemEntryDynObjList.stream().map(m -> m.getBigDecimal(TOTALOUTSTOCKBASEQTY)).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.setStatus(totalInstockBaseQty, totalOutstockBaseQty, totalApproveBaseQty, saleOrder);
                saveValue.add(saleOrder);
            }
            return saveValue;
        }
        return new ArrayList<DynamicObject>(0);
    }

    private void setStatus(BigDecimal totalInstockBaseQty, BigDecimal totalOutstockBaseQty, BigDecimal totalApproveBaseQty, DynamicObject saleOrder) {
        if (totalInstockBaseQty.compareTo(BigDecimal.ZERO) > 0) {
            if (totalInstockBaseQty.compareTo(totalApproveBaseQty) == 0) {
                saleOrder.set(SIGNSTATUS, (Object)"D");
            } else {
                saleOrder.set(SIGNSTATUS, (Object)"C");
            }
        } else {
            saleOrder.set(SIGNSTATUS, (Object)"A");
        }
        if (totalInstockBaseQty.compareTo(totalApproveBaseQty) == 0) {
            saleOrder.set(BILLSTATUS, (Object)"F");
        } else if (totalOutstockBaseQty.compareTo(totalApproveBaseQty) == 0) {
            saleOrder.set(BILLSTATUS, (Object)"E");
        } else if (totalOutstockBaseQty.compareTo(BigDecimal.ZERO) > 0 && totalOutstockBaseQty.compareTo(totalApproveBaseQty) < 0) {
            saleOrder.set(BILLSTATUS, (Object)"D");
        } else {
            saleOrder.set(BILLSTATUS, (Object)"C");
        }
    }
}

