/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.algorithm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.algorithm.AbstractAlgorithm;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public abstract class AbstractTaxAlgorithm
extends AbstractAlgorithm {
    protected static Log log = LogFactory.getLog(AbstractTaxAlgorithm.class);
    protected int amountPrecision = 2;
    protected int curAmountPrecision = 2;
    protected int pricePrecision = 10;
    protected int curPricePrecision = 10;
    private static final String DIRECT_QUTATION = "0";
    private static final String INDIRECT_QUTATION = "1";

    protected void initPrecision() {
        DynamicObject curCurrency;
        DynamicObject currency = (DynamicObject)this.getValue("settlecurrency");
        if (currency != null) {
            this.amountPrecision = currency.getInt("amtprecision");
        }
        if ((curCurrency = (DynamicObject)this.getValue("currency")) != null) {
            this.curAmountPrecision = curCurrency.getInt("amtprecision");
        }
    }

    public boolean calByChange(String key) {
        boolean hasCal = true;
        switch (key) {
            case "currency": 
            case "biztime": 
            case "exchangerate": 
            case "quotation": {
                this.calByExchangeRate();
                break;
            }
            case "settlecurrency": {
                this.calBySettleCurrency();
                break;
            }
            case "istax": {
                this.calByIsTax();
                break;
            }
            default: {
                hasCal = false;
            }
        }
        return hasCal;
    }

    private void calByIsTax() {
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            this.calFarmieldsByCurAmount(i);
        }
    }

    private void calByExchangeRate() {
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            this.calEntryCurFileds(i);
        }
    }

    private void calBySettleCurrency() {
        int size = this.getEntrySize();
        if (this.hasTax()) {
            for (int i = 0; i < size; ++i) {
                this.calAmountAndTaxByCur(i);
                this.calTaxAmount(i);
                this.calCurTaxAmount(i);
                this.calAmount(i);
                this.calCurAmount(i);
                this.calTaxPriceByAmountAndTax(i);
                this.calPrice(i);
                this.calDiscountAmount(i);
                this.calActualPrice(i);
                this.calActualTaxPrice(i);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.calAmountByCur(i);
                this.calTaxAmount(i);
                this.calCurTaxAmount(i);
                this.calAmountAndTax(i);
                this.calCurAmountAndTax(i);
                this.calPriceByAmount(i);
                this.calPriceAndTax(i);
                this.calDiscountAmount(i);
                this.calActualPrice(i);
                this.calActualTaxPrice(i);
            }
        }
    }

    public boolean calByEntryChange(String key, int i) {
        boolean hasCal = true;
        switch (key) {
            case "qty": {
                this.calByQty(i);
                break;
            }
            case "qtyunit2nd": {
                this.calByQty(i);
                break;
            }
            case "price": {
                this.calByPrice(i);
                break;
            }
            case "taxrate": {
                this.calByTaxRate(i);
                break;
            }
            case "priceandtax": {
                this.calByPriceAndTax(i);
                break;
            }
            case "discounttype": {
                this.calByDiscountType(i);
                break;
            }
            case "discountrate": {
                this.calByDiscountRate(i);
                break;
            }
            case "discountamount": {
                this.calByDiscountAmount(i);
                break;
            }
            case "actualprice": {
                this.calByActualPrice(i);
                break;
            }
            case "actualtaxprice": {
                this.calByActualTaxPrice(i);
                break;
            }
            case "taxamount": {
                this.calByTaxAmount(i);
                break;
            }
            case "amount": {
                this.calByAmount(i);
                break;
            }
            case "amountandtax": {
                this.calByAmountAndTax(i);
                break;
            }
            case "deductiblerate": {
                this.calByEductibleRate(i);
                break;
            }
            case "intercostamt": {
                this.calByIntercostAmt(i);
                break;
            }
            case "taxpayertype": {
                this.calCostAmtByTaxPayer(i);
                break;
            }
            default: {
                hasCal = false;
            }
        }
        return hasCal;
    }

    protected void calByQty(int i) {
        if (this.hasTax()) {
            this.calPrice(i);
        } else {
            this.calPriceAndTax(i);
        }
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calEntryCurFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    protected void calByPrice(int i) {
        this.calPriceAndTax(i);
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calEntryCurFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    protected void calByTaxRate(int i) {
        if (this.hasTax()) {
            this.calByPriceAndTax(i);
        } else {
            this.calByPrice(i);
        }
    }

    protected void calByPriceAndTax(int i) {
        this.calPrice(i);
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calEntryCurFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    protected void calByDiscountType(int i) {
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calEntryCurFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    protected void calByDiscountAmount(int i) {
        this.calDiscountRate(i);
        this.calEntryAmountFileds(i);
        this.calEntryCurFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    protected void calByDiscountRate(int i) {
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calEntryCurFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    protected void calByTaxAmount(int i) {
        if (this.hasTax()) {
            this.calCurTaxAmount(i);
            this.calAmount(i);
            this.calCurAmount(i);
        } else {
            this.calCurTaxAmount(i);
            this.calAmountAndTax(i);
            this.calCurAmountAndTax(i);
        }
    }

    protected void calByActualPrice(int i) {
        this.calDiscountRateByActualPrice(i);
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calEntryCurFileds(i);
        this.calActualTaxPrice(i);
    }

    protected void calByActualTaxPrice(int i) {
        this.calDiscountRateByActualTaxPrice(i);
        this.calDiscountAmount(i);
        if (this.hasTax()) {
            this.calAmountAndTaxByActualTaxPrice(i);
            this.calTaxAmount(i);
            this.calAmount(i);
        } else {
            this.calAmount(i);
            this.calTaxAmount(i);
            this.calAmountAndTax(i);
        }
        this.calEntryCurFileds(i);
        this.calActualPrice(i);
    }

    protected void calByAmount(int i) {
        this.calCurAmount(i);
        this.calTaxAmount(i);
        this.calCurTaxAmount(i);
        this.calAmountAndTax(i);
        this.calCurAmountAndTax(i);
        this.calPriceByAmount(i);
        this.calPriceAndTax(i);
        this.calDiscountAmount(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    protected void calByAmountAndTax(int i) {
        this.calCurAmountAndTax(i);
        this.calTaxAmount(i);
        this.calCurTaxAmount(i);
        this.calAmount(i);
        this.calCurAmount(i);
        this.calTaxPriceByAmountAndTax(i);
        this.calPrice(i);
        this.calDiscountAmount(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    protected void calByEductibleRate(int i) {
        this.calFarmieldsByCurAmount(i);
    }

    private void calPrice(int i) {
        BigDecimal taxPrice = this.getNullToZero("priceandtax", i);
        BigDecimal taxRate = this.getNullToZero("taxrate", i);
        BigDecimal price = BigDecimalConstants.ZERO;
        if (taxPrice != null) {
            BigDecimal zero = BigDecimalConstants.ZERO;
            BigDecimal one = BigDecimalConstants.ONE;
            BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
            taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, taxRate.scale() + 2, 4);
            price = taxPrice.divide(one.add(taxRate), this.pricePrecision, 4);
        }
        this.setValue("price", price, i);
    }

    private void calPriceAndTax(int i) {
        BigDecimal price = this.getNullToZero("price", i);
        BigDecimal taxRate = this.getNullToZero("taxrate", i);
        BigDecimal taxPrice = BigDecimalConstants.ZERO;
        BigDecimal one = BigDecimalConstants.ONE;
        BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
        taxRate = taxRate.divide(oneHundred, taxRate.scale() + 2, 4);
        taxPrice = price.multiply(one.add(taxRate));
        taxPrice = taxPrice.setScale(this.pricePrecision, 4);
        this.setValue("priceandtax", taxPrice, i);
    }

    protected void calPriceByAmount(int i) {
        String discountType = (String)this.getValue("discounttype", i);
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal qty = this.getNullToZero("qty", i);
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal amount = this.getNullToZero("amount", i);
        if (StringUtils.isEmpty((CharSequence)discountType)) {
            if (amount.compareTo(BigDecimal.ZERO) != 0) {
                price = amount.divide(qty, this.pricePrecision, 4);
            }
        } else {
            DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
            if (null == discountTypeEnum) {
                return;
            }
            BigDecimal discount = this.getNullToZero("discountrate", i);
            switch (discountTypeEnum) {
                case DISRATE: {
                    if (amount.compareTo(BigDecimal.ZERO) == 0) break;
                    if (discount.compareTo(BigDecimal.ZERO) != 0) {
                        discount = discount.divide(BigDecimalConstants.ONEHUNDRED, discount.scale() + 2, 4);
                    }
                    if (discount.compareTo(BigDecimalConstants.ONE) == 0) break;
                    price = amount.divide(qty.multiply(BigDecimal.ONE.subtract(discount)), this.pricePrecision, 4);
                    break;
                }
                case UNITDIS: 
                case DISAMT: {
                    if (amount.compareTo(BigDecimal.ZERO) == 0) break;
                    price = amount.divide(qty, this.pricePrecision, 4).add(discount);
                    break;
                }
                case NULL: {
                    if (amount.compareTo(BigDecimal.ZERO) == 0) break;
                    price = amount.divide(qty, this.pricePrecision, 4);
                    break;
                }
            }
        }
        this.setValue("price", price, i);
    }

    protected void calTaxPriceByAmountAndTax(int i) {
        String discountType = (String)this.getValue("discounttype", i);
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal qty = this.getNullToZero("qty", i);
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal itemAmount = this.getNullToZero("amountandtax", i);
        if (StringUtils.isEmpty((CharSequence)discountType)) {
            if (itemAmount.compareTo(BigDecimal.ZERO) != 0) {
                taxPrice = itemAmount.divide(qty, this.pricePrecision, 4);
            }
        } else {
            DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
            if (null == discountTypeEnum) {
                return;
            }
            BigDecimal discount = this.getNullToZero("discountrate", i);
            switch (discountTypeEnum) {
                case DISRATE: {
                    if (itemAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    if (discount.compareTo(BigDecimal.ZERO) != 0) {
                        discount = discount.divide(BigDecimalConstants.ONEHUNDRED, discount.scale() + 2, 4);
                    }
                    if (discount.compareTo(BigDecimalConstants.ONE) == 0) break;
                    taxPrice = itemAmount.divide(qty.multiply(BigDecimal.ONE.subtract(discount)), this.pricePrecision, 4);
                    break;
                }
                case UNITDIS: 
                case DISAMT: {
                    if (itemAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    taxPrice = itemAmount.divide(qty, this.pricePrecision, 4).add(discount);
                    break;
                }
                case NULL: {
                    if (itemAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    taxPrice = itemAmount.divide(qty, this.pricePrecision, 4);
                    break;
                }
            }
        }
        this.setValue("priceandtax", taxPrice, i);
    }

    private void calDiscountRate(int i) {
        int discountRatePrecision = 4;
        BigDecimal taxPrice = this.getNullToZero("priceandtax", i);
        BigDecimal taxRate = this.getNullToZero("taxrate", i);
        BigDecimal qty = this.getNullToZero("qty", i);
        BigDecimal discountAmount = this.getNullToZero("discountamount", i);
        String discountType = (String)this.getValue("discounttype", i);
        BigDecimal discountRate = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(qty) != 0 && BigDecimal.ZERO.compareTo(taxPrice) != 0 && StringUtils.isNotEmpty((CharSequence)discountType)) {
            DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
            if (null == discountTypeEnum) {
                return;
            }
            switch (discountTypeEnum) {
                case DISRATE: {
                    discountRate = discountAmount.multiply(BigDecimalConstants.ONEHUNDRED).divide(qty.multiply(taxPrice), discountRatePrecision, 4);
                    break;
                }
                case UNITDIS: 
                case DISAMT: {
                    if (this.hasTax()) {
                        discountRate = discountAmount.divide(qty, this.pricePrecision, 4);
                        break;
                    }
                    taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                    discountRate = discountAmount.divide(qty.multiply(BigDecimal.ONE.add(taxRate)), this.pricePrecision, 4);
                    break;
                }
                case NULL: {
                    break;
                }
            }
        }
        this.setValue("discountrate", discountRate, i);
    }

    protected void calDiscountRateByActualPrice(int i) {
        int discountRatePrecision = 4;
        BigDecimal price = this.getNullToZero("price", i);
        BigDecimal actualPrice = this.getNullToZero("actualprice", i);
        String discountType = (String)this.getValue("discounttype", i);
        BigDecimal discountRate = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)discountType)) {
            DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
            if (null == discountTypeEnum) {
                return;
            }
            switch (discountTypeEnum) {
                case DISRATE: {
                    if (BigDecimal.ZERO.compareTo(price) == 0) break;
                    discountRate = price.subtract(actualPrice).multiply(BigDecimalConstants.ONEHUNDRED).divide(price, discountRatePrecision, 4);
                    break;
                }
                case UNITDIS: 
                case DISAMT: {
                    discountRate = price.subtract(actualPrice);
                    break;
                }
                case NULL: {
                    break;
                }
            }
        }
        this.setValue("discountrate", discountRate, i);
    }

    private void calDiscountRateByActualTaxPrice(int i) {
        int discountRatePrecision = 4;
        BigDecimal price = this.getNullToZero("priceandtax", i);
        BigDecimal actualPrice = this.getNullToZero("actualtaxprice", i);
        String discountType = (String)this.getValue("discounttype", i);
        BigDecimal discountRate = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)discountType)) {
            DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
            if (null == discountTypeEnum) {
                return;
            }
            switch (discountTypeEnum) {
                case DISRATE: {
                    if (BigDecimal.ZERO.compareTo(price) == 0) break;
                    discountRate = price.subtract(actualPrice).multiply(BigDecimalConstants.ONEHUNDRED).divide(price, discountRatePrecision, 4);
                    break;
                }
                case UNITDIS: 
                case DISAMT: {
                    discountRate = price.subtract(actualPrice);
                    break;
                }
                case NULL: {
                    break;
                }
            }
        }
        this.setValue("discountrate", discountRate, i);
    }

    public void calDiscountAmount(int i) {
        BigDecimal price = this.getNullToZero("priceandtax", i);
        BigDecimal qty = this.getNullToZero("qty", i);
        BigDecimal discountRate = this.getNullToZero("discountrate", i);
        String discountType = (String)this.getValue("discounttype", i);
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)discountType)) {
            DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
            if (null == discountTypeEnum) {
                return;
            }
            switch (discountTypeEnum) {
                case DISRATE: {
                    discountAmount = price.multiply(qty).multiply(discountRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4)).setScale(this.amountPrecision, 4);
                    break;
                }
                case UNITDIS: 
                case DISAMT: {
                    if (discountRate.compareTo(price) > 0) {
                        discountRate = BigDecimal.ZERO;
                        this.setValue("discountrate", discountRate, i);
                    }
                    if (this.hasTax()) {
                        discountAmount = qty.multiply(discountRate).setScale(this.amountPrecision, 4);
                        break;
                    }
                    BigDecimal taxRate = this.getNullToZero("taxrate", i);
                    taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4);
                    discountAmount = qty.multiply(discountRate).multiply(BigDecimal.ONE.add(taxRate)).setScale(this.amountPrecision, 4);
                    break;
                }
                case NULL: {
                    break;
                }
            }
        }
        this.setValue("discountamount", discountAmount, i);
    }

    private void calActualPrice(int i) {
        BigDecimal discountAmount = this.getNullToZero("discountamount", i);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal price = this.getNullToZero("price", i);
            this.setValue("actualprice", price, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            if (BigDecimal.ZERO.compareTo(amount) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                this.setValue("actualprice", BigDecimal.ZERO, i);
            } else {
                BigDecimal price = amount.divide(qty, this.pricePrecision, 4);
                this.setValue("actualprice", price, i);
            }
        }
    }

    private void calActualTaxPrice(int i) {
        BigDecimal discountAmount = this.getNullToZero("discountamount", i);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal taxPrice = this.getNullToZero("priceandtax", i);
            this.setValue("actualtaxprice", taxPrice, i);
        } else {
            BigDecimal amountAndTax = this.getNullToZero("amountandtax", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            if (BigDecimal.ZERO.compareTo(amountAndTax) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                this.setValue("actualtaxprice", BigDecimal.ZERO, i);
            } else {
                BigDecimal taxPrice = amountAndTax.divide(qty, this.pricePrecision, 4);
                this.setValue("actualtaxprice", taxPrice, i);
            }
        }
    }

    private void calAmountAndTaxByActualTaxPrice(int i) {
        if (this.hasTax()) {
            BigDecimal priceAndTax = this.getNullToZero("priceandtax", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            BigDecimal taxAmount = BigDecimal.ZERO;
            BigDecimal discountRate = this.getNullToZero("discountrate", i);
            String discountType = (String)this.getValue("discounttype", i);
            if (StringUtils.isNotEmpty((CharSequence)discountType)) {
                DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
                if (null == discountTypeEnum) {
                    return;
                }
                switch (discountTypeEnum) {
                    case DISRATE: {
                        taxAmount = priceAndTax.multiply(qty).multiply(BigDecimal.ONE.subtract(discountRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4)));
                        break;
                    }
                    case UNITDIS: 
                    case DISAMT: {
                        taxAmount = qty.multiply(priceAndTax.subtract(discountRate)).setScale(this.amountPrecision, 4);
                        break;
                    }
                    case NULL: {
                        taxAmount = qty.multiply(priceAndTax).setScale(this.amountPrecision, 4);
                        break;
                    }
                }
            } else {
                taxAmount = qty.multiply(priceAndTax).setScale(this.amountPrecision, 4);
            }
            this.setValue("amountandtax", taxAmount, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal tax = this.getNullToZero("taxamount", i);
            BigDecimal taxAmount = amount.add(tax);
            this.setValue("amountandtax", taxAmount, i);
        }
    }

    private void calAmountAndTax(int i) {
        if (this.hasTax()) {
            BigDecimal priceAndTax = this.getNullToZero("priceandtax", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            BigDecimal taxAmount = BigDecimal.ZERO;
            BigDecimal discountAmount = this.getNullToZero("discountamount", i);
            BigDecimal discountRate = this.getNullToZero("discountrate", i);
            String discountType = (String)this.getValue("discounttype", i);
            taxAmount = DiscountTypeEnum.DISRATE.getValue().equals(discountType) && discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) == 0 ? qty.multiply(priceAndTax).setScale(this.amountPrecision, 4).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(this.amountPrecision, 4);
            AbstractTaxAlgorithm.setTaxAmountErrorTip(taxAmount);
            this.setValue("amountandtax", taxAmount, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal tax = this.getNullToZero("taxamount", i);
            BigDecimal taxAmount = amount.add(tax);
            AbstractTaxAlgorithm.setTaxAmountErrorTip(taxAmount);
            this.setValue("amountandtax", taxAmount, i);
        }
    }

    public static void setTaxAmountErrorTip(BigDecimal taxAmount) {
        if (taxAmount.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_TAX_AMOUNT()));
        }
    }

    private void calAmountAndTaxByCur(int i) {
        BigDecimal exchangeRate = this.getNullToZero("exchangerate");
        BigDecimal curAmountAndTax = this.getNullToZero("curamountandtax", i);
        BigDecimal amountAndTax = BigDecimal.ZERO;
        if (exchangeRate.compareTo(BigDecimal.ZERO) != 0 && curAmountAndTax.compareTo(BigDecimal.ZERO) != 0) {
            Object quotation = this.getValue("quotation");
            if (DIRECT_QUTATION.equals(quotation)) {
                amountAndTax = curAmountAndTax.divide(exchangeRate, this.amountPrecision, RoundingMode.HALF_UP);
            } else if (INDIRECT_QUTATION.equals(quotation)) {
                amountAndTax = curAmountAndTax.multiply(exchangeRate).setScale(this.amountPrecision, RoundingMode.HALF_UP);
            }
        }
        this.setValue("amountandtax", amountAndTax, i);
    }

    private void calCurAmountAndTax(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", i);
            BigDecimal exchangerate = this.getNullToZero("exchangerate");
            BigDecimal localTaxAmount = BigDecimal.ZERO;
            Object quotation = this.getValue("quotation");
            if (DIRECT_QUTATION.equals(quotation)) {
                localTaxAmount = taxAmount.multiply(exchangerate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
            } else if (INDIRECT_QUTATION.equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
                localTaxAmount = taxAmount.divide(exchangerate, this.curAmountPrecision, RoundingMode.HALF_UP);
            }
            this.setValue("curamountandtax", localTaxAmount, i);
        } else {
            BigDecimal localAmount = this.getNullToZero("curamount", i);
            BigDecimal localTax = this.getNullToZero("curtaxamount", i);
            this.setValue("curamountandtax", localAmount.add(localTax), i);
        }
        this.calIntercostAmt(i);
    }

    private void calTaxAmount(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", i);
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            BigDecimal tax = BigDecimalConstants.ZERO;
            if (taxAmount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = taxAmount.multiply(taxRate).divide(taxRate.add(BigDecimalConstants.ONE), this.amountPrecision, 4);
            }
            this.setValue("taxamount", tax, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            BigDecimal tax = BigDecimalConstants.ZERO;
            if (amount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = amount.multiply(taxRate).setScale(this.amountPrecision, 4);
            }
            this.setValue("taxamount", tax, i);
        }
    }

    private void calCurTaxAmount(int i) {
        Object quotation = this.getValue("quotation");
        BigDecimal tax = this.getNullToZero("taxamount", i);
        BigDecimal exchangerate = this.getNullToZero("exchangerate");
        BigDecimal localTax = BigDecimal.ZERO;
        if (DIRECT_QUTATION.equals(quotation)) {
            localTax = tax.multiply(exchangerate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
        } else if (INDIRECT_QUTATION.equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
            localTax = tax.divide(exchangerate, this.curAmountPrecision, RoundingMode.HALF_UP);
        }
        this.setValue("curtaxamount", localTax, i);
    }

    private void calAmount(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", i);
            BigDecimal tax = this.getNullToZero("taxamount", i);
            BigDecimal amount = taxAmount.subtract(tax);
            this.setValue("amount", amount, i);
        } else {
            BigDecimal price = this.getNullToZero("price", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal discountRate = this.getNullToZero("discountrate", i);
            String discountType = (String)this.getValue("discounttype", i);
            if (StringUtils.isNotEmpty((CharSequence)discountType)) {
                DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
                if (null == discountTypeEnum) {
                    return;
                }
                switch (discountTypeEnum) {
                    case DISRATE: {
                        BigDecimal reDiscountRate = discountRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4);
                        amount = price.multiply(qty).multiply(BigDecimal.ONE.subtract(reDiscountRate)).setScale(this.amountPrecision, 4);
                        break;
                    }
                    case UNITDIS: 
                    case DISAMT: {
                        amount = qty.multiply(price.subtract(discountRate)).setScale(this.amountPrecision, 4);
                        break;
                    }
                    case NULL: {
                        amount = qty.multiply(price).setScale(this.amountPrecision, 4);
                        break;
                    }
                }
            } else {
                amount = qty.multiply(price).setScale(this.amountPrecision, 4);
            }
            this.setValue("amount", amount, i);
        }
    }

    private void calAmountByCur(int i) {
        BigDecimal exchangeRate = this.getNullToZero("exchangerate");
        BigDecimal curAmount = this.getNullToZero("curamount", i);
        BigDecimal amount = BigDecimal.ZERO;
        Object quotation = this.getValue("quotation");
        if (exchangeRate.compareTo(BigDecimal.ZERO) != 0 && curAmount.compareTo(BigDecimal.ZERO) != 0) {
            if (DIRECT_QUTATION.equals(quotation)) {
                amount = curAmount.divide(exchangeRate, this.amountPrecision, RoundingMode.HALF_UP);
            } else if (INDIRECT_QUTATION.equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) != 0) {
                amount = curAmount.multiply(exchangeRate).setScale(this.amountPrecision, RoundingMode.HALF_UP);
            }
        }
        this.setValue("amount", amount, i);
    }

    private void calCurAmount(int i) {
        if (this.hasTax()) {
            BigDecimal LocalTaxAmount = this.getNullToZero("curamountandtax", i);
            BigDecimal LocalTax = this.getNullToZero("curtaxamount", i);
            this.setValue("curamount", LocalTaxAmount.subtract(LocalTax), i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal exchangerate = this.getNullToZero("exchangerate");
            Object quotation = this.getValue("quotation");
            BigDecimal localTaxAmount = BigDecimal.ZERO;
            if (DIRECT_QUTATION.equals(quotation)) {
                localTaxAmount = amount.multiply(exchangerate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
            } else if (INDIRECT_QUTATION.equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
                localTaxAmount = amount.divide(exchangerate, this.curAmountPrecision, RoundingMode.HALF_UP);
            }
            this.setValue("curamount", localTaxAmount, i);
        }
        this.calFarmieldsByCurAmount(i);
    }

    private void calCostAmtByTaxPayer(int i) {
        boolean inFarmBillType = this.isPurInFarmBillType();
        if (inFarmBillType || !this.isPurInBill()) {
            return;
        }
        BigDecimal curAmountAndTax = this.getNullToZero("curamountandtax", i);
        BigDecimal curdeductibleAmt = this.getNullToZero("curdeductibleamt", i);
        BigDecimal interCostAmt = curAmountAndTax.subtract(curdeductibleAmt).setScale(this.curAmountPrecision, 4);
        Object taxPayerType = this.getValue("taxpayertype", i);
        if (StringUtils.isBlank((Object)taxPayerType)) {
            interCostAmt = BigDecimal.ZERO;
        }
        this.setValue("intercostamt", interCostAmt, i);
    }

    protected void calFarmieldsByCurAmount(int i) {
        Object taxPayerType;
        String quotation;
        BigDecimal deductibleAmt;
        boolean isPurInBill = this.isPurInBill();
        if (!isPurInBill) {
            return;
        }
        BigDecimal curAmount = this.getNullToZero("curamount", i);
        BigDecimal amount = this.getNullToZero("amount", i);
        BigDecimal deductibleRate = this.getNullToZero("deductiblerate", i);
        deductibleRate = deductibleRate.divide(BigDecimalConstants.ONEHUNDRED, deductibleRate.scale() + 2, 4);
        BigDecimal curAmountAndTax = this.getNullToZero("curamountandtax", i);
        BigDecimal amountAndTax = this.getNullToZero("amountandtax", i);
        if (this.hasTax()) {
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
            deductibleAmt = amountAndTax.multiply(deductibleRate).divide(taxRate.add(BigDecimalConstants.ONE), this.amountPrecision, 4);
        } else {
            deductibleAmt = amount.multiply(deductibleRate).setScale(this.amountPrecision, 4);
        }
        BigDecimal exchangeRate = (BigDecimal)this.getValue("exchangerate");
        if (null == exchangeRate) {
            exchangeRate = BigDecimal.ONE;
        }
        if (DIRECT_QUTATION.equals(quotation = (String)this.getValue("quotation"))) {
            deductibleAmt = deductibleAmt.multiply(exchangeRate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
        } else if (INDIRECT_QUTATION.equals(quotation) && BigDecimal.ZERO.compareTo(exchangeRate) != 0) {
            deductibleAmt = deductibleAmt.divide(exchangeRate, this.curAmountPrecision, RoundingMode.HALF_UP);
        }
        this.setValue("curdeductibleamt", deductibleAmt, i);
        BigDecimal interCostAmt = curAmountAndTax.subtract(deductibleAmt).setScale(this.curAmountPrecision, 4);
        boolean inFarmBillType = this.isPurInFarmBillType();
        if (!inFarmBillType && StringUtils.isBlank((Object)(taxPayerType = this.getValue("taxpayertype", i)))) {
            interCostAmt = BigDecimal.ZERO;
        }
        this.setValue("intercostamt", interCostAmt, i);
    }

    protected void calIntercostAmt(int i) {
        Object taxPayerType;
        boolean isPurInBill = this.isPurInBill();
        if (!isPurInBill) {
            return;
        }
        BigDecimal curAmountAndTax = this.getNullToZero("curamountandtax", i);
        BigDecimal curdeductibleAmt = this.getNullToZero("curdeductibleamt", i);
        BigDecimal interCostAmt = curAmountAndTax.subtract(curdeductibleAmt).setScale(this.curAmountPrecision, 4);
        boolean inFarmBillType = this.isPurInFarmBillType();
        if (!inFarmBillType && StringUtils.isBlank((Object)(taxPayerType = this.getValue("taxpayertype", i)))) {
            interCostAmt = BigDecimal.ZERO;
        }
        this.setValue("intercostamt", interCostAmt, i);
    }

    protected void calByIntercostAmt(int i) {
        BigDecimal curAmountAndTax = this.getNullToZero("curamountandtax", i);
        BigDecimal intercostAmt = this.getNullToZero("intercostamt", i);
        BigDecimal deductibleAmt = curAmountAndTax.subtract(intercostAmt).setScale(this.curAmountPrecision, 4);
        this.setValue("curdeductibleamt", deductibleAmt, i);
    }

    protected boolean isPurInFarmBillType() {
        if (this.getValue("billtype") == null) {
            return false;
        }
        DynamicObject billType = (DynamicObject)this.getValue("billtype");
        if (null == billType) {
            return false;
        }
        return "im_PurInBill_FARM_BT_S".equals(billType.get("number"));
    }

    private boolean isPurInBill() {
        String entityName = this.getEntityName();
        return "im_purinbill".equals(entityName) || "im_ospurinbill".equals(entityName) || "im_mdc_ominbill".equals(entityName);
    }

    protected void calEntryAmountFileds(int i) {
        if (this.hasTax()) {
            this.calAmountAndTax(i);
            this.calTaxAmount(i);
            this.calAmount(i);
        } else {
            this.calAmount(i);
            this.calTaxAmount(i);
            this.calAmountAndTax(i);
        }
    }

    protected void calEntryAmountFiledsValue(int i) {
        this.calAmountValue(i);
    }

    private void calAmountValue(int i) {
        BigDecimal price = this.getNullToZero("price", i);
        BigDecimal qty = this.getNullToZero("qty", i);
        BigDecimal amount = BigDecimal.ZERO;
        amount = qty.multiply(price).setScale(this.amountPrecision, 4);
        this.setValue("amount", amount, i);
    }

    protected void calEntryCurFileds(int i) {
        if (this.hasTax()) {
            this.calCurAmountAndTax(i);
            this.calCurTaxAmount(i);
            this.calCurAmount(i);
        } else {
            this.calCurAmount(i);
            this.calCurTaxAmount(i);
            this.calCurAmountAndTax(i);
        }
    }

    public boolean hasTax() {
        boolean isTax = (Boolean)this.getValue("istax");
        return isTax;
    }
}

