/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balance.recal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.balance.recal.AbstractReCalComsumer;
import kd.scmc.im.business.balance.recal.BalReCalCache;
import kd.scmc.im.business.balance.recal.UpdateByBatchId;
import kd.scmc.im.business.balance.recal.UpdateByOrg;
import kd.scmc.im.business.util.ExceptionUtil;
import org.apache.commons.lang3.StringUtils;

public class BalReCalConsumer
implements MessageConsumer {
    private static final Log LOG = LogFactory.getLog(BalReCalConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object param, String messageId, boolean resend, MessageAcker acker) {
        Long taskId;
        block19: {
            Date now;
            Object idData;
            DynamicObject task;
            block17: {
                block18: {
                    if (resend) {
                        acker.ack(messageId);
                        return;
                    }
                    JSONObject p = null;
                    task = null;
                    idData = null;
                    now = new Date();
                    taskId = null;
                    p = JSON.parseObject((String)((String)param));
                    taskId = p.getLong("taskid");
                    if (!BalReCalCache.isRunning(taskId)) break block17;
                    acker.ack(messageId);
                    if (idData == null) break block18;
                    idData.close();
                }
                BalReCalCache.removeRunning(taskId);
                BalReCalCache.clearTaskPercent(taskId);
                acker.ack(messageId);
                return;
            }
            try {
                BalReCalCache.setRunning(taskId);
                task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"im_bal_recal_log");
                if (task == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\uff08id:{0}\uff09\u4e0d\u5b58\u5728\u3002", (String)"IM-E-447081", (String)"scmc-im-business", (Object[])new Object[]{taskId}));
                }
                AbstractReCalComsumer cal = null;
                String bal = task.getString("bal");
                String ruleId = task.getString("rule");
                if (StringUtils.isNotBlank((CharSequence)bal)) {
                    Date start = task.getDate("start");
                    Long org = task.getDynamicObject("org").getLong("id");
                    cal = new UpdateByOrg(taskId, start, bal, org);
                } else if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                    String billName = task.getString("billname");
                    String fsStr = task.getString("billfs");
                    cal = new UpdateByBatchId(taskId, billName, ruleId, fsStr);
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u6d88\u606f\u8bb0\u5f55\u6709\u8bef\uff1a\u4f59\u989d\u8868\u548c\u89c4\u5219\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"IM-E-773317", (String)"scmc-im-business", (Object[])new Object[0]));
                }
                cal.doUpdate();
                task.set("msgid", (Object)messageId);
                StringBuilder errorMsg = cal.getErrorMsg();
                if (errorMsg.length() > 0) {
                    task.set("status", (Object)"B");
                    task.set("errormsg_tag", (Object)errorMsg.toString());
                } else {
                    task.set("status", (Object)"A");
                    task.set("errormsg_tag", null);
                }
                task.set("truecount", (Object)cal.getSuccesCount());
                task.set("msgstart", (Object)now);
                task.set("msgusertime", (Object)(System.currentTimeMillis() - now.getTime()));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
                acker.ack(messageId);
                if (idData == null) break block19;
            }
            catch (Exception e) {
                block20: {
                    try {
                        try {
                            if (task == null) {
                                task = BusinessDataServiceHelper.newDynamicObject((String)"im_bal_recal_log");
                                task.set("taskno", (Object)"error");
                            }
                            task.set("status", (Object)"B");
                            task.set("errormsg_tag", (Object)ExceptionUtil.parseMsg(e, 1600));
                            task.set("msgid", (Object)messageId);
                            task.set("msgstart", (Object)now);
                            task.set("msgusertime", (Object)(System.currentTimeMillis() - now.getTime()));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
                        }
                        catch (Exception ev) {
                            LOG.error("\u4f59\u989d\u91cd\u7b97\u5f02\u5e38\uff0c\u63d2\u5165\u5931\u8d25\u6d88\u606f\u5f02\u5e38", (Throwable)e);
                        }
                        if (idData == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (idData != null) {
                            idData.close();
                        }
                        BalReCalCache.removeRunning(taskId);
                        BalReCalCache.clearTaskPercent(taskId);
                        acker.ack(messageId);
                        throw throwable;
                    }
                    idData.close();
                }
                BalReCalCache.removeRunning(taskId);
                BalReCalCache.clearTaskPercent(taskId);
                acker.ack(messageId);
            }
            idData.close();
        }
        BalReCalCache.removeRunning(taskId);
        BalReCalCache.clearTaskPercent(taskId);
        acker.ack(messageId);
    }
}

