/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balance.transform.func;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.scmc.im.business.helper.NoUpdateFieldsAnalysisHelper;
import org.apache.commons.lang3.StringUtils;

public class SetNullMapFunc
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta;
    private Map<String, List<String>> colsMap;
    private int referColIndex;
    private Map<String, List<Integer>> indexCache = new HashMap<String, List<Integer>>(8);

    public void setColsMap(Map<String, List<String>> colsMap) {
        this.colsMap = colsMap;
    }

    public SetNullMapFunc(RowMeta rowMeta, String referCol) {
        this.rowMeta = rowMeta;
        this.referColIndex = this.rowMeta.getFieldIndex(referCol, false);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public Object[] map(Row row) {
        String funcName;
        Object[] data = RowUtil.toArray((Row)row);
        if (this.referColIndex < 0) {
            return data;
        }
        String referCol = row.getString(this.referColIndex);
        if (StringUtils.isNotBlank((CharSequence)referCol) && "setnull".equals(funcName = NoUpdateFieldsAnalysisHelper.getFuncName(referCol))) {
            List<Integer> indexs = this.indexCache.get(referCol);
            if (indexs == null) {
                indexs = this.parseIndexs(referCol);
                this.indexCache.put(referCol, indexs);
            }
            for (int i : indexs) {
                if (i < 0) continue;
                data[i] = null;
            }
        }
        return data;
    }

    private List<Integer> parseIndexs(String referCol) {
        List<String> noUpdateFieldsList = NoUpdateFieldsAnalysisHelper.getNoUpdateFieldsList(referCol);
        int size = noUpdateFieldsList.size();
        ArrayList<Integer> colIndexs = new ArrayList<Integer>(8);
        for (int i = 0; i < size; ++i) {
            String field = noUpdateFieldsList.get(i);
            List<String> balKeys = this.colsMap.get(field);
            if (balKeys == null) continue;
            for (String balKey : balKeys) {
                if (!StringUtils.isNotBlank((CharSequence)balKey)) continue;
                int fieldIndex = this.rowMeta.getFieldIndex(balKey);
                colIndexs.add(fieldIndex);
            }
        }
        return colIndexs;
    }
}

