/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;

public class BalanceInvStepExecutor {
    private Log logger = LogFactory.getLog(BalanceInvStepExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String entityNum, Object[] entryIds, Long balanceOrgId, Long balanceLogId) {
        ArrayList<Long> entryIdList = new ArrayList<Long>(entryIds.length);
        for (Object id : entryIds) {
            entryIdList.add((Long)id);
        }
        String selector = "balanceorg,calcnum,scheme,status,starttime,endtime,processrate,timespan,entryentity.calstep,entryentity.calstep.implclass,entryentity.processdata,entryentity.steptimespan,entryentity.stepresult,entryentity.detailmsg,entryentity.detailmsg_tag";
        DynamicObject balanceLogInfo = BusinessDataServiceHelper.loadSingle((Object)balanceLogId, (String)BalanceInvLogConstants.ENTITY_NUM, (String)selector);
        BalanceInvContext ctx = BalanceInvContext.get();
        ctx.setEntryIds(entryIdList);
        ctx.setEntityNum(entityNum);
        if (null != balanceLogInfo.getDynamicObject(BalanceInvLogConstants.SCHEME)) {
            ctx.setSchemeId(balanceLogInfo.getDynamicObject(BalanceInvLogConstants.SCHEME).getLong("id"));
        }
        ctx.setBalanceOrgId(balanceOrgId);
        String calNum = balanceLogInfo.getString(BalanceInvLogConstants.CAL_NUM);
        ctx.setCalcNum(calNum);
        this.logger.info("\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\u5f00\u59cb\uff0c\u8fd0\u7b97\u7f16\u7801\uff1a" + calNum);
        StringBuilder lockDescription = new StringBuilder();
        String balanceInvMsg = ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93", (String)"BalanceInvStepExecutor_0", (String)"scmc-im-business", (Object[])new Object[0]);
        lockDescription.append(balanceInvMsg);
        lockDescription.append("-").append(balanceOrgId);
        DLock lock = DLock.create((String)("balnaceinv-" + balanceOrgId), (String)lockDescription.toString());
        ctx.setLock(lock);
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("balanceInventory");
        String calStatus = BalanceInvLogConstants.STATUS_SUCCESS;
        try {
            int processRate = 0;
            DynamicObjectCollection logEntries = balanceLogInfo.getDynamicObjectCollection(BalanceInvLogConstants.ENTRY_ENTITY);
            for (int i = 0; i < logEntries.size(); ++i) {
                if (BalanceInvLogConstants.STATUS_FAIL.equals(calStatus) && i < logEntries.size() - 1) continue;
                DynamicObject logEntry = (DynamicObject)logEntries.get(i);
                long startTime = System.currentTimeMillis();
                String status = this.getStatus(calNum);
                StepResult stepResult = new StepResult();
                if (BalanceInvLogConstants.STATUS_USER_STOP.equals(status) && i < logEntries.size() - 1) {
                    stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_C);
                } else {
                    stepResult = this.executeStep(logEntry);
                    processRate += 9;
                }
                long endTime = System.currentTimeMillis();
                String stepTimeSpan = new BigDecimal(String.valueOf(endTime - startTime)).divide(new BigDecimal("60000"), 4, RoundingMode.UP).toPlainString();
                BalanceInvStepExecutor.updateBalanceLog(balanceLogInfo, logEntry, stepResult, stepTimeSpan, processRate);
                if (stepResult.isSuccess().booleanValue()) continue;
                calStatus = BalanceInvLogConstants.STATUS_FAIL;
            }
            Date startTime = balanceLogInfo.getDate(BalanceInvLogConstants.START_TIME);
            Date endTime = TimeServiceHelper.now();
            balanceLogInfo.set(BalanceInvLogConstants.END_TIME, (Object)endTime);
            String timeSpan = new BigDecimal(String.valueOf(endTime.getTime() - startTime.getTime())).divide(new BigDecimal("60000"), 4, RoundingMode.UP).toPlainString();
            balanceLogInfo.set(BalanceInvLogConstants.TIME_SPAN, (Object)timeSpan);
            String status = this.getStatus(calNum);
            if (BalanceInvLogConstants.STATUS_USER_STOP.equals(status)) {
                calStatus = BalanceInvLogConstants.STATUS_USER_STOP;
            }
            balanceLogInfo.set(BalanceInvLogConstants.STATUS, (Object)calStatus);
            if (BalanceInvLogConstants.STATUS_SUCCESS.equals(calStatus)) {
                processRate = 100;
            }
            balanceLogInfo.set(BalanceInvLogConstants.PROCESS_RATE, (Object)processRate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{balanceLogInfo});
        }
        finally {
            lock.unlock();
            sessionLessCache.remove(calNum);
            ctx.release();
        }
    }

    private String getStatus(String calNum) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("balanceInventory");
        return sessionLessCache.get(calNum) == null ? BalanceInvLogConstants.STATUS_USER_STOP : (String)sessionLessCache.get(calNum);
    }

    private static void updateBalanceLog(DynamicObject balanceLogInfo, DynamicObject logEntry, StepResult stepResult, String stepTimeSpan, int processRate) {
        logEntry.set(BalanceInvLogConstants.PROCESS_DATA, (Object)(stepResult.getProcessData() + ""));
        logEntry.set(BalanceInvLogConstants.STEP_TIME_SPAN, (Object)stepTimeSpan);
        logEntry.set(BalanceInvLogConstants.STEP_RESULT, (Object)stepResult.getStepResult());
        String detailMsg = stepResult.getDetailMsg();
        if (!StringUtils.isEmpty((String)detailMsg)) {
            if (detailMsg.length() > 50) {
                logEntry.set(BalanceInvLogConstants.DETAIL_MSG, (Object)(detailMsg.substring(0, 50) + "..."));
            } else {
                logEntry.set(BalanceInvLogConstants.DETAIL_MSG, (Object)detailMsg);
            }
            logEntry.set(BalanceInvLogConstants.DETAIL_MSG_TAG, (Object)detailMsg);
        }
        if (processRate > 100) {
            processRate = 100;
        }
        balanceLogInfo.set(BalanceInvLogConstants.PROCESS_RATE, (Object)processRate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{balanceLogInfo});
    }

    private StepResult executeStep(DynamicObject logEntry) {
        StepResult stepResult = new StepResult();
        try {
            String implClass = logEntry.getDynamicObject(BalanceInvLogConstants.CAL_STEP).getString("implclass");
            Class implClazz = TypesContainer.getOrRegister((String)implClass);
            IBalanceInventoryStep splitTaskExecutor = (IBalanceInventoryStep)implClazz.newInstance();
            stepResult = splitTaskExecutor.execute();
        }
        catch (Throwable e) {
            this.logger.error(e);
            stepResult.setSuccess(false);
            stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_B);
            stepResult.setDetailMsg(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"BalanceInvStepExecutor_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        return stepResult;
    }
}

