/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.func.BillFormulaValueTransFunc;
import kd.scmc.im.business.balanceinv.func.MatchDimensionTransFunc;
import kd.scmc.im.business.balanceinv.func.MatchOrderCalFunc;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.InvDimensionInfo;
import kd.scmc.im.business.balanceinv.pojo.InvLevelInfo;
import kd.scmc.im.business.balanceinv.pojo.MatchDimension;
import kd.scmc.im.business.balanceinv.pojo.SupplyModel;
import kd.scmc.im.business.balanceinv.pojo.SupplyPolicy;
import kd.scmc.im.business.balanceinv.pojo.SupplyQtyInfo;
import kd.scmc.im.business.balanceinv.pojo.SupplyRelation;
import kd.scmc.im.business.balanceinv.pojo.SupplySafeQtyInfo;

public class BalanceSupplyBillGetter {
    private BalanceInvContext ctx;
    private static final String ALGO = "kd.scmc.im.business.balanceinv.BalanceSupplyBillGetter";
    private static final Log logger = LogFactory.getLog(BalanceSupplyBillGetter.class);

    public BalanceSupplyBillGetter(BalanceInvContext ctx) {
        this.ctx = ctx;
    }

    public int buildGroupedSupplyBillData(Map<String, List<Long>> supplyEntryIdMap) {
        BalanceInventoryScheme scheme = this.ctx.getScheme();
        HashMap<String, List<DynamicObject>> supplyBillsGroupedMap = new HashMap<String, List<DynamicObject>>(16);
        HashMap<String, List<DynamicObject>> supplyNullGroupedMap = new HashMap<String, List<DynamicObject>>(16);
        Map<Long, DynamicObjectCollection> demandBillGroupedMap = this.groupDemandBillsByDemandOrg(this.ctx.getDemandBillCol());
        int processData = 0;
        for (Long demandOrgId : scheme.getSupplyPolicyMap().keySet()) {
            if (!demandBillGroupedMap.containsKey(demandOrgId)) continue;
            List<Map<String, List<QFilter>>> supplyBillFilterMap = this.getSupplyBillFilterMap(supplyEntryIdMap, demandBillGroupedMap.get(demandOrgId), demandOrgId);
            DynamicObjectCollection supplyBillCol = this.getSupplyBillCol(supplyBillFilterMap, demandOrgId);
            processData += supplyBillCol.size();
            for (DynamicObject supplyBill : supplyBillCol) {
                String groupValue = demandOrgId + "$" + supplyBill.getString("entryentity.flexmetricid");
                supplyBillsGroupedMap.computeIfAbsent(groupValue, k -> new ArrayList()).add(supplyBill);
                groupValue = demandOrgId + "$" + supplyBill.getString("allmatchfieldkey");
                supplyNullGroupedMap.computeIfAbsent(groupValue, k -> new ArrayList()).add(supplyBill);
            }
        }
        this.ctx.setSupplyBillGroupedMap(supplyBillsGroupedMap);
        this.ctx.setSupplyNullGroupedMap(supplyNullGroupedMap);
        return processData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildEntryId2SupplyQtyMap(Map<String, List<QFilter>> supplyBillFilterMap, BalanceInventoryScheme balanceScheme) {
        HashMap<Long, SupplyQtyInfo> supplyBaseQtyMap = new HashMap<Long, SupplyQtyInfo>(16);
        for (String entityNum : balanceScheme.getSupplyDsList()) {
            List<QFilter> filterList = supplyBillFilterMap.get(entityNum);
            if (filterList == null || filterList.isEmpty()) continue;
            if (this.ctx.getDebugMode()) {
                logger.info(entityNum + "\u4f9b\u5e94\u5b9e\u4f53\u83b7\u53d6\u6570\u91cf\u7684\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a" + BalanceInvExecuteHelper.getStringFilter(filterList));
            }
            String selector = this.getSupplyQtySelector(entityNum);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)entityNum, (String)selector, (QFilter[])filterList.toArray(new QFilter[0]), (String)"");){
                Map<String, String> formulaMap = this.getSupplyQtyFormulaMap(entityNum);
                RowMeta rowMeta = dataSet.getRowMeta();
                if (!formulaMap.isEmpty()) {
                    dataSet = dataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, formulaMap));
                }
                Map<String, InvLevelInfo> invLevelMap = this.ctx.getSupplyInvLevelMap();
                HashMap<String, SupplySafeQtyInfo> safeQtyInfoMap = new HashMap<String, SupplySafeQtyInfo>(16);
                for (Row row : dataSet) {
                    InvDimensionInfo invDimensionInfo;
                    SupplyQtyInfo supplyQtyInfo = new SupplyQtyInfo();
                    BigDecimal baseQty = row.getBigDecimal("entryentity.usablebaseqty");
                    supplyQtyInfo.setBaseQty(baseQty);
                    if (row.get("entryentity.qty") != null && StringUtils.isNotBlank((CharSequence)row.get("entryentity.qty").toString())) {
                        supplyQtyInfo.setQty(row.getBigDecimal("entryentity.qty"));
                    }
                    if (row.get("entryentity.assitqty") != null && StringUtils.isNotBlank((CharSequence)row.get("entryentity.assitqty").toString())) {
                        supplyQtyInfo.setQty2nd(row.getBigDecimal("entryentity.assitqty"));
                    }
                    if ((invDimensionInfo = balanceScheme.getInvDimensionInfo()) != null && "im_inv_realbalance".equals(entityNum) && invLevelMap != null && !invLevelMap.isEmpty()) {
                        StringBuilder invDimensionValueBuilder = new StringBuilder();
                        List<String> supplyFields = invDimensionInfo.getSupplyFields();
                        for (String supplyField : supplyFields) {
                            invDimensionValueBuilder.append(row.get(supplyField)).append("$");
                        }
                        if (invLevelMap.containsKey(invDimensionValueBuilder.toString())) {
                            SupplySafeQtyInfo supplySafeQtyInfo = (SupplySafeQtyInfo)safeQtyInfoMap.get(invDimensionValueBuilder.toString());
                            if (supplySafeQtyInfo == null) {
                                supplySafeQtyInfo = new SupplySafeQtyInfo();
                                supplySafeQtyInfo.setSafeQty(invLevelMap.get(invDimensionValueBuilder.toString()).getSafeQty());
                                safeQtyInfoMap.put(invDimensionValueBuilder.toString(), supplySafeQtyInfo);
                            }
                            supplySafeQtyInfo.setTotalQty(supplySafeQtyInfo.getTotalQty().add(baseQty));
                            supplyQtyInfo.setSafeQtyInfo(supplySafeQtyInfo);
                        }
                    }
                    supplyBaseQtyMap.put(row.getLong("entryentity.billentryid"), supplyQtyInfo);
                }
            }
        }
        this.subtractReserveQty(supplyBaseQtyMap);
        this.ctx.setEntryId2SupplyQtyMap(supplyBaseQtyMap);
    }

    private Map<Long, DynamicObjectCollection> groupDemandBillsByDemandOrg(DynamicObjectCollection demandBillCol) {
        HashMap<Long, DynamicObjectCollection> demandBillGroupedMap = new HashMap<Long, DynamicObjectCollection>(16);
        for (DynamicObject demandBill : demandBillCol) {
            demandBillGroupedMap.computeIfAbsent(demandBill.getLong("entryentity.demandorg"), k -> new DynamicObjectCollection()).add((Object)demandBill);
        }
        return demandBillGroupedMap;
    }

    private List<Map<String, List<QFilter>>> getSupplyBillFilterMap(Map<String, List<Long>> supplyEntryIdMap, DynamicObjectCollection demandBillCol, Long demandOrgId) {
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        SupplyRelation supplyRelation = balanceScheme.getSupplyRelationMap().get(demandOrgId);
        SupplyPolicy supplyPolicy = balanceScheme.getSupplyPolicyMap().get(demandOrgId);
        MatchDimension matchDimension = balanceScheme.getMatchDimension();
        Map<String, String> fieldMatchMap = matchDimension.getDemand2SupplyMatchFieldMap();
        HashMap supplyFilterMap = new HashMap(balanceScheme.getSupplyDsList().size());
        HashMap nullSupplyFilterMap = new HashMap(balanceScheme.getSupplyDsList().size());
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        for (String entityNumber : balanceScheme.getSupplyDsList()) {
            QFilter ownerAndSupplyFilter;
            Map<String, String> target2SourceFieldMap = supplyModel.getTarget2SourceFieldMap(entityNumber);
            String supplyOrgField = target2SourceFieldMap.get("entryentity.supplyorgunit");
            String storageOrgField = target2SourceFieldMap.get("entryentity.stockorg");
            String supplyWarehouseField = target2SourceFieldMap.get("entryentity.stock");
            String supplyLocationField = target2SourceFieldMap.get("entryentity.stockindex");
            String supplyStoreTypeField = target2SourceFieldMap.get("entryentity.stocktype");
            String supplyStoreStateField = target2SourceFieldMap.get("entryentity.stockstatus");
            String ownerTypeField = target2SourceFieldMap.get("entryentity.owertype");
            ArrayList<QFilter> matchFilterList = new ArrayList<QFilter>();
            ArrayList<QFilter> nullFilterList = new ArrayList<QFilter>();
            if (supplyEntryIdMap != null) {
                List<Long> supplyEntryIds = supplyEntryIdMap.get(entityNumber);
                if (supplyEntryIds == null || supplyEntryIdMap.isEmpty()) continue;
                String materialField = target2SourceFieldMap.get("entryentity.material");
                Iterator<Map.Entry<String, Set<Object>>> entryKey = "id";
                if (materialField.contains(".")) {
                    entryKey = materialField.split("\\.")[0] + ".id";
                }
                QFilter idFilter = new QFilter((String)((Object)entryKey), "in", supplyEntryIds);
                matchFilterList.add(idFilter);
            }
            if (StringUtils.isNotEmpty((CharSequence)ownerTypeField) && StringUtils.isNotEmpty((CharSequence)supplyOrgField)) {
                ownerAndSupplyFilter = this.buildOwnerAndSupplyFilter(ownerTypeField, supplyOrgField, demandOrgId, supplyRelation);
                if (ownerAndSupplyFilter != null) {
                    matchFilterList.add(ownerAndSupplyFilter);
                }
            } else {
                ownerAndSupplyFilter = this.buildOwnerAndSupplyFilter("entryentity.owertype", "entryentity.supplyorgunit", demandOrgId, supplyRelation);
                if (ownerAndSupplyFilter != null) {
                    nullFilterList.add(ownerAndSupplyFilter);
                }
            }
            if ("im_inv_realbalance".equals(entityNumber)) {
                matchFilterList.addAll(supplyPolicy.getPolicyFilterList(storageOrgField, supplyWarehouseField, supplyLocationField, supplyStoreTypeField, supplyStoreStateField, entityNumber));
            } else {
                QFilter supplyPolicyStockOrgFilter = supplyPolicy.getPrePolicyFilterList(storageOrgField);
                if (StringUtils.isNotEmpty((CharSequence)storageOrgField) && supplyPolicyStockOrgFilter != null) {
                    matchFilterList.add(supplyPolicyStockOrgFilter);
                } else if (StringUtils.isEmpty((CharSequence)storageOrgField) && supplyPolicyStockOrgFilter != null) {
                    nullFilterList.add(supplyPolicyStockOrgFilter);
                }
            }
            Map<String, Set<Object>> sourceValueMap = matchDimension.getSourceValueMap(demandBillCol);
            List<String> demandNullMatchFields = balanceScheme.getDemandNullMatchFields();
            for (String demandNullMatchField : demandNullMatchFields) {
                sourceValueMap.remove(demandNullMatchField);
            }
            for (Map.Entry<String, Set<Object>> sourceFieldEntry : sourceValueMap.entrySet()) {
                String supplyModelField = fieldMatchMap.get(sourceFieldEntry.getKey());
                if (!StringUtils.isEmpty((CharSequence)supplyModelField) && !StringUtils.isEmpty((CharSequence)target2SourceFieldMap.get(supplyModelField))) {
                    QFilter filter = new QFilter(target2SourceFieldMap.get(supplyModelField), "in", sourceFieldEntry.getValue());
                    matchFilterList.add(filter);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)supplyModelField) || !StringUtils.isEmpty((CharSequence)target2SourceFieldMap.get(supplyModelField))) continue;
                nullFilterList.add(new QFilter(supplyModelField, "in", sourceFieldEntry.getValue()));
            }
            QFilter supplyFilter = supplyModel.getDataSourceFilter(entityNumber);
            if (supplyFilter != null) {
                matchFilterList.add(supplyFilter);
            }
            supplyFilterMap.put(entityNumber, matchFilterList);
            nullSupplyFilterMap.put(entityNumber, nullFilterList);
        }
        ArrayList<Map<String, List<QFilter>>> result = new ArrayList<Map<String, List<QFilter>>>(2);
        result.add(supplyFilterMap);
        result.add(nullSupplyFilterMap);
        return result;
    }

    private DynamicObjectCollection getSupplyBillCol(List<Map<String, List<QFilter>>> filterList, Long demandOrgId) {
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        Map<String, List<QFilter>> supplyBillFilterMap = filterList.get(0);
        Map<String, List<QFilter>> nullFieldFilterMap = filterList.get(1);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        MatchDimension matchDimension = balanceScheme.getMatchDimension();
        SupplyPolicy supplyPolicy = balanceScheme.getSupplyPolicyMap().get(demandOrgId);
        SupplyRelation supplyRelation = balanceScheme.getSupplyRelationMap().get(demandOrgId);
        DynamicObjectCollection preRecordCollection = new DynamicObjectCollection();
        StringBuilder selectorBuilder = new StringBuilder();
        for (Map.Entry<String, List<QFilter>> supplyFilterEntry : supplyBillFilterMap.entrySet()) {
            String supplyEntityNumber = supplyFilterEntry.getKey();
            QFilter[] qFilters = supplyFilterEntry.getValue().toArray(new QFilter[0]);
            String selector = supplyModel.getMatchSelector(supplyEntityNumber);
            selectorBuilder.append(selector);
            selectorBuilder.append(",-1 as ").append("supplyorder");
            selectorBuilder.append(",-1 as ").append("priority");
            selectorBuilder.append(",-1 as ").append("supplypriority");
            selectorBuilder.append(",-1 as ").append("invstatuspriority");
            selectorBuilder.append(",-1 as ").append("invtypepriority");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)supplyEntityNumber, (String)selectorBuilder.toString(), (QFilter[])qFilters, (String)"");
            if (this.ctx.getDebugMode()) {
                logger.info(BalanceInvExecuteHelper.getStringFilter(Arrays.asList(qFilters)));
            }
            selectorBuilder.setLength(0);
            RowMeta rowMeta = dataSet.getRowMeta();
            Map<String, String> targetFormulaMap = supplyModel.getTargetExpressionMap(supplyEntityNumber);
            ArrayList<String> matchFields = new ArrayList<String>();
            matchFields.addAll(matchDimension.getSupplyMatchFields());
            matchFields.removeAll(balanceScheme.getSupplyNullMatchFields());
            dataSet = dataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, targetFormulaMap)).map((MapFunction)new MatchDimensionTransFunc(rowMeta, matchFields, "entryentity.flexmetricid"));
            dataSet = dataSet.addField("''", "allmatchfieldkey");
            dataSet = dataSet.map((MapFunction)new MatchDimensionTransFunc(dataSet.getRowMeta(), matchDimension.getSupplyMatchFields(), "allmatchfieldkey"));
            ORM orm = ORM.create();
            if (dataSet.isEmpty()) continue;
            if ("im_inv_realbalance".equals(supplyEntityNumber)) {
                dataSet = dataSet.map((MapFunction)new MatchOrderCalFunc(supplyPolicy, dataSet.getRowMeta(), supplyRelation));
                dataSet = dataSet.orderBy(new String[]{"invtypepriority", "invstatuspriority", "priority", "supplypriority", "supplyorder"});
                dynamicObjectCollection.addAll(0, (Collection)orm.toPlainDynamicObjectCollection(dataSet));
                continue;
            }
            List<QFilter> dataSetFilter = nullFieldFilterMap.get(supplyEntityNumber);
            if (dataSetFilter.size() > 0) {
                dataSet = dataSet.filter(BalanceInvExecuteHelper.getStringFilter(dataSetFilter));
            }
            preRecordCollection.addAll((Collection)orm.toPlainDynamicObjectCollection(dataSet));
        }
        this.sortBySupplyDate(preRecordCollection);
        dynamicObjectCollection.addAll((Collection)preRecordCollection);
        return dynamicObjectCollection;
    }

    private void sortBySupplyDate(DynamicObjectCollection preRecordCollection) {
        preRecordCollection.sort((o1, o2) -> {
            Date date1 = o1.getDate("entryentity.billdate");
            Date date2 = o2.getDate("entryentity.billdate");
            if (date1 != null && date2 != null) {
                return date1.compareTo(date2);
            }
            if (date1 == null) {
                return -1;
            }
            return 1;
        });
    }

    private QFilter buildOwnerAndSupplyFilter(String ownerTypeField, String supplyOrgField, Long demandOrgId, SupplyRelation supplyRelation) {
        QFilter ownerTypeFilter = new QFilter(ownerTypeField, "=", (Object)"bd_supplier");
        QFilter relationFilter = null;
        relationFilter = supplyRelation != null ? supplyRelation.getRelationFilter(supplyOrgField) : new QFilter(supplyOrgField, "=", (Object)demandOrgId);
        if (relationFilter != null) {
            return relationFilter.or(ownerTypeFilter);
        }
        return null;
    }

    private void subtractReserveQty(Map<Long, SupplyQtyInfo> supplyBaseQtyMap) {
        if (supplyBaseQtyMap.size() > 0) {
            QFilter qFilter = new QFilter("bal_entryid", "in", supplyBaseQtyMap.keySet()).and("base_qty", ">", (Object)0).and("ispredict", "=", (Object)true);
            Map<Long, Map<String, BigDecimal>> reserveQty = this.queryReserveQty(qFilter);
            for (Map.Entry<Long, Map<String, BigDecimal>> entry : reserveQty.entrySet()) {
                Long key = entry.getKey();
                SupplyQtyInfo supplyQtyInfo = supplyBaseQtyMap.get(key);
                if (supplyQtyInfo == null) continue;
                this.dealQty(supplyQtyInfo, entry.getValue());
            }
        }
    }

    private Map<Long, Map<String, BigDecimal>> queryReserveQty(QFilter qFilter) {
        HashMap<Long, Map<String, BigDecimal>> reserveQtyMap = new HashMap<Long, Map<String, BigDecimal>>();
        try (DataSet reserveRecord = QueryServiceHelper.queryDataSet((String)ALGO, (String)"msmod_reserve_record", (String)"bal_entryid,qty,base_qty, qty2nd", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : reserveRecord) {
                Long balEntryId = row.getLong("bal_entryid");
                BigDecimal qty = row.getBigDecimal("qty");
                BigDecimal baseQty = row.getBigDecimal("base_qty");
                BigDecimal qty2nd = row.getBigDecimal("qty2nd");
                HashMap<String, BigDecimal> qtyMap = (HashMap<String, BigDecimal>)reserveQtyMap.get(balEntryId);
                if (qtyMap == null) {
                    qtyMap = new HashMap<String, BigDecimal>(4);
                } else {
                    qty = qty.add((BigDecimal)qtyMap.get("entryentity.qty"));
                    baseQty = baseQty.add((BigDecimal)qtyMap.get("entryentity.usablebaseqty"));
                    qty2nd = qty2nd.add((BigDecimal)qtyMap.get("entryentity.assitqty"));
                }
                qtyMap.put("entryentity.qty", qty);
                qtyMap.put("entryentity.usablebaseqty", baseQty);
                qtyMap.put("entryentity.assitqty", qty2nd);
                reserveQtyMap.put(balEntryId, qtyMap);
            }
        }
        return reserveQtyMap;
    }

    private void dealQty(SupplyQtyInfo supplyQtyInfo, Map<String, BigDecimal> qtyMap) {
        BigDecimal baseQty = supplyQtyInfo.getBaseQty().subtract(qtyMap.get("entryentity.usablebaseqty"));
        BigDecimal qty = supplyQtyInfo.getQty().subtract(qtyMap.get("entryentity.qty"));
        BigDecimal qty2nd = supplyQtyInfo.getQty2nd().subtract(qtyMap.get("entryentity.assitqty"));
        supplyQtyInfo.setBaseQty(baseQty.compareTo(BigDecimal.ZERO) > 0 ? baseQty : BigDecimal.ZERO);
        supplyQtyInfo.setQty(qty.compareTo(BigDecimal.ZERO) > 0 ? qty : BigDecimal.ZERO);
        supplyQtyInfo.setQty2nd(qty2nd.compareTo(BigDecimal.ZERO) > 0 ? qty2nd : BigDecimal.ZERO);
    }

    private String getSupplyQtySelector(String entityNum) {
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("entryentity.billentryid");
        fields.add("entryentity.usablebaseqty");
        fields.add("entryentity.qty");
        fields.add("entryentity.assitqty");
        InvDimensionInfo invDimensionInfo = balanceScheme.getInvDimensionInfo();
        if (invDimensionInfo != null) {
            fields.addAll(invDimensionInfo.getSupplyFields());
        }
        StringBuilder selectorBuilder = new StringBuilder();
        selectorBuilder.append(supplyModel.getFieldSelector(entityNum, fields.toArray(new String[0])));
        selectorBuilder.append(",0 as ").append("safeinv");
        return selectorBuilder.toString();
    }

    private Map<String, String> getSupplyQtyFormulaMap(String entityNum) {
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("entryentity.billentryid");
        fields.add("entryentity.usablebaseqty");
        fields.add("entryentity.qty");
        fields.add("entryentity.assitqty");
        InvDimensionInfo invDimensionInfo = balanceScheme.getInvDimensionInfo();
        if (invDimensionInfo != null) {
            List<String> supplyFields = invDimensionInfo.getSupplyFields();
            for (String supplyField : supplyFields) {
                fields.add(supplyField);
            }
        }
        return supplyModel.getFieldFormulaMap(entityNum, fields.toArray(new String[0]));
    }
}

