/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.func;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;

public class MatchDimensionTransFunc
extends MapFunction {
    private RowMeta rowMeta;
    private List<String> matchFields;
    private String targetKey;

    public MatchDimensionTransFunc(RowMeta rowMeta, List<String> matchFields, String targetKey) {
        this.rowMeta = rowMeta;
        this.matchFields = matchFields;
        this.targetKey = targetKey;
    }

    public Object[] map(Row row) {
        String dimensionValue = this.getDimensionValue(row);
        Object[] data = RowUtil.toArray((Row)row);
        int flexMetricIndex = this.rowMeta.getFieldIndex(this.targetKey);
        data[flexMetricIndex] = dimensionValue;
        return data;
    }

    private String getDimensionValue(Row row) {
        StringBuilder filedSb = new StringBuilder();
        Object fieldValue = null;
        for (String matchField : this.matchFields) {
            fieldValue = row.get(matchField);
            if (row.get(matchField) instanceof DynamicObject) {
                fieldValue = ((DynamicObject)row.get(matchField)).get("id");
            }
            if (fieldValue == null) {
                fieldValue = "null";
            }
            filedSb.append(fieldValue).append("$");
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] digest = md.digest(filedSb.toString().getBytes());
        String dimensionValue = Base64.getEncoder().encodeToString(digest);
        return dimensionValue;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

