/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.func;

import java.util.Map;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.pojo.SupplyPolicy;
import kd.scmc.im.business.balanceinv.pojo.SupplyRelation;

public class MatchOrderCalFunc
extends MapFunction {
    private SupplyPolicy supplyPolicy;
    private SupplyRelation supplyRelation;
    private RowMeta rowMeta;

    public MatchOrderCalFunc(SupplyPolicy supplyPolicy, RowMeta rowMeta, SupplyRelation supplyRelation) {
        this.supplyPolicy = supplyPolicy;
        this.rowMeta = rowMeta;
        this.supplyRelation = supplyRelation;
    }

    public Object[] map(Row row) {
        String ownerType;
        Map<Long, Integer> storeStateMap;
        Object[] valueArr = RowUtil.toArray((Row)row);
        if (this.supplyRelation != null) {
            Map<Long, Integer> supplyOrg2OrderMap = this.supplyRelation.getSupplyOrg2OrderMap();
            Integer supplyOrgOrder = supplyOrg2OrderMap.get(row.getLong("entryentity.supplyorgunit"));
            valueArr[this.rowMeta.getFieldIndex((String)"supplyorder")] = supplyOrgOrder;
        }
        if ((storeStateMap = this.supplyPolicy.getStoreStateMap()) != null && storeStateMap.containsKey(row.getLong("entryentity.stockstatus"))) {
            Integer soreStateOrder = storeStateMap.get(row.getLong("entryentity.stockstatus"));
            valueArr[this.rowMeta.getFieldIndex((String)"invstatuspriority")] = soreStateOrder;
        }
        Map<Long, Integer> storageOrderMap = this.supplyPolicy.getStorageOrderMap();
        Integer storageOrgOrder = storageOrderMap.get(row.getLong("entryentity.stockorg"));
        valueArr[this.rowMeta.getFieldIndex((String)"priority")] = storageOrgOrder;
        int warehouseSetting = this.supplyPolicy.getWarehouseSetting();
        if (warehouseSetting == 2 && this.supplyPolicy.getWarehouseEntries() != null && !this.supplyPolicy.getWarehouseEntries().isEmpty()) {
            String location = row.getString("entryentity.stockindex");
            if (!StringUtils.isEmpty((String)location) && !"0".equals(location)) {
                String orderSign = row.getString("entryentity.stockorg") + "$" + row.getString("entryentity.stock") + "$" + location;
                if (this.supplyPolicy.getLocationOrderMap().containsKey(orderSign)) {
                    Integer locationOrder = this.supplyPolicy.getLocationOrderMap().get(orderSign);
                    valueArr[this.rowMeta.getFieldIndex((String)"supplypriority")] = locationOrder;
                }
            } else {
                String orderSign = row.getString("entryentity.stockorg") + "$" + row.getString("entryentity.stock");
                if (this.supplyPolicy.getWarehouseOrderMap().containsKey(orderSign)) {
                    Integer warehouseOrder = this.supplyPolicy.getWarehouseOrderMap().get(orderSign);
                    valueArr[this.rowMeta.getFieldIndex((String)"supplypriority")] = warehouseOrder;
                }
            }
        }
        valueArr[this.rowMeta.getFieldIndex((String)"invtypepriority")] = "bd_supplier".equals(ownerType = row.getString("entryentity.owertype")) ? Integer.valueOf(2) : Integer.valueOf(1);
        return valueArr;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

