/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.pojo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class AbstractModel {
    private Map<String, DynamicObject> dataSourceMap = new HashMap<String, DynamicObject>();
    private Map<String, Map<String, String>> target2SourceMatchMap = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> source2TargetMatchMap = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> targetFormulaMaps = new HashMap<String, Map<String, String>>();

    public AbstractModel(DynamicObject dataModel) {
        this.init(dataModel);
    }

    private void init(DynamicObject dataModel) {
        DynamicObjectCollection dataSourceEntries = dataModel.getDynamicObjectCollection("entryentityds");
        for (DynamicObject dataSourceEntry : dataSourceEntries) {
            String entityNumber = dataSourceEntry.getDynamicObject("srcbillds").getString("number");
            this.dataSourceMap.put(entityNumber, dataSourceEntry);
        }
    }

    public Map<String, String> getTarget2SourceFieldMap(String entityNumber) {
        if (this.target2SourceMatchMap.containsKey(entityNumber)) {
            return this.target2SourceMatchMap.get(entityNumber);
        }
        DynamicObject dataSource = this.dataSourceMap.get(entityNumber);
        DynamicObject billFieldMap = dataSource.getDynamicObject("billfieldmap");
        DynamicObjectCollection matchFieldCol = billFieldMap.getDynamicObjectCollection("colsmap");
        HashMap<String, String> target2SourceFieldMap = new HashMap<String, String>();
        for (DynamicObject matchField : matchFieldCol) {
            String sourceFiled = matchField.getString("sourcebillcol");
            String targetFiled = matchField.getString("targetobjcol");
            if (StringUtils.isEmpty((String)targetFiled)) continue;
            target2SourceFieldMap.put(targetFiled, sourceFiled);
        }
        this.target2SourceMatchMap.put(entityNumber, target2SourceFieldMap);
        return target2SourceFieldMap;
    }

    public Set<String> getTargetFields(String entityNum) {
        HashSet<String> fieldSet = new HashSet<String>();
        DynamicObject dataSource = this.dataSourceMap.get(entityNum);
        DynamicObject billFieldMap = dataSource.getDynamicObject("billfieldmap");
        DynamicObjectCollection matchFieldCol = billFieldMap.getDynamicObjectCollection("colsmap");
        for (DynamicObject matchField : matchFieldCol) {
            fieldSet.add(matchField.getString("targetobjcol"));
        }
        return fieldSet;
    }

    public Map<String, String> getSource2TargetFieldMap(String entityNumber) {
        if (this.source2TargetMatchMap.containsKey(entityNumber)) {
            return this.source2TargetMatchMap.get(entityNumber);
        }
        DynamicObject dataSource = this.dataSourceMap.get(entityNumber);
        DynamicObject billFieldMap = dataSource.getDynamicObject("billfieldmap");
        DynamicObjectCollection matchFieldCol = billFieldMap.getDynamicObjectCollection("colsmap");
        HashMap<String, String> source2TargetFieldMap = new HashMap<String, String>();
        for (DynamicObject matchField : matchFieldCol) {
            String sourceFiled = matchField.getString("sourcebillcol");
            String targetFiled = matchField.getString("targetobjcol");
            if (StringUtils.isEmpty((String)sourceFiled)) continue;
            source2TargetFieldMap.put(sourceFiled, targetFiled);
        }
        this.source2TargetMatchMap.put(entityNumber, source2TargetFieldMap);
        return source2TargetFieldMap;
    }

    public QFilter getDataSourceFilter(String entityNumber) {
        DynamicObject dataSource = this.dataSourceMap.get(entityNumber);
        String filterJson = dataSource.getString("filtervalueds");
        if (StringUtils.isEmpty((String)filterJson)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilter();
    }

    public String getMatchSelector(String entityNumber) {
        DynamicObject dataSource = this.dataSourceMap.get(entityNumber);
        DynamicObject billFieldMap = dataSource.getDynamicObject("billfieldmap");
        DynamicObjectCollection colsMap = billFieldMap.getDynamicObjectCollection("colsmap");
        StringBuilder selectorBuilder = new StringBuilder();
        HashSet<String> targetFieldSet = new HashSet<String>(colsMap.size());
        for (DynamicObject colMap : colsMap) {
            String targetField = colMap.getString("targetobjcol");
            String sourceField = colMap.getString("sourcebillcol");
            targetFieldSet.add(targetField);
            if (StringUtils.isEmpty((String)sourceField)) {
                sourceField = "''";
            }
            if (selectorBuilder.length() > 0) {
                selectorBuilder.append(",");
            }
            selectorBuilder.append(sourceField).append(" as ").append(targetField);
        }
        Map<String, String> targetExpressionMap = this.getTargetExpressionMap(entityNumber);
        HashSet<String> formulaSelector = new HashSet<String>();
        for (String expression : targetExpressionMap.values()) {
            String[] variables;
            for (String variable : variables = FormulaEngine.extractVariables((String)expression)) {
                formulaSelector.add(variable + " as " + variable + "_XX");
            }
        }
        if (!formulaSelector.isEmpty()) {
            if (selectorBuilder.length() > 0) {
                selectorBuilder.append(",");
            }
            selectorBuilder.append(String.join((CharSequence)",", formulaSelector));
        }
        if (!targetFieldSet.contains("entryentity.flexmetricid")) {
            selectorBuilder.append(",'' as ").append("entryentity.flexmetricid");
        }
        if (selectorBuilder.length() > 0) {
            selectorBuilder.append(",");
        }
        selectorBuilder.append("'").append(entityNumber).append("' as ").append("entryentity.billentity");
        return selectorBuilder.toString();
    }

    public Map<String, String> getTargetExpressionMap(String entityNum) {
        if (this.targetFormulaMaps.get(entityNum) != null) {
            return this.targetFormulaMaps.get(entityNum);
        }
        DynamicObject dataSource = this.dataSourceMap.get(entityNum);
        DynamicObject billFieldMap = dataSource.getDynamicObject("billfieldmap");
        DynamicObjectCollection colsMap = billFieldMap.getDynamicObjectCollection("colsmap");
        HashMap<String, String> targetExpressionMap = new HashMap<String, String>();
        for (DynamicObject colMap : colsMap) {
            String targetField = colMap.getString("targetobjcol");
            String formula = colMap.getString("formula_tag");
            if (StringUtils.isEmpty((String)formula) || !colMap.get("selectvalue").equals("1")) continue;
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)formula, CRCondition.class);
            targetExpressionMap.put(targetField, crCondition.getExpression());
        }
        this.targetFormulaMaps.put(entityNum, targetExpressionMap);
        return this.targetFormulaMaps.get(entityNum);
    }

    public String getFieldSelector(String entityNum, String ... fields) {
        StringBuilder selector = new StringBuilder();
        for (String field : fields) {
            String[] variables;
            String entryIdField;
            if (selector.length() > 0) {
                selector.append(",");
            }
            if (StringUtils.isEmpty((String)(entryIdField = this.getTarget2SourceFieldMap(entityNum).get(field)))) {
                entryIdField = "null";
            }
            selector.append(entryIdField).append(" as ").append(field);
            String entryIdExpression = this.getTargetExpressionMap(entityNum).get(field);
            if (StringUtils.isEmpty((String)entryIdExpression)) continue;
            for (String variable : variables = FormulaEngine.extractVariables((String)entryIdExpression)) {
                selector.append(",");
                selector.append(variable).append(" as ").append(variable).append("_XX");
            }
        }
        return selector.toString();
    }

    public Map<String, String> getFieldFormulaMap(String entityNum, String ... fields) {
        HashMap<String, String> formulaMap = new HashMap<String, String>(fields.length);
        Map<String, String> targetExpressionMap = this.getTargetExpressionMap(entityNum);
        for (String field : fields) {
            if (!targetExpressionMap.containsKey(field)) continue;
            formulaMap.put(field, targetExpressionMap.get(field));
        }
        return formulaMap;
    }

    public DynamicObject getBillFiledMap(String entityNumber) {
        DynamicObject dataSource = this.dataSourceMap.get(entityNumber);
        DynamicObject billFieldMap = dataSource.getDynamicObject("billfieldmap");
        return billFieldMap;
    }

    public Map<String, DynamicObject> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public Map<String, Map<String, String>> getTarget2SourceMatchMap() {
        return this.target2SourceMatchMap;
    }

    public Map<String, Map<String, String>> getSource2TargetMatchMap() {
        return this.source2TargetMatchMap;
    }
}

