/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.balanceinv.pojo.DemandModel;
import kd.scmc.im.business.balanceinv.pojo.InvDimensionInfo;
import kd.scmc.im.business.balanceinv.pojo.MatchDimension;
import kd.scmc.im.business.balanceinv.pojo.SupplyModel;
import kd.scmc.im.business.balanceinv.pojo.SupplyPolicy;
import kd.scmc.im.business.balanceinv.pojo.SupplyRelation;

public class BalanceInventoryScheme {
    private Long id;
    private String number;
    private String name;
    private Long balanceOrgId;
    private Map<Long, SupplyPolicy> supplyPolicyMap = new HashMap<Long, SupplyPolicy>();
    private Map<Long, SupplyRelation> supplyRelationMap = new HashMap<Long, SupplyRelation>();
    private Set<Long> containSafeInvOrgs = new HashSet<Long>();
    private SupplyModel supplyModel;
    private DemandModel demandModel;
    private MatchDimension matchDimension;
    private boolean autoAuditResult = false;
    private boolean autoPutResult = false;
    private String[] demandOrderArr;
    List<String> supplyDsList = new ArrayList<String>();
    Map<String, String> demandDsMap = new HashMap<String, String>();
    DynamicObjectCollection outPutParamColl;
    Map<String, String> demandMatchResultFieldMap = new HashMap<String, String>();
    Map<String, String> supplyMatchResultFieldMap = new HashMap<String, String>();
    InvDimensionInfo invDimensionInfo;
    Long invLevelInfoId = 0L;
    private List<String> demandNullMatchFields = new ArrayList<String>();
    private List<String> supplyNullMatchFields = new ArrayList<String>();
    private List<String> splitRuleFields = new ArrayList<String>();

    public BalanceInventoryScheme(DynamicObject balanceInventoryScheme) {
        this.init(balanceInventoryScheme);
    }

    private void init(DynamicObject balanceInventoryScheme) {
        this.id = balanceInventoryScheme.getLong("id");
        this.number = balanceInventoryScheme.getString("number");
        this.name = balanceInventoryScheme.getString("name");
        this.balanceOrgId = balanceInventoryScheme.getDynamicObject("balanceinvorg").getLong("id");
        DynamicObjectCollection orgEntries = balanceInventoryScheme.getDynamicObjectCollection("orgentryentity");
        for (Object orgEntry : orgEntries) {
            long demandOrgId = orgEntry.getDynamicObject("demandorg").getLong("id");
            this.supplyPolicyMap.put(demandOrgId, new SupplyPolicy(orgEntry.getDynamicObject("invstrategy")));
            if (orgEntry.getDynamicObject("supplyrelation") != null) {
                this.supplyRelationMap.put(demandOrgId, new SupplyRelation(orgEntry.getDynamicObject("supplyrelation")));
            } else {
                this.supplyRelationMap.put(demandOrgId, null);
            }
            if (orgEntry.getBoolean("containsafeinv")) {
                this.containSafeInvOrgs.add(demandOrgId);
            }
            this.containSafeInvOrgs.add(this.balanceOrgId);
        }
        this.matchDimension = new MatchDimension(balanceInventoryScheme.getDynamicObject("mappingdimen"));
        this.supplyModel = new SupplyModel(balanceInventoryScheme.getDynamicObject("supplymodel"));
        this.demandModel = new DemandModel(balanceInventoryScheme.getDynamicObject("demandmodel"));
        this.demandOrderArr = this.getDemandOrder(balanceInventoryScheme);
        DynamicObjectCollection supplyDsCol = balanceInventoryScheme.getDynamicObjectCollection("supplysrcentry");
        for (DynamicObject supplyDs : supplyDsCol) {
            if (!supplyDs.getBoolean("supplyinbalanceinv")) continue;
            this.supplyDsList.add(supplyDs.getDynamicObject("supplysrc").getString("number"));
        }
        DynamicObjectCollection demandDsCol = balanceInventoryScheme.getDynamicObjectCollection("demandsrcentry");
        for (Object demandDs : demandDsCol) {
            if (!demandDs.getBoolean("deminbalanceinv")) continue;
            String entityNumber = demandDs.getDynamicObject("demandsrc").getString("number");
            String botpRuleId = demandDs.getDynamicObject("demoutputbotp").getString("id");
            this.demandDsMap.put(entityNumber, botpRuleId);
        }
        this.outPutParamColl = balanceInventoryScheme.getDynamicObjectCollection("autoputparamentry");
        this.buildMatchResultMap();
        if (balanceInventoryScheme.getDynamicObject("dimension") != null) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)balanceInventoryScheme.getDynamicObject("dimension").getLong("id"), (String)"msplan_plan_dimension");
            this.invDimensionInfo = new InvDimensionInfo(dynamicObject);
            this.invLevelInfoId = (Long)dynamicObject.getPkValue();
        }
        DynamicObjectCollection matchEntries = balanceInventoryScheme.getDynamicObjectCollection("matchentry");
        for (DynamicObject matchEntry : matchEntries) {
            this.demandNullMatchFields.add(matchEntry.getString("demandfieldkey"));
            this.supplyNullMatchFields.add(matchEntry.getString("supplyfieldkey"));
        }
        DynamicObject splitRule = balanceInventoryScheme.getDynamicObject("splitrule");
        if (splitRule != null) {
            DynamicObjectCollection entries = splitRule.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                this.splitRuleFields.add(entry.getString("fieldkey"));
            }
        }
    }

    private void buildMatchResultMap() {
        this.demandMatchResultFieldMap.put("entryentity.material", "materiel");
        this.demandMatchResultFieldMap.put("entryentity.auxpty", "auxpty");
        this.demandMatchResultFieldMap.put("entryentity.demandorg", "demandorg");
        this.demandMatchResultFieldMap.put("entryentity.biztype", "biztype");
        this.demandMatchResultFieldMap.put("entryentity.demandtype", "demandkind");
        this.demandMatchResultFieldMap.put("entryentity.baseunit", "baseunit");
        this.demandMatchResultFieldMap.put("entryentity.billtype", "demandbilltype");
        this.demandMatchResultFieldMap.put("entryentity.billnumber", "demandbillno");
        this.demandMatchResultFieldMap.put("entryentity.billdate", "demanddate");
        this.demandMatchResultFieldMap.put("entryentity.billid", "demandbillid");
        this.demandMatchResultFieldMap.put("entryentity.billentryid", "demandentryid");
        this.demandMatchResultFieldMap.put("entryentity.billentryseq", "demandbillseq");
        this.demandMatchResultFieldMap.put("entryentity.ownerid", "demandowner");
        this.demandMatchResultFieldMap.put("entryentity.ownertype", "demandownertype");
        this.demandMatchResultFieldMap.put("entryentity.demandqty", "previousbaseqty");
        this.demandMatchResultFieldMap.put("entryentity.demandqty", "demandbaseqty");
        this.supplyMatchResultFieldMap.put("entryentity.originbaseqty", "srcsupplybaseqty");
        this.supplyMatchResultFieldMap.put("entryentity.invtype", "invstocktype");
        this.supplyMatchResultFieldMap.put("entryentity.supplyorgunit", "supplyorg");
        this.supplyMatchResultFieldMap.put("entryentity.billtype", "supplybilltype");
        this.supplyMatchResultFieldMap.put("entryentity.billnumber", "supplybillno");
        this.supplyMatchResultFieldMap.put("entryentity.billid", "supplybillid");
        this.supplyMatchResultFieldMap.put("entryentity.billentryid", "supplybillentryid");
        this.supplyMatchResultFieldMap.put("entryentity.billentryseq", "supplybillseq");
        this.supplyMatchResultFieldMap.put("entryentity.billdate", "supplybilldate");
        this.supplyMatchResultFieldMap.put("entryentity.material", "supplymateriel");
        this.supplyMatchResultFieldMap.put("entryentity.stock", "supplywarehouse");
        this.supplyMatchResultFieldMap.put("entryentity.stockindex", "supplylocation");
        this.supplyMatchResultFieldMap.put("entryentity.owner", "supplyowner");
        this.supplyMatchResultFieldMap.put("entryentity.owertype", "supplyownertype");
        this.supplyMatchResultFieldMap.put("entryentity.materialflexprops", "supplyauxpty");
        this.supplyMatchResultFieldMap.put("entryentity.stockorg", "supplyinvorg");
        this.supplyMatchResultFieldMap.put("entryentity.unit", "supplyunit");
        this.supplyMatchResultFieldMap.put("entryentity.assistunit", "supplyunit2nd");
        this.supplyMatchResultFieldMap.put("entryentity.stockstatus", "invstatus");
        this.supplyMatchResultFieldMap.put("entryentity.stocktype", "supplystoretype");
    }

    private String[] getDemandOrder(DynamicObject balanceScheme) {
        DynamicObjectCollection demandOrderCol = balanceScheme.getDynamicObjectCollection("dempriorityentry");
        ArrayList<String> orderList = new ArrayList<String>();
        for (DynamicObject demandOrderEntry : demandOrderCol) {
            String demandOrderField = demandOrderEntry.getString("entrydemandlogo");
            String demandOrderType = demandOrderEntry.getString("sorttype");
            orderList.add(demandOrderField + " " + demandOrderType);
        }
        return orderList.toArray(new String[0]);
    }

    public Map<Long, SupplyPolicy> getSupplyPolicyMap() {
        return this.supplyPolicyMap;
    }

    public Map<Long, SupplyRelation> getSupplyRelationMap() {
        return this.supplyRelationMap;
    }

    public SupplyModel getSupplyModel() {
        return this.supplyModel;
    }

    public DemandModel getDemandModel() {
        return this.demandModel;
    }

    public boolean isAutoAuditResult() {
        return this.autoAuditResult;
    }

    public boolean isAutoPutResult() {
        return this.autoPutResult;
    }

    public String[] getDemandOrderArr() {
        return this.demandOrderArr;
    }

    public MatchDimension getMatchDimension() {
        return this.matchDimension;
    }

    public List<String> getSupplyDsList() {
        return this.supplyDsList;
    }

    public Map<String, String> getDemandDsMap() {
        return this.demandDsMap;
    }

    public DynamicObjectCollection getOutPutParamColl() {
        return this.outPutParamColl;
    }

    public Long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getDemandMatchResultFieldMap() {
        return this.demandMatchResultFieldMap;
    }

    public Map<String, String> getSupplyMatchResultFieldMap() {
        return this.supplyMatchResultFieldMap;
    }

    public InvDimensionInfo getInvDimensionInfo() {
        return this.invDimensionInfo;
    }

    public Long getBalanceOrgId() {
        return this.balanceOrgId;
    }

    public Long getInvLevelInfoId() {
        return this.invLevelInfoId;
    }

    public List<String> getDemandNullMatchFields() {
        return this.demandNullMatchFields;
    }

    public List<String> getSupplyNullMatchFields() {
        return this.supplyNullMatchFields;
    }

    public Set<Long> getContainSafeInvOrgs() {
        return this.containSafeInvOrgs;
    }

    public List<String> getSplitRuleFields() {
        return this.splitRuleFields;
    }
}

