/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class InvDimensionInfo {
    private Set<String> dimensions = new HashSet<String>();
    private List<String> invLevelFields = new ArrayList<String>();
    private List<String> demandFields = new ArrayList<String>();
    private List<String> supplyFields = new ArrayList<String>();
    Map<String, String> demandFieldMap = new HashMap<String, String>();
    Map<String, String> supplyFieldMap = new HashMap<String, String>();
    Map<String, String> invLevelFieldMap = new HashMap<String, String>();
    private Set<Long> dimensionIds = new HashSet<Long>();

    public Set<Long> getDimensionIds() {
        return this.dimensionIds;
    }

    public void setDimensionIds(Set<Long> dimensionIds) {
        this.dimensionIds = dimensionIds;
    }

    public InvDimensionInfo(DynamicObject invDimensionObj) {
        this.init(invDimensionObj);
    }

    private void init(DynamicObject invDimensionObj) {
        DynamicObjectCollection entries = invDimensionObj.getDynamicObjectCollection("entryentity");
        this.initFieldMap();
        for (DynamicObject entry : entries) {
            String dimensionValue;
            switch (dimensionValue = entry.getDynamicObject("associationobject").getString("id")) {
                case "bd_material": 
                case "bd_materialgroup": 
                case "bd_materialgroupstandard": {
                    if (!this.demandFields.contains(this.demandFieldMap.get("bd_material"))) {
                        this.demandFields.add(this.demandFieldMap.get("bd_material"));
                    }
                    if (!this.supplyFields.contains(this.supplyFieldMap.get("bd_material"))) {
                        this.supplyFields.add(this.supplyFieldMap.get("bd_material"));
                    }
                    if (this.invLevelFields.contains(this.invLevelFieldMap.get("bd_material"))) break;
                    this.invLevelFields.add(this.invLevelFieldMap.get("bd_material"));
                    break;
                }
                default: {
                    this.demandFields.add(this.demandFieldMap.get(dimensionValue));
                    this.supplyFields.add(this.supplyFieldMap.get(dimensionValue));
                    this.invLevelFields.add(this.invLevelFieldMap.get(dimensionValue));
                }
            }
            this.dimensions.add(dimensionValue);
        }
    }

    public Set<String> getDimensions() {
        return this.dimensions;
    }

    private void initFieldMap() {
        this.demandFieldMap.put("bd_material", "entryentity.material");
        this.demandFieldMap.put("bos_org", "entryentity.balanceinvorg");
        this.demandFieldMap.put("bd_warehouse", "entryentity.stock");
        this.supplyFieldMap.put("bd_material", "entryentity.material");
        this.supplyFieldMap.put("bos_org", "entryentity.supplyorgunit");
        this.supplyFieldMap.put("bd_warehouse", "entryentity.stock");
        this.invLevelFieldMap.put("bd_material", "bd_material");
        this.invLevelFieldMap.put("bos_org", "bos_org");
        this.invLevelFieldMap.put("bd_warehouse", "bd_warehouse");
    }

    public Boolean containsMaterial() {
        return this.dimensions.contains("bd_material");
    }

    public List<String> getInvLevelFields() {
        return this.invLevelFields;
    }

    public List<String> getDemandFields() {
        return this.demandFields;
    }

    public List<String> getSupplyFields() {
        return this.supplyFields;
    }
}

