/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.steps.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.pojo.SumMatchInfo;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;

public class BalanceInvGenMatchAdviseStep
implements IBalanceInventoryStep {
    private Log logger = LogFactory.getLog((String)this.getClass().getName());
    private StepResult stepResult = new StepResult();
    private Map<Long, Long> demandOrgCache = new HashMap<Long, Long>();
    private StringBuilder stepErrorMsg = new StringBuilder();
    private static final String ALGO = "kd.scmc.im.business.balanceinv.steps.impl.BalanceInvGenMatchAdviseStep";
    int matReqCount = 0;
    int vmiReqCount = 0;
    int transCount = 0;
    int vmiTransCount = 0;

    @Override
    public StepResult execute() {
        BalanceInvContext ctx = BalanceInvContext.get();
        Map<String, List<DynamicObject>> groupedMatchMap = ctx.getGroupedMatchMap();
        BalanceInventoryScheme scheme = ctx.getScheme();
        this.logger.info("\u5e73\u8861\u5229\u5e93\u751f\u6210\u5229\u5e93\u5efa\u8bae");
        Set<Long> adviseIdSet = this.genMatchedBalanceAdvise(groupedMatchMap, scheme);
        ctx.getAdviseIdSet().addAll(adviseIdSet);
        ctx.getGroupedMatchMap().clear();
        return this.stepResult;
    }

    private Set<Long> genMatchedBalanceAdvise(Map<String, List<DynamicObject>> groupedMatchMap, BalanceInventoryScheme balanceScheme) {
        String outPutResultEntity = balanceScheme.getDemandModel().getOutPutResultEntity();
        HashSet<Long> adviseIdSet = new HashSet<Long>();
        ArrayList<DynamicObject> reserveMatchInfoList = new ArrayList<DynamicObject>(16);
        for (List<DynamicObject> matchInfoList : groupedMatchMap.values()) {
            List<DynamicObject> balanceAdviseList;
            if (matchInfoList == null || matchInfoList.isEmpty()) continue;
            DynamicObject topMatchInfoEntry = matchInfoList.get(0);
            String demandSrcBillEntityNum = topMatchInfoEntry.getString("demandbilltype");
            String botpRuleId = balanceScheme.getDemandDsMap().get(demandSrcBillEntityNum);
            String demandEntryField = BalanceInvExecuteHelper.getDemandEntryField(demandSrcBillEntityNum, balanceScheme);
            ArrayList<ListSelectedRow> rowList = new ArrayList<ListSelectedRow>(matchInfoList.size());
            HashMap<Long, SumMatchInfo> splitMap = new HashMap<Long, SumMatchInfo>(16);
            for (DynamicObject dynamicObject : matchInfoList) {
                String invType = dynamicObject.getString("invstocktype");
                if ("B".equals(invType)) continue;
                Long entryID = dynamicObject.getLong("demandentryid");
                if (!splitMap.containsKey(entryID)) {
                    SumMatchInfo sumMatchInfo = new SumMatchInfo();
                    sumMatchInfo.setGroup("supplyinvorg", "supplywarehouse", "supplylocation", "supplystoretype", "invstatus");
                    sumMatchInfo.setSum("matchbaseqty");
                    splitMap.put(entryID, sumMatchInfo);
                }
                ((SumMatchInfo)splitMap.get(entryID)).addMatchResultInfo(dynamicObject);
                ListSelectedRow selectedRow = this.buildListSelectedRow(demandEntryField, dynamicObject);
                rowList.add(selectedRow);
            }
            if (rowList.size() <= 0 || (balanceAdviseList = this.convertAdvise(outPutResultEntity, demandSrcBillEntityNum, botpRuleId, rowList)) == null || balanceAdviseList.isEmpty()) continue;
            for (DynamicObject balanceAdvise : balanceAdviseList) {
                adviseIdSet.add(balanceAdvise.getLong("id"));
                this.handleAfterMatchAdviseConvert(topMatchInfoEntry, balanceAdvise, balanceScheme, splitMap);
                this.countAdviseType(balanceAdvise);
            }
            List<DynamicObject> list = this.saveAdviseAndGetReserveInfos(matchInfoList, balanceAdviseList);
            reserveMatchInfoList.addAll(list);
        }
        boolean needReserve = BalanceInvExecuteHelper.getNeedReserve();
        if (needReserve) {
            this.doReserve(balanceScheme, reserveMatchInfoList);
        }
        String detailMsg = this.buildDetailMsg();
        if (!StringUtils.isEmpty((String)this.stepErrorMsg.toString())) {
            this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
        }
        this.stepResult.setDetailMsg(detailMsg);
        this.stepResult.setProcessData(this.matReqCount + this.vmiReqCount + this.transCount + this.vmiTransCount);
        return adviseIdSet;
    }

    private String buildDetailMsg() {
        StringBuilder detailMsg = new StringBuilder();
        detailMsg.append(String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u9886\u6599\u5efa\u8bae\u6570\u91cf\uff1a%1$s\u6761\u3002", (String)"BalanceInvGenMatchAdviseStep_4", (String)"scmc-im-business", (Object[])new Object[0]), this.matReqCount)).append("\n");
        detailMsg.append(String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684VMI\u9886\u6599\u5efa\u8bae\u6570\u91cf\uff1a%1$s\u6761\u3002", (String)"BalanceInvGenMatchAdviseStep_5", (String)"scmc-im-business", (Object[])new Object[0]), this.vmiReqCount)).append("\n");
        detailMsg.append(String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u8c03\u62e8\u5efa\u8bae\u6570\u91cf\uff1a%1$s\u6761\u3002", (String)"BalanceInvGenMatchAdviseStep_6", (String)"scmc-im-business", (Object[])new Object[0]), this.transCount)).append("\n");
        detailMsg.append(String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684VMI\u8c03\u62e8\u5efa\u8bae\u6570\u91cf\uff1a%1$s\u6761\u3002", (String)"BalanceInvGenMatchAdviseStep_7", (String)"scmc-im-business", (Object[])new Object[0]), this.vmiTransCount)).append("\n");
        detailMsg.append((CharSequence)this.stepErrorMsg);
        return detailMsg.toString();
    }

    private List<DynamicObject> convertAdvise(String targetEntity, String sourceEntity, String botpRuleId, List<ListSelectedRow> rowList) {
        ConvertOperationResult covertResult = BalanceInvExecuteHelper.convertBill(sourceEntity, targetEntity, rowList, botpRuleId, false);
        if (!covertResult.isSuccess()) {
            this.stepErrorMsg.append(ResManager.loadKDString((String)"\u5229\u5e93\u5efa\u8bae", (String)"BalanceInvGenMatchAdviseStep_0", (String)"scmc-im-business", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25\uff1a", (String)"BalanceInvGenMatchAdviseStep_1", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
            this.stepErrorMsg.append(BalanceInvExecuteHelper.getConvertErrorMsg(covertResult));
            return new ArrayList<DynamicObject>(0);
        }
        MainEntityType balanceAdviseEntity = EntityMetadataCache.getDataEntityType((String)targetEntity);
        List balanceAdviseList = covertResult.loadTargetDataObjects((objects, dataEntityType) -> BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)dataEntityType), balanceAdviseEntity);
        return balanceAdviseList;
    }

    private ListSelectedRow buildListSelectedRow(String demandEntryField, DynamicObject matchInfo) {
        ListSelectedRow selectedRow = new ListSelectedRow();
        selectedRow.setPrimaryKeyValue((Object)matchInfo.getLong("demandbillid"));
        selectedRow.setBillNo(matchInfo.getString("demandbillno"));
        selectedRow.setEntryEntityKey(demandEntryField);
        selectedRow.setEntryPrimaryKeyValue((Object)matchInfo.getLong("demandentryid"));
        return selectedRow;
    }

    private void countAdviseType(DynamicObject balanceAdvise) {
        String adviseType;
        switch (adviseType = balanceAdvise.getString("advicetype")) {
            case "B": {
                ++this.matReqCount;
                break;
            }
            case "C": {
                ++this.vmiReqCount;
                break;
            }
            case "E": {
                ++this.transCount;
                break;
            }
            case "D": {
                ++this.vmiTransCount;
                break;
            }
        }
    }

    private List<DynamicObject> saveAdviseAndGetReserveInfos(List<DynamicObject> matchInfoList, List<DynamicObject> balanceAdviseList) {
        ArrayList<DynamicObject> reserveMatchInfoList = new ArrayList<DynamicObject>();
        try (TXHandle txHandle = TX.requiresNew((String)"balanceinv_save_advice");){
            try {
                OperationResult result = SaveServiceHelper.saveOperate((String)"im_balanceinv_advice", (DynamicObject[])balanceAdviseList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                Map billNos = result.getBillNos();
                Map<String, String> errorMap = null;
                if (!result.isSuccess()) {
                    List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
                    errorMap = BalanceInvExecuteHelper.getOperateErrorMsg(allErrorOrValidateInfo);
                }
                for (DynamicObject matchInfo : matchInfoList) {
                    String errMsg;
                    if (!result.isSuccess() && errorMap != null && !StringUtils.isEmpty((String)(errMsg = errorMap.get(matchInfo.get("invadvice"))))) {
                        errMsg = ResManager.loadKDString((String)"\u5229\u5e93\u5efa\u8bae\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"BalanceInvGenMatchAdviseStep_2", (String)"scmc-im-business", (Object[])new Object[0]) + "\n" + errMsg;
                        this.stepErrorMsg.append(errMsg).append("\n");
                        matchInfo.set("extrainfo_tag", (Object)errMsg);
                        if (errMsg.length() > 200) {
                            errMsg = errMsg.substring(0, 200);
                        }
                        matchInfo.set("extrainfo", (Object)errMsg);
                    }
                    matchInfo.set("invadvice", billNos.get(matchInfo.get("invadvice")));
                    if (!result.isSuccess() || !matchInfo.get("supplybilltype").equals("im_inv_realbalance")) continue;
                    reserveMatchInfoList.add(matchInfo);
                }
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
                txHandle.markRollback();
                this.stepErrorMsg.append(ResManager.loadKDString((String)"\u5229\u5e93\u5efa\u8bae\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"BalanceInvGenMatchAdviseStep_2", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
                if (BalanceInvContext.get().getDebugMode()) {
                    this.stepErrorMsg.append(BalanceInvExecuteHelper.getExceptionMessage(e));
                } else {
                    this.stepErrorMsg.append(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"BalanceInvStepExecutor_1", (String)"scmc-im-business", (Object[])new Object[0]));
                }
            }
        }
        return reserveMatchInfoList;
    }

    private void doReserve(BalanceInventoryScheme balanceScheme, List<DynamicObject> reserveMatchInfoList) {
        if (reserveMatchInfoList == null || reserveMatchInfoList.isEmpty()) {
            return;
        }
        Map groupedByEntity = reserveMatchInfoList.stream().collect(Collectors.groupingBy(matchInfo -> matchInfo.getString("demandbilltype"), Collectors.toList()));
        for (Map.Entry matchInfoEntry : groupedByEntity.entrySet()) {
            Map reserveResult;
            String demandEntityNum = matchInfoEntry.getKey();
            List matchInfoList = matchInfoEntry.getValue();
            ArrayList<Long> billIdList = new ArrayList<Long>(matchInfoList.size());
            ArrayList<Long> entryIdList = new ArrayList<Long>(matchInfoList.size());
            for (DynamicObject matchInfo2 : matchInfoList) {
                billIdList.add(matchInfo2.getLong("demandbillid"));
                entryIdList.add(matchInfo2.getLong("demandentryid"));
            }
            String entryField = BalanceInvExecuteHelper.getDemandEntryField(demandEntityNum, balanceScheme);
            if (!"pm_requirapplybill".equals(demandEntityNum)) continue;
            Map<Long, Map<String, Object>> entryIdSourceMap = BalanceInvExecuteHelper.getEntryBFRowIdMap(demandEntityNum, entryField, billIdList, entryIdList);
            ArrayList<Map<String, Object>> reserveParamList = new ArrayList<Map<String, Object>>(matchInfoList.size());
            for (DynamicObject matchInfo3 : matchInfoList) {
                Map<String, Object> paramMap = BalanceInvExecuteHelper.buildReserveParam(matchInfo3, entryIdSourceMap, false);
                reserveParamList.add(paramMap);
            }
            if (reserveParamList.isEmpty() || !Boolean.FALSE.equals((reserveResult = BalanceInvExecuteHelper.invokeReserveService(demandEntityNum, "im_inv_realbalance", reserveParamList)).get("success"))) continue;
            this.stepErrorMsg.append(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25\uff1a", (String)"BalanceInvGenMatchAdviseStep_3", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
            this.stepErrorMsg.append(reserveResult.get("errMsg")).append("\n");
        }
    }

    private void handleAfterMatchAdviseConvert(DynamicObject matchInfoEntry, DynamicObject balanceAdvise, BalanceInventoryScheme balanceScheme, Map<Long, SumMatchInfo> splitMap) {
        ORM orm = ORM.create();
        String calculateNum = BalanceInvContext.get().getCalcNum();
        balanceAdvise.set("calculatenum", (Object)calculateNum);
        balanceAdvise.set("balanceinvscheme", (Object)orm.newDynamicObject("balanceinv_scheme", (Object)balanceScheme.getId()));
        balanceAdvise.set("advicetype", (Object)matchInfoEntry.getString("advicetype"));
        String supplyType = matchInfoEntry.getString("supplytype");
        if (!"C".equals(supplyType) && !"D".equals(supplyType)) {
            balanceAdvise.set("supplyorg", (Object)orm.newDynamicObject("bos_org", (Object)matchInfoEntry.getLong("supplyorg")));
        } else {
            balanceAdvise.set("supplier", (Object)orm.newDynamicObject("bd_supplier", (Object)matchInfoEntry.getLong("supplyorg")));
        }
        DynamicObjectCollection entries = balanceAdvise.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection newEntries = new DynamicObjectCollection();
        MainEntityType orgEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_org");
        String ownerType = matchInfoEntry.getString("supplyownertype");
        MainEntityType ownerEntityType = MetadataServiceHelper.getDataEntityType((String)ownerType);
        MainEntityType warehouseEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_warehouse");
        MainEntityType locationEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_location");
        MainEntityType invTypeEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_invtype");
        MainEntityType invStatusEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_invstatus");
        int seq = 0;
        for (DynamicObject entry : entries) {
            Long demandInvOrgId;
            ++seq;
            DynamicObject demandInvOrg = entry.getDynamicObject("invorg");
            if (demandInvOrg == null && (demandInvOrgId = BalanceInvExecuteHelper.getDemandInvOrg(entry.get("demandorg"), this.demandOrgCache)) != null) {
                entry.set("invorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, (Object)demandInvOrgId));
            }
            long demandSrcEntryId = entry.getLong("demandbillentryid");
            SumMatchInfo sumMatchInfo = splitMap.get(demandSrcEntryId);
            int i = 0;
            for (Map<String, Object> sumMatchInfoEntry : sumMatchInfo.getGroupedCollection()) {
                if (i > 0) {
                    ++seq;
                    entry = (DynamicObject)OrmUtils.clone((IDataEntityBase)entry, (boolean)false, (boolean)true);
                    entry.setParent((Object)balanceAdvise);
                    newEntries.add((Object)entry);
                }
                entry.set("ownertype", (Object)ownerType);
                entry.set("owner", (Object)new DynamicObject((DynamicObjectType)ownerEntityType, matchInfoEntry.get("supplyowner")));
                entry.set("adviseqty", sumMatchInfoEntry.get("matchbaseqty"));
                entry.set("baseqty", sumMatchInfoEntry.get("matchbaseqty"));
                entry.set("remaininbaseqty", sumMatchInfoEntry.get("matchbaseqty"));
                entry.set("supplyinvorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, sumMatchInfoEntry.get("supplyinvorg")));
                entry.set("supplywarehouse", (Object)new DynamicObject((DynamicObjectType)warehouseEntityType, sumMatchInfoEntry.get("supplywarehouse")));
                entry.set("supplylocation", (Object)new DynamicObject((DynamicObjectType)locationEntityType, sumMatchInfoEntry.get("supplylocation")));
                entry.set("supplystoretype", (Object)new DynamicObject((DynamicObjectType)invTypeEntityType, sumMatchInfoEntry.get("supplystoretype")));
                entry.set("supplystorestate", (Object)new DynamicObject((DynamicObjectType)invStatusEntityType, sumMatchInfoEntry.get("invstatus")));
                for (DynamicObject matchResultEntry : (List)sumMatchInfoEntry.get("resultList")) {
                    matchResultEntry.set("invadviceseq", (Object)seq);
                    matchResultEntry.set("invadvice", (Object)balanceAdvise.getString("id"));
                }
                entry.set("seq", (Object)seq);
                ++i;
            }
        }
        entries.addAll((Collection)newEntries);
    }
}

