/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.steps.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.func.BillFormulaValueTransFunc;
import kd.scmc.im.business.balanceinv.func.MatchDimensionTransFunc;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.DemandModel;
import kd.scmc.im.business.balanceinv.pojo.MatchDimension;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;

public class BalanceInvGetDemandStep
implements IBalanceInventoryStep {
    private Map<String, Boolean> demandPropMustInputMap = new HashMap<String, Boolean>();
    private StepResult stepResult = new StepResult();

    @Override
    public StepResult execute() {
        BalanceInvContext ctx = BalanceInvContext.get();
        String entityNum = ctx.getEntityNum();
        BalanceInventoryScheme balanceScheme = ctx.getScheme();
        List<Long> entryIdList = ctx.getEntryIds();
        DataSet demandDataSet = this.getDemandBillDataSet(entityNum, entryIdList, balanceScheme, false);
        Set<Long> entryIdSet = this.getFiltedEntryIdSet(entityNum, entryIdList, balanceScheme);
        DynamicObjectCollection demandBillCol = this.filterDemandBills(demandDataSet, entryIdSet, balanceScheme);
        ctx.setDemandBillCol(demandBillCol);
        if (demandBillCol == null || demandBillCol.isEmpty()) {
            this.stepResult.setSuccess(false);
            this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_B);
            this.stepResult.setDetailMsg(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b26\u5408\u6761\u4ef6\u7684\u9700\u6c42\u6570\u636e\u3002", (String)"BalanceInvGetDemandStep_0", (String)"scmc-im-business", (Object[])new Object[0]));
            return this.stepResult;
        }
        if ("pm_requirapplybill".equals(entityNum)) {
            this.releasePreInReserve(ctx, demandBillCol);
        }
        return this.stepResult;
    }

    private void releasePreInReserve(BalanceInvContext ctx, DynamicObjectCollection demandBillCol) {
        try {
            boolean needReserve = BalanceInvExecuteHelper.getNeedReserve();
            if (needReserve && demandBillCol != null) {
                Set<Long> entryIds = demandBillCol.stream().map(bill -> bill.getLong("entryentity.billentryid")).collect(Collectors.toSet());
                BalanceInvExecuteHelper.releaseReserveRecord(entryIds);
            }
        }
        catch (Exception e) {
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append(ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u5931\u8d25\u3002", (String)"IM-D-036010", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
            if (ctx.getDebugMode()) {
                msgBuilder.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            this.stepResult.setDetailMsg(msgBuilder.toString());
        }
    }

    private DynamicObjectCollection filterDemandBills(DataSet demandDataSet, Set<Long> entryIdSet, BalanceInventoryScheme balanceScheme) {
        ORM orm = ORM.create();
        DynamicObjectCollection demandBillCol = null;
        ArrayList<Row> demandDataList = new ArrayList<Row>(10);
        Set<Long> demandOrgIds = balanceScheme.getSupplyPolicyMap().keySet();
        RowMeta rowMeta = demandDataSet.getRowMeta();
        int processData = 0;
        int successCount = 0;
        while (demandDataSet.hasNext()) {
            ++processData;
            Row row = demandDataSet.next();
            String checkMsg = this.getDemandBillMustInputCheckMsg(rowMeta, row, balanceScheme);
            if (!StringUtils.isEmpty((String)checkMsg)) {
                this.addErrorMatchResultEntry(rowMeta, row, balanceScheme, checkMsg);
                continue;
            }
            if (!entryIdSet.contains(row.getLong("entryentity.billentryid"))) {
                if (!demandOrgIds.contains(row.getLong("entryentity.demandorg"))) {
                    this.addErrorMatchResultEntry(rowMeta, row, balanceScheme, ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u672a\u5728\u5229\u5e93\u65b9\u6848\u4e2d\u7ec4\u7ec7\u53c2\u6570\u4e2d\u7ef4\u62a4\u3002", (String)"BalanceInvGetDemandStep_1", (String)"scmc-im-business", (Object[])new Object[0]));
                    continue;
                }
                this.addErrorMatchResultEntry(rowMeta, row, balanceScheme, ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u9700\u6c42\u6765\u6e90\u5b9e\u4f53\u7684\u53d6\u6570\u6761\u4ef6\u3002", (String)"BalanceInvGetDemandStep_2", (String)"scmc-im-business", (Object[])new Object[0]));
                continue;
            }
            if (row.getBigDecimal("entryentity.demandqty").compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMatchResultEntry(rowMeta, row, balanceScheme, ResManager.loadKDString((String)"\u672a\u5e73\u8861\u5229\u5e93\u6570\u91cf\u5c0f\u4e8e\u7b49\u4e8e0\u3002", (String)"BalanceInvGetDemandStep_4", (String)"scmc-im-business", (Object[])new Object[0]));
                continue;
            }
            ++successCount;
            demandDataList.add(row);
        }
        if (!demandDataList.isEmpty()) {
            demandBillCol = orm.toPlainDynamicObjectCollection(demandDataList, rowMeta, 0, demandDataList.size());
        }
        this.stepResult.setProcessData(processData);
        StringBuilder detailMsg = new StringBuilder();
        detailMsg.append(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u9700\u6c42\u6570\u636e\u5171\uff1a%1$s\u6761\u3002", (String)"BalanceInvGetDemandStep_5", (String)"scmc-im-business", (Object[])new Object[0]), processData)).append("\n");
        detailMsg.append(String.format(ResManager.loadKDString((String)"\u5176\u4e2d\u7b26\u5408\u6761\u4ef6\u6570\u636e\uff1a%1$s\u6761\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u6570\u636e\uff1a%2$s\u6761\u3002", (String)"BalanceInvGetDemandStep_6", (String)"scmc-im-business", (Object[])new Object[0]), successCount, processData - successCount));
        this.stepResult.setDetailMsg(detailMsg.toString());
        return demandBillCol;
    }

    private String getDemandBillMustInputCheckMsg(RowMeta rowMeta, Row row, BalanceInventoryScheme balanceScheme) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"balanceinv_demandbill");
        EntityType entryEntity = (EntityType)dataEntityType.getAllEntities().get("entryentity");
        Collection entryProps = entryEntity.getFields().values();
        StringBuilder errorMsg = new StringBuilder();
        for (IDataEntityProperty prop : entryProps) {
            Object value;
            boolean mustInput = BalanceInvExecuteHelper.isPropMustInput(prop, this.demandPropMustInputMap);
            if (!mustInput || (value = BalanceInvExecuteHelper.getValue(rowMeta, row, "entryentity." + prop.getName())) != null && (!(value instanceof Long) || (Long)value != 0L)) continue;
            errorMsg.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceInvGetDemandStep_7", (String)"scmc-im-business", (Object[])new Object[]{prop.getDisplayName().getLocaleValue()}));
        }
        return errorMsg.toString();
    }

    private void addErrorMatchResultEntry(RowMeta rowMeta, Row row, BalanceInventoryScheme balanceScheme, String errorMsg) {
        BalanceInvContext ctx = BalanceInvContext.get();
        DynamicObject matchResultInfo = ctx.getMatchResultInfo();
        DynamicObject newEntry = matchResultInfo.getDynamicObjectCollection("entryentity").addNew();
        Map<String, String> demandMatchResultFieldMap = balanceScheme.getDemandMatchResultFieldMap();
        for (Map.Entry<String, String> matchField : demandMatchResultFieldMap.entrySet()) {
            newEntry.set(matchField.getValue(), BalanceInvExecuteHelper.getValue(rowMeta, row, matchField.getKey()));
        }
        newEntry.set("extrainfo_tag", (Object)errorMsg);
        if (errorMsg.length() > 200) {
            errorMsg = errorMsg.substring(0, 200);
        }
        newEntry.set("extrainfo", (Object)errorMsg);
    }

    private DataSet getDemandBillDataSet(String entityNum, List<Long> entryIdList, BalanceInventoryScheme balanceScheme, boolean filterDataSource) {
        DemandModel demandModel = balanceScheme.getDemandModel();
        List<QFilter> filterList = BalanceInvExecuteHelper.getDemandFilter(entityNum, entryIdList, balanceScheme, filterDataSource);
        String selector = demandModel.getMatchSelector(entityNum);
        String[] orderArr = balanceScheme.getDemandOrderArr();
        MatchDimension matchDimension = balanceScheme.getMatchDimension();
        DataSet demandDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityNum, (String)selector, (QFilter[])filterList.toArray(new QFilter[0]), (String)"");
        RowMeta rowMeta = demandDataSet.getRowMeta();
        Map<String, String> targetFormulaMap = demandModel.getTargetExpressionMap(entityNum);
        ArrayList<String> matchFields = new ArrayList<String>();
        matchFields.addAll(matchDimension.getDemandMatchFields());
        matchFields.removeAll(balanceScheme.getDemandNullMatchFields());
        demandDataSet = demandDataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, targetFormulaMap)).map((MapFunction)new MatchDimensionTransFunc(rowMeta, matchFields, "entryentity.flexmetricid"));
        demandDataSet = demandDataSet.addField("''", "allmatchfieldkey");
        demandDataSet = demandDataSet.map((MapFunction)new MatchDimensionTransFunc(demandDataSet.getRowMeta(), matchDimension.getDemandMatchFields(), "allmatchfieldkey"));
        if (orderArr != null && orderArr.length > 0) {
            demandDataSet = demandDataSet.orderBy(orderArr);
        }
        return demandDataSet;
    }

    private Set<Long> getFiltedEntryIdSet(String entityNum, List<Long> entryIdList, BalanceInventoryScheme balanceScheme) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        DemandModel demandModel = balanceScheme.getDemandModel();
        String entryField = BalanceInvExecuteHelper.getDemandEntryField(entityNum, balanceScheme);
        QFilter idFilter = new QFilter(entryField + ".id", "in", entryIdList);
        filterList.add(idFilter);
        QFilter dataSourceFilter = demandModel.getDataSourceFilter(entityNum);
        if (dataSourceFilter != null) {
            filterList.add(dataSourceFilter);
        }
        String demandOrgField = demandModel.getTarget2SourceFieldMap(entityNum).get("entryentity.demandorg");
        Set<Long> demandOrgIds = balanceScheme.getSupplyPolicyMap().keySet();
        QFilter demandOrgFilter = new QFilter(demandOrgField, "in", demandOrgIds);
        filterList.add(demandOrgFilter);
        StringBuilder selector = new StringBuilder();
        String entryIdField = demandModel.getTarget2SourceFieldMap(entityNum).get("entryentity.billentryid");
        if (StringUtils.isEmpty((String)entryIdField)) {
            entryIdField = "''";
        }
        selector.append(entryIdField).append(" as ").append("entryentity.billentryid");
        String entryIdExpression = demandModel.getTargetExpressionMap(entityNum).get("entryentity.billentryid");
        if (!StringUtils.isEmpty((String)entryIdExpression)) {
            String[] variables;
            for (String variable : variables = FormulaEngine.extractVariables((String)entryIdExpression)) {
                selector.append(",");
                selector.append(variable).append(" as ").append(variable).append("_XX");
            }
        }
        DataSet demandDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityNum, (String)selector.toString(), (QFilter[])filterList.toArray(new QFilter[0]), (String)"");
        if (!StringUtils.isEmpty((String)entryIdExpression)) {
            RowMeta rowMeta = demandDataSet.getRowMeta();
            HashMap<String, String> targetFormulaMap = new HashMap<String, String>(1);
            targetFormulaMap.put("entryentity.billentryid", entryIdExpression);
            demandDataSet = demandDataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, targetFormulaMap));
        }
        HashSet<Long> entryIdSet = new HashSet<Long>();
        for (Row row : demandDataSet) {
            entryIdSet.add(row.getLong("entryentity.billentryid"));
        }
        return entryIdSet;
    }

    private void removePreSupplyRecordById(Set<Object> id) {
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"balanceinv_pre_record"), (Object[])id.toArray());
    }
}

