/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.steps.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.func.BillFormulaValueTransFunc;
import kd.scmc.im.business.balanceinv.func.MatchDimensionTransFunc;
import kd.scmc.im.business.balanceinv.func.MatchOrderCalFunc;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.InvDimensionInfo;
import kd.scmc.im.business.balanceinv.pojo.InvLevelInfo;
import kd.scmc.im.business.balanceinv.pojo.MatchDimension;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.pojo.SupplyModel;
import kd.scmc.im.business.balanceinv.pojo.SupplyPolicy;
import kd.scmc.im.business.balanceinv.pojo.SupplyQtyInfo;
import kd.scmc.im.business.balanceinv.pojo.SupplyRelation;
import kd.scmc.im.business.balanceinv.pojo.SupplySafeQtyInfo;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;

public class BalanceInvGetSupplyStep
implements IBalanceInventoryStep {
    private StepResult stepResult = new StepResult();
    private static final String ALGO = "kd.scmc.im.business.balanceinv.steps.impl.BalanceInvGetSupplyStep";
    private Log logger = LogFactory.getLog(BalanceInvGetSupplyStep.class);

    @Override
    public StepResult execute() {
        BalanceInvContext ctx = BalanceInvContext.get();
        BalanceInventoryScheme scheme = ctx.getScheme();
        HashMap<String, List<DynamicObject>> supplyBillsGroupedMap = new HashMap<String, List<DynamicObject>>();
        HashMap<String, List<DynamicObject>> supplyNullGroupedMap = new HashMap<String, List<DynamicObject>>();
        Map<Long, DynamicObjectCollection> demandBillGroupedMap = this.groupDemandBillsByDemandOrg(ctx.getDemandBillCol());
        int processData = 0;
        for (Long demandOrgId : scheme.getSupplyPolicyMap().keySet()) {
            if (!demandBillGroupedMap.containsKey(demandOrgId)) continue;
            List<Map<String, List<QFilter>>> supplyBillFilterMap = this.getSupplyBillFilterMap(scheme, demandBillGroupedMap.get(demandOrgId), demandOrgId);
            DynamicObjectCollection supplyBillCol = this.getSupplyBillCol(supplyBillFilterMap, scheme, demandOrgId);
            for (DynamicObject supplyBill : supplyBillCol) {
                ++processData;
                String groupValue = demandOrgId + "$" + supplyBill.getString("entryentity.flexmetricid");
                supplyBillsGroupedMap.putIfAbsent(groupValue, new ArrayList());
                ((List)supplyBillsGroupedMap.get(groupValue)).add(supplyBill);
                groupValue = demandOrgId + "$" + supplyBill.getString("allmatchfieldkey");
                supplyNullGroupedMap.putIfAbsent(groupValue, new ArrayList());
                ((List)supplyNullGroupedMap.get(groupValue)).add(supplyBill);
            }
        }
        ctx.setSupplyBillGroupedMap(supplyBillsGroupedMap);
        ctx.setSupplyNullGroupedMap(supplyNullGroupedMap);
        Map<String, List<QFilter>> supplyQtyFilterMap = this.getSupplyQtyFilterMap(scheme);
        Map<Long, SupplyQtyInfo> entryId2SupplyQtyMap = this.getEntryId2SupplyQtyMap(supplyQtyFilterMap, scheme);
        ctx.setEntryId2SupplyQtyMap(entryId2SupplyQtyMap);
        this.stepResult.setProcessData(processData);
        this.stepResult.setDetailMsg(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u4f9b\u5e94\u6570\u636e\u5171\uff1a%1$s\u6761\u3002", (String)"BalanceInvGetSupplyStep_0", (String)"scmc-im-business", (Object[])new Object[0]), processData));
        return this.stepResult;
    }

    private Map<Long, DynamicObjectCollection> groupDemandBillsByDemandOrg(DynamicObjectCollection demandBillCol) {
        HashMap<Long, DynamicObjectCollection> demandBillGroupedMap = new HashMap<Long, DynamicObjectCollection>();
        for (DynamicObject demandBill : demandBillCol) {
            demandBillGroupedMap.putIfAbsent(demandBill.getLong("entryentity.demandorg"), new DynamicObjectCollection());
            ((DynamicObjectCollection)demandBillGroupedMap.get(demandBill.getLong("entryentity.demandorg"))).add((Object)demandBill);
        }
        return demandBillGroupedMap;
    }

    private Map<Long, SupplyQtyInfo> getEntryId2SupplyQtyMap(Map<String, List<QFilter>> supplyBillFilterMap, BalanceInventoryScheme balanceScheme) {
        HashMap<Long, SupplyQtyInfo> supplyBaseQtyMap = new HashMap<Long, SupplyQtyInfo>();
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        for (String entityNum : balanceScheme.getSupplyDsList()) {
            List<QFilter> filterList = supplyBillFilterMap.get(entityNum);
            if (BalanceInvContext.get().getDebugMode()) {
                this.logger.info(entityNum + "\u7684\u8fc7\u6ee4\u6761\u4ef6\u4e3a:" + BalanceInvExecuteHelper.getStringFilter(filterList));
            }
            StringBuilder selectorBuilder = new StringBuilder();
            selectorBuilder.append(supplyModel.getFieldSelector(entityNum, "entryentity.billentryid")).append(",");
            selectorBuilder.append(supplyModel.getFieldSelector(entityNum, "entryentity.usablebaseqty")).append(",");
            selectorBuilder.append(supplyModel.getFieldSelector(entityNum, "entryentity.qty")).append(",");
            selectorBuilder.append(supplyModel.getFieldSelector(entityNum, "entryentity.assitqty"));
            InvDimensionInfo invDimensionInfo = balanceScheme.getInvDimensionInfo();
            if (invDimensionInfo != null) {
                List<String> supplyFields = invDimensionInfo.getSupplyFields();
                for (String supplyField : supplyFields) {
                    selectorBuilder.append(",");
                    selectorBuilder.append(supplyModel.getFieldSelector(entityNum, supplyField));
                }
            }
            selectorBuilder.append(",0 as ").append("safeinv");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)entityNum, (String)selectorBuilder.toString(), (QFilter[])filterList.toArray(new QFilter[0]), (String)"");
            Map<String, String> targetExpressionMap = supplyModel.getTargetExpressionMap(entityNum);
            HashMap<String, String> formulaMap = new HashMap<String, String>();
            if (targetExpressionMap.containsKey("entryentity.billentryid")) {
                formulaMap.put("entryentity.billentryid", targetExpressionMap.get("entryentity.billentryid"));
            }
            if (targetExpressionMap.containsKey("entryentity.usablebaseqty")) {
                formulaMap.put("entryentity.usablebaseqty", targetExpressionMap.get("entryentity.usablebaseqty"));
            }
            if (targetExpressionMap.containsKey("entryentity.qty")) {
                formulaMap.put("entryentity.qty", targetExpressionMap.get("entryentity.qty"));
            }
            if (targetExpressionMap.containsKey("entryentity.assitqty")) {
                formulaMap.put("entryentity.assitqty", targetExpressionMap.get("entryentity.assitqty"));
            }
            if (invDimensionInfo != null) {
                List<String> supplyFields = invDimensionInfo.getSupplyFields();
                for (String supplyField : supplyFields) {
                    if (!targetExpressionMap.containsKey(supplyField)) continue;
                    formulaMap.put(supplyField, targetExpressionMap.get(supplyField));
                }
            }
            RowMeta rowMeta = dataSet.getRowMeta();
            if (!formulaMap.isEmpty()) {
                dataSet = dataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, formulaMap));
            }
            Map<String, InvLevelInfo> invLevelMap = BalanceInvContext.get().getSupplyInvLevelMap();
            HashMap<String, SupplySafeQtyInfo> safeQtyInfoMap = new HashMap<String, SupplySafeQtyInfo>();
            for (Row row : dataSet) {
                SupplyQtyInfo supplyQtyInfo = new SupplyQtyInfo();
                BigDecimal baseQty = row.getBigDecimal("entryentity.usablebaseqty");
                supplyQtyInfo.setBaseQty(baseQty);
                if (row.get("entryentity.qty") != null && !StringUtils.isEmpty((String)row.get("entryentity.qty").toString())) {
                    supplyQtyInfo.setQty(row.getBigDecimal("entryentity.qty"));
                }
                if (row.get("entryentity.assitqty") != null && !StringUtils.isEmpty((String)row.get("entryentity.assitqty").toString())) {
                    supplyQtyInfo.setQty2nd(row.getBigDecimal("entryentity.assitqty"));
                }
                if (invDimensionInfo != null && "im_inv_realbalance".equals(entityNum) && invLevelMap != null && !invLevelMap.isEmpty()) {
                    StringBuilder invDimensionValueBuilder = new StringBuilder();
                    List<String> supplyFields = invDimensionInfo.getSupplyFields();
                    for (String supplyField : supplyFields) {
                        invDimensionValueBuilder.append(row.get(supplyField)).append("$");
                    }
                    if (invLevelMap.containsKey(invDimensionValueBuilder.toString())) {
                        SupplySafeQtyInfo supplySafeQtyInfo = (SupplySafeQtyInfo)safeQtyInfoMap.get(invDimensionValueBuilder.toString());
                        if (supplySafeQtyInfo == null) {
                            supplySafeQtyInfo = new SupplySafeQtyInfo();
                            supplySafeQtyInfo.setSafeQty(invLevelMap.get(invDimensionValueBuilder.toString()).getSafeQty());
                            safeQtyInfoMap.put(invDimensionValueBuilder.toString(), supplySafeQtyInfo);
                        }
                        supplySafeQtyInfo.setTotalQty(supplySafeQtyInfo.getTotalQty().add(baseQty));
                        supplyQtyInfo.setSafeQtyInfo(supplySafeQtyInfo);
                    }
                }
                supplyBaseQtyMap.put(row.getLong("entryentity.billentryid"), supplyQtyInfo);
            }
        }
        this.subtractReserveQty(supplyBaseQtyMap);
        return supplyBaseQtyMap;
    }

    private DynamicObjectCollection getSupplyBillCol(List<Map<String, List<QFilter>>> filterList, BalanceInventoryScheme balanceScheme, Long demandOrgId) {
        Map<String, List<QFilter>> supplyBillFilterMap = filterList.get(0);
        Map<String, List<QFilter>> nullFieldFilterMap = filterList.get(1);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        MatchDimension matchDimension = balanceScheme.getMatchDimension();
        SupplyPolicy supplyPolicy = balanceScheme.getSupplyPolicyMap().get(demandOrgId);
        SupplyRelation supplyRelation = balanceScheme.getSupplyRelationMap().get(demandOrgId);
        DynamicObjectCollection preRecordCollection = new DynamicObjectCollection();
        StringBuilder selectorBuilder = new StringBuilder();
        for (Map.Entry<String, List<QFilter>> supplyFilterEntry : supplyBillFilterMap.entrySet()) {
            String supplyEntityNumber = supplyFilterEntry.getKey();
            QFilter[] qFilters = supplyFilterEntry.getValue().toArray(new QFilter[0]);
            String selector = supplyModel.getMatchSelector(supplyEntityNumber);
            selectorBuilder.append(selector);
            selectorBuilder.append(",-1 as ").append("supplyorder");
            selectorBuilder.append(",-1 as ").append("priority");
            selectorBuilder.append(",-1 as ").append("supplypriority");
            selectorBuilder.append(",-1 as ").append("invstatuspriority");
            selectorBuilder.append(",-1 as ").append("invtypepriority");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)supplyEntityNumber, (String)selectorBuilder.toString(), (QFilter[])qFilters, (String)"");
            if (BalanceInvContext.get().getDebugMode()) {
                this.logger.info("\u9700\u6c42\u5355\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a" + BalanceInvExecuteHelper.getStringFilter(Arrays.asList(qFilters)));
            }
            selectorBuilder.setLength(0);
            RowMeta rowMeta = dataSet.getRowMeta();
            Map<String, String> targetFormulaMap = supplyModel.getTargetExpressionMap(supplyEntityNumber);
            ArrayList<String> matchFields = new ArrayList<String>();
            matchFields.addAll(matchDimension.getSupplyMatchFields());
            matchFields.removeAll(balanceScheme.getSupplyNullMatchFields());
            dataSet = dataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, targetFormulaMap)).map((MapFunction)new MatchDimensionTransFunc(rowMeta, matchFields, "entryentity.flexmetricid"));
            dataSet = dataSet.addField("''", "allmatchfieldkey");
            dataSet = dataSet.map((MapFunction)new MatchDimensionTransFunc(dataSet.getRowMeta(), matchDimension.getSupplyMatchFields(), "allmatchfieldkey"));
            ORM orm = ORM.create();
            if (dataSet.isEmpty()) continue;
            if ("im_inv_realbalance".equals(supplyEntityNumber)) {
                dataSet = dataSet.map((MapFunction)new MatchOrderCalFunc(supplyPolicy, dataSet.getRowMeta(), supplyRelation));
                dataSet = dataSet.orderBy(new String[]{"invtypepriority", "invstatuspriority", "priority", "supplypriority", "supplyorder"});
                dynamicObjectCollection.addAll(0, (Collection)orm.toPlainDynamicObjectCollection(dataSet));
                continue;
            }
            List<QFilter> dataSetFilter = nullFieldFilterMap.get(supplyEntityNumber);
            if (dataSetFilter.size() > 0) {
                dataSet = dataSet.filter(this.getStringFilter(dataSetFilter));
            }
            preRecordCollection.addAll((Collection)orm.toPlainDynamicObjectCollection(dataSet));
        }
        this.sortBySupplyDate(preRecordCollection);
        dynamicObjectCollection.addAll((Collection)preRecordCollection);
        return dynamicObjectCollection;
    }

    private void sortBySupplyDate(DynamicObjectCollection preRecordCollection) {
        preRecordCollection.sort((o1, o2) -> {
            Date date1 = o1.getDate("entryentity.billdate");
            Date date2 = o2.getDate("entryentity.billdate");
            if (date1 != null && date2 != null) {
                return date1.compareTo(date2);
            }
            if (date1 == null) {
                return -1;
            }
            return 1;
        });
    }

    private String getStringFilter(List<QFilter> dataSetFilter) {
        QFilter qFilter = null;
        for (QFilter filter : dataSetFilter) {
            if (qFilter == null) {
                qFilter = filter;
                continue;
            }
            qFilter = qFilter.and(filter);
        }
        return qFilter == null ? null : qFilter.toString();
    }

    private List<Map<String, List<QFilter>>> getSupplyBillFilterMap(BalanceInventoryScheme balanceScheme, DynamicObjectCollection demandBillCol, Long demandOrgId) {
        SupplyRelation supplyRelation = balanceScheme.getSupplyRelationMap().get(demandOrgId);
        SupplyPolicy supplyPolicy = balanceScheme.getSupplyPolicyMap().get(demandOrgId);
        MatchDimension matchDimension = balanceScheme.getMatchDimension();
        Map<String, String> fieldMatchMap = matchDimension.getDemand2SupplyMatchFieldMap();
        HashMap supplyFilterMap = new HashMap(balanceScheme.getSupplyDsList().size());
        HashMap nullSupplyFilterMap = new HashMap(balanceScheme.getSupplyDsList().size());
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        for (String entityNumber : balanceScheme.getSupplyDsList()) {
            QFilter ownerAndSupplyFilter;
            Map<String, String> target2SourceFieldMap = supplyModel.getTarget2SourceFieldMap(entityNumber);
            String supplyOrgField = target2SourceFieldMap.get("entryentity.supplyorgunit");
            String storageOrgField = target2SourceFieldMap.get("entryentity.stockorg");
            String supplyWarehouseField = target2SourceFieldMap.get("entryentity.stock");
            String supplyLocationField = target2SourceFieldMap.get("entryentity.stockindex");
            String supplyStoreTypeField = target2SourceFieldMap.get("entryentity.stocktype");
            String supplyStoreStateField = target2SourceFieldMap.get("entryentity.stockstatus");
            String ownerTypeField = target2SourceFieldMap.get("entryentity.owertype");
            ArrayList<QFilter> matchFilterList = new ArrayList<QFilter>();
            ArrayList<QFilter> nullFilterList = new ArrayList<QFilter>();
            if (StringUtils.isNotEmpty((String)ownerTypeField) && StringUtils.isNotEmpty((String)supplyOrgField)) {
                ownerAndSupplyFilter = this.buildOwnerAndSupplyFilter(ownerTypeField, supplyOrgField, demandOrgId, supplyRelation);
                if (ownerAndSupplyFilter != null) {
                    matchFilterList.add(ownerAndSupplyFilter);
                }
            } else {
                ownerAndSupplyFilter = this.buildOwnerAndSupplyFilter("entryentity.owertype", "entryentity.supplyorgunit", demandOrgId, supplyRelation);
                if (ownerAndSupplyFilter != null) {
                    nullFilterList.add(ownerAndSupplyFilter);
                }
            }
            if ("im_inv_realbalance".equals(entityNumber)) {
                matchFilterList.addAll(supplyPolicy.getPolicyFilterList(storageOrgField, supplyWarehouseField, supplyLocationField, supplyStoreTypeField, supplyStoreStateField, entityNumber));
            } else {
                QFilter supplyPolicyStockOrgFilter = supplyPolicy.getPrePolicyFilterList(storageOrgField);
                if (StringUtils.isNotEmpty((String)storageOrgField) && supplyPolicyStockOrgFilter != null) {
                    matchFilterList.add(supplyPolicyStockOrgFilter);
                } else if (StringUtils.isEmpty((String)storageOrgField) && supplyPolicyStockOrgFilter != null) {
                    nullFilterList.add(supplyPolicyStockOrgFilter);
                }
            }
            Map<String, Set<Object>> sourceValueMap = matchDimension.getSourceValueMap(demandBillCol);
            List<String> demandNullMatchFields = balanceScheme.getDemandNullMatchFields();
            for (String string : demandNullMatchFields) {
                sourceValueMap.remove(string);
            }
            for (Map.Entry entry : sourceValueMap.entrySet()) {
                String supplyModelField = fieldMatchMap.get(entry.getKey());
                if (!StringUtils.isEmpty((String)supplyModelField) && !StringUtils.isEmpty((String)target2SourceFieldMap.get(supplyModelField))) {
                    QFilter filter = new QFilter(target2SourceFieldMap.get(supplyModelField), "in", entry.getValue());
                    matchFilterList.add(filter);
                    continue;
                }
                if (StringUtils.isEmpty((String)supplyModelField) || !StringUtils.isEmpty((String)target2SourceFieldMap.get(supplyModelField))) continue;
                nullFilterList.add(new QFilter(supplyModelField, "in", entry.getValue()));
            }
            QFilter supplyFilter = supplyModel.getDataSourceFilter(entityNumber);
            if (supplyFilter != null) {
                matchFilterList.add(supplyFilter);
            }
            supplyFilterMap.put(entityNumber, matchFilterList);
            nullSupplyFilterMap.put(entityNumber, nullFilterList);
        }
        ArrayList<Map<String, List<QFilter>>> result = new ArrayList<Map<String, List<QFilter>>>(2);
        result.add(supplyFilterMap);
        result.add(nullSupplyFilterMap);
        return result;
    }

    private QFilter buildOwnerAndSupplyFilter(String ownerTypeField, String supplyOrgField, Long demandOrgId, SupplyRelation supplyRelation) {
        QFilter ownerTypeFilter = new QFilter(ownerTypeField, "=", (Object)"bd_supplier");
        QFilter relationFilter = null;
        relationFilter = supplyRelation != null ? supplyRelation.getRelationFilter(supplyOrgField) : new QFilter(supplyOrgField, "=", (Object)demandOrgId);
        if (relationFilter != null) {
            return relationFilter.or(ownerTypeFilter);
        }
        return null;
    }

    private Map<String, List<QFilter>> getSupplyQtyFilterMap(BalanceInventoryScheme balanceScheme) {
        BalanceInvContext ctx = BalanceInvContext.get();
        Map<Long, SupplyRelation> supplyRelationMap = balanceScheme.getSupplyRelationMap();
        HashSet<Long> supplyOrgSet = new HashSet<Long>();
        for (Map.Entry<Long, SupplyRelation> supplyRelationEntry : supplyRelationMap.entrySet()) {
            if (supplyRelationEntry.getValue() == null) {
                supplyOrgSet.add(supplyRelationEntry.getKey());
                continue;
            }
            supplyOrgSet.addAll(supplyRelationEntry.getValue().getSupplyOrg2OrderMap().keySet());
        }
        Map<Long, SupplyPolicy> supplyPolicyMap = balanceScheme.getSupplyPolicyMap();
        HashSet<Long> storageOrgIdSet = new HashSet<Long>();
        for (Map.Entry<Long, SupplyPolicy> supplyPolicyEntry : supplyPolicyMap.entrySet()) {
            storageOrgIdSet.addAll(supplyPolicyEntry.getValue().getStorageOrgSetMap().keySet());
        }
        HashMap<String, List<QFilter>> supplyFilterMap = new HashMap<String, List<QFilter>>(balanceScheme.getSupplyDsList().size());
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        for (String entityNumber : balanceScheme.getSupplyDsList()) {
            QFilter dataSourceFilter;
            Map<String, String> target2SourceFieldMap = supplyModel.getTarget2SourceFieldMap(entityNumber);
            String supplyOrgField = target2SourceFieldMap.get("entryentity.supplyorgunit");
            String storageOrgField = target2SourceFieldMap.get("entryentity.stockorg");
            String materialField = target2SourceFieldMap.get("entryentity.material");
            String ownerTypeField = target2SourceFieldMap.get("entryentity.owertype");
            ArrayList<QFilter> matchFilterList = new ArrayList<QFilter>();
            if (!StringUtils.isEmpty((String)supplyOrgField)) {
                QFilter supplyOrgFilter = new QFilter(supplyOrgField, "in", supplyOrgSet);
                if (!StringUtils.isEmpty((String)ownerTypeField)) {
                    QFilter ownerTypeFilter = new QFilter(ownerTypeField, "=", (Object)"bd_supplier");
                    supplyOrgFilter = supplyOrgFilter.or(ownerTypeFilter);
                }
                matchFilterList.add(supplyOrgFilter);
            }
            if (!StringUtils.isEmpty((String)storageOrgField)) {
                matchFilterList.add(new QFilter(storageOrgField, "in", storageOrgIdSet));
            }
            if (!StringUtils.isEmpty((String)materialField)) {
                matchFilterList.add(new QFilter(materialField, "in", ctx.getMaterialIdSet()));
            }
            if ((dataSourceFilter = supplyModel.getDataSourceFilter(entityNumber)) != null) {
                matchFilterList.add(dataSourceFilter);
            }
            supplyFilterMap.put(entityNumber, matchFilterList);
        }
        return supplyFilterMap;
    }

    private void subtractReserveQty(Map<Long, SupplyQtyInfo> supplyBaseQtyMap) {
        if (supplyBaseQtyMap.size() > 0) {
            QFilter qFilter = new QFilter("bal_entryid", "in", supplyBaseQtyMap.keySet()).and("base_qty", ">", (Object)0).and("ispredict", "=", (Object)true);
            Map<Long, Map<String, BigDecimal>> reserveQty = this.queryReserveQty(qFilter);
            for (Map.Entry<Long, Map<String, BigDecimal>> entry : reserveQty.entrySet()) {
                Long key = entry.getKey();
                SupplyQtyInfo supplyQtyInfo = supplyBaseQtyMap.get(key);
                if (supplyQtyInfo == null) continue;
                this.dealQty(supplyQtyInfo, entry.getValue());
            }
        }
    }

    private Map<Long, Map<String, BigDecimal>> queryReserveQty(QFilter qFilter) {
        HashMap<Long, Map<String, BigDecimal>> reserveQtyMap = new HashMap<Long, Map<String, BigDecimal>>();
        DataSet reserveRecord = QueryServiceHelper.queryDataSet((String)ALGO, (String)"msmod_reserve_record", (String)"bal_entryid,qty,base_qty, qty2nd", (QFilter[])new QFilter[]{qFilter}, null);
        for (Row row : reserveRecord) {
            Long balEntryId = row.getLong("bal_entryid");
            BigDecimal qty = row.getBigDecimal("qty");
            BigDecimal baseQty = row.getBigDecimal("base_qty");
            BigDecimal qty2nd = row.getBigDecimal("qty2nd");
            HashMap<String, BigDecimal> qtyMap = (HashMap<String, BigDecimal>)reserveQtyMap.get(balEntryId);
            if (qtyMap == null) {
                qtyMap = new HashMap<String, BigDecimal>(4);
            } else {
                qty = qty.add((BigDecimal)qtyMap.get("entryentity.qty"));
                baseQty = baseQty.add((BigDecimal)qtyMap.get("entryentity.usablebaseqty"));
                qty2nd = qty2nd.add((BigDecimal)qtyMap.get("entryentity.assitqty"));
            }
            qtyMap.put("entryentity.qty", qty);
            qtyMap.put("entryentity.usablebaseqty", baseQty);
            qtyMap.put("entryentity.assitqty", qty2nd);
            reserveQtyMap.put(balEntryId, qtyMap);
        }
        return reserveQtyMap;
    }

    private void dealQty(SupplyQtyInfo supplyQtyInfo, Map<String, BigDecimal> qtyMap) {
        BigDecimal baseQty = supplyQtyInfo.getBaseQty().subtract(qtyMap.get("entryentity.usablebaseqty"));
        BigDecimal qty = supplyQtyInfo.getQty().subtract(qtyMap.get("entryentity.qty"));
        BigDecimal qty2nd = supplyQtyInfo.getQty2nd().subtract(qtyMap.get("entryentity.assitqty"));
        supplyQtyInfo.setBaseQty(baseQty.compareTo(BigDecimal.ZERO) > 0 ? baseQty : BigDecimal.ZERO);
        supplyQtyInfo.setQty(qty.compareTo(BigDecimal.ZERO) > 0 ? qty : BigDecimal.ZERO);
        supplyQtyInfo.setQty2nd(qty2nd.compareTo(BigDecimal.ZERO) > 0 ? qty2nd : BigDecimal.ZERO);
    }
}

