/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.steps.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.InvLevelInfo;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.pojo.SupplyRelation;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;

public class BalanceInvInitInvLevelStep
implements IBalanceInventoryStep {
    private StepResult stepResult = new StepResult();
    private static String ALGO = "kd.scmc.im.business.balanceinv.steps.impl.BalanceInvInitInvLevelStep";

    @Override
    public StepResult execute() {
        BalanceInvContext ctx = BalanceInvContext.get();
        BalanceInventoryScheme balanceScheme = ctx.getScheme();
        if (balanceScheme.getInvDimensionInfo() == null) {
            this.stepResult.setDetailMsg(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d\u672a\u7ef4\u62a4\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\uff0c\u65e0\u9700\u521d\u59cb\u5316\u5b89\u5168\u5e93\u5b58\u3002", (String)"BalanceInvInitInvLevelStep_0", (String)"scmc-im-business", (Object[])new Object[0]));
            return this.stepResult;
        }
        Set<String> dimensionFields = balanceScheme.getInvDimensionInfo().getDimensions();
        List<String> matchFields = balanceScheme.getInvDimensionInfo().getInvLevelFields();
        boolean withMaterial = dimensionFields.contains("bd_material");
        if (dimensionFields.contains("bos_org") && (dimensionFields.contains("bd_materialgroup") || withMaterial)) {
            DataSet dataSet;
            QFilter materialFilter;
            String selector;
            Set<Long> materialIdSet = ctx.getMaterialIdSet();
            Map<Long, SupplyRelation> supplyRelationMap = balanceScheme.getSupplyRelationMap();
            HashSet<Long> allOrgIdSet = new HashSet<Long>(16);
            for (Map.Entry<Long, SupplyRelation> supplyRelationEntry : supplyRelationMap.entrySet()) {
                if (supplyRelationEntry.getValue() == null) continue;
                for (Map.Entry<Long, Boolean> supplyOrgEntry : supplyRelationEntry.getValue().getSupplyOrg2ProviderMap().entrySet()) {
                    if (supplyOrgEntry.getValue().booleanValue()) continue;
                    allOrgIdSet.add(supplyOrgEntry.getKey());
                }
            }
            if (allOrgIdSet.isEmpty()) {
                this.stepResult.setDetailMsg(ResManager.loadKDString((String)"\u9700\u8981\u67e5\u8be2\u5b89\u5168\u5e93\u5b58\u7684\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u9700\u521d\u59cb\u5316\u5b89\u5168\u5e93\u5b58\u3002", (String)"BalanceInvInitInvLevelStep_1", (String)"scmc-im-business", (Object[])new Object[0]));
                return this.stepResult;
            }
            QFilter orgFilter = new QFilter("bos_org", "in", allOrgIdSet);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter dimensionFilter = new QFilter("dimension", "=", (Object)balanceScheme.getInvLevelInfoId());
            if (withMaterial) {
                selector = "bos_org,bd_material,bd_warehouse,bd_materialgroupstandard,bd_materialgroup,safestock";
                materialFilter = new QFilter("bd_material", "in", materialIdSet);
                dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"invp_safestock_record", (String)selector, (QFilter[])new QFilter[]{orgFilter, materialFilter, enableFilter, dimensionFilter}, (String)"modifytime desc");
            } else {
                selector = "bos_org,bd_warehouse,bd_materialgroupstandard,bd_materialgroup,safestock";
                dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"invp_safestock_record", (String)selector, (QFilter[])new QFilter[]{orgFilter, enableFilter, dimensionFilter}, (String)"");
                materialFilter = new QFilter("material", "in", materialIdSet);
                DataSet matGroupDataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"bd_materialgroupdetail", (String)"group,material", (QFilter[])new QFilter[]{materialFilter}, (String)"");
                dataSet = dataSet.join(matGroupDataSet).on("bd_materialgroup", "group").select((selector + ",material bd_material").split(",")).finish();
            }
            StringBuilder matchValueBuilder = new StringBuilder();
            int processData = 0;
            for (Row row : dataSet) {
                ++processData;
                InvLevelInfo invLevelInfo = new InvLevelInfo();
                invLevelInfo.setSafeQty(row.getBigDecimal("safestock"));
                for (String matchField : matchFields) {
                    matchValueBuilder.append(row.get(matchField)).append("$");
                }
                ctx.getSupplyInvLevelMap().put(matchValueBuilder.toString(), invLevelInfo);
                matchValueBuilder.setLength(0);
            }
            this.stepResult.setProcessData(processData);
        } else {
            this.stepResult.setDetailMsg(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u4e2d\u5fc5\u987b\u6709\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u7269\u6599\u5206\u7c7b\u6216\u7269\u6599\u3002", (String)"BalanceInvInitInvLevelStep_2", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        return this.stepResult;
    }

    private Set<Long> getDimensionIds(Set<String> dimensionFields) {
        Set dimensionSet;
        DataSet dimensionData = QueryServiceHelper.queryDataSet((String)ALGO, (String)"msplan_plan_dimension", (String)"id,entryentity.associationobject", (QFilter[])new QFilter("enable", "=", (Object)"1").toArray(), null);
        HashMap<Long, Set> dimensionMap = new HashMap<Long, Set>(8);
        for (Row row : dimensionData) {
            Long id = row.getLong("id");
            String entityNum = row.getString("entryentity.associationobject");
            if (id == null || entityNum == null) continue;
            dimensionSet = dimensionMap.computeIfAbsent(id, k -> new HashSet(4));
            dimensionSet.add(entityNum);
        }
        HashSet<Long> dimensionIds = new HashSet<Long>(dimensionMap.size());
        for (Map.Entry entry : dimensionMap.entrySet()) {
            Long id = (Long)entry.getKey();
            dimensionSet = (Set)entry.getValue();
            if (dimensionSet.size() != dimensionFields.size()) continue;
            dimensionSet.removeAll(dimensionFields);
            if (!dimensionSet.isEmpty()) continue;
            dimensionIds.add(id);
        }
        return dimensionIds;
    }
}

