/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.steps.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.func.BillFormulaValueTransFunc;
import kd.scmc.im.business.balanceinv.func.MatchDimensionTransFunc;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.DemandModel;
import kd.scmc.im.business.balanceinv.pojo.InvDimensionInfo;
import kd.scmc.im.business.balanceinv.pojo.MatchInfo;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.pojo.SupplyModel;
import kd.scmc.im.business.balanceinv.pojo.UnMatchInfo;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;

public class BalanceInvLevelStep
implements IBalanceInventoryStep {
    private static final Log logger = LogFactory.getLog(BalanceInvLevelStep.class);
    private StepResult stepResult = new StepResult();
    private static String ALGO = "kd.scmc.im.business.balanceinv.steps.impl.BalanceInvInvLevelCalStep";
    private Map<Long, Integer> unitPrecisionCache = new HashMap<Long, Integer>();
    Map<Long, List<UnMatchInfo>> entryIdUnMatchMap = new HashMap<Long, List<UnMatchInfo>>();
    private Map<Long, Long> demandOrgCache = new HashMap<Long, Long>();
    private Map<Long, Long> purRelationOrgCache = new HashMap<Long, Long>();
    private Map<Long, Long> purOrg2AccountOrgCache = new HashMap<Long, Long>();
    private Map<Long, Long> purOrg2InvOrgCache = new HashMap<Long, Long>();
    private Map<Long, Integer> demandOrderCache = new HashMap<Long, Integer>();
    private Map<Long, BigDecimal> demandOriginQtyCache = new HashMap<Long, BigDecimal>();

    @Override
    public StepResult execute() {
        BalanceInvContext ctx = BalanceInvContext.get();
        String entityNum = "invp_safestock_record";
        BalanceInventoryScheme scheme = ctx.getScheme();
        Set<Long> materialIdSet = ctx.getMaterialIdSet();
        this.doInvLevelBalanceByScheme(entityNum, scheme, materialIdSet);
        return this.stepResult;
    }

    private void handleAdvice(BalanceInventoryScheme balanceScheme, List<UnMatchInfo> unMatchInfos, DynamicObject balanceAdvise, Date systemDate, Set<Long> matIds) {
        ORM orm = ORM.create();
        DynamicObject safeStockEntityObj = orm.newDynamicObject("bos_entityobject", (Object)"invp_safestock_record");
        balanceAdvise.set("org", (Object)orm.newDynamicObject("bos_org", (Object)BalanceInvContext.get().getBalanceOrgId()));
        balanceAdvise.set("balanceinvscheme", (Object)orm.newDynamicObject("balanceinv_scheme", (Object)balanceScheme.getId()));
        balanceAdvise.set("calculatenum", (Object)BalanceInvContext.get().getCalcNum());
        balanceAdvise.set("advicetype", (Object)unMatchInfos.get(0).getAdviseType());
        String demandKind = unMatchInfos.get(0).getDemandKind();
        balanceAdvise.set("demandkind", (Object)demandKind);
        balanceAdvise.set("biztype", (Object)orm.newDynamicObject("bd_biztype", (Object)422857170485263360L));
        balanceAdvise.set("billstatus", (Object)"A");
        balanceAdvise.set("creator", (Object)orm.newDynamicObject("bos_user", (Object)RequestContext.get().getCurrUserId()));
        MainEntityType orgEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_org");
        MainEntityType matEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_material");
        MainEntityType unitEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_measureunits");
        DynamicObjectCollection entries = balanceAdvise.getDynamicObjectCollection("entryentity");
        for (UnMatchInfo unMatchInfo : unMatchInfos) {
            Long demandInvOrgId;
            DynamicObject entry = entries.addNew();
            DynamicObject matchEntryInfo = unMatchInfo.getMatchEntryInfo();
            Long demandBillId = unMatchInfo.getBillId();
            entry.set("demandbillid", (Object)demandBillId);
            entry.set("isclosed", (Object)"A");
            entry.set("iscancel", (Object)"A");
            entry.set("demandorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, (Object)unMatchInfo.getDemandOrgId()));
            entry.set("applybilltype", (Object)safeStockEntityObj);
            Long materialId = unMatchInfo.getMaterialId();
            matIds.add(materialId);
            if ("invp_safestock_record".equals(unMatchInfo.getDemandSrcBillEntityNum())) {
                if (entry.get("material") == null) {
                    entry.set("material", (Object)new DynamicObject((DynamicObjectType)matEntityType, (Object)materialId));
                }
                if (entry.get("baseunit") == null) {
                    entry.set("baseunit", (Object)new DynamicObject((DynamicObjectType)unitEntityType, (Object)unMatchInfo.getBaseUnitId()));
                }
            }
            entry.set("planfinishdate", (Object)systemDate);
            entry.set("adviseqty", (Object)unMatchInfo.getUnMatchQty());
            entry.set("baseqty", (Object)unMatchInfo.getUnMatchQty());
            entry.set("remaininbaseqty", (Object)unMatchInfo.getUnMatchQty());
            DynamicObject demandInvOrg = entry.getDynamicObject("invorg");
            if (demandInvOrg != null || (demandInvOrgId = BalanceInvExecuteHelper.getDemandInvOrg(entry.get("demandorg"), this.demandOrgCache)) == null) continue;
            entry.set("invorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, (Object)demandInvOrgId));
        }
    }

    private Long getPurOrgByRelation(Long balanceOrgId) {
        Long purchaseOrgId = this.purRelationOrgCache.get(balanceOrgId);
        if (purchaseOrgId != null) {
            return purchaseOrgId;
        }
        DynamicObject purchaseOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)balanceOrgId, (String)"bos_org", (String)"fispurchase");
        if (purchaseOrg.getBoolean("fispurchase")) {
            this.purRelationOrgCache.put(balanceOrgId, balanceOrgId);
            return balanceOrgId;
        }
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(balanceOrgId.longValue());
        param.setToViewType("02");
        param.setDirectViewType("toorg");
        Map orgRelationMap = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
        List orgRelations = (List)orgRelationMap.get("data");
        if (orgRelations != null && !orgRelations.isEmpty()) {
            for (Map orgRelation : orgRelations) {
                if (!Boolean.TRUE.equals(orgRelation.get("isDefault"))) continue;
                purchaseOrgId = (Long)orgRelation.get("orgId");
                break;
            }
            if (purchaseOrgId == null) {
                purchaseOrgId = (Long)((Map)orgRelations.get(0)).get("orgId");
            }
        }
        this.purRelationOrgCache.put(balanceOrgId, purchaseOrgId != null ? purchaseOrgId : 0L);
        return purchaseOrgId;
    }

    private void doInvLevelBalanceByScheme(String entityNum, BalanceInventoryScheme balanceScheme, Set<Long> materialIdSet) {
        if (!this.needBalanceInvLevel(balanceScheme)) {
            StringBuilder detailMsg = new StringBuilder();
            detailMsg.append(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u5b89\u5168\u5e93\u5b58\u5e73\u8861\u5229\u5e93\u6761\u4ef6\uff1a", (String)"BalanceInvLevelStep_0", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
            detailMsg.append(ResManager.loadKDString((String)"1.\u9700\u6c42\u6570\u636e\u6e90\u4e2d\u5305\u542b\u5b89\u5168\u5e93\u5b58\u3002", (String)"BalanceInvLevelStep_1", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
            detailMsg.append(ResManager.loadKDString((String)"2.\u5e73\u8861\u5229\u5e93\u65b9\u6848\u4e2d\u7ef4\u62a4\u4e86\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u3002", (String)"BalanceInvLevelStep_2", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
            detailMsg.append(ResManager.loadKDString((String)"3.\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u4e2d\u5305\u542b\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u4e14\u5305\u542b\u7269\u6599\u6216\u7269\u6599\u5206\u7c7b\u3002", (String)"BalanceInvLevelStep_3", (String)"scmc-im-business", (Object[])new Object[0])).append("\n");
            this.stepResult.setDetailMsg(detailMsg.toString());
            return;
        }
        if (materialIdSet == null || materialIdSet.isEmpty()) {
            logger.info("\u9700\u8981\u505a\u5b89\u5168\u5e93\u5b58\u5229\u5e93\u7684\u7269\u6599\u4e3a\u7a7a\u3002");
            return;
        }
        ORM orm = ORM.create();
        DataSet invLevelDataSet = this.getInvLevelDataSet(materialIdSet, balanceScheme);
        DynamicObjectCollection invLevelBillCol = orm.toPlainDynamicObjectCollection(invLevelDataSet);
        Map<String, DynamicObjectCollection> demandBillByDimension = this.groupBillByMatchDimension(invLevelBillCol, "entryentity.flexmetricid");
        DynamicObjectCollection realBalCollection = new DynamicObjectCollection();
        DynamicObjectCollection preInCollection = new DynamicObjectCollection();
        this.getSupplyData(materialIdSet, balanceScheme, realBalCollection, preInCollection);
        Map<String, DynamicObjectCollection> realBalColByDimension = this.groupBillByMatchDimension(realBalCollection, "entryentity.flexmetricid");
        Map<String, DynamicObjectCollection> preInColByDimension = this.groupBillByMatchDimension(preInCollection, "preinmatchfields");
        this.matchDemandByDimension(demandBillByDimension, realBalColByDimension, preInColByDimension, balanceScheme, orm);
        Map<String, List<UnMatchInfo>> groupedUnMatchInfo = BalanceInvExecuteHelper.getGroupedUnMatchInfoWithAdviseType(entityNum, this.entryIdUnMatchMap);
        Set<Long> adviseIdSet = this.genUnMatchedBalanceAdvise(balanceScheme, groupedUnMatchInfo, orm);
        if (adviseIdSet.isEmpty()) {
            return;
        }
        BalanceInvExecuteHelper.autoOutPut(adviseIdSet, balanceScheme, this.stepResult);
    }

    private DynamicObjectCollection handleReserveQty(DynamicObjectCollection preInCollection) {
        if (preInCollection == null || preInCollection.isEmpty()) {
            return preInCollection;
        }
        Map<Long, BigDecimal> reserveQtyMap = this.getReserveData(preInCollection);
        if (reserveQtyMap.isEmpty()) {
            return preInCollection;
        }
        for (DynamicObject preInData : preInCollection) {
            Long billEntryId = preInData.getLong("entryentity.billentryid");
            if (reserveQtyMap.get(billEntryId) == null) continue;
            BigDecimal reserveBaseQty = reserveQtyMap.get(billEntryId);
            BigDecimal supplyQtyValue = preInData.getBigDecimal("entryentity.usablebaseqty");
            if ((supplyQtyValue = supplyQtyValue.subtract(reserveBaseQty)).compareTo(BigDecimal.ZERO) < 0) {
                supplyQtyValue = BigDecimal.ZERO;
            }
            preInData.set("entryentity.usablebaseqty", (Object)supplyQtyValue);
        }
        return preInCollection;
    }

    private Map<Long, BigDecimal> getReserveData(DynamicObjectCollection preInCollection) {
        HashSet<Long> entryIds = new HashSet<Long>(preInCollection.size());
        for (DynamicObject preInData : preInCollection) {
            Long entryId = preInData.getLong("entryentity.billentryid");
            entryIds.add(entryId);
        }
        HashMap<Long, BigDecimal> reserveQtyMap = new HashMap<Long, BigDecimal>(preInCollection.size());
        if (entryIds.isEmpty()) {
            return reserveQtyMap;
        }
        QFilter qFilter = new QFilter("bal_entryid", "in", entryIds).and("base_qty", ">", (Object)0).and("ispredict", "=", (Object)true);
        DataSet reserveRecord = QueryServiceHelper.queryDataSet((String)ALGO, (String)"msmod_reserve_record", (String)"bal_entryid,qty,base_qty, qty2nd", (QFilter[])new QFilter[]{qFilter}, null);
        while (reserveRecord.hasNext()) {
            Row row = reserveRecord.next();
            Long balEntryId = row.getLong("bal_entryid");
            BigDecimal baseQty = row.getBigDecimal("base_qty");
            if (reserveQtyMap.get(balEntryId) != null) {
                baseQty = baseQty.add((BigDecimal)reserveQtyMap.get(balEntryId));
            }
            reserveQtyMap.put(balEntryId, baseQty);
        }
        return reserveQtyMap;
    }

    private Set<Long> genUnMatchedBalanceAdvise(BalanceInventoryScheme balanceScheme, Map<String, List<UnMatchInfo>> groupedUnMatchMap, ORM orm) {
        List<UnMatchInfo> unMatchInfoList2;
        HashSet<Long> adviseIdSet = new HashSet<Long>();
        int centerPurCount = 0;
        int purCount = 0;
        StringBuilder stepErrorMsg = new StringBuilder();
        ArrayList<DynamicObject> targetBillList = new ArrayList<DynamicObject>(groupedUnMatchMap.size());
        Date systemDate = new Date();
        HashSet<Long> matIds = new HashSet<Long>(groupedUnMatchMap.size());
        long[] adviceIds = DB.genGlobalLongIds((int)groupedUnMatchMap.size());
        int index = 0;
        for (List<UnMatchInfo> unMatchInfoList2 : groupedUnMatchMap.values()) {
            if (unMatchInfoList2 == null || unMatchInfoList2.isEmpty()) continue;
            DynamicObject balanceAdvice = orm.newDynamicObject("im_balanceinv_advice");
            balanceAdvice.set("id", (Object)adviceIds[index++]);
            this.handleAdvice(balanceScheme, unMatchInfoList2, balanceAdvice, systemDate, matIds);
            targetBillList.add(balanceAdvice);
            String adviseType = balanceAdvice.getString("advicetype");
            if ("A".equals(adviseType)) {
                ++purCount;
                continue;
            }
            if (!"F".equals(adviseType)) continue;
            ++centerPurCount;
        }
        this.handleEntryPurchaseOrg(targetBillList, matIds, BalanceInvContext.get().getBalanceOrgId(), orm);
        TXHandle txHandle = TX.requiresNew();
        unMatchInfoList2 = null;
        try {
            String balanceInvMsg2;
            try {
                OperationResult result = SaveServiceHelper.saveOperate((String)"im_balanceinv_advice", (DynamicObject[])targetBillList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (!result.isSuccess()) {
                    balanceInvMsg2 = ResManager.loadKDString((String)"\u5229\u5e93\u5efa\u8bae", (String)"BalanceInvExecuteHelper_2", (String)"scmc-im-business", (Object[])new Object[0]);
                    String balanceInvMsg4 = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"BalanceInvExecuteHelper_4", (String)"scmc-im-business", (Object[])new Object[0]);
                    stepErrorMsg.append(balanceInvMsg2).append(balanceInvMsg4).append("\n");
                    stepErrorMsg.append(BalanceInvExecuteHelper.getBillOperateErrorMsg(result));
                    this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
                } else {
                    List successPkIds = result.getSuccessPkIds();
                    for (Object successPkId : successPkIds) {
                        adviseIdSet.add((Long)successPkId);
                    }
                }
            }
            catch (Exception e) {
                balanceInvMsg2 = ResManager.loadKDString((String)"\u5229\u5e93\u5efa\u8bae", (String)"BalanceInvExecuteHelper_2", (String)"scmc-im-business", (Object[])new Object[0]);
                String balanceInvMsg4 = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"BalanceInvExecuteHelper_4", (String)"scmc-im-business", (Object[])new Object[0]);
                stepErrorMsg.append(balanceInvMsg2).append(balanceInvMsg4).append("\n");
                stepErrorMsg.append(BalanceInvExecuteHelper.getExceptionMessage(e));
                this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
            }
        }
        catch (Throwable e) {
            unMatchInfoList2 = e;
            throw e;
        }
        finally {
            if (txHandle != null) {
                if (unMatchInfoList2 != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)((Object)unMatchInfoList2)).addSuppressed(e);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        StringBuilder detailMsg = new StringBuilder();
        if (!StringUtils.isEmpty((String)this.stepResult.getDetailMsg())) {
            detailMsg.append(this.stepResult.getDetailMsg());
        }
        String balanceInvMsg5 = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u5916\u8d2d\u5efa\u8bae\u6570\u91cf\uff1a%1$s\u6761\u3002", (String)"BalanceInvExecuteHelper_5", (String)"scmc-im-business", (Object[])new Object[0]), purCount);
        String balanceInvMsg6 = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u96c6\u91c7\u5efa\u8bae\u6570\u91cf\uff1a%1$s\u6761\u3002", (String)"BalanceInvExecuteHelper_6", (String)"scmc-im-business", (Object[])new Object[0]), centerPurCount);
        detailMsg.append(balanceInvMsg5).append("\n").append(balanceInvMsg6).append("\n");
        detailMsg.append((CharSequence)stepErrorMsg);
        if (!StringUtils.isEmpty((String)stepErrorMsg.toString())) {
            this.stepResult.setStepResult(BalanceInvLogConstants.STEP_RESULT_E);
        }
        this.stepResult.setDetailMsg(detailMsg.toString());
        this.stepResult.setProcessData(this.stepResult.getProcessData() + purCount + centerPurCount);
        return adviseIdSet;
    }

    private void handleEntryPurchaseOrg(List<DynamicObject> targetBillList, Set<Long> matIds, Long balanceOrgId, ORM orm) {
        Object data;
        if (balanceOrgId == null) {
            return;
        }
        ArrayList paramList = new ArrayList(matIds.size());
        for (Long matId : matIds) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            paramMap.put("baseDataType", "2");
            paramMap.put("orgId", balanceOrgId);
            paramMap.put("baseDataId", matId);
            paramMap.put("bizType", "3");
            paramList.add(paramMap);
        }
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"ICategoryService", (String)"batchGetPurChaseOrg", (Object[])new Object[]{paramList, "invp_safestock_record"});
        Map dataMap = new HashMap(16);
        if (result != null && ((Boolean)result.get("success")).booleanValue() && (data = result.get("data")) != null) {
            dataMap = (Map)data;
        }
        for (DynamicObject advice : targetBillList) {
            DynamicObjectCollection entrySet = advice.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrySet) {
                Object material = entry.get("material");
                if (material == null) continue;
                Object materialId = ((DynamicObject)material).getPkValue();
                String cacheKey = balanceOrgId + "-" + materialId + "-" + "3" + "-" + "2";
                Object purchaseOrg = dataMap.get(cacheKey);
                if (purchaseOrg == null) {
                    purchaseOrg = this.getPurOrgByRelation(balanceOrgId);
                } else {
                    Map purchaseOrgMap = (Map)purchaseOrg;
                    purchaseOrg = purchaseOrgMap.get("orgId");
                }
                if (purchaseOrg != null) {
                    entry.set("purorg", (Object)orm.newDynamicObject("bos_org", purchaseOrg));
                }
                BalanceInvExecuteHelper.handlePurAdvice(entry, balanceOrgId, this.purOrg2AccountOrgCache, this.purOrg2InvOrgCache);
            }
        }
    }

    private void matchDemandByDimension(Map<String, DynamicObjectCollection> demandBillByDimension, Map<String, DynamicObjectCollection> realBalColByDimension, Map<String, DynamicObjectCollection> preInColByDimension, BalanceInventoryScheme balanceScheme, ORM orm) {
        if (demandBillByDimension == null || demandBillByDimension.isEmpty()) {
            return;
        }
        DynamicObject bizType = orm.newDynamicObject("bd_biztype", (Object)422857170485263360L);
        for (Map.Entry<String, DynamicObjectCollection> demandBillEntry : demandBillByDimension.entrySet()) {
            String dimensionKey = demandBillEntry.getKey();
            DynamicObjectCollection demandBills = demandBillEntry.getValue();
            if (demandBills == null || demandBills.isEmpty()) continue;
            this.matchByDimension(demandBills, realBalColByDimension, dimensionKey, balanceScheme, bizType);
            if (!demandBills.isEmpty()) {
                this.matchByDimension(demandBills, preInColByDimension, "preinmatchfields", balanceScheme, bizType);
            }
            this.buildPureDemand(demandBills, balanceScheme, bizType);
        }
    }

    private void buildPureDemand(DynamicObjectCollection demandBills, BalanceInventoryScheme balanceScheme, DynamicObject bizType) {
        if (demandBills == null || demandBills.isEmpty()) {
            return;
        }
        for (DynamicObject demandBill : demandBills) {
            if (demandBill.getBigDecimal("entryentity.demandqty").compareTo(BigDecimal.ZERO) <= 0) continue;
            long demandBillId = demandBill.getLong("id");
            DynamicObject matchResultEntry = BalanceInvExecuteHelper.addNoSupplyMatchResultEntry(demandBill, this.demandOriginQtyCache.get(demandBillId), demandBill.getBigDecimal("entryentity.demandqty"), this.demandOrderCache.get(demandBillId));
            matchResultEntry.set("biztype", (Object)bizType);
            matchResultEntry.set("demandkind", (Object)"B");
            BigDecimal demandQty = demandBill.getBigDecimal("entryentity.demandqty");
            UnMatchInfo unMatchInfo = BalanceInvExecuteHelper.buildUnMatchInfo(demandBill, demandQty);
            unMatchInfo.setBalanceOrgId(balanceScheme.getBalanceOrgId());
            unMatchInfo.setMatchEntryInfo(matchResultEntry);
            unMatchInfo.setDemandKind("B");
            this.entryIdUnMatchMap.computeIfAbsent(unMatchInfo.getBillId(), k -> new ArrayList()).add(unMatchInfo);
        }
    }

    private void matchByDimension(DynamicObjectCollection demandBills, Map<String, DynamicObjectCollection> supplyColByDimension, String dimensionKey, BalanceInventoryScheme balanceScheme, DynamicObject bizType) {
        Iterator iterator = demandBills.iterator();
        BigDecimal matchBaseQty = BigDecimal.ZERO;
        BigDecimal matchQty = BigDecimal.ZERO;
        BigDecimal matchQty2nd = BigDecimal.ZERO;
        int demandOrder = 0;
        BalanceInvContext ctx = BalanceInvContext.get();
        block0: while (iterator.hasNext()) {
            DynamicObjectCollection supplyBills;
            DynamicObject demandBill = (DynamicObject)iterator.next();
            long demandBillId = demandBill.getLong("id");
            this.demandOrderCache.put(demandBillId, ++demandOrder);
            BigDecimal originDemandBaseQty = demandBill.getBigDecimal("entryentity.demandqty");
            this.demandOriginQtyCache.putIfAbsent(demandBillId, originDemandBaseQty);
            if (originDemandBaseQty.compareTo(BigDecimal.ZERO) <= 0 || (supplyBills = supplyColByDimension.get(dimensionKey = "preinmatchfields".equals(dimensionKey) ? demandBill.getString("preinmatchfields") : dimensionKey)) == null || supplyBills.isEmpty()) continue;
            for (DynamicObject supplyBill : supplyBills) {
                BigDecimal curDemandBaseQty = demandBill.getBigDecimal("entryentity.demandqty");
                if (curDemandBaseQty.compareTo(BigDecimal.ZERO) <= 0) {
                    iterator.remove();
                    continue block0;
                }
                BigDecimal supplyBaseQty = supplyBill.getBigDecimal("entryentity.usablebaseqty");
                if (supplyBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                matchBaseQty = curDemandBaseQty.compareTo(supplyBaseQty) <= 0 ? curDemandBaseQty : supplyBaseQty;
                if (BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.unit") != null) {
                    matchQty = BalanceInvExecuteHelper.calculateQtyByBaseQty(matchBaseQty, supplyBill.getLong("entryentity.material"), supplyBill.getLong("entryentity.unit"), supplyBill.getLong("entryentity.baseunit"), this.unitPrecisionCache);
                }
                if (BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.assistunit") != null && BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.originassitqty") != null && supplyBill.getBigDecimal("entryentity.originassitqty").compareTo(BigDecimal.ZERO) != 0) {
                    matchQty2nd = matchBaseQty.multiply(supplyBill.getBigDecimal("entryentity.originassitqty")).divide(supplyBill.getBigDecimal("entryentity.originbaseqty"), BalanceInvExecuteHelper.getUnitPrecision(supplyBill.getLong("entryentity.assistunit"), this.unitPrecisionCache), RoundingMode.HALF_UP);
                }
                MatchInfo matchInfo = new MatchInfo(matchQty, matchBaseQty, matchQty2nd, this.demandOriginQtyCache.get(demandBillId), curDemandBaseQty);
                BigDecimal demandRemainQty = curDemandBaseQty.subtract(matchBaseQty);
                demandBill.set("entryentity.demandqty", (Object)demandRemainQty);
                supplyBill.set("entryentity.usablebaseqty", (Object)supplyBaseQty.subtract(matchBaseQty));
                DynamicObject matchResultEntry = BalanceInvExecuteHelper.addMatchResultEntry(demandBill, supplyBill, matchInfo, demandOrder);
                matchResultEntry.set("biztype", (Object)bizType);
                matchResultEntry.set("demandkind", (Object)"B");
                if (demandRemainQty.compareTo(BigDecimal.ZERO) > 0) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    private void getSupplyData(Set<Long> materialIdSet, BalanceInventoryScheme balanceScheme, DynamicObjectCollection realBalCollection, DynamicObjectCollection preInCollection) {
        List<String> supplyDsList = balanceScheme.getSupplyDsList();
        ORM orm = ORM.create();
        for (String supplyEntityNumber : supplyDsList) {
            boolean isRealBalSupply;
            DataSet srcDataSet = this.getSafeStockSupplyDataSet(balanceScheme, supplyEntityNumber, materialIdSet, isRealBalSupply = "im_inv_realbalance".equals(supplyEntityNumber));
            DynamicObjectCollection srcDataCollection = orm.toPlainDynamicObjectCollection(srcDataSet);
            if (srcDataCollection == null || srcDataCollection.isEmpty()) continue;
            if (isRealBalSupply) {
                realBalCollection.addAll((Collection)srcDataCollection);
                continue;
            }
            preInCollection.addAll((Collection)this.handleReserveQty(srcDataCollection));
        }
    }

    private DataSet getSafeStockSupplyDataSet(BalanceInventoryScheme balanceScheme, String supplyEntityNumber, Set<Long> materialIdSet, boolean isRealBalSupply) {
        SupplyModel supplyModel = balanceScheme.getSupplyModel();
        Map<String, String> target2SourceFieldMap = supplyModel.getTarget2SourceFieldMap(supplyEntityNumber);
        String materialField = target2SourceFieldMap.get("entryentity.material");
        String supplyOrgField = target2SourceFieldMap.get("entryentity.supplyorgunit");
        QFilter supplyFilter = supplyModel.getDataSourceFilter(supplyEntityNumber);
        QFilter filter = new QFilter(materialField, "in", materialIdSet).and(supplyFilter);
        if (!StringUtils.isBlank((String)supplyOrgField)) {
            filter.and(supplyOrgField, "in", balanceScheme.getContainSafeInvOrgs());
        }
        String selector = supplyModel.getMatchSelector(supplyEntityNumber);
        StringBuilder selectorBuilder = new StringBuilder();
        selectorBuilder.append(selector);
        selectorBuilder.append(",0 as ").append("supplyorder");
        selectorBuilder.append(",0 as ").append("priority");
        selectorBuilder.append(",0 as ").append("supplypriority");
        selectorBuilder.append(",0 as ").append("invstatuspriority");
        selectorBuilder.append(",'' as ").append("preinmatchfields");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)supplyEntityNumber, (String)selectorBuilder.toString(), (QFilter[])filter.toArray(), (String)"");
        selectorBuilder.setLength(0);
        RowMeta rowMeta = dataSet.getRowMeta();
        InvDimensionInfo invDimensionInfo = balanceScheme.getInvDimensionInfo();
        Map<String, String> targetFormulaMap = supplyModel.getTargetExpressionMap(supplyEntityNumber);
        String matchKey = isRealBalSupply ? "entryentity.flexmetricid" : "preinmatchfields";
        List<String> matchFields = invDimensionInfo.getSupplyFields();
        if (!isRealBalSupply) {
            matchFields = Arrays.asList("entryentity.supplyorgunit", "entryentity.material");
        }
        dataSet = dataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, targetFormulaMap)).map((MapFunction)new MatchDimensionTransFunc(rowMeta, matchFields, matchKey));
        QFilter expressFilterVal = new QFilter("entryentity.supplyorgunit", "in", balanceScheme.getContainSafeInvOrgs());
        dataSet = dataSet.filter(expressFilterVal.toString());
        return dataSet;
    }

    private Map<String, DynamicObjectCollection> groupBillByMatchDimension(DynamicObjectCollection billCol, String matchKey) {
        HashMap<String, DynamicObjectCollection> dimensionGroupBillMap = new HashMap<String, DynamicObjectCollection>(16);
        for (DynamicObject demandBill : billCol) {
            String flexMetricId = demandBill.getString(matchKey);
            dimensionGroupBillMap.computeIfAbsent(flexMetricId, k -> new DynamicObjectCollection()).add((Object)demandBill);
        }
        return dimensionGroupBillMap;
    }

    private boolean needBalanceInvLevel(BalanceInventoryScheme balanceScheme) {
        if (balanceScheme.getDemandModel().getDataSourceMap().containsKey("invp_safestock_record")) {
            if (balanceScheme.getInvDimensionInfo() == null) {
                return false;
            }
            Set<String> dimensionFields = balanceScheme.getInvDimensionInfo().getDimensions();
            if (dimensionFields.contains("bos_org") && (dimensionFields.contains("bd_material") || dimensionFields.contains("bd_materialgroup"))) {
                return true;
            }
        }
        return false;
    }

    private DataSet getInvLevelDataSet(Set<Long> materialIdSet, BalanceInventoryScheme balanceScheme) {
        DemandModel demandModel = balanceScheme.getDemandModel();
        InvDimensionInfo invDimensionInfo = balanceScheme.getInvDimensionInfo();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter dataSourceFilter = demandModel.getDataSourceFilter("invp_safestock_record");
        filterList.add(dataSourceFilter);
        Set<Long> orgIds = balanceScheme.getContainSafeInvOrgs();
        QFilter orgFilter = new QFilter("bos_org", "in", orgIds);
        filterList.add(orgFilter);
        if (invDimensionInfo.containsMaterial().booleanValue()) {
            QFilter materialFilter = new QFilter("bd_material", "in", materialIdSet);
            filterList.add(materialFilter);
        }
        Long dimensionId = balanceScheme.getInvLevelInfoId();
        logger.info("BalanceInvLevelStep.getInvLevelDataSet\uff1a\u83b7\u53d6\u6c34\u4f4d\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u503c={}", (Object)dimensionId);
        QFilter dimensionFilter = new QFilter("dimension", "=", (Object)dimensionId);
        filterList.add(dimensionFilter);
        String selector = demandModel.getMatchSelector("invp_safestock_record");
        if (!invDimensionInfo.containsMaterial().booleanValue()) {
            selector = selector + "," + "bd_materialgroup";
        }
        selector = selector + "," + "id";
        selector = selector + ",'' as " + "preinmatchfields";
        DataSet demandDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"invp_safestock_record", (String)selector, (QFilter[])filterList.toArray(new QFilter[0]), (String)"modifytime desc");
        if (!invDimensionInfo.containsMaterial().booleanValue()) {
            QFilter materialFilter = new QFilter("material", "in", materialIdSet);
            DataSet matGroupDataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"bd_materialgroupdetail", (String)"group,material,material.baseunit", (QFilter[])new QFilter[]{materialFilter}, (String)"");
            ArrayList<String> selectorList = new ArrayList<String>(demandDataSet.getRowMeta().getFields().length);
            for (Field field : demandDataSet.getRowMeta().getFields()) {
                selectorList.add(field.getName());
            }
            selectorList.remove("entryentity.material");
            selectorList.remove("entryentity.baseunit");
            selectorList.add("material as entryentity.material");
            selectorList.add("material.baseunit as entryentity.baseunit");
            demandModel.getTargetExpressionMap("invp_safestock_record").remove("entryentity.baseunit");
            demandDataSet = demandDataSet.join(matGroupDataSet).on("bd_materialgroup", "group").select(selectorList.toArray(new String[0])).finish();
        }
        RowMeta rowMeta = demandDataSet.getRowMeta();
        Map<String, String> targetFormulaMap = demandModel.getTargetExpressionMap("invp_safestock_record");
        List<String> preInMatchFields = Arrays.asList("entryentity.demandorg", "entryentity.material");
        demandDataSet = demandDataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, targetFormulaMap)).map((MapFunction)new MatchDimensionTransFunc(rowMeta, invDimensionInfo.getDemandFields(), "entryentity.flexmetricid")).map((MapFunction)new MatchDimensionTransFunc(rowMeta, preInMatchFields, "preinmatchfields"));
        return demandDataSet;
    }
}

