/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.pojo.StepResult;

public class BalanceInvLogUtils {
    public static final String RUNBATCHNUM = "balanceinvbatchnum";

    public static void updateBalanceInvEntryLog(StepResult stepResult, long logEntryId) {
        String updateSql = "UPDATE T_IM_BALANCEINVLOGENTRY SET FPROCESSDATA = ?, FSTEPTIMESPAN = ?, FSTEPRESULT = ?, FDETAILMSG = ?, FDETAILMSG_TAG = ? WHERE FENTRYID = ?";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(stepResult.getProcessData() + "");
        paramList.add(stepResult.getTimeSpan());
        paramList.add(stepResult.getStepResult());
        String detailMsg = stepResult.getDetailMsg();
        paramList.add(StringUtils.isNotBlank((CharSequence)detailMsg) && detailMsg.length() > 50 ? detailMsg.substring(0, 50) : detailMsg);
        paramList.add(detailMsg);
        paramList.add(logEntryId);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, (Object[])paramList.toArray());
    }

    public static void updateBalanceLogRate(long logId, int rate) {
        String updateSql = "UPDATE T_IM_BALANCEINVLOG SET FPROCESSRATE = FPROCESSRATE + ? WHERE FID = ?";
        ArrayList<Number> paramList = new ArrayList<Number>();
        paramList.add(rate);
        paramList.add(logId);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, (Object[])paramList.toArray());
    }

    public static void processBalanceLog(long logId, String calcNum) {
        DynamicObject logInfo = BusinessDataServiceHelper.loadSingle((Object)logId, (String)BalanceInvLogConstants.ENTITY_NUM, (String)"starttime,endtime,timespan,status,processrate");
        String status = BalanceInvLogUtils.getBalanceInvStatus(calcNum);
        if (StringUtils.isBlank((CharSequence)status)) {
            status = BalanceInvLogConstants.STATUS_USER_STOP;
        } else if (BalanceInvLogConstants.STATUS_RUNNING.equals(status)) {
            status = BalanceInvLogConstants.STATUS_FAIL;
        }
        logInfo.set(BalanceInvLogConstants.STATUS, (Object)status);
        if (BalanceInvLogConstants.STATUS_SUCCESS.equals(status)) {
            logInfo.set(BalanceInvLogConstants.PROCESS_RATE, (Object)100);
        } else {
            QFilter qFilter = new QFilter("calculatenum", "=", (Object)calcNum);
            DeleteServiceHelper.delete((String)"im_balanceinv_matchdetail", (QFilter[])qFilter.toArray());
        }
        long startTime = logInfo.getDate(BalanceInvLogConstants.START_TIME).getTime();
        long endTime = System.currentTimeMillis();
        String timeSpan = new BigDecimal(String.valueOf(endTime - startTime)).divide(new BigDecimal("60000"), 4, RoundingMode.UP).toPlainString();
        logInfo.set(BalanceInvLogConstants.TIME_SPAN, (Object)timeSpan);
        logInfo.set(BalanceInvLogConstants.END_TIME, (Object)endTime);
        SaveServiceHelper.update((DynamicObject)logInfo);
    }

    public static void initRunningBatchNum(String calcNum, int batchNum) {
        DistributeSessionlessCache sessionLessCache = BalanceInvExecuteHelper.getDistributeSessionlessCache();
        sessionLessCache.put(calcNum + RUNBATCHNUM, (Object)(batchNum + ""));
    }

    public static void decreaseRunningBatchNum(String calcNum) {
        DistributeSessionlessCache sessionLessCache = BalanceInvExecuteHelper.getDistributeSessionlessCache();
        int runningCount = 0;
        try (DLock dLock = DLock.create((String)calcNum);){
            dLock.lock();
            String runNumber = (String)sessionLessCache.get(calcNum + RUNBATCHNUM);
            if (StringUtils.isBlank((CharSequence)runNumber)) {
                return;
            }
            runningCount = Integer.parseInt(runNumber) - 1;
            sessionLessCache.put(calcNum + RUNBATCHNUM, (Object)(runningCount + ""));
        }
    }

    public static int getRunningBatchNum(String calcNum) {
        DistributeSessionlessCache sessionLessCache = BalanceInvExecuteHelper.getDistributeSessionlessCache();
        String runNum = (String)sessionLessCache.get(calcNum + RUNBATCHNUM);
        if (StringUtils.isBlank((CharSequence)runNum)) {
            return 0;
        }
        return Integer.parseInt(runNum);
    }

    public static String getBalanceInvStatus(String calcNum) {
        DistributeSessionlessCache sessionLessCache = BalanceInvExecuteHelper.getDistributeSessionlessCache();
        return (String)sessionLessCache.get(calcNum);
    }

    public static void setBalanceInvStatus(String calcNum, String status) {
        DistributeSessionlessCache sessionLessCache = BalanceInvExecuteHelper.getDistributeSessionlessCache();
        sessionLessCache.put(calcNum, (Object)status);
    }
}

