/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.executor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.BalanceInvSchemeChecker;
import kd.scmc.im.business.balanceinv.BalanceSupplyBillGetter;
import kd.scmc.im.business.balanceinv.func.BillFormulaValueTransFunc;
import kd.scmc.im.business.balanceinv.func.MatchDimensionTransFunc;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.DemandModel;
import kd.scmc.im.business.balanceinv.pojo.MatchDimension;
import kd.scmc.im.business.balanceinv.pojo.SupplyModel;
import kd.scmc.im.business.balanceinv.pojo.SupplyQtyInfo;
import kd.scmc.im.business.balanceinv.workbench.steps.impl.BalanceInvWorkBenchMatchStep;

public class BalanceInvAdjustResultExecutor {
    private static final Log logger = LogFactory.getLog(BalanceInvAdjustResultExecutor.class);
    private Long balanceOrgId;
    private Long balanceInvSchemeId;
    private Long matchDetailId;
    private BalanceInvContext ctx;

    public BalanceInvAdjustResultExecutor(Long balanceOrgId, Long balanceInvSchemeId, Long matchDetailId) {
        this.balanceOrgId = balanceOrgId;
        this.balanceInvSchemeId = balanceInvSchemeId;
        this.matchDetailId = matchDetailId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<Long, Map<String, Object>> demandEntryInfoMap, Map<String, Map<Long, Map<String, Object>>> supplyEntryInfoMap, List<Long> matchDetailEntryIds) {
        if (demandEntryInfoMap == null || demandEntryInfoMap.isEmpty() || supplyEntryInfoMap == null || matchDetailEntryIds == null || matchDetailEntryIds.isEmpty()) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew((String)"balanceInv_adjustResult");){
            DLock mutexDLock = this.getMutexDLock();
            try {
                if (!mutexDLock.tryLock()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5229\u5e93\u7ec4\u7ec7\u6b63\u5728\u8fdb\u884c\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"BalanceInvPrepareStep_0", (String)"scmc-im-business", (Object[])new Object[0]));
                }
                this.checkSumReserve();
                this.buildContext();
                this.checkBalanceScheme(this.balanceInvSchemeId);
                DynamicObjectCollection demandBills = this.getDemandBills(demandEntryInfoMap);
                if (demandBills != null) {
                    Set<Long> entryIds = demandBills.stream().map(bill -> bill.getLong("entryentity.billentryid")).collect(Collectors.toSet());
                    BalanceInvExecuteHelper.releaseReserveRecord(entryIds);
                }
                this.getSupplyBills(supplyEntryInfoMap);
                this.checkSupplyQty(demandEntryInfoMap);
                this.matchDemandAndSupply();
                this.dealMatchDetail(matchDetailEntryIds);
            }
            catch (KDBizException e) {
                txHandle.markRollback();
                throw e;
            }
            catch (Exception ex) {
                txHandle.markRollback();
                logger.error("\u5e73\u8861\u5229\u5e93\u624b\u5de5\u8c03\u6574\u51fa\u9519\uff1a", (Throwable)ex);
            }
            finally {
                mutexDLock.unlock();
                if (this.ctx != null) {
                    this.ctx.release();
                }
            }
        }
    }

    private void checkSupplyQty(Map<Long, Map<String, Object>> demandEntryInfoMap) {
        Map<Long, SupplyQtyInfo> entryId2SupplyQtyMap = this.ctx.getEntryId2SupplyQtyMap();
        BigDecimal totalDemandQty = BigDecimal.ZERO;
        for (Map<String, Object> demandEntryInfo : demandEntryInfoMap.values()) {
            BigDecimal demandQty = (BigDecimal)demandEntryInfo.get("adjustedqty");
            totalDemandQty = totalDemandQty.add(demandQty);
        }
        BigDecimal totalSupplyQty = BigDecimal.ZERO;
        for (SupplyQtyInfo supplyQtyInfo : entryId2SupplyQtyMap.values()) {
            totalSupplyQty = totalSupplyQty.add(supplyQtyInfo.getBaseQty());
        }
        if (totalDemandQty.compareTo(totalSupplyQty) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u6c42\u660e\u7ec6\u7684\u201c\u8c03\u6574\u57fa\u672c\u6570\u91cf\u201d\u5408\u8ba1{0}\uff0c\u5927\u4e8e\u4f9b\u5e94\u660e\u7ec6\u7684\u5b9e\u9645\u201c\u4f9b\u5e94\u57fa\u672c\u6570\u91cf\u201d\u5408\u8ba1{1}\uff0c\u4fdd\u5b58\u5931\u8d25\u3002\u4f9b\u5e94\u660e\u7ec6\u7684\u5b9e\u9645\u201c\u4f9b\u5e94\u57fa\u672c\u6570\u91cf\u201d\u53ef\u67e5\u8be2\u5373\u65f6\u5e93\u5b58\u6216\u4f9b\u5e94\u5355\u636e\u3002", (String)"IM-E-343023", (String)"scmc-im-business", (Object[])new Object[]{totalDemandQty.stripTrailingZeros().toPlainString(), totalSupplyQty.stripTrailingZeros().toPlainString()}));
        }
    }

    private void checkSumReserve() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)1406552222187325440L, (String)"msmod_total_reserveset", (String)"isenable");
        boolean isSumReserve = dynamicObject.getBoolean("isenable");
        if (isSumReserve) {
            throw new KDBizException(ResManager.loadKDString((String)"\u542f\u7528\u603b\u91cf\u9884\u7559\u548c\u5e73\u8861\u5229\u5e93\u4e0d\u80fd\u540c\u65f6\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BalanceInvPrepareStep_21", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    private void dealMatchDetail(List<Long> matchDetailEntryIds) {
        DynamicObject matchDetail = BusinessDataServiceHelper.loadSingle((Object)this.matchDetailId, (String)"im_balanceinv_matchdetail", (String)"number,scheme,creator,calculatenum,createtime,comfirmstatus,ishistory");
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject newMatchDetail = (DynamicObject)cloneUtils.clone((IDataEntityBase)matchDetail);
        String number = this.getNewMatchDetailNumber(matchDetail.getString("number"), matchDetail.getString("calculatenum"));
        newMatchDetail.set("number", (Object)number);
        newMatchDetail.set("ishistory", (Object)true);
        newMatchDetail.set("createtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newMatchDetail});
        Object newMatchDetailId = newMatchDetail.getPkValue();
        String sql = "UPDATE T_IM_BALINV_DETAILENTRY SET FID = ? WHERE FENTRYID = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(matchDetailEntryIds.size());
        for (Long matchDetailEntryId : matchDetailEntryIds) {
            Object[] param = new Object[]{newMatchDetailId, matchDetailEntryId};
            paramList.add(param);
        }
        if (!paramList.isEmpty()) {
            String dbRouteKey = MetadataServiceHelper.getDataEntityType((String)"im_balanceinv_matchdetail").getDBRouteKey();
            DB.executeBatch((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, paramList);
        }
        if (!this.ctx.getMatchDetailEntries().isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.ctx.getMatchDetailEntries().toArray(new DynamicObject[0]));
        }
    }

    private String getNewMatchDetailNumber(String number, String calNumber) {
        QFilter filter = new QFilter("calculatenum", "=", (Object)calNumber).and("number", "!=", (Object)number);
        DynamicObjectCollection matchDetails = QueryServiceHelper.query((String)"im_balanceinv_matchdetail", (String)"number", (QFilter[])filter.toArray());
        int maxSeq = 0;
        if (matchDetails != null && !matchDetails.isEmpty()) {
            for (DynamicObject matchDetail : matchDetails) {
                String billNumber = matchDetail.getString("number");
                String seq = billNumber.replace(number + "_", "");
                maxSeq = Math.max(maxSeq, Integer.parseInt(seq));
            }
        }
        return number + "_" + ++maxSeq;
    }

    private void matchDemandAndSupply() {
        BalanceInvWorkBenchMatchStep matchStep = new BalanceInvWorkBenchMatchStep(this.ctx);
        matchStep.matchDemandAndSupply();
        String stepMsg = matchStep.getStepMsg();
        if (StringUtils.isNotBlank((CharSequence)stepMsg)) {
            throw new KDBizException(stepMsg);
        }
    }

    private void getSupplyBills(Map<String, Map<Long, Map<String, Object>>> supplyEntryInfoMap) {
        BalanceSupplyBillGetter getter = new BalanceSupplyBillGetter(this.ctx);
        HashMap<String, List<Long>> supplyEntryIdMap = new HashMap<String, List<Long>>(supplyEntryInfoMap.size());
        for (Map.Entry<String, Map<Long, Map<String, Object>>> supplyInfoEntry : supplyEntryInfoMap.entrySet()) {
            supplyEntryIdMap.put(supplyInfoEntry.getKey(), new ArrayList<Long>(supplyInfoEntry.getValue().keySet()));
        }
        getter.buildGroupedSupplyBillData(supplyEntryIdMap);
        BalanceInventoryScheme scheme = this.ctx.getScheme();
        Map<String, List<QFilter>> supplyQtyFilterMap = this.getSupplyQtyFilterMap(supplyEntryIdMap);
        getter.buildEntryId2SupplyQtyMap(supplyQtyFilterMap, scheme);
    }

    private Map<String, List<QFilter>> getSupplyQtyFilterMap(Map<String, List<Long>> supplyEntryIdMap) {
        SupplyModel supplyModel = this.ctx.getScheme().getSupplyModel();
        HashMap<String, List<QFilter>> filterMap = new HashMap<String, List<QFilter>>(supplyEntryIdMap.size());
        for (Map.Entry<String, List<Long>> billMapEntry : supplyEntryIdMap.entrySet()) {
            String billEntity = billMapEntry.getKey();
            List<Long> entryIds = billMapEntry.getValue();
            Map<String, String> target2SourceFieldMap = supplyModel.getTarget2SourceFieldMap(billEntity);
            String materialField = target2SourceFieldMap.get("entryentity.material");
            String entryKey = "id";
            if (materialField.contains(".")) {
                entryKey = materialField.split("\\.")[0] + ".id";
            }
            QFilter idFilter = new QFilter(entryKey, "in", entryIds);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(idFilter);
            filterMap.put(billEntity, filters);
        }
        return filterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectCollection getDemandBills(Map<Long, Map<String, Object>> demandEntryInfoMap) {
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        DemandModel demandModel = balanceScheme.getDemandModel();
        ArrayList<Long> entryIds = new ArrayList<Long>(demandEntryInfoMap.keySet());
        List<QFilter> filterList = BalanceInvExecuteHelper.getDemandFilter("pm_requirapplybill", entryIds, balanceScheme, false);
        String selector = demandModel.getMatchSelector("pm_requirapplybill");
        String[] orderArr = balanceScheme.getDemandOrderArr();
        MatchDimension matchDimension = balanceScheme.getMatchDimension();
        try (DataSet demandDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_requirapplybill", (String)selector, (QFilter[])filterList.toArray(new QFilter[0]), (String)"");){
            DynamicObjectCollection demandBillCol;
            RowMeta rowMeta = demandDataSet.getRowMeta();
            Map<String, String> targetFormulaMap = demandModel.getTargetExpressionMap("pm_requirapplybill");
            ArrayList<String> matchFields = new ArrayList<String>();
            matchFields.addAll(matchDimension.getDemandMatchFields());
            matchFields.removeAll(balanceScheme.getDemandNullMatchFields());
            demandDataSet = demandDataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, targetFormulaMap)).map((MapFunction)new MatchDimensionTransFunc(rowMeta, matchFields, "entryentity.flexmetricid"));
            demandDataSet = demandDataSet.addField("''", "allmatchfieldkey");
            demandDataSet = demandDataSet.map((MapFunction)new MatchDimensionTransFunc(demandDataSet.getRowMeta(), matchDimension.getDemandMatchFields(), "allmatchfieldkey"));
            if (orderArr != null && orderArr.length > 0) {
                demandDataSet = demandDataSet.orderBy(orderArr);
            }
            if ((demandBillCol = ORM.create().toPlainDynamicObjectCollection(demandDataSet)).isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b26\u5408\u6761\u4ef6\u7684\u9700\u6c42\u6570\u636e\u3002", (String)"BalanceInvGetDemandStep_0", (String)"scmc-im-business", (Object[])new Object[0]));
            }
            for (DynamicObject demandBill : demandBillCol) {
                long entryId = demandBill.getLong("entryentity.billentryid");
                Map<String, Object> entryInfo = demandEntryInfoMap.get(entryId);
                if (entryInfo == null) continue;
                BigDecimal adjustQty = (BigDecimal)entryInfo.get("adjustedqty");
                BigDecimal pureDemandQty = (BigDecimal)entryInfo.get("puredemandqty");
                demandBill.set("entryentity.demandqty", (Object)adjustQty.add(pureDemandQty));
                this.ctx.getEntryPurDemandQtyMap().put(entryId, pureDemandQty);
            }
            this.ctx.setDemandBillCol(demandBillCol);
            Iterator iterator = demandBillCol;
            return iterator;
        }
    }

    private void buildContext() {
        BalanceInvContext context = BalanceInvContext.get();
        context.setSchemeId(this.balanceInvSchemeId);
        context.setBalanceOrgId(this.balanceOrgId);
        context.setMatchDetailId(this.matchDetailId);
        this.ctx = context;
    }

    private void checkBalanceScheme(Long balanceInvSchemeId) {
        BalanceInvSchemeChecker checker = new BalanceInvSchemeChecker();
        DynamicObject balanceSchemeInfo = BalanceInvExecuteHelper.getBalanceSchemeInfo(balanceInvSchemeId);
        String checkMsg = checker.checkSchemeDynamicObj(balanceSchemeInfo, true);
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            throw new KDBizException(checkMsg);
        }
        BalanceInventoryScheme scheme = new BalanceInventoryScheme(balanceSchemeInfo);
        checkMsg = checker.checkSchemeInfo(scheme);
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            throw new KDBizException(checkMsg);
        }
        this.ctx.setScheme(scheme);
    }

    private DLock getMutexDLock() {
        StringBuilder lockDescription = new StringBuilder();
        String balanceInvMsg = ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93", (String)"BalanceInvStepExecutor_0", (String)"scmc-im-business", (Object[])new Object[0]);
        lockDescription.append(balanceInvMsg);
        lockDescription.append("-").append(this.balanceOrgId);
        DLock lock = DLock.create((String)("balnaceinv-" + this.balanceOrgId), (String)lockDescription.toString());
        return lock;
    }
}

