/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.business.balanceinv.steps.IBalanceInventoryStep;
import kd.scmc.im.business.balanceinv.util.BalanceInvLogUtils;

public class BalanceInvWorkBenchExecutor {
    private static final Log logger = LogFactory.getLog(BalanceInvWorkBenchExecutor.class);
    public static final String TYPE_PREPARE = "B";
    public static final String TYPE_EXECUTE = "C";
    public static int BATCH_SIZE = 1000;
    public static final String IM_BALANCEINV_STEP = "im_balanceinv_step";
    public static int MAXSIZE = 100000;
    private Long balanceOrgId;
    private Long balanceInvSchemeId;
    private List<Long> requireEntryIds;
    private String calculateNum;
    private Long calLogId;
    public static int OUT_TIME = 3600;

    public Long execute(Long balanceOrgId, Long balanceInvSchemeId, List<Long> requireEntryIds) {
        this.limitCheck(requireEntryIds);
        this.balanceOrgId = balanceOrgId;
        this.balanceInvSchemeId = balanceInvSchemeId;
        this.requireEntryIds = requireEntryIds;
        BalanceInvExecuteHelper.checkLicense();
        this.calculateNum = BalanceInvExecuteHelper.genCalculateNum();
        this.calLogId = this.buildBalanceInvLog();
        this.asynExecute();
        return this.calLogId;
    }

    private void limitCheck(List<Long> requireEntryIds) {
        if (requireEntryIds.size() > MAXSIZE) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u8bf7\u6c42\u6279\u91cf\u6700\u5927\u4e0d\u80fd\u8d85\u8fc710\u4e07\u3002", (String)"BalanceInvWorkBenchExecutor_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    private void asynExecute() {
        ThreadPools.executeOnce((String)"balanceinv", () -> {
            logger.info("\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\u5f00\u59cb\uff0c\u8fd0\u7b97\u7f16\u7801\uff1a" + this.calculateNum);
            BalanceInvContext ctx = this.buildContext();
            DLock mutexDLock = this.getMutexDLock();
            ctx.setLock(mutexDLock);
            try {
                BalanceInvLogUtils.setBalanceInvStatus(this.calculateNum, BalanceInvLogConstants.STATUS_RUNNING);
                if (this.prepareExecute()) {
                    List<List<Long>> entryIdGrouped = this.getGroupedEntryIds(ctx.getEntryIds(), BATCH_SIZE);
                    this.calculationExecute(ctx, entryIdGrouped);
                    this.waitForEnd();
                }
            }
            finally {
                BalanceInvLogUtils.processBalanceLog(this.calLogId, this.calculateNum);
                MutexHelper.release((String)"im_balance_workbenches", (String)"balanceinv", (String)String.valueOf(ctx.getBalanceOrgId()));
                mutexDLock.unlock();
                this.clear();
                ctx.release();
            }
        });
    }

    private void waitForEnd() {
        long endTime;
        long startTime = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int runningBatchNum = BalanceInvLogUtils.getRunningBatchNum(this.calculateNum);
            String planLogStatus = BalanceInvLogUtils.getBalanceInvStatus(this.calculateNum);
            if (!BalanceInvLogConstants.STATUS_RUNNING.equals(planLogStatus)) {
                return;
            }
            if (runningBatchNum > 0) continue;
            BalanceInvLogUtils.setBalanceInvStatus(this.calculateNum, BalanceInvLogConstants.STATUS_SUCCESS);
            return;
        } while ((endTime = System.currentTimeMillis()) - startTime <= (long)OUT_TIME * 1000L);
        BalanceInvLogUtils.setBalanceInvStatus(this.calculateNum, BalanceInvLogConstants.STATUS_FAIL);
    }

    private void calculationExecute(BalanceInvContext context, List<List<Long>> entryIdGrouped) {
        int batchSize = entryIdGrouped.size();
        BalanceInvLogUtils.initRunningBatchNum(this.calculateNum, batchSize);
        Map<Integer, List<Long>> batchLogMap = this.addBatchLog(batchSize);
        int batchRate = 89 / batchSize;
        for (Map.Entry<Integer, List<Long>> batchLogEntry : batchLogMap.entrySet()) {
            Integer batch = batchLogEntry.getKey();
            List<Long> logEntryIds = batchLogEntry.getValue();
            List<Long> entryIds = entryIdGrouped.get(batch - 1);
            Map<String, Object> param = this.buildBatchParam(context, logEntryIds, entryIds, batchRate);
            String batchKey = context.getCalcNum() + "batch" + batch;
            this.cacheBatchParam(param, batchKey);
            this.sendBalanceInvCalMsg(batchKey);
        }
    }

    private void sendBalanceInvCalMsg(String batchKey) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("scmc", "kd.scmc.im.balanceinvcal_queue");){
            pub.publish(batchKey);
        }
    }

    private Map<String, Object> buildBatchParam(BalanceInvContext ctx, List<Long> logEntryIds, List<Long> entryIds, int batchRate) {
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        param.put("balanceorgid", this.balanceOrgId);
        param.put("balanceinvschemeid", this.balanceInvSchemeId);
        param.put("calculatenum", this.calculateNum);
        param.put("callogid", this.calLogId);
        param.put("logentryids", logEntryIds);
        param.put("entryids", entryIds);
        param.put("matchdetailid", ctx.getMatchDetailId());
        param.put("debugmode", ctx.getDebugMode());
        param.put("rate", batchRate);
        return param;
    }

    private void cacheBatchParam(Map<String, Object> params, String batchKey) {
        DistributeSessionlessCache sessionLessCache = BalanceInvExecuteHelper.getDistributeSessionlessCache();
        sessionLessCache.put(batchKey, (Object)SerializationUtils.toJsonString(params));
    }

    private Map<Integer, List<Long>> addBatchLog(int size) {
        QFilter filter = new QFilter("calctype", "=", (Object)TYPE_EXECUTE);
        DynamicObjectCollection stepCol = QueryServiceHelper.query((String)this.getClass().getName(), (String)IM_BALANCEINV_STEP, (String)"id,step,name,implclass", (QFilter[])filter.toArray(), (String)"step");
        String selector = "entryentity.id,entryentity.seq,entryentity.calstep,entryentity.calstep.implclass";
        DynamicObject calcLogInfo = BusinessDataServiceHelper.loadSingle((Object)this.calLogId, (String)BalanceInvLogConstants.ENTITY_NUM, (String)selector);
        DynamicObjectCollection logEntries = calcLogInfo.getDynamicObjectCollection(BalanceInvLogConstants.ENTRY_ENTITY);
        long[] ids = DB.genGlobalLongIds((int)(size * stepCol.size()));
        int index = 0;
        HashMap<Integer, List<Long>> logEntryIdMap = new HashMap<Integer, List<Long>>(size);
        for (int i = 1; i <= size; ++i) {
            for (DynamicObject stepInfo : stepCol) {
                long logEntryId = ids[index];
                Long stepId = stepInfo.getLong("id");
                DynamicObject logEntry = logEntries.addNew();
                logEntry.set("id", (Object)logEntryId);
                logEntry.set(BalanceInvLogConstants.CAL_STEP, (Object)stepId);
                logEntry.set("seq", (Object)logEntries.size());
                logEntryIdMap.computeIfAbsent(i, k -> new ArrayList()).add(logEntryId);
                ++index;
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcLogInfo});
        return logEntryIdMap;
    }

    private List<List<Long>> getGroupedEntryIds(List<Long> entryIds, int batchSize) {
        QFilter filter = new QFilter("billentry.id", "in", entryIds);
        HashMap<Long, Set> groupedEntryIdMap = new HashMap<Long, Set>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_requirapplybill", (String)"billentry.id,billentry.materialmasterid", (QFilter[])filter.toArray(), (String)"");
        Object object = null;
        try {
            for (Row row : dataSet) {
                Long materialId = row.getLong("billentry.materialmasterid");
                Long entryId = row.getLong("billentry.id");
                groupedEntryIdMap.computeIfAbsent(materialId, k -> new HashSet()).add(entryId);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<List<Long>> groupList = new ArrayList<List<Long>>(16);
        entryIds = new ArrayList<Long>(16);
        for (Map.Entry entry : groupedEntryIdMap.entrySet()) {
            if (((Set)entry.getValue()).size() >= batchSize) {
                groupList.add(new ArrayList((Collection)entry.getValue()));
                continue;
            }
            entryIds.addAll((Collection)entry.getValue());
            if (entryIds.size() < batchSize) continue;
            groupList.add(entryIds);
            entryIds = new ArrayList<Long>(16);
        }
        if (!entryIds.isEmpty()) {
            groupList.add(entryIds);
        }
        return groupList;
    }

    private boolean prepareExecute() {
        String selector = "id,entryentity.id,entryentity.calstep.implclass";
        DynamicObjectCollection entries = QueryServiceHelper.query((String)BalanceInvLogConstants.ENTITY_NUM, (String)selector, (QFilter[])new QFilter("id", "=", (Object)this.calLogId).toArray());
        if (entries == null || entries.isEmpty()) {
            return false;
        }
        int rate = 10 / entries.size();
        for (DynamicObject entry : entries) {
            StepResult stepResult = this.executeStep(entry);
            if (!stepResult.isSuccess().booleanValue()) {
                if (BalanceInvLogConstants.STEP_RESULT_B.equals(stepResult.getStepResult())) {
                    BalanceInvLogUtils.setBalanceInvStatus(this.calculateNum, BalanceInvLogConstants.STATUS_FAIL);
                }
                return false;
            }
            BalanceInvLogUtils.updateBalanceLogRate(entry.getLong("id"), rate);
        }
        return true;
    }

    private StepResult executeStep(DynamicObject entry) {
        String implClass = entry.getString("entryentity.calstep.implclass");
        IBalanceInventoryStep step = (IBalanceInventoryStep)TypesContainer.createInstance((String)implClass);
        StepResult stepResult = step.execute();
        BalanceInvLogUtils.updateBalanceInvEntryLog(stepResult, entry.getLong("entryentity.id"));
        return stepResult;
    }

    private Long buildBalanceInvLog() {
        DynamicObject calcLogInfo = BusinessDataServiceHelper.newDynamicObject((String)BalanceInvLogConstants.ENTITY_NUM);
        calcLogInfo.set(BalanceInvLogConstants.BALANCE_ORG, (Object)this.balanceOrgId);
        calcLogInfo.set(BalanceInvLogConstants.SCHEME, (Object)this.balanceInvSchemeId);
        calcLogInfo.set(BalanceInvLogConstants.CAL_NUM, (Object)this.calculateNum);
        calcLogInfo.set(BalanceInvLogConstants.STATUS, (Object)BalanceInvLogConstants.STEP_RESULT_A);
        calcLogInfo.set(BalanceInvLogConstants.START_TIME, (Object)TimeServiceHelper.now());
        RequestContext requestContext = RequestContext.get();
        calcLogInfo.set(BalanceInvLogConstants.EXECUTOR, (Object)requestContext.getCurrUserId());
        String loginIP = requestContext.getLoginIP();
        if (!StringUtils.isEmpty((String)loginIP) && loginIP.length() > 50) {
            loginIP = loginIP.substring(0, 50);
        }
        calcLogInfo.set(BalanceInvLogConstants.EXECUTE_IP, (Object)loginIP);
        QFilter filter = new QFilter("calctype", "=", (Object)TYPE_PREPARE);
        DynamicObjectCollection stepCol = QueryServiceHelper.query((String)this.getClass().getName(), (String)IM_BALANCEINV_STEP, (String)"id,step,name,implclass", (QFilter[])filter.toArray(), (String)"step");
        DynamicObjectCollection logEntries = calcLogInfo.getDynamicObjectCollection(BalanceInvLogConstants.ENTRY_ENTITY);
        for (DynamicObject stepInfo : stepCol) {
            Long stepId = stepInfo.getLong("id");
            DynamicObject logEntry = logEntries.addNew();
            logEntry.set(BalanceInvLogConstants.CAL_STEP, (Object)stepId);
            logEntry.set("seq", (Object)logEntries.size());
        }
        Object[] logArr = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcLogInfo});
        return ((DynamicObject)logArr[0]).getLong("id");
    }

    private void clear() {
        DistributeSessionlessCache sessionLessCache = BalanceInvExecuteHelper.getDistributeSessionlessCache();
        sessionLessCache.remove(this.calculateNum);
        sessionLessCache.remove(this.calculateNum + "balanceinvbatchnum");
    }

    private BalanceInvContext buildContext() {
        BalanceInvContext ctx = BalanceInvContext.get();
        ctx.setEntryIds(this.requireEntryIds);
        ctx.setSchemeId(this.balanceInvSchemeId);
        ctx.setBalanceOrgId(this.balanceOrgId);
        ctx.setCalcNum(this.calculateNum);
        return ctx;
    }

    private DLock getMutexDLock() {
        StringBuilder lockDescription = new StringBuilder();
        String balanceInvMsg = ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93", (String)"BalanceInvStepExecutor_0", (String)"scmc-im-business", (Object[])new Object[0]);
        lockDescription.append(balanceInvMsg);
        lockDescription.append("-").append(this.balanceOrgId);
        DLock lock = DLock.create((String)("balnaceinv-" + this.balanceOrgId), (String)lockDescription.toString());
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOneBatch(Map<String, Object> param) {
        BalanceInvContext ctx = this.buildBatchContext(param);
        try {
            List logEntryIds = (List)param.get("logentryids");
            String selector = "id,entryentity.id,entryentity.calstep.implclass";
            QFilter filter = new QFilter("entryentity.id", "in", (Object)logEntryIds);
            DynamicObjectCollection entries = QueryServiceHelper.query((String)BalanceInvLogConstants.ENTITY_NUM, (String)selector, (QFilter[])filter.toArray(), (String)"entryentity.calstep.step");
            int batchRate = (Integer)param.get("rate");
            int rate = batchRate / entries.size();
            for (DynamicObject entry : entries) {
                StepResult stepResult = this.executeStep(entry);
                if (!stepResult.isSuccess().booleanValue()) {
                    BalanceInvLogUtils.setBalanceInvStatus(ctx.getCalcNum(), BalanceInvLogConstants.STATUS_FAIL);
                    break;
                }
                BalanceInvLogUtils.updateBalanceLogRate(entry.getLong("id"), rate);
            }
        }
        finally {
            ctx.release();
        }
    }

    private BalanceInvContext buildBatchContext(Map<String, Object> param) {
        BalanceInvContext ctx = BalanceInvContext.get();
        ctx.setBalanceOrgId(Long.parseLong(param.get("balanceorgid").toString()));
        Long schemeId = Long.parseLong(param.get("balanceinvschemeid").toString());
        ctx.setSchemeId(schemeId);
        DynamicObject balanceSchemeInfo = BalanceInvExecuteHelper.getBalanceSchemeInfo(schemeId);
        BalanceInventoryScheme balanceInventoryScheme = new BalanceInventoryScheme(balanceSchemeInfo);
        ctx.setScheme(balanceInventoryScheme);
        List entryIds = (List)param.get("entryids");
        ctx.setEntryIds(entryIds);
        ctx.setCalcNum((String)param.get("calculatenum"));
        ctx.setDebugMode((Boolean)param.get("debugmode"));
        ctx.setMatchDetailId((Long)param.get("matchdetailid"));
        Set<Long> materialIdSet = BalanceInvExecuteHelper.getDemandMaterialIdSet("pm_requirapplybill", balanceInventoryScheme, entryIds);
        ctx.setMaterialIdSet(materialIdSet);
        return ctx;
    }
}

