/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balanceinv.func.MatchDimensionTransFunc;

public class BalanceInvAdjustmentHelper {
    Map<String, String> demandMatchResultFieldMap = new HashMap<String, String>();
    Map<String, String> supplyMatchResultFieldMap = new HashMap<String, String>();
    Map<String, String> demandEntryMatchResultFieldMap = new HashMap<String, String>();
    Map<String, String> supplyEntryMatchResultFieldMap = new HashMap<String, String>();

    public Set<Long> getMatchedPkEntryPks(DynamicObject scheme, Long matchDetailPk, Long matchDetailEntryPk) {
        Long entryId;
        HashSet<Long> result = new HashSet<Long>(4);
        if (scheme == null || matchDetailPk == null || matchDetailEntryPk == null) {
            return result;
        }
        scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"balanceinv_scheme", (String)"mappingdimen,matchentry.demandfieldkey");
        List<String> matchDetailFields = this.getMatchDetailFields(scheme);
        String selectFields = String.join((CharSequence)",", matchDetailFields);
        selectFields = selectFields + ",'' as matchdimension,entryentity.id";
        QFilter filter = new QFilter("id", "=", (Object)matchDetailPk);
        filter.and("entryentity.demandbilltype", "!=", (Object)"invp_safestock_record");
        DataSet matchDetails = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_balanceinv_matchdetail", (String)selectFields, (QFilter[])filter.toArray(), null);
        RowMeta rowMeta = matchDetails.getRowMeta();
        matchDetails = matchDetails.map((MapFunction)new MatchDimensionTransFunc(rowMeta, matchDetailFields, "matchdimension"));
        ORM orm = ORM.create();
        DynamicObjectCollection matchDetailCollection = orm.toPlainDynamicObjectCollection(matchDetails);
        String targetMatchValue = null;
        for (DynamicObject matchDetail : matchDetailCollection) {
            entryId = matchDetail.getLong("entryentity.id");
            if (entryId.compareTo(matchDetailEntryPk) != 0) continue;
            targetMatchValue = matchDetail.getString("matchdimension");
            break;
        }
        if (targetMatchValue == null) {
            return result;
        }
        for (DynamicObject matchDetail : matchDetailCollection) {
            entryId = matchDetail.getLong("entryentity.id");
            String curRowMatchValue = matchDetail.getString("matchdimension");
            if (!targetMatchValue.equals(curRowMatchValue)) continue;
            result.add(entryId);
        }
        return result;
    }

    private List<String> getMatchDetailFields(DynamicObject scheme) {
        DynamicObject mappingDimen = scheme.getDynamicObject("mappingdimen");
        mappingDimen = BusinessDataServiceHelper.loadSingleFromCache((Object)mappingDimen.getPkValue(), (String)"sbs_billfieldmapping", (String)"targetobj,colsmap.targetobjcol,colsmap.sourcebillcol");
        DynamicObject targetObj = mappingDimen.getDynamicObject("targetobj");
        String demandColsMapKey = "";
        demandColsMapKey = "balanceinv_demandbill".equals(targetObj.getString("number")) ? "targetobjcol" : "sourcebillcol";
        DynamicObjectCollection colsMap = mappingDimen.getDynamicObjectCollection("colsmap");
        ArrayList<String> demandBillKeys = new ArrayList<String>(colsMap.size());
        for (Object col : colsMap) {
            String demandBillKey = col.getString(demandColsMapKey);
            demandBillKeys.add(demandBillKey);
        }
        DynamicObjectCollection schemeMatchEntry = scheme.getDynamicObjectCollection("matchentry");
        for (DynamicObject entry : schemeMatchEntry) {
            String demandFieldKey = entry.getString("demandfieldkey");
            demandBillKeys.remove(demandFieldKey);
        }
        this.buildMatchResultMap();
        ArrayList<String> matchDetailFields = new ArrayList<String>();
        for (String demandBillKey : demandBillKeys) {
            String matchDetailField = this.demandMatchResultFieldMap.get(demandBillKey);
            if (StringUtils.isEmpty((CharSequence)matchDetailField)) continue;
            matchDetailFields.add("entryentity." + matchDetailField);
        }
        return matchDetailFields;
    }

    private void buildMatchResultMap() {
        this.demandMatchResultFieldMap.put("entryentity.material", "materiel");
        this.demandMatchResultFieldMap.put("entryentity.auxpty", "auxpty");
        this.demandMatchResultFieldMap.put("entryentity.demandorg", "demandorg");
        this.demandMatchResultFieldMap.put("entryentity.biztype", "biztype");
        this.demandMatchResultFieldMap.put("entryentity.demandtype", "demandkind");
        this.demandMatchResultFieldMap.put("entryentity.baseunit", "baseunit");
        this.demandMatchResultFieldMap.put("entryentity.billtype", "demandbilltype");
        this.demandMatchResultFieldMap.put("entryentity.billnumber", "demandbillno");
        this.demandMatchResultFieldMap.put("entryentity.billdate", "demanddate");
        this.demandMatchResultFieldMap.put("entryentity.billid", "demandbillid");
        this.demandMatchResultFieldMap.put("entryentity.billentryid", "demandentryid");
        this.demandMatchResultFieldMap.put("entryentity.billentryseq", "demandbillseq");
        this.demandMatchResultFieldMap.put("entryentity.ownerid", "demandowner");
        this.demandMatchResultFieldMap.put("entryentity.ownertype", "demandownertype");
        this.demandMatchResultFieldMap.put("entryentity.demandqty", "previousbaseqty");
        this.demandMatchResultFieldMap.put("entryentity.demandqty", "demandbaseqty");
        this.supplyMatchResultFieldMap.put("entryentity.originbaseqty", "srcsupplybaseqty");
        this.supplyMatchResultFieldMap.put("entryentity.invtype", "invstocktype");
        this.supplyMatchResultFieldMap.put("entryentity.supplyorgunit", "supplyorg");
        this.supplyMatchResultFieldMap.put("entryentity.billtype", "supplybilltype");
        this.supplyMatchResultFieldMap.put("entryentity.billnumber", "supplybillno");
        this.supplyMatchResultFieldMap.put("entryentity.billid", "supplybillid");
        this.supplyMatchResultFieldMap.put("entryentity.billentryid", "supplybillentryid");
        this.supplyMatchResultFieldMap.put("entryentity.billentryseq", "supplybillseq");
        this.supplyMatchResultFieldMap.put("entryentity.billdate", "supplybilldate");
        this.supplyMatchResultFieldMap.put("entryentity.material", "supplymateriel");
        this.supplyMatchResultFieldMap.put("entryentity.stock", "supplywarehouse");
        this.supplyMatchResultFieldMap.put("entryentity.stockindex", "supplylocation");
        this.supplyMatchResultFieldMap.put("entryentity.owner", "supplyowner");
        this.supplyMatchResultFieldMap.put("entryentity.owertype", "supplyownertype");
        this.supplyMatchResultFieldMap.put("entryentity.materialflexprops", "supplyauxpty");
        this.supplyMatchResultFieldMap.put("entryentity.stockorg", "supplyinvorg");
        this.supplyMatchResultFieldMap.put("entryentity.unit", "supplyunit");
        this.supplyMatchResultFieldMap.put("entryentity.assistunit", "supplyunit2nd");
        this.supplyMatchResultFieldMap.put("entryentity.stockstatus", "invstatus");
        this.supplyMatchResultFieldMap.put("entryentity.stocktype", "supplystoretype");
    }

    private void buildAdjustmentMatchResultFieldMap() {
        this.demandEntryMatchResultFieldMap.put("demandorg", "demandorg");
        this.demandEntryMatchResultFieldMap.put("demandbilltype", "demandbilltype");
        this.demandEntryMatchResultFieldMap.put("demandbillno", "demandbillno");
        this.demandEntryMatchResultFieldMap.put("demandbillrow", "demandbillseq");
        this.demandEntryMatchResultFieldMap.put("demandmaterial", "materiel");
        this.demandEntryMatchResultFieldMap.put("demandauxpty", "auxpty");
        this.demandEntryMatchResultFieldMap.put("demanddate", "demanddate");
        this.demandEntryMatchResultFieldMap.put("demandbaseunit", "baseunit");
        this.demandEntryMatchResultFieldMap.put("demandbaseqty", "previousbaseqty");
        this.demandEntryMatchResultFieldMap.put("matchbaseqty", "matchbaseqty");
        this.demandEntryMatchResultFieldMap.put("adjustbaseqty", "matchbaseqty");
        this.demandEntryMatchResultFieldMap.put("demandbillentryid", "demandentryid");
        this.supplyEntryMatchResultFieldMap.put("supplymaterial", "materiel");
        this.supplyEntryMatchResultFieldMap.put("supplyauxpty", "auxpty");
        this.supplyEntryMatchResultFieldMap.put("inventorytype", "invstocktype");
        this.supplyEntryMatchResultFieldMap.put("supplybaseunit", "baseunit");
        this.supplyEntryMatchResultFieldMap.put("supplybaseqty", "matchbaseqty");
        this.supplyEntryMatchResultFieldMap.put("supplybilltype", "supplybilltype");
        this.supplyEntryMatchResultFieldMap.put("supplybillno", "supplybillno");
        this.supplyEntryMatchResultFieldMap.put("supplybillrow", "supplybillseq");
        this.supplyEntryMatchResultFieldMap.put("supplybilldate", "supplybilldate");
        this.supplyEntryMatchResultFieldMap.put("supplyownertype", "supplyownertype");
        this.supplyEntryMatchResultFieldMap.put("supplyowner", "supplyowner");
        this.supplyEntryMatchResultFieldMap.put("supplyorg", "supplyorg");
        this.supplyEntryMatchResultFieldMap.put("supplyinvorg", "supplyinvorg");
        this.supplyEntryMatchResultFieldMap.put("supplywarehouse", "supplywarehouse");
        this.supplyEntryMatchResultFieldMap.put("supplylocation", "supplylocation");
        this.supplyEntryMatchResultFieldMap.put("supplyinvtype", "supplystoretype");
        this.supplyEntryMatchResultFieldMap.put("supplyinvstatus", "invstatus");
        this.supplyEntryMatchResultFieldMap.put("supplybillentryid", "supplybillentryid");
    }

    public void initAdjustmentData(IDataModel model, Long matchDetailPk, Set<Long> matchDetailEntryPks) {
        this.buildAdjustmentMatchResultFieldMap();
        DataSet matchDetailDataSet = this.loadMatchDetailData(matchDetailPk, matchDetailEntryPks);
        ORM orm = ORM.create();
        DynamicObjectCollection matchDetailDataCollection = orm.toPlainDynamicObjectCollection(matchDetailDataSet);
        HashMap<String, List<DynamicObject>> demandDataMap = new HashMap<String, List<DynamicObject>>(matchDetailDataCollection.size());
        HashMap<String, List<DynamicObject>> supplyDataMap = new HashMap<String, List<DynamicObject>>(matchDetailDataCollection.size());
        for (DynamicObject matchDetailData : matchDetailDataCollection) {
            String demandMatchKey = matchDetailData.getString("demandmatchkey");
            String supplyMatchKey = matchDetailData.getString("supplymatchkey");
            String adviceType = matchDetailData.getString("advicetype");
            demandDataMap.computeIfAbsent(demandMatchKey, k -> new ArrayList(4)).add(matchDetailData);
            if ("F".equals(adviceType) || "A".equals(adviceType)) continue;
            supplyDataMap.computeIfAbsent(supplyMatchKey, k -> new ArrayList(4)).add(matchDetailData);
        }
        this.setEntryValue(model, demandDataMap, "demandentry");
        this.setEntryValue(model, supplyDataMap, "supplyentry");
    }

    private void setEntryValue(IDataModel model, Map<String, List<DynamicObject>> matchDetailDataMap, String entryKey) {
        if (matchDetailDataMap.isEmpty()) {
            return;
        }
        model.deleteEntryData(entryKey);
        model.batchCreateNewEntryRow(entryKey, matchDetailDataMap.size());
        boolean isDemand = "demandentry".equals(entryKey);
        String summaryKey = isDemand ? "adjustbaseqty" : "supplybaseqty";
        List<String> targetEntryFields = this.getTargetEntryFields(isDemand);
        int rowIndex = 0;
        for (Map.Entry<String, List<DynamicObject>> entry : matchDetailDataMap.entrySet()) {
            BigDecimal summaryQty = BigDecimal.ZERO;
            List<DynamicObject> dataList = entry.getValue();
            if (dataList.isEmpty()) continue;
            for (DynamicObject dynamicObject : dataList) {
                BigDecimal qty = dynamicObject.getBigDecimal(summaryKey);
                if (qty == null) continue;
                summaryQty = summaryQty.add(qty);
            }
            DynamicObject assignValueDym = dataList.get(0);
            for (String targetEntryField : targetEntryFields) {
                model.setValue(targetEntryField, assignValueDym.get(targetEntryField), rowIndex);
            }
            if (isDemand) {
                BigDecimal bigDecimal = assignValueDym.getBigDecimal("demandbaseqty");
                model.setValue("demandbaseqty", (Object)bigDecimal, rowIndex);
                model.setValue("adjustbaseqty", (Object)summaryQty, rowIndex);
                model.setValue("matchbaseqty", (Object)summaryQty, rowIndex);
                model.setValue("purdemandbaseqty", (Object)bigDecimal.subtract(summaryQty), rowIndex);
            } else {
                model.setValue("supplybaseqty", (Object)summaryQty, rowIndex);
            }
            ++rowIndex;
        }
    }

    private List<String> getTargetEntryFields(boolean isDemand) {
        ArrayList<String> targetEntryFields = new ArrayList<String>(16);
        if (isDemand) {
            targetEntryFields.addAll(this.demandEntryMatchResultFieldMap.keySet());
        } else {
            targetEntryFields.addAll(this.supplyEntryMatchResultFieldMap.keySet());
            targetEntryFields.remove("supplyowner");
            targetEntryFields.remove("supplyownertype");
            targetEntryFields.add("supplyownertype");
            targetEntryFields.add("supplyowner");
        }
        return targetEntryFields;
    }

    private DataSet loadMatchDetailData(Long matchDetailPk, Set<Long> matchDetailEntryPks) {
        List<String> selectFields = this.buildSelectFieldStr(this.demandEntryMatchResultFieldMap);
        selectFields.addAll(this.buildSelectFieldStr(this.supplyEntryMatchResultFieldMap));
        String selectFieldStr = String.join((CharSequence)",", selectFields);
        selectFieldStr = selectFieldStr + ", '' as demandmatchkey, '' as supplymatchkey";
        selectFieldStr = selectFieldStr + ",entryentity.advicetype as advicetype";
        QFilter filter = new QFilter("id", "=", (Object)matchDetailPk);
        filter.and("entryentity.id", "in", matchDetailEntryPks);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_balanceinv_matchdetail", (String)selectFieldStr, (QFilter[])filter.toArray(), null);
        HashSet<String> demandGroupByFields = new HashSet<String>(this.demandEntryMatchResultFieldMap.keySet());
        demandGroupByFields.remove("adjustbaseqty");
        demandGroupByFields.remove("matchbaseqty");
        HashSet<String> supplyGroupByFields = new HashSet<String>(this.supplyEntryMatchResultFieldMap.keySet());
        supplyGroupByFields.remove("supplybaseqty");
        RowMeta rowMeta = dataSet.getRowMeta();
        dataSet = dataSet.map((MapFunction)new MatchDimensionTransFunc(rowMeta, new ArrayList<String>(demandGroupByFields), "demandmatchkey"));
        dataSet = dataSet.map((MapFunction)new MatchDimensionTransFunc(rowMeta, new ArrayList<String>(supplyGroupByFields), "supplymatchkey"));
        return dataSet;
    }

    private List<String> buildSelectFieldStr(Map<String, String> fieldMap) {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> selectFields = new ArrayList<String>(fieldMap.size());
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            String matchDetailDemandKey = entry.getValue();
            String adjustmentDemandKey = entry.getKey();
            builder.append("entryentity.").append(matchDetailDemandKey).append(" as ").append(adjustmentDemandKey);
            selectFields.add(builder.toString());
            builder.setLength(0);
        }
        return selectFields;
    }
}

