/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.helper;

import java.util.HashMap;
import java.util.List;
import kd.bos.base.parameter.ParameterService;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BalanceInvProgressHelper {
    public static final String TABAP = "tabap";
    public static final String APPNAME = "appname";
    public static final String APPIMAGEURL = "appImageUrl";
    public static final String WFTASK = "wftask";
    public static final String APPID = "appid";
    public static final String MESSAGE_ID = "messageId";
    public static final String TAB_TYPE = "tabType";
    public static final String OPEN_PAGE = "openPage";
    public static final String BILL_FORM_ID = "billFormId";
    private static final Log logger = LogFactory.getLog(BalanceInvProgressHelper.class);

    public static void showMatchDetail(String taskId, String pageId, IFormView view, String workbenchLogId) {
        IFormView parent = view.getView(pageId);
        if (parent == null) {
            String tarMenuInfo = null;
            List appMenuInfos = AppMetadataCache.getAppMenusInfoByAppId((String)"im");
            for (AppMenuInfo menuInfo : appMenuInfos) {
                String formId = menuInfo.getFormId();
                if (!"im_balance_workbenches".equals(formId)) continue;
                tarMenuInfo = menuInfo.getId();
                break;
            }
            if (tarMenuInfo != null) {
                HashMap<String, String> param = new HashMap<String, String>(4);
                param.put("benchLogId", workbenchLogId);
                OpenPageUtils.openMenu((IFormView)view, (String)tarMenuInfo, (String)"=9Q86DR2P+Q", param);
            } else {
                BalanceInvProgressHelper.openWorkbenchForm(view, pageId, taskId, workbenchLogId);
            }
        } else {
            OperateOption option = OperateOption.create();
            option.setVariableValue("benchLogId", String.valueOf(workbenchLogId));
            parent.invokeOperation("tomatchdetail", option);
            view.sendFormAction(parent);
        }
    }

    private static void openWorkbenchForm(IFormView view, String pageId, String taskId, String workbenchLogId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setHasRight(true);
        showParameter.setPageId(pageId);
        showParameter.setFormId("im_balance_workbenches");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getCustomParams().put("benchLogId", workbenchLogId);
        view.showForm(showParameter);
        TaskClientProxy.setProgressPageId((String)taskId, (String)showParameter.getPageId());
    }

    public static void showBalanceLogForm(Long balanceLogId, IFormView view) {
        DynamicObject appConf = BusinessDataServiceHelper.loadSingle((String)"im_balanceinv_appmenuconf", (QFilter[])new QFilter("number", "=", (Object)"BALANCEINV_APPCONF").toArray());
        String appid = appConf == null ? "im" : appConf.getString(APPID);
        appid = StringUtils.isEmpty((CharSequence)appid) ? "im" : appid;
        List appMenuInfos = AppMetadataCache.getAppMenusInfoByAppId((String)appid);
        String tarMenuInfo = null;
        for (AppMenuInfo menuInfo : appMenuInfos) {
            String formId = menuInfo.getFormId();
            if (!"im_balanceinv_log".equals(formId)) continue;
            tarMenuInfo = menuInfo.getId();
            break;
        }
        if (tarMenuInfo != null) {
            BalanceInvProgressHelper.showForm(view, tarMenuInfo, appid, balanceLogId);
        } else {
            BalanceInvProgressHelper.showBalanceLogUI(balanceLogId, view);
        }
    }

    public static void showForm(IFormView view, String menuItemId, String bizAppId, Long balanceLogId) {
        String appPageID;
        IFormView mainPageView = BalanceInvProgressHelper.getMainPageView(view);
        IFormView appPageView = mainPageView.getViewNoPlugin(appPageID = bizAppId + mainPageView.getPageId());
        if (appPageView != null) {
            BalanceInvProgressHelper.activatePage(appPageID, view);
        } else {
            BalanceInvProgressHelper.openAppPage(bizAppId, view);
        }
        BalanceInvProgressHelper.openPage(balanceLogId, bizAppId, menuItemId, view);
    }

    private static void openAppPage(String appID, IFormView view) {
        AppInfo app = AppMetadataCache.getAppInfo((String)appID);
        String appName = app.getName().getLocaleValue();
        String appHomeNum = app.getHomeNum();
        if (appName == null || appHomeNum == null || view == null) {
            logger.debug("OpenPageUtils----openAppPage----appmainnumber or view in map is null [105]");
            return;
        }
        IFormView mainPageView = BalanceInvProgressHelper.getMainPageView(view);
        String mainPageID = mainPageView.getPageId();
        String appPageID = appID + mainPageID;
        FormShowParameter para = new FormShowParameter();
        para.setAppId(appID);
        para.getOpenStyle().setTargetKey(TABAP);
        para.getOpenStyle().setShowType(ShowType.NewTabPage);
        para.setFormId(appHomeNum);
        para.setCaption(appName);
        para.setPageId(appPageID);
        para.setHasRight(true);
        HashMap<String, String> customMap = new HashMap<String, String>();
        customMap.put(APPID, appID);
        customMap.put(APPNAME, appName);
        customMap.put(APPIMAGEURL, BalanceInvProgressHelper.getAppImgUrl(app.getImage()));
        para.setCustomParams(customMap);
        para.setInvokeTimeout(300);
        if (mainPageView.getPageId().equals(view.getPageId())) {
            view.showForm(para);
        } else {
            mainPageView.showForm(para);
            view.sendFormAction(mainPageView);
        }
    }

    private static String getAppImgUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "icons/pc/entrance/default_48_48.png";
        }
        if (url.startsWith("/") && url.length() > 1) {
            url = url.substring(1);
        }
        return url;
    }

    private static void openPage(Long balanceLogId, String bizAppId, String menuItemId, IFormView view) {
        String menuPageID;
        boolean existView;
        String appPageID;
        IFormView mainPageView = BalanceInvProgressHelper.getMainPageView(view);
        IFormView appPageView = mainPageView.getViewNoPlugin(appPageID = bizAppId + mainPageView.getPageId());
        if (appPageView.getPageId().equalsIgnoreCase(view.getPageId())) {
            appPageView = view;
        }
        if (existView = mainPageView.existView(menuPageID = menuItemId + mainPageView.getPageId())) {
            menuPageID = menuPageID + "_" + kd.bos.login.utils.StringUtils.randomNumber((int)16);
        }
        BillShowParameter fsp = new BillShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        fsp.getOpenStyle().setTargetKey("_submaintab_");
        fsp.setFormId("im_balanceinv_log");
        fsp.setPkId((Object)balanceLogId);
        fsp.setHasRight(true);
        fsp.setAppId(bizAppId);
        HashMap<String, String> customMap = fsp.getCustomParams();
        if (customMap == null) {
            customMap = new HashMap<String, String>();
        }
        customMap.put(APPID, bizAppId);
        fsp.setCustomParams(customMap);
        fsp.setPageId(menuPageID);
        List pluginList = ((FormViewPluginProxy)appPageView.getService(FormViewPluginProxy.class)).getPlugIns();
        if (pluginList != null && pluginList.size() > 0) {
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)pluginList.get(0), "close_menupage"));
        }
        if (view.getPageId().equals(appPageView.getPageId())) {
            view.showForm((FormShowParameter)fsp);
        } else {
            appPageView.showForm((FormShowParameter)fsp);
            view.sendFormAction(appPageView);
        }
    }

    private static void activatePage(String pageID, IFormView view) {
        IFormView childView = view.getViewNoPlugin(pageID);
        if (WFTASK.equals(childView.getFormShowParameter().getAppId())) {
            childView = view.getView(pageID);
        }
        if (childView != null) {
            if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
                childView.getFormShowParameter().getCustomParams().remove(MESSAGE_ID);
                childView.getFormShowParameter().getCustomParams().remove(TAB_TYPE);
                childView.getFormShowParameter().getCustomParams().remove(OPEN_PAGE);
                childView.getFormShowParameter().getCustomParams().remove(BILL_FORM_ID);
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                BalanceInvProgressHelper.newPortalSelectAppTab(childView);
                if (WFTASK.equals(childView.getFormShowParameter().getAppId())) {
                    childView.updateView();
                }
                view.sendFormAction(childView);
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u91cd\u65b0\u767b\u5f55\u3002", (String)"IM-W-503680", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    private static void newPortalSelectAppTab(IFormView formView) {
        Tab tab;
        boolean isNewPortal = ParameterService.isSupportNewPortal();
        if (!isNewPortal) {
            return;
        }
        if (!WFTASK.equals(formView.getFormShowParameter().getAppId()) && (tab = (Tab)formView.getControl("_submaintab_")) != null) {
            tab.activeTab("appmiantab");
        }
    }

    private static IFormView getMainPageView(IFormView myappView) {
        String rootPageId;
        IFormView mainPageView = myappView.getMainView();
        if (mainPageView == null && (mainPageView = myappView.getView(rootPageId = myappView.getFormShowParameter().getRootPageId())) == null) {
            throw new KDException(new ErrorCode("mainView is null", "mainView is null"), new Object[0]);
        }
        return mainPageView;
    }

    public static void showBalanceLogUI(Long balanceLogId, IFormView view) {
        if (balanceLogId == null) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("im_balanceinv_log");
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setPkId((Object)balanceLogId);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setHasRight(true);
        FormConfig fConfig = FormMetadataCache.getFormConfig((String)"im_balanceinv_log");
        fConfig.setHeight(new LocaleString("90%"));
        fConfig.setWidth(new LocaleString("90%"));
        showParameter.setFormConfig(fConfig);
        view.showForm((FormShowParameter)showParameter);
    }
}

