/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.steps.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.workbench.steps.impl.AbstractBalanceInvWorkBenchStep;

public class BalanceInvWorkBenchClearDataStep
extends AbstractBalanceInvWorkBenchStep {
    private static final Log logger = LogFactory.getLog(BalanceInvWorkBenchClearDataStep.class);
    private static final String ALGO = "kd.scmc.im.business.balanceinv.workbench.steps.impl.BalanceInvWorkBenchClearDataStep";

    @Override
    public void innerExecute() {
        QFilter filter = this.getDeleteFilter();
        ArrayList<Long> idList = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"im_balanceinv_advice", (String)"id", (QFilter[])filter.toArray(), (String)"");){
            for (Row row : dataSet) {
                idList.add(row.getLong("id"));
            }
        }
        int processCount = idList.size();
        this.setProcessData(processCount);
        int failCount = 0;
        if (!idList.isEmpty()) {
            this.deleteBalanceAdvise(idList);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"im_balanceinv_advice", (String)"id", (QFilter[])filter.toArray(), (String)"");){
                failCount = dataSet.count("id", true);
            }
        }
        int successCount = processCount - failCount;
        this.addInfoMessage(String.format(ResManager.loadKDString((String)"\u6e05\u7406\u5386\u53f2\u6570\u636e\uff1a\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"BalanceInvClearOldDataStep_1", (String)"scmc-im-business", (Object[])new Object[0]), successCount, failCount) + "\n");
        this.clearMatchDetail();
        this.initMatchDetail();
    }

    private void clearMatchDetail() {
        Set<Long> needDeleteIds = BalanceInvExecuteHelper.getNeedClearMatchDetail(this.ctx.getSchemeId());
        if (needDeleteIds != null && !needDeleteIds.isEmpty()) {
            try (TXHandle txHandle = TX.requiresNew((String)"balanceinv_clearmatchdetail");){
                block32: {
                    boolean needReserve = BalanceInvExecuteHelper.getNeedReserve();
                    if (needReserve) {
                        try {
                            QFilter idFilter = new QFilter("id", "in", needDeleteIds);
                            HashSet<Long> demandEntryIds = new HashSet<Long>(16);
                            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"im_balanceinv_matchdetail", (String)"entryentity.demandentryid", (QFilter[])idFilter.toArray(), (String)"");){
                                for (Row row : dataSet) {
                                    demandEntryIds.add(row.getLong("entryentity.demandentryid"));
                                }
                            }
                            BalanceInvExecuteHelper.releaseReserveRecord(demandEntryIds);
                        }
                        catch (Exception e) {
                            txHandle.markRollback();
                            this.addInfoMessage(ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u5931\u8d25\u3002", (String)"IM-D-036010", (String)"scmc-im-business", (Object[])new Object[0]) + "\n");
                            if (!this.ctx.getDebugMode()) break block32;
                            this.addInfoMessage(BalanceInvExecuteHelper.getExceptionMessage(e));
                        }
                    }
                }
                try {
                    MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"im_balanceinv_matchdetail");
                    DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])needDeleteIds.toArray());
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    throw e;
                }
            }
        }
    }

    private void initMatchDetail() {
        DynamicObject matchResult = BusinessDataServiceHelper.newDynamicObject((String)"im_balanceinv_matchdetail");
        matchResult.set("scheme", (Object)this.ctx.getSchemeId());
        matchResult.set("createtime", (Object)TimeServiceHelper.now());
        matchResult.set("calculatenum", (Object)this.ctx.getCalcNum());
        matchResult.set("comfirmstatus", (Object)"0");
        matchResult.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        SaveServiceHelper.saveOperate((String)"im_balanceinv_matchdetail", (DynamicObject[])new DynamicObject[]{matchResult}, (OperateOption)OperateOption.create());
        this.ctx.setMatchDetailId(matchResult.getLong("id"));
    }

    private void deleteBalanceAdvise(List<Long> idList) {
        block16: {
            try (TXHandle txHandle = TX.requiresNew((String)"balanceinv_delete_advice");){
                try {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"im_balanceinv_advice", (Object[])idList.toArray(), (OperateOption)OperateOption.create());
                    if (!result.isSuccess()) {
                        this.addErrorMessage(ResManager.loadKDString((String)"\u6e05\u7406\u5386\u53f2\u5229\u5e93\u5efa\u8bae\u5931\u8d25\uff1a", (String)"BalanceInvClearOldDataStep_0", (String)"scmc-im-business", (Object[])new Object[0]) + "\n");
                        this.addErrorMessage(BalanceInvExecuteHelper.getBillOperateErrorMsg(result));
                    }
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    logger.error((Throwable)e);
                    this.addErrorMessage(ResManager.loadKDString((String)"\u6e05\u7406\u5386\u53f2\u5229\u5e93\u5efa\u8bae\u5931\u8d25\uff1a", (String)"BalanceInvClearOldDataStep_0", (String)"scmc-im-business", (Object[])new Object[0]) + "\n");
                    if (this.ctx.getDebugMode()) {
                        this.addErrorMessage(BalanceInvExecuteHelper.getExceptionMessage(e));
                        break block16;
                    }
                    this.addErrorMessage(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"BalanceInvStepExecutor_1", (String)"scmc-im-business", (Object[])new Object[0]));
                }
            }
        }
    }

    private QFilter getDeleteFilter() {
        Long schemeId = this.ctx.getSchemeId();
        long currUserId = RequestContext.get().getCurrUserId();
        return new QFilter("balanceinvscheme", "=", (Object)schemeId).and("billstatus", "=", (Object)"A").and("creator", "=", (Object)currUserId);
    }
}

