/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.steps.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.func.BillFormulaValueTransFunc;
import kd.scmc.im.business.balanceinv.func.MatchDimensionTransFunc;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.DemandModel;
import kd.scmc.im.business.balanceinv.pojo.MatchDimension;
import kd.scmc.im.business.balanceinv.workbench.steps.impl.AbstractBalanceInvWorkBenchStep;

public class BalanceInvWorkBenchGetDemandStep
extends AbstractBalanceInvWorkBenchStep {
    private static final Log logger = LogFactory.getLog(BalanceInvWorkBenchGetDemandStep.class);
    public static final String SCMC_IM_BUSINESS = "scmc-im-business";

    @Override
    public void innerExecute() {
        List<Long> entryIds = this.ctx.getEntryIds();
        DynamicObjectCollection demandBillCol = this.getDemandBills("pm_requirapplybill", entryIds);
        if (demandBillCol.isEmpty()) {
            this.addErrorMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b26\u5408\u6761\u4ef6\u7684\u9700\u6c42\u6570\u636e\u3002", (String)"BalanceInvGetDemandStep_0", (String)SCMC_IM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        this.addCountMsg(entryIds.size(), demandBillCol.size());
        this.ctx.setDemandBillCol(demandBillCol);
    }

    private void addCountMsg(int processCount, int successCount) {
        this.setProcessData(processCount);
        this.addInfoMessage(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u9700\u6c42\u6570\u636e\u5171\uff1a%1$s\u6761\u3002", (String)"BalanceInvGetDemandStep_5", (String)SCMC_IM_BUSINESS, (Object[])new Object[0]), processCount) + "\n");
        this.addInfoMessage(String.format(ResManager.loadKDString((String)"\u5176\u4e2d\u7b26\u5408\u6761\u4ef6\u6570\u636e\uff1a%1$s\u6761\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u6570\u636e\uff1a%2$s\u6761\u3002", (String)"BalanceInvGetDemandStep_6", (String)SCMC_IM_BUSINESS, (Object[])new Object[0]), successCount, processCount - successCount) + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectCollection getDemandBills(String entityNum, List<Long> entryIdList) {
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        DemandModel demandModel = balanceScheme.getDemandModel();
        List<QFilter> filterList = BalanceInvExecuteHelper.getDemandFilter(entityNum, entryIdList, balanceScheme, true);
        String selector = demandModel.getMatchSelector(entityNum);
        String[] orderArr = balanceScheme.getDemandOrderArr();
        MatchDimension matchDimension = balanceScheme.getMatchDimension();
        DataSet demandDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityNum, (String)selector, (QFilter[])filterList.toArray(new QFilter[0]), (String)"");
        if (this.ctx.getDebugMode()) {
            logger.info("\u83b7\u53d6\u9700\u6c42\u5355\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a" + BalanceInvExecuteHelper.getStringFilter(filterList));
        }
        try {
            Iterator iterator;
            RowMeta rowMeta = demandDataSet.getRowMeta();
            Map<String, String> targetFormulaMap = demandModel.getTargetExpressionMap(entityNum);
            ArrayList<String> matchFields = new ArrayList<String>();
            matchFields.addAll(matchDimension.getDemandMatchFields());
            matchFields.removeAll(balanceScheme.getDemandNullMatchFields());
            demandDataSet = demandDataSet.map((MapFunction)new BillFormulaValueTransFunc(rowMeta, targetFormulaMap)).map((MapFunction)new MatchDimensionTransFunc(rowMeta, matchFields, "entryentity.flexmetricid"));
            demandDataSet = demandDataSet.addField("''", "allmatchfieldkey");
            demandDataSet = demandDataSet.map((MapFunction)new MatchDimensionTransFunc(demandDataSet.getRowMeta(), matchDimension.getDemandMatchFields(), "allmatchfieldkey"));
            if (orderArr != null && orderArr.length > 0) {
                demandDataSet = demandDataSet.orderBy(orderArr);
            }
            rowMeta = demandDataSet.getRowMeta();
            ArrayList<Row> demandDataList = new ArrayList<Row>(10);
            List<String> mustInputFields = this.getMustInputFields();
            for (Row row : demandDataSet) {
                boolean hasError = false;
                for (String mustInputField : mustInputFields) {
                    Object value = BalanceInvExecuteHelper.getValue(rowMeta, row, "entryentity." + mustInputField);
                    if (value != null && (!(value instanceof Long) || (Long)value != 0L)) continue;
                    hasError = true;
                    break;
                }
                if (hasError) continue;
                demandDataList.add(row);
            }
            if (!demandDataList.isEmpty()) {
                iterator = ORM.create().toPlainDynamicObjectCollection(demandDataList, rowMeta, 0, demandDataList.size());
                return iterator;
            }
            iterator = new DynamicObjectCollection();
            return iterator;
        }
        finally {
            demandDataSet.close();
        }
    }

    private List<String> getMustInputFields() {
        ArrayList<String> mustInputFields = new ArrayList<String>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"balanceinv_demandbill");
        EntityType entryEntity = (EntityType)dataEntityType.getAllEntities().get("entryentity");
        Collection entryProps = entryEntity.getFields().values();
        for (IDataEntityProperty prop : entryProps) {
            boolean mustInput = BalanceInvExecuteHelper.isPropMustInput(prop, new HashMap<String, Boolean>(16));
            if (!mustInput) continue;
            mustInputFields.add(prop.getName());
        }
        return mustInputFields;
    }
}

